rem 
rem $Header: catdefrt.sql 7020200.1 95/02/15 18:32:53 cli Generic<base> $ 
rem 
Rem  Copyright (c) 1992 by Oracle Corporation 
Rem    NAME
Rem      catdefrt.sql - CATalog DEFeRred rpc Tables
Rem    DESCRIPTION
Rem      create deferred rpc tables
Rem    RETURNS
Rem 
Rem    NOTES
Rem      This is called from catdefer.sql
Rem    MODIFIED   (MM/DD/YY)
Rem     hasun      01/23/95 -  merge changes from branch 1.1.710.5
Rem     dsdaniel   12/21/94 -  merge changes from branch 1.1.710.2&3&4
Rem     hasun      01/11/95 -  Add fix to resolve duplicate SCNs
Rem     dsdaniel   12/08/94 -  add def _destinaton constraint
Rem     dsdaniel   12/08/94 -  name defcall primary
Rem     dsdaniel   11/25/94 -  eliminate deftrandest, ect
Rem     dsdaniel   11/25/94 -  Branch_for_patch
Rem     dsdaniel   11/22/94 -  Creation

--  create the call table.  One row for each deferred call.
CREATE TABLE system.def$_call  (
  deferred_tran_db VARCHAR2(128),   -- origin db
  deferred_tran_id  VARCHAR2(22),   -- transaction id
  buffer_number NUMBER,            -- parameters buffer number 
  callno            NUMBER,         -- UID of call, orders calls in transaction 
   CONSTRAINT def$_calls_primary
      PRIMARY KEY(deferred_tran_db, deferred_tran_id, callno, buffer_number),
  schemaname    VARCHAR2(30),      -- schema name NOT NULL
  packagename   VARCHAR2(30),      -- package name  NOT NULL
  procname      VARCHAR2(30),      -- procedue name NOT NULL
  argcount      NUMBER,            -- # of args  NOT NULL
  parm_buffer   LONG RAW,          -- parameters buffer    
  -- THE FOLLOWING COLUMNS ARE NONLY NON-NULL FOR THE FIRST (lowest callno,
  -- buffno = 1 
  destination_list CHAR(1),       -- R = RepSchema, D = def$_calldest
  origin_user_id   NUMBER,        -- userid deferring tran
  origin_user      VARCHAR2(30),  -- user deferring tran (used at remote)
  delivery_order   NUMBER,        -- order to deliver to destinations
  origin_tran_id   VARCHAR2(22),  -- original tid (if copied)
  origin_tran_db   VARCHAR2(128), -- origial  node
  start_time       DATE,          -- time original tid started
  destination_count INTEGER,      -- set on first push
  commit_comment VARCHAR2(50))    -- commit comment
/

--  create the table where the exceptions get logged. One row for each
--  transactionXorigin_node when the execution of the transaction at 
--  this  node encountered  an error.
CREATE TABLE system.def$_error(
  deferred_tran_db VARCHAR2(128),  -- node origination/copying txn
  deferred_tran_id VARCHAR2(22),   -- transaction id
  callno           NUMBER,           -- UID of call
-- forign key constrain on call not used.  Users can create error transacitons
-- with null or invalid callno - it is for documenation only
--  dummy_buffer_number NUMBER DEFAULT 1,
--    CONSTRAINT def$_error_call
--      FOREIGN KEY(callno, dummy_buffer_number, deferred_tran_db)
--      REFERENCES system.def$_call(callno, buffer_number, deferred_tran_db),
   destination     VARCHAR2(128),  -- dblink transaciton destined to
     CONSTRAINT def$_error_primary
        PRIMARY KEY(deferred_tran_db, deferred_tran_id, destination),
   error_time      DATE,           -- time at which 
                                   -- conflit occured
   error_number    NUMBER,         -- error 
                                   -- number reported
   error_msg       VARCHAR2(200))  -- error message
/


CREATE TABLE system.def$_destination(
  dblink         VARCHAR2(128)  -- queue name
    CONSTRAINT def$_destination_primary PRIMARY KEY,
  last_delivered NUMBER         -- scn (from deliver_order column of def$_call)
                         DEFAULT 0 NOT NULL,
  last_tran_id   VARCHAR2(22),  -- transaction id last delivered
  last_tran_db   VARCHAR2(128), -- node  origination/copying last delivered txn
  disabled       CHAR(1),       -- T = propogtion to dest disabled F = enabled 
  job            NUMBER,        -- number of job which does the push
  last_txn_count NUMBER,        -- number of transacitons executed lat push
  last_error     NUMBER,        -- sqlcode from last push
  last_msg       VARCHAR2(255)) -- error message from last push
/


--  create the  table that identifies a call to be executed	
--  at a remote node. One row for each callsXnode when the 
--  destination_list is D
CREATE TABLE system.def$_calldest(
  deferred_tran_db VARCHAR2(128), -- deferred transaction db
  deferred_tran_id VARCHAR2(22),  -- deferred transaction id
  callno           NUMBER,        -- call id 
  dummy_buffer_number NUMBER DEFAULT 1, -- for forign key reference
    CONSTRAINT def$_calldest_call
      FOREIGN KEY(deferred_tran_db,
                           deferred_tran_id, callno, dummy_buffer_number)
      REFERENCES system.def$_call(deferred_tran_db,
                                  deferred_tran_id, callno, buffer_number),
  dblink           VARCHAR2(128), -- dblink to destination
    CONSTRAINT def$_calldest_primary 
      PRIMARY KEY(deferred_tran_db, deferred_tran_id, 
                  callno, dummy_buffer_number, dblink),
   CONSTRAINT def$_call_destination  -- Destination table must have a row
      FOREIGN KEY(dblink)  
      REFERENCES system.def$_destination(dblink))
/                    

CREATE TABLE system.def$_defaultdest (
  dblink VARCHAR2(128)  -- dblink 
    CONSTRAINT def$_defalutdest_primary
    PRIMARY KEY)
/
