Rem 
Rem $Header: dbmspb.sql 7020200.1 95/02/15 18:31:41 cli Generic<base> $ 
Rem 
Rem  Copyright (c) 1995 by Oracle Corporation 
Rem    NAME
Rem      dbmspb.sql - ProBe (PL/SQL debugger) server-side packages.
Rem
Rem    DESCRIPTION
Rem      Server-side packages that implement server-side Probe support.
Rem      (PBUTL, PBRPH, PBSDE, PBREAK)
Rem
Rem    NOTES
Rem      * Must be installed as SYS.
Rem
Rem      * These packages are not intended to be used directly by the ordinary
Rem        user: they provide a low-level interface to Probe services.
Rem
Rem      * These packages are not a complete specification of the Probe 
Rem        interface. If you are interested in implementing a PL/SQL debugger
Rem        please contact the Oracle Corporation Languages Group.
Rem
Rem      * The status of these packages is BETA.
Rem
Rem      * These packages are NOT to be loaded by default with the 
Rem        procedural option. They will only be loaded if Procedure Builder
Rem        or other debugger is present.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem     jmallory   02/13/95 -  Branch_for_patch
Rem     jmallory   02/09/95 -  Creation

REM  ******************************************************************
REM  * THIS PACKAGE MUST NOT BE MODIFIED BY THE CUSTOMER.  DOING SO   *
REM  * COULD CAUSE INTERNAL ERRORS AND SECURITY VIOLATIONS IN THE     *
REM  * RDBMS.                                                         *
REM  ******************************************************************

------------------------------------------------------------------------------
--                           OVERVIEW
--
--  Probe is a component of the PL/SQL interpreter; debugging a program 
--  means running the interpreter in debug mode. If an event (defined later)
--  occurs while the interpreter is running in debug mode, execution is 
--  transferred to an event signaller. The signaller may examine and modify
--  the state of the program. When the signaller returns, execution of the
--  original program continues. In order to be useful, the signaller must 
--  be able to talk to the user of the debugger, so s/he may communicate
--  requests and receive replies. This file contains the specifications for
--  the default signaller and communication mechanism for Probe on the server.
--  
--  The signaller that is invoked is described in package PBSDE.
--  The user interacts with PBSDE by invoking entrypoints in package PBRPH.
--  PBRPH and PBSDE run in different processes or sessions but know how to
--  communicate with each other. (This interaction is currently implemented
--  via secure SGA pipes, but may be changed in the future). PBSDE calls
--  entrypoints in package PBREAK in order to do the actual work that was
--  requested by the user. The final package, PBUTL, contains types and
--  constants that are shared by the packages.
--
--  Events that Probe can handle fall into two categories: breakpoints (which
--  are set on procedures or lines within procedures and which last for the
--  duration of a session) and temporary events. Temporary events consist
--  of requests like "step to the next line," "stop when an exception is
--  raised" etc. PBUTL contains the list of possible events in the
--  flag_break_* constants. (They are named flag_break_* because they are
--  actually flags: any number of temporary events may be enabled in
--  combination at any time.)
--
--  Note that Probe is a low-level set of services. It is not a front-end.
--  It is not a full-fledged debugger. It is not expected to be used directly
--  by an ordinary user. 
--
--  A debugger implementor would write a front-end that would call the
--  procedures in PBRPH, which effectively describes the interface available
--  for debugging programs on the server. This is a somewhat minimal 
--  interface at the current time, but it will grow in the future.
--  As mentioned above, please contact Oracle for a more complete spec if
--  you are considering implementing a debugger.
--
  
CREATE OR REPLACE package PBUTL is
  --  NAME 
  --     PBUTL ProBe UTiLity package.
  --  DESCRIPTION
  --     Defines constants and types used by the Probe packages.

  ------------------------------
  --  PUBLIC CONSTANTS and TYPES

  pipe_buffer_size  constant binary_integer := 1000;
  -- Largest amount to read/write to pipe. (Should include a healthy fudge
  -- factor, since the message status must also go in the message )

  type source_table_type is table of varchar2(1000) index by binary_integer;
  -- source_table is used to transfer large objects (like the entire source
  -- for a unit) over the pipe.
  -- {Should be varchar2(pipe_buffer_size) (except that isn't allowed)}

  -- Flags to pass to set_debug_flags/continue
  -- These MUST correspond exactly to the PEDE* versions in pei.h
  -- (Not all the flags in pei.h are allowed here though.)
  flag_break_on_exception     CONSTANT binary_integer :=    2;
  flag_break_on_call          CONSTANT binary_integer :=    4;
  flag_break_on_external_call CONSTANT binary_integer :=    8;
  flag_break_on_any_return    CONSTANT binary_integer :=   16;
  flag_break_next_line        CONSTANT binary_integer :=   32;
  flag_break_on_ICD           CONSTANT binary_integer :=   64;
  flag_break_on_ICD_return    CONSTANT binary_integer :=  128;
  --flag_break_control_c      CONSTANT binary_integer :=  256;
  flag_break_on_return        CONSTANT binary_integer :=  512;
  flag_break_on_handler       CONSTANT binary_integer := 2048;
  flag_break_on_RPC           CONSTANT binary_integer := 4096;

  type de_context is record (
    status     binary_integer,       -- status of the request
    be_status  binary_integer,       -- status returned by the back-end (PBSDE)
    terminated boolean := false      -- whether the RPC has now terminated
  );
  -- Context passed to pbrph entry-points. This is a diagnostic structure
  -- for debugging the debugger.

  type perst    is record (dummy raw(12));   -- opaque
  -- opaque, and currently unused structure. 
  -- (It is required to be here because it is referenced in peibpa below.)

  -- peibpa drives the "one-call-does-all" get/set interface: the mask 
  -- indicates which of the fields are of interest.
  type peibpa is record (
        mask            binary_integer,
        percflags       binary_integer,
        framecount      binary_integer,
        line            binary_integer,
        breakpoint      binary_integer,
        ith_peibpa      binary_integer,
        ith_frame       perst
  );

  -- mask values for peibpa
  mask_percflags         CONSTANT binary_integer := 1;
  mask_framecount        CONSTANT binary_integer := 2;
  mask_line              CONSTANT binary_integer := 4;
  mask_breakpoint        CONSTANT binary_integer := 8;
  mask_ith_peibpa        CONSTANT binary_integer := 16;
  mask_ith_frame         CONSTANT binary_integer := 32;

  -- Libunit types (used when setting breakpoints)
  -- (These correspond to KGLNPRCD and KGLNBODY in kgl.h)
  libunit_spec           CONSTANT binary_integer := 1;
  libunit_body           CONSTANT binary_integer := 2;
  libunit_procedure      CONSTANT binary_integer := 1;

  -- Events (reasons) that can be read from the pipe. 
  -- These MUST correspond exactly to those in pfrdef.h
  de_none                CONSTANT binary_integer := 0;
  de_bogus_init          CONSTANT binary_integer := 1;
  de_init                CONSTANT binary_integer := 2;
  de_breakpoint          CONSTANT binary_integer := 3;
  de_breakpoint_line     CONSTANT binary_integer := 4;
  de_breakpoint_entry    CONSTANT binary_integer := 5;
  de_enter               CONSTANT binary_integer := 6;
  de_return              CONSTANT binary_integer := 7;
  de_finish              CONSTANT binary_integer := 8;
  de_line                CONSTANT binary_integer := 9;
  de_interrupt           CONSTANT binary_integer := 10;
  de_exception           CONSTANT binary_integer := 11;
  de_icd_call            CONSTANT binary_integer := 12;
  de_icd_return          CONSTANT binary_integer := 13;
  de_watch               CONSTANT binary_integer := 14;
  de_exit                CONSTANT binary_integer := 15;
  de_exception_handler   CONSTANT binary_integer := 16;
  de_timeout             CONSTANT binary_integer := 17;
  de_rpc                 CONSTANT binary_integer := 18;
  de_unhandled_exception CONSTANT binary_integer := 19;
  de_instantiate         CONSTANT binary_integer := 20;
  de_abort               CONSTANT binary_integer := 21;

  -- Statuses from PBSDE indicating whether it was able to fulfill the request.
  -- (These must not overlap the de_* events immediately above.)
  be_success             CONSTANT binary_integer := 1000;
  be_failure             CONSTANT binary_integer := 1001;
  be_warning             CONSTANT binary_integer := 1002;
  be_exception           CONSTANT binary_integer := 1003;
  be_indexed_write       CONSTANT binary_integer := 1004;
  --   be_indexed_write : this message is part of a multi-line message

  ------------------------------
  --  PRIVATE CONSTANTS and TYPES

  -- the string to concatenate to the end of pipe_base to obtain the 
  -- the input and output pipes.
  pls_to_de_extension  CONSTANT  varchar2(10) := '$PLS_TO_DE';
  de_to_pls_extension  CONSTANT  varchar2(10) := '$DE_TO_PLS';

  -- Requests that can be read from the input pipe
  request_continue               CONSTANT binary_integer := 0;
  --request_step                 CONSTANT binary_integer := 1;
  --request_step_into            CONSTANT binary_integer := 2;
  --request_step_return          CONSTANT binary_integer := 3;
  request_quit                   CONSTANT binary_integer := 4;

  request_set_breakpoint_entry   CONSTANT binary_integer := 10;
  request_set_breakpoint_line    CONSTANT binary_integer := 11;
  request_set_breakpoint_except  CONSTANT binary_integer := 12;
  --request_set_debug_flags      CONSTANT binary_integer := 13;
  request_get_debug_flags        CONSTANT binary_integer := 14;

  request_delete_breakpoint      CONSTANT binary_integer := 20;
  request_disable_breakpoint     CONSTANT binary_integer := 21;
  request_enable_breakpoint      CONSTANT binary_integer := 22;

  request_display_frame          CONSTANT binary_integer := 30;
  request_print_backtrace        CONSTANT binary_integer := 31;
  request_print_source           CONSTANT binary_integer := 32;
  request_print_source_location  CONSTANT binary_integer := 33;
  --request_print_pcode_line     CONSTANT binary_integer := 34;
  request_print_breakpoints      CONSTANT binary_integer := 35;

  request_abort                  CONSTANT binary_integer := 100;
  request_unknown                CONSTANT binary_integer := 999;

  -- Additional messages
  tidl_coming           CONSTANT binary_integer := 2000;
  tidl_failure          CONSTANT binary_integer := 2001;
  send_next_tidl        CONSTANT binary_integer := 2002;
  source_coming         CONSTANT binary_integer := 2010;
  source_failure        CONSTANT binary_integer := 2011;
  send_next_source      CONSTANT binary_integer := 2012;

end PBUTL;
/
drop public synonym pbutl;
create public synonym pbutl for sys.pbutl;
grant execute on pbutl to public;


Rem----------------------------------------------------------------------------
Rem    NAME
Rem      pbrph.sql - ProBe (PL/SQL Debugger) Remote Procedure Handler
Rem
Rem    DESCRIPTION
Rem      This package acts as a front-end to debug a program on the server.
Rem      The operations available via this package should be identical to
Rem      those available via the client-side Probe interface. The client
Rem      calls these functions/procedures to communicate requests to the
Rem      program on the server that is being debugged.
Rem
Rem    NOTES
Rem      ******************************************************************
Rem      ** If you are implementing a PL/SQL debugger then this is the   **
Rem      ** package that you are interested in. After receiving requests **
Rem      ** from the user you will call this package to execute them.    **
Rem      ******************************************************************
Rem
Rem      PBRPH passes requests to PBSDE via a communication mechanism, then
Rem      returns results via OUT parameters. 
Rem
Rem      The PL/SQL interpreter (as of 7.2) contains hooks that, when running
Rem      in debug mode, can execute any stored-procedure call in asynchronous
Rem      (ie. non-blocking) mode and set up an additional shadow process to
Rem      debug the call on the server. The shadow process then calls PBRPH
Rem      routines to communicate with and debug the asynchronous call. 
Rem      (Note that this works only for client-to-server at this time: server-
Rem       to-server debugging will be available in a later release.)
Rem
Rem      Alternatively, this package can be called by a client tool to debug
Rem      a PL/SQL execution that is taking place in another process or session. 
Rem      The pipe base must be set up to be the same as that in the other 
Rem      process.
Rem
Rem      Most of the entrypoints in this package take a request and write 
Rem      it (in an encoded form) to the pipe, and then wait for a response. 
Rem      The server-side process reads the request from the pipe, executes it, 
Rem      and puts a response back on the pipe.
Rem      None of the entries take a plspga or a perc: they all operate upon 
Rem      the plspga or perc that the server-side process knows about. (You
Rem      are not expected to understand this if you do not have the Probe
Rem      client-side interface available to you.)
Rem      In addition, there are entrypoints to start and continue execution.
Rem      This corresponds (on the client-side) to starting and suspending 
Rem      the interpreter.
Rem
Rem      Note about displaying values: the procedure "display_frame" returns
Rem      a representation of the stack. This representation is in TIDL
Rem      ("Transportable/Text IDL"). To decode it you need access to the 
Rem      Probe grammars.
Rem
Rem      Global variables "response", "operation", and "status" may be used
Rem      to determine if the interchange was effected successfully.
Rem
Rem      Pipe reads/writes timeout after the provided timeout value.
Rem      Recovery after timeout is currently very poor. This will be fixed
Rem      in the next release.
Rem
Rem    SAMPLE USE:
Rem      (1) Establish a pipe-base to use.
Rem          (This is typically the base returned from a call to PBSDE.init
Rem           in the target process. See PBSDE for notes on how to initialize
Rem           the session to be debugged.)
Rem      (2) Communicate the pipe-base to PBRPH:
Rem          PBRPH.attach(<pipe_base>)
Rem      (3) Once the program to be debugged is executing, listen for the
Rem          first communication from it:
Rem          PBRPH.listen()
Rem      (4) Set a breakpoint:
Rem          PBRPH.set_break_line()
Rem      (5) Step to the next line of the program:
Rem          PBRPH.continue() using debug_flags PBUTL.flag_break_next_line
Rem      (6) Display all values on the current stack:
Rem          PBRPH.display_frame()
Rem      etc.
Rem

CREATE OR REPLACE package PBRPH is

  ------------------------------
  --  PUBLIC CONSTANTS and TYPES

  default_timeout binary_integer := 120;        -- 2 minute timeout
  -- NOTE: default_timeout is not actually used. The caller is required
  --       to provide explicit timeouts in most of the calls.
  --

  -- Some error statuses that can be returned to the caller. These are mostly
  -- for diagnostic purposes.
  min_op_status           CONSTANT binary_integer := 0;
  op_success              CONSTANT binary_integer := 0;
  op_timed_out            CONSTANT binary_integer := 1;
  op_exception            CONSTANT binary_integer := 2;   -- exception in Probe
  op_unpack_error         CONSTANT binary_integer := 3;   -- pipe error
  op_pack_message_error   CONSTANT binary_integer := 4;   -- pipe error
  op_unpack_message_error CONSTANT binary_integer := 5;   -- pipe error
  op_send_message_error   CONSTANT binary_integer := 6;   -- pipe error
  op_be_failure           CONSTANT binary_integer := 7;   -- error in back-end
  op_generic_failure      CONSTANT binary_integer := 8;   -- unidentifed failure
  op_uninitialized        CONSTANT binary_integer := 9;   -- pipe not open
  op_request_queued       CONSTANT binary_integer := 10;
  op_synch_error          CONSTANT binary_integer := 11;  -- continue() out of
                                                          -- phase
  max_op_status           CONSTANT binary_integer := 11;

  request varchar2(200);   -- general-purpose buffer
  buf     varchar2(200);   -- general-purpose buffer

  request_queue        request_table;   -- any pending requests


  -- debugging (diagnostic) levels
  no_debugging     CONSTANT binary_integer := 0;
  full_debugging   CONSTANT binary_integer := 1;

  ------------------------------
  --  PRIVATE TYPES

  -- Used by private internal functions.
  type request_list is table of varchar2(200) index by binary_integer;
  type request_table is record(
    entries request_list,
    len     binary_integer := 0
  );

  ------------------------------
  --  PUBLIC PROCEDURES

  function attach(new_pipe_base in varchar2) return boolean;
  --  Set the input and output pipe names, based on new_pipe_base.
  --  This is equivalent to "attaching" to a process, where the
  --  target process has the same pipe base.
  
  procedure get_pipe_names(inpipe out varchar2, outpipe out varchar2);
  --  Return the current pipe names.
  --   (Because variable-references via RPC do not currently work.)

  procedure shutdown;
  --   Shutdown : delete the pipes.

  procedure listen(
       ctx         in out pbutl.de_context,
       reason      in out binary_integer,   -- the reason for the suspension
       source_line    out binary_integer,   -- line at which suspension occurs
       unit_name   in out varchar2,         -- unit in which suspension occurs
       namespace      out binary_integer,   -- namespace of unit_name
       unit_owner  in out varchar2,         -- owner of unit_name
       dblink      in out varchar2,         -- dblink, if any
       depth       in out binary_integer,   -- number of nested executions
       timeout     in     binary_integer);
  --  Listen for a communication from PBSDE.
  --    When starting an RPC, listen is typically used to wait for the
  --    first information (DE_INIT) from the RPC.

  procedure continue(
       ctx         in out pbutl.de_context,
       debug_flags in     binary_integer,  -- flags to execute with
       reason      in out binary_integer,  -- reason for next suspension
       source_line    out binary_integer,  -- line at which suspension occurs
       unit_name in   out varchar2,        -- unit in which suspension occurs
       namespace      out binary_integer,  -- namespace of unit_name
       unit_owner  in out varchar2,        -- owner of unit_name
       dblink      in out varchar2,        -- dblink, if any
       depth       in out binary_integer,  -- number of nested executions
       timeout     in     binary_integer);
  --  Tell PBSDE to continue execution. 
  --    Waits for the next communication if the current depth is greater
  --    than 0. Otherwise sets "terminated" to 1 and returns.
  --    (If the current depth is 0 then the program on the server has
  --     terminated.)

  procedure display_frame(
       ctx               in out pbutl.de_context, 
       start_frame       in     binary_integer,  -- frame# to start at
       frame_count       in     binary_integer,  -- # frames to fetch
       flags             in     binary_integer,  --  (unused)
       max_string_length in     binary_integer,  -- largest string to fetch
       max_index_values  in     binary_integer,  -- largest table-element to get
       tidl_buf          in out raw,             -- returned TIDL
       --tidl_buflen     in     binary_integer,
       --pieces             out binary_integer,
       timeout           in     binary_integer);
  --  Display one or more frames from the current call stack.
  --  (See the comments in PBREAK for more information.)

  procedure print_backtrace(
       ctx     in out pbutl.de_context,
       listing in out varchar2,
       timeout in     binary_integer);
  --  Dump a call-stack backtrace (just displaying calls, not values)

  procedure print_source(
       ctx         in out pbutl.de_context,
       low         in     binary_integer,     -- line to start at
       high        in     binary_integer,     -- ending line
       window      in     binary_integer,     -- number of lines
       print_arrow in     binary_integer,     -- print arrow at current line?
       buf         in out varchar2,           -- output buffer
       buflen      in     binary_integer,     -- size of buf
       pieces         out binary_integer,     -- # of additional pieces
       timeout     in     binary_integer);
  --  Print out some or all of the source into buf.
  --  (The preferred method is to use KGL on client-side to pin the source,
  --  since that doesn't require repeated passing of text via RPC).

  procedure get_more_source(ctx    in out pbutl.de_context,
                            buf    in out varchar2,
			    buflen in     binary_integer,
                            piece  in     binary_integer);
  --  If print_source indicated that additional pieces were required, call
  --  get_more_source.

  procedure print_source_location(
       ctx         in out pbutl.de_context,
       source_line    out binary_integer,     -- buffer to hold source-line
       unit_name   in out varchar2,           -- buffer to hold unit-name
       namespace      out binary_integer,     -- namespace?
       unit_owner  in out varchar2,           -- owner of current unit
       dblink      in out varchar2,
       timeout     in     binary_integer);
  --  Return the current unit-name and line-number for the target program.
  --    namespace - one of libunit_spec, libunit_body, libunit_procedure (see
  --    package pbutl.)

  function set_break_entry(
       ctx       in out pbutl.de_context,
       unit_name in varchar2,
       unit_type in binary_integer,
       entry     in binary_integer,
       timeout   in binary_integer) return binary_integer;
  --  Set_break_entry : set a breakpoint at the supplied entrypoint.
  --  Set_break_line  : set a breakpoint at the supplied line number.
  --       Both return the breakpoint number, or 0 for failure.
  --
  --  unit_type : one of libunit_spec, libunit_body, libunit_procedure.
  function set_break_line(
       ctx       in out pbutl.de_context,
       unit_name in varchar2,
       unit_type in binary_integer,
       entry     in binary_integer,
       timeout   in binary_integer) return binary_integer;
  -- (See set_break_entry)

  procedure delete_breakpoint(
       ctx        in out pbutl.de_context,
       breakpoint in     binary_integer,
       timeout    in     binary_integer);
  -- Delete_breakpoint : delete the specified breakpoint (which should be
  --                     the return-value from set_break_entry etc.)

  procedure enable_breakpoint(
       ctx        in out pbutl.de_context,
       breakpoint in binary_integer,
       timeout    in binary_integer);
  --  enable a (previously-set) breakpoint

  procedure disable_breakpoint(
       ctx        in out pbutl.de_context,
       breakpoint in binary_integer,
       timeout    in binary_integer);
  --  disable a (previously-set) breakpoint

--
-- Note: the C interface includes a set_debug_flags call, which is used to
--       set the temporary perc flags before resuming the interpreter.
--       In the PL/SQL interface we have the freedom to specify the flags
--       at the continue() call, and this results in one less round-trip
--       across the wire (and one less pipe message too).
--
--       A client-to-server RPC executed by Probe takes advantage of this
--       interface by only setting the local perc flags when requested by
--       the user, and then transmitting those flags with the continue.
--   
--       (This call can certainly be replaced if there is any demand for
--       it.)
--
--  function set_debug_flags(ctx in out pbutl.de_context,
--                           debug_flags in binary_integer,
--                           timeout binary_integer) return binary_integer;

  function get_debug_flags(
       ctx         in out pbutl.de_context,
       debug_flags in out binary_integer,
       timeout     in binary_integer) return binary_integer;
  -- Return the current values of the debug flags.

  procedure print_all_breakpoints(
       ctx     in out pbutl.de_context,
       listing in out varchar2,
       timeout in     binary_integer);
  -- Dump a listing of the currently known breakpoints.

  function set_multiple(bpap in out pbutl.peibpa,
                        timeout binary_integer) return boolean;
  -- Set multiple attributes via the peibpa record.
  --   ****** NOT YET IMPLEMENTED ********

  function get_multiple(bpap in out pbutl.peibpa,
                        timeout binary_integer) return boolean;
  --  Get  multiple attributes via the peibpa record.
  --   ****** NOT YET IMPLEMENTED ********

  ------------------------------
  --  UTILITY/DIAGNOSTIC PROCEDURES

  procedure get_pending_request(
       ctx         in out pbutl.de_context,
       one_request in out varchar2,
       nth         in     binary_integer);
  -- Return the n'th pending request, if one exists.
  --  The current communication mechanism queues any requests that it receives
  --  while PBSDE is not listening. This procedure can be used to look at
  --  requests that have not yet been transmitted to PBSDE.

  function set_debug_level(debug_level in binary_integer) return boolean;
  --  Set the diagnostic level.
  --  debug_level : one of no_debugging, full_debugging.

  procedure flush_pipes(
       ctx              in out pbutl.de_context,
       num_in_messages  in out binary_integer,
       num_out_messages in out binary_integer);
  --  Flush the pipes by repeatedly reading from both of them.
  --    This should not generally be needed.

  procedure delete_debug_table(ctx in out pbutl.de_context);
  --  Empty the debug (diagnostic) table.

  procedure get_oracle_processes(
       ctx     in out pbutl.de_context,
       padsize in     binary_integer,
       result  in out varchar2);
  --  Query for the available Oracle processes. This is just a convenience
  --  for tool2, and it is run here instead of on client-side because this 
  --  package is assumed to be installed as internal (or at least as some
  --  schema that has access to v$process).

  ------------------------------
  --  VARIABLES

  -- the input and output pipes
  pipe_base   varchar2(50) := NULL;   -- just for debugging purposes
  input_pipe  varchar2(50) := NULL;
  output_pipe varchar2(50) := NULL;
  pipes_open  boolean := false;

  current_depth     binary_integer := 0;
  -- The current depth (ie. how many pfrrun's are currently on the C stack
  -- on this host). The depth may be greater than one if a SQL statement 
  -- results in a trigger firing.
  -- Incremented upon DE_INIT and decremented upon DE_EXIT.
  -- All the control entrypoints are defined to return TRUE if current_depth
  -- is 0: this means that the RPC is over.
  -- NOTE: Modifying this variable from outside will upset Probe. Do not do it!
  
  instantiate_depth binary_integer := 0;
  -- RPC instantiation of package spec and/or body is done via additional
  -- calls to the interpreter. Instantiate_depth, if non-zero, indicates
  -- that we are just instantiating a package: therefore DO NOT exit if
  -- depth becomes 0 : the requested entrypoint is still to be run.
  -- NOTE: Modifying this variable from outside will upset Probe. Do not do it!

  operation   binary_integer;   -- the current (or latest) pipe operation
                                -- (helpful in debugging pipe problems)
  reason      binary_integer;   -- reason for the current stoppage
  response    varchar2(1000);   -- the response received from the pipe

  source_tab     pbutl.source_table_type;  -- Private buffer. Do not modify.
  source_tab_len binary_integer := 0;

  debugging  binary_integer := no_debugging;     --> Default to NO diagnostics
  -- debugging (diagnostic) variable. Set by calling "set_debug_level"

  counter    binary_integer := 0;
  -- Diagnostic variable. Do not modify.
  
  ------------------------------
  --  PRIVATE PROCEDURES
  --   These should not ordinarily be called from outside this package.

  procedure continue2(
       ctx          in out pbutl.de_context,
       debug_flags  in     binary_integer,
       reason       in out binary_integer,
       source_line     out binary_integer,
       unit_name in    out varchar2,
       namespace       out binary_integer,
       unit_owner   in out varchar2,
       dblink       in out varchar2,
       depth        in out binary_integer,
       timeout      in     binary_integer,
       ignore_depth in    boolean);
  -- Auxiliary procedure called from continue.  (PRIVATE)

  procedure enqueue(
       ctx  in out pbutl.de_context,
       request in varchar2, 
       queue in out request_table);
  --  Enqueue the request on queue.  (PRIVATE)

  procedure send_pending_requests(
       ctx           in out pbutl.de_context,
       request_queue in out request_table,
       timeout       in     binary_integer);
  --  Send any pending requests to PBSDE.   (PRIVATE)

  procedure print_current_depth;
  --  Dump the nesting depth to the debug stream   (PRIVATE)

  function process_request(
       ctx        in out pbutl.de_context,
       request    in out varchar2,
       result_buf in out varchar2,
       timeout    in     binary_integer) return binary_integer;
  --  Either send a request or enqueue it.   (PRIVATE)

  function read_into_table(
       ctx             in out pbutl.de_context,
       initial_message in     varchar2,
       response        in     binary_integer,
       next_message    in     binary_integer,
       timeout         in     binary_integer) return boolean;
  --  Read a set of messages into the global indexed table   (PRIVATE)
  --  (Used to get TIDL as well as source)

  function multi_read(
       ctx in out pbutl.de_context,
       pieces in binary_integer,
       next in varchar2,
       timeout in  binary_integer) return boolean ;
  --  Auxiliary used by read_into_table    (PRIVATE)

end PBRPH;
/
drop public synonym pbrph;
create public synonym pbrph for sys.pbrph;
grant execute on pbrph to public;


Rem----------------------------------------------------------------------------
Rem    NAME
Rem      pbreak.sql -  ProBe bREAKpoint package.
Rem
Rem    DESCRIPTION
Rem      This package is the PL/SQL API for the breakpoint interface.
Rem      (The corresponding C interface is peibpt.h).
Rem
Rem      This package is strictly a utility package for PBSDE. None of the
Rem      procedures or functions in this package should be called directly,
Rem      with the exception of set_debug and clear_debug. 
Rem      (All of the procedures/functions in this package operate on the 
Rem       current program, so calling them directly doesn't make any sense. 
Rem       If you are thinking of calling any of them directly, you probably
Rem       want the versions in PBRPH instead.)
Rem      
Rem    NOTES
Rem      Should be installed as SYS.
Rem

CREATE OR REPLACE package PBREAK is

  ------------------------------
  --  PUBLIC CONSTANTS and TYPES

  type peidef   is record (dummy raw(12));   -- opaque
  type plspgadf is record (dummy raw(12));   -- opaque
  type kglhd    is record (dummy raw(12));   -- opaque
  -- (peidef, plspgadf, kglhd are currently implemented via binary_integer
  --  due to problems with passing to/from ICD's).

  -- The possible values to pass to set_debug (see below).
  --
  -- debug_rpc_only   : the interpreter will run in debug-mode on the server
  --                    ONLY if it is started from a PL/SQL RPC call.
  -- debug_everything : the interpreter will always run in debug-mode on the
  --                    server
  --
  -- (These values MUST match DE_DEBUG_ON, DE_DEBUG_PEND in pliu.h)
  debug_off             CONSTANT binary_integer := 0;
  debug_rpc_only        CONSTANT binary_integer := 1;  -- (DE_DEBUG_PEND)
  debug_everything      CONSTANT binary_integer := 2;  -- (DE_DEBUG_ON)

  ------------------------------
  --  PUBLIC UTILITY PROCEDURES

  procedure set_debug(debug_level in binary_integer := debug_everything);
  --  Set the debug status in the UGA. 
  --    Subsequent calls to PL/SQL (in this session) will be debugged.

  procedure clear_debug;
  --  Clear the UGA debug status.
  --    Subsequent calls to PL/SQL (in this session) will NOT be debugged.

  ------------------------------
  --  PRIVATE (except to PBSDE)

  --procedure print_pcode_line(perc in peidef, lin out varchar2);
  -- Print the pcode corresponding to current PC.
  --           *** Not implemented ***

  procedure print_source(
       perc        in     peidef, 
       low         in     binary_integer,
       high        in     binary_integer,
       window      in     binary_integer,
       print_arrow in     binary_integer,
       srctab      in out pbutl.source_table_type,
       srctab_size in out binary_integer);
  --  Print the source line corresponding to current PC.
  --  The source is returned in srctab.

  function print_source_location(
       perc in peidef, 
       buf  in out varchar2) return boolean;
  --  Print out the current line number and the unit name.

  function get_plsp_from_perc(perc in peidef) return plspgadf;
  -- Return the plsp associated with perc.

  function set_multiple(
       perc in peidef, 
       bpap in out pbutl.peibpa) return boolean;
  -- Set multiple attributes via the peibpa record.
  --   *** Not yet implemented. ***
  
  function get_multiple(
       perc in peidef, 
       bpap in out pbutl.peibpa) return boolean;
  -- Get multiple attributes via the peibpa record.
  -- *** Not yet implemented ***

  function set_break_entry(
       plsp      in plspgadf,
       unit_name in varchar2,
       unit_type in binary_integer,
       entry     in binary_integer) return binary_integer;
  -- Set a breakpoint at the supplied entrypoint.
  --   Return: breakpoint number, or 0 for failure.
  --   ub4 peibpentry(/*_ plspgadf *plsp, kglhd *lu, ub4 entry _*/);

  function set_break_line(
       plsp      in plspgadf,
       unit_name in varchar2,
       unit_type in binary_integer,
       entry     in binary_integer) return binary_integer;
  --  Set a breakpoint at the supplied line number.
  --    Return: the breakpoint number, or 0 for failure.
  --    ub4 peibpline(/*_ plspgadf *plsp, kglhd *lu, ub4 line _*/);
  --

  procedure delete_breakpoint(breakpoint in binary_integer);
  -- Delete the specified breakpoint (which should be the return-value
  --    from set_break_entry etc.)
  -- void peibpdelete(/*_ plspgadf *plsp, ub4 bpt_index _*/);

  procedure enable_breakpoint(breakpoint in binary_integer);
  -- Enable a (previously-set) breakpoint

  procedure disable_breakpoint(breakpoint in binary_integer);
  -- Disable a (previously-set) breakpoint

  --procedure get_line_and_entry_info(plsp in plspgadf, lu in kglhd,
  --                                 bit_table out <some table>,
  --                                 bit_table_size in binary_integer,
  --                                 max_entries in binary_integer,
  --                                 max_lines in binary_integer);
  -- **************** Not yet implemented *************************
  -- /* Get line number and entry information for a lib unit */
  -- void peibplu_info(/*_ plspgadf *plsp, kglhd *lu, bitvec *bit_table, 
  --             ub4 bit_table_size, ub4 *max_entries_p, ub4 *max_lines_p
  --         _*/);
  -- 

  procedure display_frame(
       perc              in     peidef,
       start_frame_depth in     binary_integer,   -- frame# to start at
       frame_count       in     binary_integer,   -- # of frames to fetch
       flags             in     binary_integer,   -- not yet used
       max_string_length in     binary_integer,   -- longest string
       max_index_values  in     binary_integer,   -- max table values
       tidl_buf          in out raw,              -- buf to place result
       more out boolean);                         -- more pieces to come?
  --  Display one or more frames from the current stack.
  --   The frame is currently the smallest granularity available.

   procedure display_frame_more(
       tidl_buf out raw,
       more out boolean);
   --  Call to get more of the frame, if display_frame indicated that it
   --    couldn't finish in one call.

  function set_debug_flags(
       perc in peidef, request in binary_integer) return binary_integer;
  --  Set percdefl to indicate interesting events on which to break.
  --   "request" must be one of the pbutl.request_* constants.

  function get_debug_flags(perc in peidef) return binary_integer;
  --  Get the current value of percdefl.

  ------------------------------
  --  DEBUGGING ROUTINES

  procedure print_all_breakpoints(
       plsp    in     plspgadf, 
       listing in out varchar2);  -- result buffer
  --  Dump a listing of all the known breakpoints.

  procedure print_backtrace(
       perc    in  peidef, 
       listing out varchar2);    -- result buffer
  --  Dump a listing of the current stack backtrace (display calls, not values)

  procedure debug_message(buf in varchar2);
  --  For debugging the debugger: writes a message to the trace file.

end PBREAK;
/
drop public synonym pbreak;
create public synonym pbreak for sys.pbreak;
grant execute on pbreak to public;


Rem----------------------------------------------------------------------------
Rem    NAME
Rem      pbsde.sql - ProBe (PL/SQL Debugger) Server-side DE package.
Rem
Rem    DESCRIPTION
Rem      This package acts as the server-side equivalent of the client-side
Rem      channel to the user.
Rem      The operations available through this interface should be identical
Rem      to those available on client-side with a suspended perc.
Rem 
Rem    NOTES
Rem      This package is the default "back-end" for server-side debugging. 
Rem      It is passed a perc and then reads operations from a pipe and executes
Rem      them on the perc. It is called from the server-side DE callback, which
Rem      is called from the PL/SQL interpreter whenever a DE event happens.
Rem      Should be installed as SYS.
Rem
Rem      None of the functions or procedures in this package should be called
Rem      directly by the debugger front-end. If you are thinking of calling
Rem      any function or procedure in this package you probably want the
Rem      version in PBRPH.
Rem
Rem    Errors:
Rem      Catastrophic errors (eg. pipe not open) are signalled by writing
Rem      to the trace file (see pbreak.debug_message).
Rem      Less drastic errors are handled by sending messages over the pipe
Rem      to the front-end. 
Rem
Rem    Messages: 
Rem      Messages consist of a message-number (see pbutl) and additional args.
Rem      The message is packed into one varchar2 and read/written as a unit
Rem      to the output/input pipe.
Rem      The maximum message size depends on the buffer-size that the 
Rem      dbms_pipes package was built with.
Rem
Rem      Messages should probably be compacted at some point in the future: 
Rem      for now a simple text format will suffice.
Rem
Rem    Communication:
Rem      The current method of communication between PBSDE and PBRPH is via
Rem      secure pipes in the SGA. Since PBSDE and PBRPH run in separate 
Rem      processes (and possibly separate sessions), it is necessary to 
Rem      initialize both PBSDE and PBRPH so that they agree on the pipe base.
Rem      Two pipes are used: one for communication in each direction. 
Rem      Initializing the pipes consists of setting a pipe basename: once this
Rem      is done the two pipenames are constructed be appending suffixes to
Rem      to the basename.
Rem      (See dbms_pipe.sql for more information on SGA pipes.)
Rem      
Rem
Rem    Sample use:
Rem      1. init()   
Rem        Set up the pipe-names.
Rem        init *must* be called before any output is placed on the pipe.
Rem        If passed the arg 'true' and serveroutput is enabled, dumps the 
Rem        pipe-base to stdout. (Useful when debugging via separate sqldba 
Rem        sessions).
Rem
Rem      2. debug_loop() : sit in a loop writing messages to output_pipe and 
Rem         reading messages from input_pipe and executing them.
Rem         Exit when the message is to continue.
Rem         ** This is typically called directly from the PL/SQL interpreter
Rem            that is executing the program to be debugged. **
Rem
Rem      3. shutdown() cleans up. (Dumps a termination message to the output 
Rem         pipe).
Rem

CREATE OR REPLACE package PBSDE is

  ------------------------------
  --  STATE VARIABLES and TYPES

  -- pipe_base is used as a base to construct input_pipe and output_pipe.
  -- pipes_open is true when the pipe-names have been constructed (by a call
  -- to init()).
  output_pipe  varchar2(50) := NULL;
  input_pipe   varchar2(50) := NULL;
  pipe_base    varchar2(50) := NULL;
  pipes_open   boolean := false;

  -- Debugging variables: (for debugging the debugger)
  -- Set "debugging" to true in order to get regular informative messages about
  --     what the backend is doing.
  -- Set "pipe_debugging" to true in order to get messages about every pipe
  --     operation. (Warning: this may be very verbose).
  debugging       boolean := false;
  pipe_debugging  boolean := false;

  default_timeout  CONSTANT binary_integer := 3600;  -- 1 hour

  ------------------------------
  --  PUBLIC PROCEDURES

  function debug_loop(
       perc in pbreak.peidef,      -- the executing perc
       reason in binary_integer    -- the reason for the event
       ) return binary_integer;
  --  The top-level procedure called from the interpreter upon encountering
  --    an event. Write the reason to the pipe and then execute requests
  --    from the pipe until told to continue.

  procedure init(
       base in varchar2 := null,
       notify in boolean := false);
  --  initialize (generate the pipe names)

  procedure shutdown(notify in boolean := false);
  --  Shutdown (close the pipes.) 

  procedure stat;
  --  Use dbms_output to print the current pipe names. (Used when debugging
  --   via sqldba when the pipe-names are needed to feed to the attach
  --   command. See the front-end).

  function get_pipe_base return varchar2;
  --  Get_pipe_base does the same thing as stat() but returns the pipe_base.
  --   Provided because variable-references via RPC do not (currently?) work.
  --  Used as part of the RPC implementation.


  ------------------------------
  --  PRIVATE PROCEDURES
  --  Should not ordinarily be called from outside this package.

  function write_pipe(
       status in binary_integer,
       msg    in varchar2) return binary_integer;
  --  write msg to output_pipe  (PRIVATE)

  function read_pipe(
       msg           in out varchar2, 
       expected_type in     binary_integer,
       timeout       in     binary_integer := default_timeout
       ) return binary_integer;
  --  read a message from input_pipe  (PRIVATE)

  function handle_request(
       plsp     in     pbreak.plspgadf,
       perc     in     pbreak.peidef,
       request  in     binary_integer,
       msg      in     varchar2,
       continue    out boolean
       ) return binary_integer;
  --  Handle one request (set a breakpoint, continue, etc.) (PRIVATE)
  --   Puts a reply to the output pipe indicating the status of the request.
  --   continue : set to true if the request was to step, continue, or quit.


end PBSDE;
/
drop public synonym pbsde;
create public synonym pbsde for sys.pbsde;
grant execute on pbsde to public;



