/* Copyright (c) 1991 by Oracle Corporation */
/*
   NAME
     ociapr.h

 *  Declare the OCI functions.
 *  Prototype information is included.
 *  Use this header for ANSI C compilers.
 */

#ifndef OCIAPR
#define OCIAPR

#ifdef __IBMC__
# ifndef ORAENTRY
#  define ORAENTRY _System
# endif
#else
# ifdef __BORLANDC__
#  ifndef ORAENTRY
#   define ORAENTRY _syscall
#  endif
# else
#  define ORAENTRY
# endif
#endif

#include <oratypes.h>
#include <ocidfn.h>


#ifdef __cplusplus
extern "c" {
#endif

sword  ORAENTRY  obndra   (struct cda_def *cursor, text *sqlvar, sword sqlvl,
                           ub1 *progv, sword progvl, sword ftype, sword scale,
                           sb2 *indp, ub2 *alen, ub2 *arcode, ub4 maxsiz,
                           ub4 *cursiz, text *fmt, sword fmtl, sword fmtt);
sword  ORAENTRY  obndrn   (struct cda_def *cursor, sword sqlvn, ub1 *progv,
                           sword progvl, sword ftype, sword scale, sb2 *indp,
                           text *fmt, sword fmtl, sword fmtt);
sword  ORAENTRY  obndrv   (struct cda_def *cursor, text *sqlvar, sword sqlvl,
                           ub1 *progv, sword progvl, sword ftype, sword scale,
                           sb2 *indp, text *fmt, sword fmtl, sword fmtt);
sword  ORAENTRY  obreak   (struct cda_def *lda);
sword  ORAENTRY  ocan     (struct cda_def *cursor);
sword  ORAENTRY  oclose   (struct cda_def *cursor);
sword  ORAENTRY  ocof     (struct cda_def *lda);
sword  ORAENTRY  ocom     (struct cda_def *lda);
sword  ORAENTRY  ocon     (struct cda_def *lda);
sword  ORAENTRY  odefin   (struct cda_def *cursor, sword pos, ub1 *buf,
                           sword bufl, sword ftype, sword scale, sb2 *indp,
                           text *fmt, sword fmtl, sword fmtt, ub2 *rlen, ub2 *rcode);
sword  ORAENTRY  odessp   (struct cda_def *cursor, text *objnam, size_t onlen,
                          ub1 *rsv1, size_t rsv1ln, ub1 *rsv2, size_t rsv2ln,
                          ub2 *ovrld, ub2 *pos, ub2 *level, text **argnam,
                          ub2 *arnlen, ub2 *dtype, ub1 *defsup, ub1* mode,
                          ub4 *dtsiz, sb2 *prec, sb2 *scale, ub1 *radix,
                          ub4 *spare, ub4 *arrsiz);
sword  ORAENTRY   odescr   (struct cda_def *cursor, sword pos, sb4 *dbsize,
                            sb2 *dbtype, sb1 *cbuf, sb4 *cbufl, sb4 *dsize,
                            sb2 *prec, sb2 *scale, sb2 *nullok);
sword  ORAENTRY   oerhms   (struct cda_def *lda, sb2 rcode, text *buf,
                            sword bufsiz);
sword  ORAENTRY   oermsg   (sb2 rcode, text *buf);
sword  ORAENTRY   oexec    (struct cda_def *cursor);
sword  ORAENTRY   oexfet   (struct cda_def *cursor, ub4 nrows,
                           sword cancel, sword exact);
sword  ORAENTRY   oexn     (struct cda_def *cursor, sword iters, sword rowoff);
sword  ORAENTRY   ofen     (struct cda_def *cursor, sword nrows);
sword  ORAENTRY   ofetch   (struct cda_def *cursor);
sword  ORAENTRY   oflng    (struct cda_def *cursor, sword pos, ub1 *buf,
                           sb4 bufl, sword dtype, ub4 *retl, sb4 offset);
sword  ORAENTRY   olog     (struct cda_def *lda, ub1* hda,
                           text *uid, sword uidl,
                           text *pswd, sword pswdl, 
                           text *conn, sword connl, 
                           ub4 mode);
sword  ORAENTRY   ologof   (struct cda_def *lda);
sword  ORAENTRY   oopen    (struct cda_def *cursor, struct cda_def *lda,
                           text *dbn, sword dbnl, sword arsize,
                           text *uid, sword uidl);
sword  ORAENTRY   oparse   (struct cda_def *cursor, text *sqlstm, sb4 sqllen,
                           sword defflg, ub4 lngflg);
sword  ORAENTRY   orol     (struct cda_def *lda);


void ORAENTRY   sqlld2     (struct cda_def *lda, text *cname, sb4 *cnlen);
void ORAENTRY   sqllda     (struct cda_def *lda);

/* non-blocking functions */

sword ORAENTRY   onbset    (struct cda_def *lda ); 
sword ORAENTRY   onbtst    (struct cda_def *lda ); 
sword ORAENTRY   onbclr    (struct cda_def *lda ); 
sword ORAENTRY    oopt     (struct cda_def *cursor, sword rbopt, sword waitopt);


/* older calls ; preferred equivalent calls above */

sword ORAENTRY    oname    (struct cda_def *cursor, sword pos, sb1 *tbuf,
                            sb2 *tbufl, sb1 *buf, sb2 *bufl);
sword ORAENTRY    orlon    (struct cda_def *lda, ub1 *hda, 
                            text *uid, sword uidl, 
                            text *pswd, sword pswdl, 
                            sword audit);
sword ORAENTRY    olon     (struct cda_def *lda, text *uid, sword uidl,
                            text *pswd, sword pswdl, sword audit);
sword ORAENTRY    osql3    (struct cda_def *cda, text *sqlstm, sword sqllen);
sword ORAENTRY    odsc     (struct cda_def *cursor, sword pos, sb2 *dbsize,
                           sb2 *fsize, sb2 *rcode, sb2 *dtype, sb1 *buf,
                           sb2 *bufl, sb2 *dsize);
#ifdef __cplusplus
}
#endif

#endif /* OCIAPR */


