/*** rexx ********************************************************************/
/*                                                                           */
/* SAMPLE3.CMD - Oracle-REXX Interface Sample                                */
/*                                                                           */
/* Sample REXX command file to demonstrate use of arrays.                    */
/*                                                                           */
/*****************************************************************************/

CALL RXFUNCADD "SQLEXEC", "RXORA", "SQLEXEC"

/*---------------------------------------------------------------------------*/

SAY "Oracle-REXX Interface - Sample 3: Using arrays"
SAY
SAY "Enter an Oracle connect string in the form: user/password@connect"
SAY "Or simply press enter to use the sample connect string: scott/tiger"
PULL connect .
if connect = "" then
  connect = "scott/tiger"

/*---------------------------------------------------------------------------*/

SAY "Connecting as" connect

CALL SQLEXEC "CONNECT :connect"
CALL CheckSQLReturn

/*---------------------------------------------------------------------------*/

SAY "Creating table REXX_SAMPLE"

CALL SQLEXEC "EXECUTE IMMEDIATE create table rexx_sample (empno number(4), ename varchar2(40), dept number(4))"
IF (result = 0) & (sqlca.sqlcode = -955) THEN DO
  SAY "REXX_SAMPLE table already exists."
  SAY "Do you wish to delete the sample table (yes/no)"
  PULL answer .
  IF answer = "YES" THEN DO
    CALL SQLEXEC "EXECUTE IMMEDIATE drop table rexx_sample"
    CALL CheckSQLReturn
    CALL SQLEXEC "EXECUTE IMMEDIATE create table rexx_sample (empno number(4), ename varchar2(40), dept number(4))"
    END
  ELSE DO
    SAY "Ending sample"
    SIGNAL disconnect
    END
END
CALL CheckSQLReturn

/*--Executing with an array--------------------------------------------------*/

SAY "Adding data to table REXX_SAMPLE"

CALL SQLEXEC "DECLARE stmt1 STATEMENT"
CALL CheckSQLReturn

CALL SQLEXEC "PREPARE stmt1 FROM insert into rexx_sample(empno,ename,dept) values(:a,:b,:c)"
CALL CheckSQLReturn

empno.1 = 1021
ename.1 = 'David'
dept.1  = 20

empno.2 = 1022
ename.2 = 'Beverly'
dept.2  = 20

empno.3 = 1023
ename.3 = 'Tim'
dept.3  = 20

empno.4 = 1024
ename.4 = 'Lily'
dept.4  = 20

n = 4
CALL SQLEXEC "FOR :n EXECUTE stmt1 USING :empno, :ename, :dept"
CALL CheckSQLReturn

/*--Fetching with an array---------------------------------------------------*/

SAY "Query data from table REXX_SAMPLE"

CALL SQLEXEC "DECLARE stmt2 STATEMENT"
CALL CheckSQLReturn

CALL SQLEXEC "DECLARE csr2 CURSOR FOR stmt2"
CALL CheckSQLReturn

CALL SQLEXEC "PREPARE stmt2 FROM select empno, ename from rexx_sample where dept=:a"
CALL CheckSQLReturn

dept = 20
CALL SQLEXEC "OPEN csr2 USING :dept"
CALL CheckSQLReturn

n = 3
rows = 0
CALL SQLEXEC "FOR :n FETCH csr2 INTO :empno, :ename"
DO WHILE (result = 0) & (sqlca.sqlcode >= 0)
  DO i=1 TO (SQLCA.SQLERRD.3 - rows)
    SAY right(empno.i,8) ename.i
  END
  rows = SQLCA.SQLERRD.3
  IF (sqlca.sqlcode > 0) THEN
    LEAVE
  CALL SQLEXEC "FOR :N FETCH csr2 INTO :empno, :ename"
END
IF (result <> 0) | (sqlca.sqlcode <> 1403) THEN
  CALL CheckSQLReturn

CALL SQLEXEC "CLOSE csr2"
CALL CheckSQLReturn

/*---------------------------------------------------------------------------*/

SAY "Drop table REXX_SAMPLE"

CALL SQLEXEC "EXECUTE IMMEDIATE drop table rexx_sample"
CALL CheckSQLReturn

/*---------------------------------------------------------------------------*/
disconnect:
SAY "Disconnect"

CALL SQLEXEC "ROLLBACK RELEASE"
CALL CheckSQLReturn

/*---------------------------------------------------------------------------*/

SAY "Sample completed - Press Enter to exit"
PULL .

EXIT

/*---------------------------------------------------------------------------*/

CheckSQLReturn:
  IF result <> 0 THEN
    SAY "Invalid embedded SQL statement ("result")."
  ELSE IF sqlca.sqlcode <> 0 THEN
    SAY sqlca.sqlerrmc
  IF (result <> 0) | (sqlca.sqlcode <> 0) THEN DO
    SAY "Sample completed - Press Enter to exit"
    PULL .
    EXIT
  END
  RETURN

