/*** rexx ********************************************************************/
/*                                                                           */
/* SAMPLE1.CMD - Oracle-REXX Interface Sample                                */
/*                                                                           */
/* Sample REXX command file to demonstrate multiple database sessions.       */
/*                                                                           */
/*****************************************************************************/

CALL RXFUNCADD "SQLEXEC", "RXORA", "SQLEXEC"

/*---------------------------------------------------------------------------*/

SAY "Oracle-REXX Interface - Sample 4: Multiple database sessions"
SAY
SAY "Enter an Oracle connect string in the form: user/password@connect"
SAY "Or simply press enter to use the sample connect string: scott/tiger"
PULL connect .
if connect = "" then
  connect = "scott/tiger"

/*--Connect using session1---------------------------------------------------*/

SAY "Connecting session1 as" connect

CALL SQLEXEC "DECLARE session1 DATABASE"
CALL CheckSQLReturn

CALL SQLEXEC "CONNECT :connect AT session1"
CALL CheckSQLReturn

/*---------------------------------------------------------------------------*/

SAY "Creating table REXX_SAMPLE"

CALL SQLEXEC "AT session1 EXECUTE IMMEDIATE create table rexx_sample (empno number(4), ename varchar2(40), deptno number(4))"
IF (result = 0) & (sqlca.sqlcode = -955) THEN DO
  SAY "REXX_SAMPLE table already exists."
  SAY "Do you wish to delete the sample table (yes/no)"
  PULL answer .
  IF answer = "YES" THEN DO
    CALL SQLEXEC "AT session1 EXECUTE IMMEDIATE drop table rexx_sample"
    CALL CheckSQLReturn
    CALL SQLEXEC "AT session1 EXECUTE IMMEDIATE create table rexx_sample (empno number(4), ename varchar2(40), deptno number(4))"
    END
  ELSE DO
    SAY "Ending sample"
    SIGNAL disconnect
    END
END
CALL CheckSQLReturn

/*--Add data from session1---------------------------------------------------*/

SAY "Adding data to table REXX_SAMPLE"

CALL SQLEXEC "AT session1 DECLARE stmt1 STATEMENT"
CALL CheckSQLReturn

CALL SQLEXEC "PREPARE stmt1 FROM insert into rexx_sample(empno,ename,deptno) values(:a,:b,:c)"
CALL CheckSQLReturn

empno  = 1021
ename  = 'David'
deptno = 20
CALL SQLEXEC "EXECUTE stmt1 USING :empno, :ename, :deptno"
CALL CheckSQLReturn

empno  = 1022
ename  = 'Beverly'
deptno = 20
CALL SQLEXEC "EXECUTE stmt1 USING :empno, :ename, :deptno"
CALL CheckSQLReturn

CALL SQLEXEC "AT session1 COMMIT"
CALL CheckSQLReturn

/*--Connect using session2---------------------------------------------------*/

SAY "Connecting session2 as" connect

CALL SQLEXEC "DECLARE session2 DATABASE"
CALL CheckSQLReturn

CALL SQLEXEC "CONNECT :connect AT session2"
CALL CheckSQLReturn

/*--Add data from session1---------------------------------------------------*/

SAY "Adding more data to table REXX_SAMPLE from session1"

empno  = 1023
ename  = 'Tim'
deptno = 20
CALL SQLEXEC "EXECUTE stmt1 USING :empno, :ename, :deptno"
CALL CheckSQLReturn

empno  = 1024
ename  = 'Lily'
deptno = 20
CALL SQLEXEC "EXECUTE stmt1 USING :empno, :ename, :deptno"
CALL CheckSQLReturn

/*--Fetch data from session2-------------------------------------------------*/

SAY "Query data from table REXX_SAMPLE from session2"
SAY "Should only see two entries"

CALL SQLEXEC "AT session2 DECLARE stmt2 STATEMENT"
CALL CheckSQLReturn

CALL SQLEXEC "DECLARE csr2 CURSOR FOR stmt2"
CALL CheckSQLReturn

CALL SQLEXEC "PREPARE stmt2 FROM select empno, ename from rexx_sample"
CALL CheckSQLReturn

CALL SQLEXEC "OPEN csr2"
CALL CheckSQLReturn

CALL SQLEXEC "FETCH csr2 INTO :empno, :ename"
DO WHILE (result = 0) & (sqlca.sqlcode = 0)
  SAY right(empno,8) ename
  CALL SQLEXEC "FETCH csr2 INTO :empno, :ename"
END
IF (result <> 0) | (sqlca.sqlcode <> 1403) THEN
  CALL CheckSQLReturn

CALL SQLEXEC "CLOSE csr2"
CALL CheckSQLReturn

/*--Fetch data from session1-------------------------------------------------*/

SAY "Query data from table REXX_SAMPLE from session1"
SAY "Should see four entries"

CALL SQLEXEC "AT session1 DECLARE stmt3 STATEMENT"
CALL CheckSQLReturn

CALL SQLEXEC "DECLARE csr3 CURSOR FOR stmt3"
CALL CheckSQLReturn

CALL SQLEXEC "PREPARE stmt3 FROM select empno, ename from rexx_sample"
CALL CheckSQLReturn

CALL SQLEXEC "OPEN csr3"
CALL CheckSQLReturn

CALL SQLEXEC "FETCH csr3 INTO :empno, :ename"
DO WHILE (result = 0) & (sqlca.sqlcode = 0)
  SAY right(empno,8) ename
  CALL SQLEXEC "FETCH csr3 INTO :empno, :ename"
END
IF (result <> 0) | (sqlca.sqlcode <> 1403) THEN
  CALL CheckSQLReturn

CALL SQLEXEC "CLOSE csr3"
CALL CheckSQLReturn

/*---------------------------------------------------------------------------*/

SAY "Disconnect Session2"

CALL SQLEXEC "AT session2 ROLLBACK RELEASE"
CALL CheckSQLReturn

/*---------------------------------------------------------------------------*/

SAY "Drop table REXX_SAMPLE"

CALL SQLEXEC "AT session1 EXECUTE IMMEDIATE drop table rexx_sample"
CALL CheckSQLReturn

/*---------------------------------------------------------------------------*/
disconnect:
SAY "Disconnect Session1"

CALL SQLEXEC "AT session1 ROLLBACK RELEASE"
CALL CheckSQLReturn

/*---------------------------------------------------------------------------*/

SAY "Sample completed - Press Enter to exit"
PULL .

EXIT

/*---------------------------------------------------------------------------*/

CheckSQLReturn:
  IF result <> 0 THEN
    SAY "Invalid embedded SQL statement ("result")."
  ELSE IF sqlca.sqlcode <> 0 THEN
    SAY sqlca.sqlerrmc
  IF (result <> 0) | (sqlca.sqlcode <> 0) THEN DO
    SAY "Sample completed - Press Enter to exit"
    PULL .
    EXIT
  END
  RETURN

