/*** rexx ********************************************************************/
/*                                                                           */
/* SAMPLE2.CMD - Oracle-REXX Interface Sample                                */
/*                                                                           */
/* Sample REXX command file to demonstrate use of PL/SQL.                    */
/*                                                                           */
/*****************************************************************************/

CALL RXFUNCADD "SQLEXEC", "RXORA", "SQLEXEC"

/*---------------------------------------------------------------------------*/

SAY "Oracle-REXX Interface - Sample 5: PL/SQL blocks"
SAY
SAY "Enter an Oracle connect string in the form: user/password@connect"
SAY "Or simply press enter to use the sample connect string: scott/tiger"
PULL connect .
if connect = "" then
  connect = "scott/tiger"

/*---------------------------------------------------------------------------*/

SAY "Connecting as" connect

CALL SQLEXEC "CONNECT :connect"
CALL CheckSQLReturn

/*---------------------------------------------------------------------------*/

SAY "Creating table REXX_SAMPLE"

CALL SQLEXEC "EXECUTE IMMEDIATE create table rexx_sample (empno number(4), ename varchar2(40), deptno number(4))"
IF (result = 0) & (sqlca.sqlcode = -955) THEN DO
  SAY "REXX_SAMPLE table already exists."
  SAY "Do you wish to delete the sample table (yes/no)"
  PULL answer .
  IF answer = "YES" THEN DO
    CALL SQLEXEC "EXECUTE IMMEDIATE drop table rexx_sample"
    CALL CheckSQLReturn
    CALL SQLEXEC "EXECUTE IMMEDIATE create table rexx_sample (empno number(4), ename varchar2(40), deptno number(4))"
    END
  ELSE DO
    SAY "Ending sample"
    SIGNAL disconnect
    END
END
CALL CheckSQLReturn

/*---------------------------------------------------------------------------*/

SAY "Adding data to table REXX_SAMPLE"

CALL SQLEXEC "DECLARE stmt1 STATEMENT"
CALL CheckSQLReturn

CALL SQLEXEC "PREPARE stmt1 FROM insert into rexx_sample(empno,ename,deptno) values(:a,:b,:c)"
CALL CheckSQLReturn

empno  = 1021
ename  = 'David'
deptno = 10
CALL SQLEXEC "EXECUTE stmt1 USING :empno, :ename, :deptno"
CALL CheckSQLReturn

empno  = 1022
ename  = 'Beverly'
deptno = 20
CALL SQLEXEC "EXECUTE stmt1 USING :empno, :ename, :deptno"
CALL CheckSQLReturn

/*---------------------------------------------------------------------------*/

SAY "Executing a PL/SQL block"

CALL SQLEXEC "DECLARE stmt2 STATEMENT"
CALL CheckSQLReturn

block = ,
   "declare" ,
     "dept number(4);" ,
   "begin" ,
     "select deptno into dept from rexx_sample where empno=:eno;" ,
     "if dept = 10 then" ,
       "update rexx_sample set deptno = 30 where empno=:eno;" ,
     "elsif dept = 20 then" ,
       "update rexx_sample set deptno = 10 where empno=:eno;" ,
     "end if;" , 
   "end;"

CALL SQLEXEC "PREPARE stmt2 FROM :block"
CALL CheckSQLReturn

empno = 1021
CALL SQLEXEC "EXECUTE stmt2 USING :empno"
CALL CheckSQLReturn

empno = 1022
CALL SQLEXEC "EXECUTE stmt2 USING :empno"
CALL CheckSQLReturn

/*---------------------------------------------------------------------------*/

SAY "Query data from table REXX_SAMPLE"

CALL SQLEXEC "DECLARE stmt3 STATEMENT"
CALL CheckSQLReturn

CALL SQLEXEC "DECLARE csr3 CURSOR FOR stmt3"
CALL CheckSQLReturn

CALL SQLEXEC "PREPARE stmt3 FROM select empno, ename, deptno from rexx_sample"
CALL CheckSQLReturn

CALL SQLEXEC "OPEN csr3"
CALL CheckSQLReturn

CALL SQLEXEC "FETCH csr3 INTO :empno, :ename, :deptno"
DO WHILE (result = 0) & (sqlca.sqlcode = 0)
  SAY right(empno,8) left(deptno,3) ename
  CALL SQLEXEC "FETCH csr3 INTO :empno, :ename, :deptno"
END
IF (result <> 0) | (sqlca.sqlcode <> 1403) THEN
  CALL CheckSQLReturn

CALL SQLEXEC "CLOSE csr3"
CALL CheckSQLReturn

/*---------------------------------------------------------------------------*/

SAY "Drop table REXX_SAMPLE"

CALL SQLEXEC "EXECUTE IMMEDIATE drop table rexx_sample"
CALL CheckSQLReturn

/*---------------------------------------------------------------------------*/
disconnect:
SAY "Disconnect"

CALL SQLEXEC "ROLLBACK RELEASE"
CALL CheckSQLReturn

/*---------------------------------------------------------------------------*/

SAY "Sample completed - Press Enter to exit"
PULL .

EXIT

/*---------------------------------------------------------------------------*/

CheckSQLReturn:
  IF result <> 0 THEN
    SAY "Invalid embedded SQL statement ("result")."
  ELSE IF sqlca.sqlcode <> 0 THEN
    SAY sqlca.sqlerrmc
  IF (result <> 0) | (sqlca.sqlcode <> 0) THEN DO
    SAY "Sample completed - Press Enter to exit"
    PULL .
    EXIT
  END
  RETURN

