/****************************************************************/
/*        Lists all members of a Major Major mailing list       */
/*                                                              */
/*      Author:       Peter Moylan (peter@pmoylan.org)          */
/*      Started:      3 May 2001                                */
/*      Last revised: 16 November 2020                          */
/*                                                              */
/*  Usage:                                                      */
/*         listmembers listname                                 */
/*                                                              */
/*  Installation:                                               */
/*         Put this file in the directory containing MAJOR.INI, */
/*         or execute it from that directory.                   */
/*                                                              */
/*  Prerequisite:                                               */
/*         The Rexx scripts SelectTNI.cmd and INI_get.cmd must  */
/*         must be either in the current directory or in your   */
/*         PATH.  To get these scripts, look for a version of   */
/*         GenINI.zip in the same place you found Major Major.  */
/*                                                              */
/****************************************************************/

CALL RxFuncAdd SysLoadFuncs, rexxutil, sysloadfuncs
CALL SysLoadFuncs

IF SysSearchPath('PATH', 'SelectTNI.cmd') = '' THEN DO
    SAY "ERROR: SelectTNI.cmd must be in your PATH"
    EXIT 1
END
IF SysSearchPath('PATH', 'INI_get.cmd') = '' THEN DO
    SAY "ERROR: INI_get.cmd must be in your PATH"
    EXIT 1
END

PARSE ARG listname
listname = Strip(listname)
IF listname = '' THEN
    DO
        SAY "Usage: listmembers listname"
        EXIT 0
    END
IF SelectTNI("Major") > 0 THEN INIname = "Major.TNI"
ELSE INIname = "Major.INI"
SAY "Using "INIname

/* Fetch the list of list members. */

names = INI_get( INIname, listname, 'Members' )
IF names = '' then
    DO
         SAY 'List 'listname' does not exist, or has no members'
         EXIT
    END

/* Strip out the individual names and write them. */

SAY 'Members of list 'listname
SAY '===================='

DO WHILE (names \= '') & (names \= '0'X)
     PARSE VALUE names WITH name1 '0'X names
     SAY '    'name1
END /* DO */

EXIT 0
