int find_secret_for_id (char *id, int idlen, struct state *st);

/* Decode the ID payload of Phase 1 (main_inI3_outR3 and main_inR3) */
static bool
decode_peer_id(struct msg_digest *md, struct state *st)
{
    struct payload_digest *const id_pld = md->chain[ISAKMP_NEXT_ID];
    pb_stream *const id_pbs = &id_pld->pbs;
    struct isakmp_id *const id = &id_pld->payload.id;
    chunk_t identity;

    setchunk(identity, id_pbs->cur, pbs_left(id_pbs));

    /* I think that RFC2407 (IPSEC DOI) 4.6.2 is confused.
     * It talks about the protocol ID and Port fields of the ID
     * Payload, but they don't exist as such in Phase 1.
     * We use more appropriate names.
     * isaid_doi_specific_a is in place of Protocol ID.
     * isaid_doi_specific_b is in place of Port.
     * Besides, there is no good reason for allowing these to be
     * other than 0 in Phase 1.
     */
    if (!(id->isaid_doi_specific_a == 0 && id->isaid_doi_specific_b == 0)
    && !(id->isaid_doi_specific_a == IPPROTO_UDP && id->isaid_doi_specific_b == IKE_UDP_PORT))
    {
      log("protocol/port in Phase 1 ID payload must be 0/0 or %d/%d"
          " but are %d/%d"
          , IPPROTO_UDP, IKE_UDP_PORT
          , id->isaid_doi_specific_a, id->isaid_doi_specific_b);
      return FALSE;
    }
    st->st_peeridentity_protocol = id->isaid_doi_specific_a;
    st->st_peeridentity_port = id->isaid_doi_specific_b;

    /* XXX Check for valid ID types? */
    switch (id->isaid_idtype)
    {
    case ID_IPV4_ADDR:
      if (pbs_left(id_pbs) != sizeof(struct in_addr))
      {
        log("size of ID_IPV4_ADDR identification should be %u"
            " but is %d in ID payload"
            , (unsigned) sizeof(struct in_addr)
            , (unsigned) pbs_left(id_pbs));
        /* XXX Could send notification back */
        return FALSE;
      }
      break;

    case ID_FQDN:
      if (memchr(id_pbs->cur, '@', pbs_left(id_pbs)) != NULL)
      {
        log("at sign (@) found in ID_FQDN identification %s",
        show_identity(identity, id->isaid_idtype));
        /* XXX Could send notification back */
        return FALSE;
      }
      break;

    case ID_USER_FQDN:
      if (memchr(id_pbs->cur, '@', pbs_left(id_pbs)) == NULL)
      {
        log("no at sign (@) found in ID_USER_FQDN identification %s",
        show_identity(identity, id->isaid_idtype));
        /* XXX Could send notification back */
        return FALSE;
      }
      break;

    case ID_KEY_ID:
      if (find_secret_for_id (identity.ptr, identity.len, st)) {
        log("no preshared secret known for %s",
        show_identity(identity, id->isaid_idtype));
        /* XXX Could send notification back */
        return FALSE;
      }
      break;

    default:
      /* XXX Could send notification back */
      log("Unacceptable identity type (%s) in ID payload"
          , enum_show(&ident_names, id->isaid_idtype));
      return FALSE;
    }

    clonereplacechunk(st->st_peeridentity
    , identity.ptr, identity.len
    , "st_peeridentity in decode_peer_id()");
      st->st_peeridentity_type = id->isaid_idtype;
    DBG(DBG_PARSING,
    DBG_log("Peer's ID type is %s: %s",
      enum_show(&ident_names, st->st_peeridentity_type),
      show_identity(st->st_peeridentity, st->st_peeridentity_type)));
    return TRUE;
}



int find_secret_for_id (char *id, int idlen, struct state *st) {
  char password[32];
  int passlen = 0;

// real finding will be here

//
  if (passlen == 0)
    return 1;

  clonetochunk (st->st_peerpreshared, password, passlen, "secret text"); 
  return 0;
}