// from server.c

init_whackfd(void)
{
    struct sockaddr_in sin;
    int s = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);

    if (s == -1)
        exit_log_errno((e, "socket() in init_whackfd()"));

    if (setsockopt(s, SOL_SOCKET, SO_REUSEADDR, (void *)&on, sizeof(on)) < 0)
        exit_log_errno((e, "setsockopt() in init_whackfd()"));

    mksin(sin, htonl(INADDR_LOOPBACK), pluto_port);
    DBG(DBG_KLIPS,
        DBG_log("listening for Whack on %s, file descriptor %d",
            show_sa_in(&sin), s));

    if (bind(s, (struct sockaddr *)&sin, sizeof(sin)) < 0)
        exit_log_errno((e, "bind() of %s in init_whackfd()"
            , show_sa_in(&sin)));

    /* 5 is a haphazardly chosen limit for the backlog.
     * Rumour has it that this is the max on BSD systems.
     */
    if (listen(s, 5) < 0)
        exit_log_errno((e, "listen() for %s in init_whackfd()"
            , show_sa_in(&sin)));

    return s;
}
init_eventlogfd(void)
{
    struct sockaddr_in sin;
    int s = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);

    if (s == -1)
        exit_log_errno((e, "socket() in init_eventlogfd()"));

    if (setsockopt(s, SOL_SOCKET, SO_REUSEADDR, (void *)&on, sizeof(on)) < 0)
        exit_log_errno((e, "setsockopt() in init_eventlogfd()"));

    mksin(sin, htonl(INADDR_LOOPBACK), pluto_port+1);
    DBG(DBG_KLIPS,
        DBG_log("listening for eventlog on %s, file descriptor %d",
            show_sa_in(&sin), s));

    if (bind(s, (struct sockaddr *)&sin, sizeof(sin)) < 0)
        exit_log_errno((e, "bind() of %s in init_eventlogfd()"
            , show_sa_in(&sin)));

    /* 5 is a haphazardly chosen limit for the backlog.
     * Rumour has it that this is the max on BSD systems.
     */
    if (listen(s, 5) < 0)
        exit_log_errno((e, "listen() for %s in init_eventlogfd()"
            , show_sa_in(&sin)));

    return s;
}

#ifndef __WIN32__
unsigned long find_if_ip (char *name, unsigned long addr) {
  int rc;
  int s;
  struct ifreq req;
  unsigned long result;

  memset (&req, 0, sizeof(req));
  strcpy (req.ifr_name, name);

  s = socket (PF_INET, SOCK_STREAM,0);

  if (s < 0) {
    printf ("socket\n");
    return -1;
  }
  rc = ioctl (s, SIOCGIFADDR, (caddr_t)&req, sizeof(req));
  if (!rc) {
    struct sockaddr_in * paddr;

    paddr = (struct sockaddr_in *)&req.ifr_addr;
    result = paddr->sin_addr.s_addr;
  } else result = addr;
  close (s);
  return result;
}

#endif
