# SMTP RESPONSE FILE _________________________________________________________
# DESCRIPTION ________________________________________________________________
# This file contains all responses given to the user client during a SMTP
# session. Only experienced users should edit. New files are likely to
# follow new releases.
#
# NUMERIC CODES ______________________________________________________________
#
#   1yz  Positive Preliminary reply
#   2yz  Positive Completion reply
#   3yz  Positive Intermediate reply
#   4yz  Transient Negative Completion reply
#   5yz  Permanent Negative Completion reply
#
#   x0z  Syntax
#   x1z  Information
#   x2z  Connections
#   x5z  Mail system
# ____________________________________________________________________________
[GLOB]
500a=500 Syntax error, command unrecognized.
502a=502 Command not implemented.

[AUTH]
235a=235 Authentication successful. (rfc2554-4)
334a=334 %(smtp.challenge)
432a=432 A password transition is needed. (rfc2554-6)
454a=454 Temporary authentication failure. (rfc2554-6)
501a=501 Authentication aborted. (rfc2554-4)
503a=503 AUTH command out of sequence; after EHLO and out of transaction. (rfc2554-4)
503b=503 Already authenticated. (rfc2554-4)
504a=504 Unrecognized authentication type. (rfc2554-)
530a=530 Authentication required. (rfc2554-6)
534a=534 Authentication mechanism is too weak. (rfc2554-6)
535a=535 Authentication failed. (rfc2554-6)
538a=538 Encryption required for requested authentication mechanism. (rfc2554-6)

[CONNECT]
220a=220 %(localdomain) Service ready.
421a=421 %(localdomain) Service not available, closing transmission channel.
421b=421 Your client address is not allowed to access this server.
421c=421 No more connections accepted, try again later.
500a=500 
501a=501 
554a=554 

[DATA]
250a=250 Ok
354a=354 Start mail input; end with <CRLF>.<CRLF>
421a=421 %(localdomain) Service not available, closing transmission channel.
451a=451 Requested action aborted: local error in processing.
452a=452 
500a=500 
501a=501 Syntax error in parameters or arguments.
503a=503 MAIL and RCPT commands required before DATA command.
503b=503 RCPT command(s) required before DATA command.
552a=552 Requested mail action aborted: Message rejected.
554a=554 Transaction failed.

[EXPN]
250a=250 name <addr>
252a=252 
421a=421 %(localdomain) Service not available, closing transmission channel.
500a=500 
501a=501 Syntax error in parameters or arguments.
502a=502 Command not implemented.
504a=504 Command parameter not implemented.
550a=550 Access Denied to You.

[HELO]
250a=250 %(localhost) Welcome %(remotehost) [%(remoteip)]
250b=250-%(localhost) Welcome %(remotehost) [%(remoteip)]
250c=250-%A%
250d=250 %A%
421a=421 %(localdomain) Service not available, closing transmission channel.
500a=500 
501a=501 Syntax error in parameters or arguments.
504a=504 Command parameter not implemented.
550a=550 

[HELP]
211a=211 System status, or system help reply.
214a=214 Help message.
421a=421 %(localdomain) Service not available, closing transmission channel.
500a=500 
501a=501 Syntax error in parameters or arguments.
502a=502 Command not implemented.
504a=504 Command parameter not implemented.

[MAIL]
250a=250 Ok
421a=421 %(localdomain) Service not available, closing transmission channel.
451a=451 
452a=452 
500a=500 
501a=501 Syntax error in parameters or arguments.
503a=503 Bad sequence of commands.
550a=550 Reverse-path rejected.
552a=552 
553a=553 Incorrect reverse-path.

[NOOP]
250a=250 Ok
421a=421 %(localdomain) Service not available, closing transmission channel.
500a=500 
501a=501 

[QUIT]
221a=221 Service closing transmission channel
421a=421 
500a=500 
501a=501 

[RCPT]
250a=250 Ok
251a=251 User not local; will forward to <%(ident)%(domain)>
421a=421 %(localdomain) Service not available, closing transmission channel.
450a=450 Requested mail action not taken: mailbox unavailable.
451a=451 
452a=452 
500a=500 
501a=501 Syntax error in parameters or arguments.
503a=503 MAIL command required before RCPT command.
550a=550 No such user here.
551a=551 User not local; please try <%(ident)%(domain)>
552a=552 
553a=553 

[RSET]
250a=250 Ok
421a=421 %(localdomain) Service not available, closing transmission channel.
500a=500 
501a=501 Syntax error in parameters or arguments.

[VRFY]
250a=250 name <addr>
251a=251 User not local; will forward to <>
252a=252 
421a=421 %(localdomain) Service not available, closing transmission channel.
500a=500 Syntax error, command unrecognized.
501a=501 Syntax error in parameters or arguments.
502a=502 Command not implemented.
504a=504 Command parameter not implemented.
550a=550 String does not match anything.
551a=551 User not local; please try <>
553a=553 User ambiguous

[DELIVERY.INTERMEDIATE]
Date: %(smtp.date)
From: %(smtp.from)
To: %(smtp.!FROM)
Subject: Intermediate message delivery report from IPS at %(localhost)

This is an automated message sent to inform you that there are problems
with the delivery of your message:

	Date: %(smtp.!DATE)
	From: %(smtp.!FROM)
	Subject: %(smtp.!SUBJECT)
%(smtp.failures)
If you believe your message has been correctly sent, no further action is
required by you as the InetPowerServer will automatically retry the
operation until it succeeds. Should the message not be successfully
delivered to all recipients within the maximum delivery time you will
receive another report at that time.

This e-mail server is running InetPowerServer (IPS) a free multi platform/
protocol Inet-server package. More information can be found at
http://www.InetPowerServer.com/
[DELIVERY.FINAL]
Date: %(smtp.date)
From: %(smtp.from)
To: %(smtp.!FROM)
Subject: Final message delivery report from IPS at %(localhost)

This is an automated message sent to inform you that there have been
problems with the delivery of your message:

	Date: %(smtp.!DATE)
	From: %(smtp.!FROM)
	Subject: %(smtp.!SUBJECT)

IPS has been unable to deliver your message to the following recipients:

%(smtp.mailboxfailures)
After numerous retires, the maximum delivery time has been exceeded and no
more attempts to deliver your message will be made.

This e-mail server is running InetPowerServer (IPS) a free multi platform/
protocol Inet-server package. More information can be found at 
http://www.InetPowerServer.com/
[DELIVERY.LOOKUP]

IPS was unable to find the network information required to deliver e-mail
to the following domains:

%(smtp.lookupfailures)
Please check the spelling of the domain names. If you find any spelling
mistakes, you should correct them and resend your message.
[DELIVERY.CONNECT]

IPS was unable to connect to any of the mail hosts for the following
domains:

%(smtp.connectfailures)
[DELIVERY.DOMAIN]

IPS was unable to perform a successful dialog with the mail host(s) for the
following domains:

%(smtp.domainfailures)
[DELIVERY.MAILBOX]

IPS was unable to deliver your message to the following recipients because
the remote mail host does not recognize the mailbox(es):

%(smtp.mailboxfailures)
Please check the spelling of the mailbox names. If you find any spelling
mistakes, you should correct them and resend your message.
[--END--]
# END ________________________________________________________________________