/*EXAMPLE REXXHOOK SCRIPT ____________________________________________________
  DESCRIPTION ________________________________________________________________
  With this script you can add your own "SITE" commands, or change/disable the
  internal commands.
  
  RETURN VALUE _______________________________________________________________
  This script should return a full FTP response if it processed/disables the
  command. The response line should be according to FTP standards defined.
  ____________________________________________________________________________*/
PARSE ARG Session CommandIdent Arguments;

PARSE UPPER VAR CommandIdent CommandIdent;
PARSE VALUE ipsVAR(Session, "%(usr.anon)|%(usr.admin)|%(usr.username)|"), 
  WITH usr_anon"|"usr_admin"|"usr_username"|";
  
SELECT
  WHEN (CheckCommand("EXEC", CommandIdent) & usr_admin) THEN 
    RETURN Exec(Arguments);

  WHEN (CheckCommand("WHO", CommandIdent) & usr_anon) THEN 
    RETURN "200 Unknown SITE command.";

  OTHERWISE 
    NOP;
END;

RETURN;
/*____________________________________________________________________________*/
Exec:
PARSE ARG Arguments;

PARSE VALUE ipsVAR(Session, "%(curdisk)|%(platform)|"), 
  WITH curdisk"|"platform"|";
  
SessionDrive = SUBSTR(curdisk, 1, 2);
SessionDirectory = SUBSTR(curdisk, 3);

IF (SessionDirectory = "") THEN 
  SessionDirectory = "\";

TempFile = DIRECTORY()"\siteexec."Session;

CommandExe = VALUE("COMSPEC",, "OS2ENVIRONMENT");
CommandArg = '/C "'SessionDrive' & cd 'SessionDirectory' & 'Arguments'" >'TempFile' 2>>'DIRECTORY()'\siteexec.err';

SELECT
  WHEN (platform = "w32") THEN
    ADDRESS SYSTEM CommandExe CommandArg;
    
  WHEN (platform = "os2") THEN
    ADDRESS CMD CommandExe CommandArg;
    
  OTHERWISE
    NOP;
END;

RETURN "202 SITE EXEC command completed.&"TempFile"!delete";
/*____________________________________________________________________________*/
CheckCommand:
RETURN ABBREV(ARG(1), ARG(2), 2);
/*____________________________________________________________________________*/