/* SRE2003, ver 1.12 

This is the main program. It reads the initialization file, 
launches a "status" daemon, stores the "parent" and "child" procedures
to macrospace (for use as transient transaction & request-specific daemons), loads the 
main "filter" to macrospace, optionally calls a filter-specific startup procedure, and
optionally launches a filter specific daemon manager.

Then, it waits for requests, and launches transaction daemons to handle them.

*/

/***** User configurable parameters -- they usually do not need to be changed ***/


/* beep when a connection is opened */
beepon=0

/* percent of active clients at which warning color is used
   (on status screen)
   Should be a value between 0 and 1 */
client_warning=0.8

/* if TZ variable not available, or not understood, use this
   GMT offset (in seconds). Note that this is the number of
   seconds that should be added to local time to obtain GMT time.
   Example: 18000 for EST */
default_gmtoffset=18000

/* To force SRE2003 to use the default_gmtoffset (and to ignore
   the TZ environment variable), set default_gmtoffset_use=1  */
default_gmtoffset_always=0

/* how frequently to check that all daemons are functioning.
   Large numbers means less frequent checks (each value is about 5 second*/
daemon_check_freq=200

/* If the SERVER_SOFTWARE parameter (in SRE2003.CFG) equals ' ' or
   equals 0, then use as the "servername" (i.e.; in the Server: response header).
   By default, this is the current version of the SRE2003 server software.
   Since an SRE2003 upgrade will NOT change the SRE2003.CFG file, the
   SERVER_SOFTWARE parameter can get out of date. 
*/
default_server_software='SRE2003 for OS/2 ver 1.12d'

/* Same usage default_server_software, for the "short" name */
default_server_software_Short='SRE2003 1.12d'


/* Use "dual key" commands for stopping and sniping (from the SRE2003 status
   screen).
      0 = use single key (ESC, S)
      1 = use dual key (Alt-x, Alt-S) 
   Note: DUAL_KEY is enabled ONLY when poll_keyboard=2. 
         Otherwise, DUAL_KEY=0 is used */
dual_key=0

/* Enable "goserve compatability mode". When enabled, SRE2003 will
   understand several Goserve functions. This can be useful
   if you are using filters or scripts that were written for  Goserve.
     GOSERVE_COMPATABILITY=1  -- enable
     GOSERVE_COMPATABILITY=0  -- disable
   Note:
      enabling compatability mode might cause problems
      if you are ALSO running goserve (on the same machine as
      SRE2003). 
   Instead of compatability mode, consider converting your filter
   to SRE2003 (you can use GOS2SRE.CMD to automate this conversion!) */
goserve_compatability=0

/* Poll keyboard while waiting for user input. All 3 approaches are flawed in wierd &
   transient ways:
   -1  = DO NOT use keyboard input (control via browser). Use to avoid problems on some systems
     0  = do NOT poll keyboard; more stable, but has shutdown problems after >50k requests
     1  = poll keyboard; less stable,  sometimes has fewer shutdown problems
     2  = poll keyboard using mkey, not stable but best approach if it did work
  Eventually we'll have a real solution.... */
poll_keyboard=-1

/* maximum number of host definitions */
max_hosts=200

/* The SRE2003_CFG file contains several basic (not filter specific) parameters */
SRE2003_CFG='cfg\SRE2003.CFG'

/* "target" time in seconds-- (if average response time>target_time, 
    or > 2* target_time, change color in display). */
target_time=1.5

/* Frequency (in seconds) to update status information */
update_rate=1

/* set verbose=1 for a little bit extra status info */
verbose=0

/*****  End of User configurable parameters ****/


/* 1) Load the various dlls, initializse, etc */

parse arg aopts; aopts=strip(aopts)

if poll_keyboard<>2 then dual_key=0

call load_dlls          /* load various procedure libraries */

call check_options     /* look for command line options */

val = SockInit()
if val \= 0 then do
   say "ERROR: SockInit failure: " errno
   exit
end
/* create a socket */
sock1 = SockSocket('AF_INET','SOCK_STREAM','IPPROTO_TCP')
if sock1 < 0 then do
   say 'ERROR: can not get socket (SockSocket:' errno
   exit
end

call sre_ini aopts

signal on syntax name abend ; signal on error name abend
signal on failure name abend ; signal on halt name doquit
signal on novalue name abend2

open_sock1:             /* back here to try an open again */

/* bind the socket to port */
addr.port =sreparams.!PORT 
addr.addr = 'INADDR_ANY'
addr.family = 'AF_INET'

prob=1
foo=socksetsockopt(sock1,'SOL_SOCKET','SO_REUSEADDR',prob)
val = SockBind(sock1,'addr.')

if val \= 0 then do
  call bad_socket
  val = SockShutdown(sock1,2)
  val = SockClose(sock1)
   sock1 = SockSocket('AF_INET','SOCK_STREAM','IPPROTO_TCP')
   if sock1 < 0 then do
      say 'ERROR: can not get socket (SockSocket:' errno
      exit
  end
  signal open_sock1
end


/* make this socket 'passive' */
inq=max(sreparams.!LIMITCLIENTS,8)
val = SockListen(sock1,inq)
if val \= 0 then do
  say 'ERROR: can not listen on socket :' errno
  val = SockShutdown(sock1,2)
  val = SockClose(sock1)
  exit
end

if Sockioctl(sock1,'FIONBIO',1) = -1 then  do      /* switch to nonblocking mode */
   foo=sre_audit('SRE2003.CMD','crashed in sockioctl of sock1 'socket':'errno)
   signal errordone
end

/* almost ready to start accepting requsts. First invoke some daemons */
call do_daemons

/* set some counters to 0 */
alist='BYTESREADTOTAL  BYTESSENTTOTAL TRANSACTIONS  REQUESTS LIMITS ERRORS BROKEN CACHEHITS ' 
do mm=1 to words(alist)
   aww=strip(word(alist,mm))
   foo=sre_countvars(aww,'RESET')
   IF abbrev(FOO,'error')=1 then do
      say 'ERROR initializing counter variable 'aww '='foo
      exit
   end 
end 


/* zero some counters */

/* load some IM procedures */
call do_im_procs
if result='QUIT' then do
    badquit=1
    signal doquit
end

/* load some PRE_TRANSACTION and pre_request procedures */
call do_pre_procs
if result='QUIT' then do
    badquit=1
    signal doquit
end
call do_prereq_procs 
if result='QUIT' then do
    badquit=1
    signal doquit
end


/* filter specific initializations: procedure, and daemon manager */
call do_init_procs
if result='QUIT' then do
    badquit=1
    signal doquit
end

call syssleep(1)              /* wait a second */

schecked=0
transaction=0
show_wait=wordpos('SHOW_WAIT',sreparams.!status_items)

if wordpos('VERBOSE',sreparams.!status_items)>0 then do
   call pmprintf(" ------- ")
  foo=pmprintf('SRE2003 started at '||date('n')||' '||time('n'))
  call pmprintf("       using filter: "sreparams.!filter)
  if sreparams.!fast_filter<>0 then 
  call pmprintf("  and Fast filter: "sreparams.!fast_filter)
end 


foo=sre_eventvars('LASTRESET',dstamp,0)
foo=sre_eventvars('LASTIDLE',dstamp,0)

/* --- At Last -- Start accepting requests!   !!!!!!!   */

if sreparams.!NO_TASKS=2 then do  /* suppress "post initialization" tasks? */
    sreparams.!NO_Tasks=0
    foo=tsre_sysvars('NO_TASKS',0)
    foo=value('SRE_$1_NO_TASKS','0','os2environment')
end 

reqcs=sreparams.!req_cache_enable','sreparams.!req_cache_verify','sreparams.!req_cache_call_anyways','sreparams.!req_cache_record
lims=sreparams.!limitbody' 'sreparams.!limitheader' 'sreparams.!limittimewait' 'sreparams.!limittimeinactive' 'sreparams.!limittimetotal
miscparams=sreparams.!default_socket_timeout||','||sreparams.!tracking_on||','||SREPARAMS.!GMTOFFSET||','|| ,
           sreparams.!datadir||','||sreparams.!server_software||','||sreparams.!im_default||','|| , 
           sreparams.!im_types2||','||num_pre_transaction||','||num_pre_request

AA=SRE_FLAG_set('PAUSE',0,pid)
pause_shutdown_flag=0

Do Forever              /**** Now enter infinite "accept requests" loop ***/

   /* wait for a connection on this socket */

/* but first check some flags */

  if sre_flag_set('#PAUSE_SHUTDOWN')=1 then do  /* pause before shutdown? */
        pause_shutdown_flag=1                   /* this is only used by SRE_STAT */
        call sre_syssleep(0.2)
        iterate
  end 

  if pause_shutdown_flag=1 then do    /* if here, done waiting to exit, so exit */
        call check_status -1
        signal doquit
  end 

  spause=sre_flag_set('#PAUSE_SNIPE')      /* snipe might set this   */

   schecked=schecked+1             /* number of sockets processed since last check_status */
   is_update=SRE_FLAG_SET('RESET',,pid)       /* check reset flag */

/* Reset parameters? Check for reset flag, or every 200 connections */
   if spause=1 | is_update>0 |  schecked>200 then do     
      call check_status is_update
      if result=1 then signal doquit
      if result=2 then do
         foo=sre_write_error('SRE2003: EXIT on Check_status error ',,1)
         signal doquit
      end 
      schecked=0
   end 

   if show_wait>0 then foo=sre_screen_write('SHOW_WAIT')

  kct=1                 /* number of .01 second "polls" (no request outstanding */
  do forever                    /* non blocking socket -- so we have to poll it */
     sock2 = SockAccept(sock1)
     if sock2>0 then leave              /* got a request */

     kct=kct+1
     if (kct//100)=1 then do     /* check for flags every 1 inactive seconds */
         foo=sre_flag_set('#SHUTDOWN')     
         if foo=0 then foo=kct//500             /* more complete check every 5 seconds */
         if foo=1 then do 
           kct=2
           call check_status 
           if result=1 then signal doquit
           schecked=0
         end
     end 
     call sre_syssleep(0.01)                /* take a short break */
  end                              /* end of polling sock2 "do forever" */

   if sock2 < 0 then do
      say  "ERROR: Can not accept on socket :" errno
      val = SockShutdown(sock1,2)
      val = SockClose(sock1)
      signal doquit
   end

   if beepon then call charout,'07'x


/* check for # of active clients (actually, "currently running transaction daemons") */
  isactive=sre_clients('!CT_T')
  if isactive>=sreparams.!LIMITCLIENTS then do  /* too many clients */
     if wordpos('LIMITS',sreparams.!STATUS_ITEMS)>0 then do 
        foo=sre_write_error("SRE2003. Client limit of "sreparams.!limitclients" exceeded at "transaction)
        foo=sre_countvars('LIMITS',1)
     end 
     rc=sockshutdown(sock2,2)
     rc = SockClose(sock2)
     iterate
  end

  caddrs=''   
  if badips.0>0 then do
      gotbad=0
      cc = SockGetPeerName(sock2,"caddr.!")
      is1=space(caddr.!addr,0)
      caddrs=is1||' '||caddr.!port  
      if badips.is1=1 then  gotbad=1
      if gotbad=1 then do       /* this is a "bad" ip -- ignore the request */
         rc=sockshutdown(sock2,2)
         rc = SockClose(sock2)
         if verbose>0 then fp=sre_screen_write('MESSAGE','Denying connection from 'is1" at "time('n'))
         iterate
      end
   end

/* get numeric name of host */
   val = SockGetSockName(sock2,"saddr.!")
   if val \= 0 then do
      foo=sre_write_error("SRE2003. ERROR: cannot get host name :" errno,,1)
      iterate
   end

/* get name of host -- or use the "_USE" values  */
   if sreparams.!serveraddr_use='' then 
      asaddr=saddr.!addr
   else
      asaddr=sreparams.!serveraddr_use

   if sreparams.!servername_use<>'' then do
       hname=sreparams.!servername_use
   end
   else do
     hname=hnames.asaddr
     if hname='' then do
        aa=sockgethostbyaddr(asaddr,"ahost.!")
        if aa=0 then  do/* no such dns entry */
            call sre_pmprintf(" WARNING: no DNS entry for this server. Perhaps you should add an entry using OS/2's TCPCFG configurator?")
              hname=asaddr
        end
        else do
             hname=ahost.!name
        end
        hnames.asaddr=hname
     end
  end


  transaction=transaction+1
  tlist=TRANSACTION'  'pid' 'sock2' 'asaddr' 'saddr.!port

  call launch_transaction_daemon

end             /* wait for next transaction */

call pmprintf(' SHOULD NEVER GET HERE IN SRE2003.cmd')

abend:
        say 'SRE2003 Syntax error, line' sigl':' rc
        foo=sre_write_error('SRE2003. Syntax error, line' sigl':' rc,,1)
         exit

abend2:
        say 'SRE2003 Syntax error, line' sigl': not specified value' 
        foo=sre_write_error('SRE2003. Syntax error, line' sigl':' rc,,1)
        exit

doquit:

 foo=sockshutdown(sock1,2)      /* no more requests accepted */
 foo=sockclose(sock1)

  if badquit=1 then do  /* wait a few seconds for short requests to finish */
        foox=strip(rxlistthreads())
        do j=1 to 4
          if foox=1 then leave
          call syssleep(1)
       end /* do */
  end

  atr=21
  aa=scrclear(,,atr,1)
  say ' Leaving SRE2003 (on socket # 'sock1

  foo=rxqueue('S',basicqueue)
  im=queued()
  do mm=1 to im
    pull .
  end 

/* disconnect all daemons */
foo=sysini(sre2003_ini,'$DMNLIST','ALL:','SLIST')
didclose=0
noclose=0
do mm=1 to slist.0
   foo=sre_dmn_command(slist.mm,'EXIT')
end 
say 'Daemons:  closed='slist.0

foo=sre_flag_set('SHUTDOWN',1,pid)  /* just in case ... signal daemons that they should close */
foo=sre_flag_set('#SHUTDOWN',1)     /* also used to signal daemons that they should close */


call syssleep(2)        /* give daemons a chance to close by themselves */

/* kill all residual threads */
/* how many threads are open... */
threadlist=RxListThreads()
nowtid=dostid()
nkilled=0
call charout,'Killing residual threads ... '
do mm=1 to words(threadlist)
   atid=strip(word(threadlist,mm))
   if nowtid=atid then iterate
   wow=rxprckillthread(atid)
   if wow<>0 then
      say " :: Unable to kill thread: "atid ' ('wow
    else
        nkilled=nkilled+1
end 
call charout,"   # of threads killed= "nkilled "( of "words(threadlist)-1")"
say ' '


/* disconnect all flags */
foo=sysini(SRE2003_INI,'$FLAGLIST','ALL:','SLIST')
didclose=0
do mm=1 to slist.0
   foo=sre_flag_close(slist.mm,pid)
   if foo=1 then 
      didclose=didclose+1
   else 
      say 'Problem disconnecting flag 'slist.mm ' = ' foo
end 
call charout, didclose ' (of '||slist.0||') flags closed.  '

shut_type=sre_value('SHUTDOWN_TYPE',,'SRESYS')

/* remove environment variables */
nenv=dosenvlist('evars.')
do mm=1 to evars.0
   avar=strip(translate(evars.mm))
   if abbrev(avar,'SRE__')=0 then iterate
   foo=sre_value(avar,' ','SRE')
end



/* disconnect all lists */
foo=sysini(SRE2003_INI,'$QLIST','ALL:','SLIST')
didclose=0
do mm=1 to slist.0
   foo=sre_q_close(slist.mm,pid)
   if foo=1 then 
      didclose=didclose+1
   else 
      say 'Problem disconnecting list 'slist.mm ' = ' foo
end 
call charout, didclose ' (of '||slist.0||') lists closed.'
say


foo=sysini('USER','SRE2K','STATUS','Stop: '||date('n')||' '||time('n'))

/* see if REBOOT or RESTART are in shutdown list */

parse var shut_type shut_type shut_type2 ; shut_type=strip(translate(shut_type))

if shut_type='REBOOT' | shut_type='RESTART' then do
    aff=sre_tempfile('SH_'||pid,'CMD',tempdir)

    call lineout aff,'/* */'
    call lineout aff,'foo=sysfiledelete("'||aff||'")'
    if shut_type='REBOOT' then do
      call lineout aff,'CALL PMPRINTF("SRE2003 will reboot shortly ...")'
      call lineout aff,'call syssleep(3)'
      call lineout aff,"'setboot /b '"
    end
    else do
      mdir=maindir
      if left(maindir,1)=':' then mdir=maindir||'\'
      call lineout aff,'goo =directory("'||mdir||'")'
      call lineout aff,' ''START "SRE2003" /C sre2003 '||shut_type2||"'"
      call lineout aff,'CALL PMPRINTF("SRE2003 will restart shortly ...")'
    end
    call lineout aff,'exit'

    call lineout aff
    'start /I /C  ' aff
    call sre_pmprintf(' SRE2003: Shut Down with: '||shut_type)
end 

exit

/****************************/
/* check for command line options */
check_options:

taopts=translate(aopts)

/* enable ansi screen controls */
aesc='1B'x
cy_ye=aesc||'[37;46;m'
cyanon=cy_ye
normal=aesc||'[0;m'
bold=aesc||'[1;m'
re_wh=aesc||'[31;47;m'
reverse=aesc||'[7;m'


call charout, '1b5b'x||'2J' 

if aopts='?' then do
    call showopts
    exit
end 

If pos('-CVT',taopts)>0 then do   /* convert from goseve to SRE2003 */
  call charout, '1b5b'x||'2J'
  oo=gos2sre(' ')
  say
  say " Conversion(s) completed. "
  exit
end

/* modify initialization file (call MOD_INI.CMD) */
if pos('-M',taopts)>0 then do
  if pos('-MALL',taopts)=0 then do
    parse var taopts . '-M' daopt .
    if daopt=''  then daopt=strip(directory(),,'\')||'\'||SRE2003_CFG
    foo="bin\mod_ini"(daopt' 2')
    say
    say " Modifications completed. Status: "bold||foo||normal
    exit
  end
  parse var taopts . '-MALL' daopt .
  if daopt=''  then daopt=strip(directory(),,'\')||'\'||SRE2003_CFG
  foo="bin\mod_ini"(daopt,asrevars)
  say
  say " Modifications completed. Status: "bold||foo||normal
  exit
end

/* change the "plugins" (in the initialization file) (call ADD_PLUG.CMD) */
if pos('-INSTALL',taopts)>0 then do
    parse var taopts . '-INSTALL' daopt .
    if daopt=''  then daopt=strip(directory(),,'\')||'\'||SRE2003_CFG
    foo="add_plug"(daopt)
    say
    say "Modifications completed. Status: "bold||foo||normal
    exit
end

/* call the edit-2002 program */
if pos('-EDIT',taopts)>0 then do
    foo="edit-2002"(daopt)
    say
    say "Modifications completed. Status: "bold||foo||normal
    exit
end


return 1


/*************/
/* problem starting this socket */
bad_socket:

osock=0
arf=rxqueue('s',basicqueue)
address cmd '@NETSTAT -s | rxqueue ' /* get some info on open sockets */
x1=0
do until queued()=0
     pull goo
     if x1=2 then iterate       /*flushing buffer */
     if x1=0 then do
         if abbrev(goo,'====')=0 then iterate
         x1=1
         iterate
     end
     if abbrev(goo,'---')=1 then do
        x1=2
        iterate
     end

/* this line has interesting stuff? */
     if pos("WWW-HTTP..",goo)>0 then do 
        parse var goo osock . ; osock=strip(osock)
     end

end
arf2=rxqueue('s',arf)

say 'ERROR: Can not bind to socket 'sock1':' errno
trykill=0
if osock<>0 then do 
   say "An open socket of "osock" may be causing a problem."
   call charout, "Enter Y to attempt to remove it: "
   aa=charin()
   
   if abbrev(translate(aa),"Y")=1 then do
         trykill=1
         say " Attempting to kill socket: "osock
         val1 = SockShutdown(osock,2)

         if val1<>0 then do
            aerr= SockSock_Errno()
            say "Problem with SockShutdown: "aerr
            trykill=-1
         end
         val2 = SockClose(osock)


         if val2<>0 then do
            aerr= SockSock_Errno()
            say "Problem with SockClose: "aerr
            trykill=-1
         end
        if trykill=1 then return 1
   end
end

if trykill<>1 then do   
   say "Suggestion: use NETSTAT -s and look for a line of the form: "
say "      1268 STREAM         0    www-http..80         0.0.0.0  LISTEN"
       say "(this means that some other app is listening to port 80)"
       say "You should find the application and close it."
       say "Or (since this may be a left over from a failed app), just close the"
       say "the socket (say, using the SOCLOSE program)."
       val = SockShutdown(sock1,2)
       val = SockClose(sock1)
       exit 
end

return 1


/*********************************/
/*   launch a daemon to  handle this transaction 
    or, use an existing "dormant" transaction daemon */

launch_transaction_daemon:

try_agin:

dmn_stuff=sre_q_set('DORMANT_TRANS','POP',0,pid)
if dmn_stuff=0 then  signal new_daemon                /* no dormant daemons, so launch one */
if abbrev(dmn_stuff,'error')=1 then do
   call sre_write_error('SRE2003: recycling transaction error= 'oldq)
   signal new_daemon
end 

/* make sure this daemon is still alive */
if sre_dmn_command(dmn_stuff,'CONNECTED',0)=0 then signal try_agin /* get another from queue */

/* awaken dormant transation daemon, using this transaction info */
paramlist='WAKEUP'||asep|| ,
                 tlist||asep|| ,
                 caddrs||asep|| ,
                 hname||asep|| ,
                 miscparams||asep|| ,
                 lims||asep||  ,
                 sreparams.!status_items||asep|| ,
                 sreparams.!audit_items||asep|| ,
                 reqcs||asep|| ,
                 sreparams.!fast_filter

foo=sre_dmn_ask(dmn_stuff,paramlist,0)
if abbrev(foo,'error q')=1 then signal new_daemon /* wierd error, so launch a new daemon */
return 1

/* jump here to launch new daemon */
new_daemon:
signal on syntax name abend ; signal on error name abend
signal on failure name abend ; signal on halt name doquit
 
 this1='TRN_'||transaction
 afoo=sre_dmn_launch(this1,':SRE_MOD2',, ,
                     tlist,,
                     caddrs, ,
                     hname, ,
                     miscparams, ,
                     lims,  ,
                     sreparams.!status_items, ,
                     sreparams.!audit_items, ,
                     reqcs, ,
                     sreparams.!fast_filter)
   if verbose>1 then call pmprintf('SRE2003 transaction daemon on 'afoo)
 return 0


/*********************/
/* create some flags and lists */

do_flags:

AA=SRE_FLAG_open('MAIN',,pid)
if abbrev(aa,'error')>0 then do 
 say "ERROR: could not create main flag: " aa
 exit
end
foo=sysini(SRE2003_INI,'$FLAGLIST','MAIN',1)

AA=SRE_FLAG_open('RESET',,pid)
if abbrev(aa,'error')>0 then do 
 say "ERROR: could not create reset flag: " aa
 exit
end
foo=sysini(SRE2003_INI,'$FLAGLIST','RESET',1)


AA=SRE_FLAG_open('FILTER_RESET',,pid)
if abbrev(aa,'error')>0 then do 
 say "ERROR: could not create filter-reset flag: " aa
 exit
end
foo=sysini(SRE2003_INI,'$FLAGLIST','FILTER_RESET',1)



AA=SRE_FLAG_open('MODIFY',,pid)
if abbrev(aa,'error')>0 then do 
 say "ERROR: could not create modify flag: " aa
 exit
end
foo=sysini(sre2003_ini,'$FLAGLIST','MODIFY',1)

AA=SRE_FLAG_open('SHUTDOWN',,pid)
if abbrev(aa,'error')>0 then do 
 say "ERROR: could not create shutdown flag: " aa
 exit
end
foo=sysini(sre2003_ini,'$FLAGLIST','SHUTDOWN',1)


AA=SRE_FLAG_open('#SHUTDOWN')
if abbrev(aa,'error')>0 then do 
 say "ERROR: could not create shutdown local flag: " aa
 exit
end
foo=sysini(sre2003_ini,'$FLAGLIST','#SHUTDOWN',1)


AA=SRE_FLAG_open('PAUSE',,pid)
if abbrev(aa,'error')>0 then do 
 say "ERROR: could not create pause flag: " aa
 exit
end
foo=sysini(sre2003_ini,'$FLAGLIST','PAUSE',1)
AA=SRE_FLAG_set('PAUSE',1,pid)


AA=SRE_FLAG_open('#PAUSE_SHUTDOWN')
if abbrev(aa,'error')>0 then do 
  say "ERROR: could not create #pause_shutdown  local flag: " aa
  exit
end
foo=sysini(sre2003_ini,'$FLAGLIST','#PAUSE_SHUTDOWN',1)

AA=SRE_FLAG_open('#PAUSE_SNIPE')
if abbrev(aa,'error')>0 then do 
  say "ERROR: could not create #pause_snipe local flag: " aa
  exit
end
foo=sysini(sre2003_ini,'$FLAGLIST','#PAUSE_SNIPE',1)


ss=sre_q_open('DORMANT_TRANS',pid)
if abbrev(ss,'error')>0 then do 
  say "ERROR: could not create DORMANT_TRANS list: " aa
  exit
end
foo=sysini(sre2003_ini,'$QLIST','DORMANT_TRANS',1)

ss=sre_q_open('DORMANT_REQ',pid)
if abbrev(ss,'error')>0 then do 
  say "ERROR: could not create DORMANT_REQ list: " aa
  exit
end
foo=sysini(sre2003_ini,'$QLIST','DORMANT_REQ',1)

ss=sre_q_open('TOTAL_TIMES',pid)
if abbrev(ss,'error')>0 then do 
  say "ERROR: could not create TOTAL_TIMES list: " aa
  exit
end
foo=sysini(sre2003_ini,'$QLIST','TOTAL_TIMES',1)


return 1



/*********************/
/* setup daemon stuff */

do_daemons:

own_id=sre_dmn_own(2,,'MAIN')   /* used by main thread when talking to daemons */
if abbrev(own_id,'error')=1 then   do
    foo=sre_write_error('SRE2003.  WARNING: own id error '||own_id)
    exit
end
parse var own_id isnew','own_id
if isnew=1 then foo=sysini(sre2003_ini,'$DMNLIST',own_id)


/* launch process-wide variable storage daemon */
var_dmnid=sre_dmn_launch('VAR',bin_dir||'\SRE_VAR.RXX',10000,dstamp,tempdir)

  if abbrev(var_dmnid,'error')=1 then do
     say  ' Problem with Variable-storage Daemon:  ' var_dmnid
     exit
  end
  else do
     parse var var_dmnid atid ',' s1 ',' verify
     if verify<>1 then do
          say  ' Problem verifying VAR  Daemon:  ' verify
         exit
     end 
     say "Variable-storage daemon started on thread "atid
     if verbose>0 then call pmprintf("SRE2003 Variable-storage daemon started on thread "atid)

    foo=sysini(sre2003_ini,'$DMNLIST',s1,1)
   end 

  dmnlist.!var=var_dmnid

/*  launch task manager daemon */
task_dmnid=sre_dmn_launch('TASK',bin_dir'\SRE_TASK.RXX',10000)
  if abbrev(task_dmnid,'error')=1 then do
     say  ' Problem with Task Daemon:  ' task_dmnid
     exit
  end
  else do
     parse var task_dmnid atid ',' s1 ',' verify
     if verify<>1 then do
          say  ' Problem verifying Task Daemon:  ' verify
         exit
     end 
     say "Task daemon started on thread "atid
     if verbose>0 then call pmprintf("SRE2003 Task daemon started on thread "atid)

    foo=sysini(sre2003_ini,'$DMNLIST',s1,1)
   end 

   dmnlist.!task=task_dmnid


/*  launch cache-data daemon */
dcsh_dmnid=sre_dmn_launch('CACHE_DATA',bin_dir'\SRE_DCSH.RXX',10000)
  if abbrev(dcsh_dmnid,'error')=1 then do
     say  ' Problem with Cache-Data Daemon:  ' dcsh_dmnid
     exit
  end
  else do
     parse var dcsh_dmnid atid ',' s1 ',' verify
     if verify<>1 then do
          say  ' Problem verifying Cache-Data Daemon:  ' verify
         exit
     end 
     say "Cache-data daemon started on thread "atid
     if verbose>0 then call pmprintf("SRE2003 Cache-data daemon started on thread "atid)
    foo=sysini(sre2003_ini,'$DMNLIST',s1,1)
   end 

   dmnlist.!dcsh=dcsh_dmnid


/*  launch audit daemon */
aud_dmnid=sre_dmn_launch('AUDIT',bin_dir'\SRE_AUDI.RXX',10000, ,
                        sreparams.!tracking_on,sreparams.!auditfile,,
                        sreparams.!req_cache_hitfile,sreparams.!req_cache_record,sreparams.!audit_delay)


  if abbrev(aud_dmnid,'error')=1 then do
     say  ' Problem with Audit Daemon:  ' aud_dmnid
     exit
  end
  else do
     parse var aud_dmnid atid ',' s1 ',' verify
     if verify<>1 then do
          say  ' Problem verifying Audit Daemon:  ' verify
         exit
     end 
     say "Audit daemon started on thread "atid
     if verbose>0 then    call pmprintf("SRE2003 Audit daemon started on thread "atid)

    foo=sysini(sre2003_ini,'$DMNLIST',s1,1)
   end 

   dmnlist.!aud=aud_dmnid

/* Launch caching daemons 
request: the request cache (match selector to a file)
ipname: match ip address to ip name
count: counter variables storage (such as BYTESENTTOTAL)
event: event variables storage (such as LASTACCEPT)
req_info: daemon info for request daemons
tran_info: daemon info for transaction daemons
*/

csh_dmnid=sre_dmn_launch('CACHE',bin_dir'\SRE_CSH.RXX',10000, ,
                         'REQ REQUEST,IPNAME,COUNT COUNTS,EVENT EVENTS, REQ_INFO, TRAN_INFO, HOSTS ')



  if abbrev(csh_dmnid,'error')=1 then do
    say  ' Problem with Cache  Daemon:  ' csh_dmnid
    exit
  end
  else do
     parse var csh_dmnid atid ',' s1 ',' verify
     if verify<>1 then do
          say  ' Problem verifying Cache  Daemon:  ' verify
          exit
     end 
     say "Cache daemon started on thread "atid
     if verbose>0 then  call pmprintf("SRE2003 Cache daemon started on thread "atid)

     foo=sysini(sre2003_ini,'$DMNLIST',s1,1)
  end 

  dmnlist.!csh=csh_dmnid

/* set sizes of various caches  - these daemons are creaed on sre_dmn_create call to SRE_CSH.RXX */
 foo=sre_cache('REQUEST','RESET',sreparams.!req_cache_size,,,own_id)
 foo=sre_cache('IPNAME','RESET',sreparams.!maxclientnames,,,own_id)
 foo=sre_cache('COUNT','RESET',sreparams.!maxcounters,,,own_id)
 foo=sre_cache('EVENT','RESET',sreparams.!maxcounters,,,own_id)
 foo=sre_cache('HOSTS','RESET',max_hosts,,,own_id)


if sreparams.!MaxMD5s>0 then do
  md5_dmnid=sre_dmn_launch('SRE_MD5',bin_dir'\SRE_MD5.RXX',10000,sreparams.!maxmd5s)


  if abbrev(md5_dmnid,'error')=1 then do
    say  ' Problem with MD5 Daemon:  ' md5_dmnid
    exit
  end
  else do
     parse var md5_dmnid atid ',' s1 ',' verify
     if verify<>1 then do
          say  ' Problem verifying MD5  Daemon:  ' verify
          exit
     end 
     say "MD5 daemon started on thread "atid
     if verbose>0 then  call pmprintf( "SRE2003 MD5 daemon started on thread "atid)

     foo=sysini(sre2003_ini,'$DMNLIST',s1,1)
  end 
end 

   dmnlist.!md5=md5_dmnid

/* Launch list daemon (which is used for statvals) */
list_dmnid=sre_dmn_launch('LIST',bin_dir'\SRE_LIST.RXX',10000)

  if abbrev(list_dmnid,'error')=1 then do
    say  ' Problem with list daemon:  ' list_dmnid
    exit
  end
  else do
     parse var list_dmnid atid ',' s1 ',' verify
     if verify<>1 then do
          say  ' Problem verifying List Daemon:  ' verify
          exit
     end 
     say  "List daemon started on thread "atid
     if verbose>0 then  call pmprintf("SRE2003 List daemon started on thread "atid)

     foo=sysini(sre2003_ini,'$DMNLIST',s1,1)
  end 
  
  dmnlist.!LIST=list_dmnid

/* set sizes of various lists 
  bytes: bytes sent in this request
  total_time: time neede to resolve this request (from launch of daemon to closing out request
  start_transmit_time: "setup" time (from launch of daemon till first response packet sent 
*/
 foo=sre_list('BYTES','CREATE',sreparams.!maxstatvals ,0)
 foo=sre_list('TOTAL_TIME','CREATE',sreparams.!maxstatvals,0)
 foo=sre_list('START_TRANSMIT_TIME','CREATE',sreparams.!maxstatvals,0)
 foo=sre_list('REQUEST','CREATE',sreparams.!maxstatvals,0)
 foo=sre_list('CLIENTADDR','CREATE',sreparams.!maxstatvals,0)


/* Launch status daemon */
  asep='01'x
  srep=sreparams.!port||asep||sreparams.!no_modify_onthefly
  srep=srep||asep||sreparams.!status_message||asep||sreparams.!status_items
  srep=srep||asep||sreparams.!server_software||asep||sreparams.!req_cache_enable
  srep=srep||asep||sreparams.!tracking_on||asep||dual_key

  if datatype(client_warning)<>'NUM' then client_warning=1
  if client_warning<0 | client_warning>1 then client_warning=1
  client_warning=client_warning*sreparams.!limitclients

  stat_dmnid=sre_dmn_launch('STATUS',bin_dir'\SRE_STAT.RXX',0,,
             sreparams.!filter' 'sreparams.!fast_filter, ,
             sock1,update_rate, ,
             target_time,client_warning,full_SRE2003_CFG,,
             srep)
  if abbrev(stat_dmnid,'error')=1 then do
     say  ' Problem with Status Daemon:  ' stat_dmnid
  end
  else do
     parse var stat_dmnid atid ',' s1 ',' .
     say "Status daemon started on thread "atid
     if verbose>0 then call pmprintf("SRE2003 Status daemon started on thread "atid)

     foo=sysini(sre2003_ini,'$DMNLIST',s1,1)
  end 

  dmnlist.!stat=stat_dmnid
  goo=sreparams.!no_modify_onthefly

  if poll_keyboard<>-1 then do
     if goo='1' | goo='2' then goo=1
    key_dmnid=sre_dmn_launch('KEYBOARD',bin_dir'\SRE_KEY.RXX',0,stat_dmnid,pid,poll_keyboard,goo,dual_key)
    if abbrev(key_dmnid,'error')=1 then do
        say  ' Problem with Keyboard Daemon:  ' key_dmnid
    end
    else do
       parse var key_dmnid atid ',' s1 ',' .
       foo=sysini(sre2003_ini,'$DMNLIST',s1,1)
    end 
    if verbose>0 then  call pmprintf('SRE2003 Keyboard daemon on 'atid)
  end
  else do
     call pmprintf(" NO KEYBOARD INPUT ACCEPTED  -- shutdown via browser or by killing process ")
  end 

  dmnlist.0='!AUD !VAR !CSH !MD5 !STAT !LIST !TASK !DCSH ' 


return 1

/********************************/
/* status check. is_update=1 -- check for updated parameter files
                 is_update=-1 -- exit (shut down daemons, etc */

check_status:
parse arg is_update

if is_update <> -1 then do       /* not a shutdown */ 
  npp=0                         /* check for "pause */
  do forever
    if sre_flag_set('PAUSE',,pid)=1 then do
       if npp=0 then  foo=sre_screen_write('MESSAGE','Paused at '||time('n'))
       foo=sre_syssleep(0.1)
       npp=npp+1
       iterate
    end 
    leave
  end
  if npp>0 then  foo=sre_write_message('Ready to accept new connections',1)
end

sflag=sre_flag_set('SHUTDOWN',,pid)

if is_update=-1 | sflag=1 then do
     if is_update=-1 & sflag<>1 then sflag=sre_flag_set('SHUTDOWN',1,pid)
     aa=sre_flag_set('#SHUTDOWN',1)
    if poll_keyboard<>-1 then  foo=sre_dmn_command(key_dmnid,'EXIT',0)
     do ww=1 to words(dmnlist.0)
         aww=strip(word(dmnlist.0,ww))
         foo=sre_dmn_command(dmnlist.aww,'EXIT',0)
     end 
     foo=sre_write_message('SHUTDOWN order has been received ',0)
     return 1
end 

/* check for "reset" signal */
if is_update='' then do
   is_update=sre_flag_set('RESET',,pid)
end

if is_update>0 then do
   aa=sre_flag_set('RESET',0,pid)
   call update_sre_ini

   if result=0 then return 2            /* some kind of error */
   if pos('RESET',sreparams.!audit_items)>0 then 
       foo=sre_audit('RESET ',time('n')||' '||date('n'),0,1)

   Foo=date('S')
   adate=left(foo,4)||'.'||substr(foo,5,2)||'.'||substr(foo,7,2)
   asec=time('N')
   dstamp=adate||' '||asec
   foo=sre_eventvars('LASTRESET',dstamp,0)


   reqcs=sreparams.!req_cache_enable','sreparams.!req_cache_verify','sreparams.!req_cache_call_anyways','sreparams.!req_cache_record
   lims=sreparams.!limitbody' 'sreparams.!limitheader' 'sreparams.!limittimewait' 'sreparams.!limittimeinactive' 'sreparams.!limittimetotal
   miscparams=sreparams.!default_socket_timeout||','||sreparams.!tracking_on||','||SREPARAMS.!GMTOFFSET||','|| ,
           sreparams.!datadir||','||sreparams.!server_software||','||sreparams.!im_default||','|| ,
           sreparams.!im_types2||','||num_pre_transaction||','||num_pre_request

end 

if sreparams.!Unallowed_file<>0 then do
  aa=stream(sreparams.!unallowed_file,'c','query datetime')
  if aa<>badips.!datetime then do
     call read_unalloweds
     if verbose>0 then  do
        nwilds=0
        if badips.!wild<>'' & badips.!wild<>0 then nwilds=words(badips.!wild)
        foo=sre_screen_write('MESSAGE','# of unallowed IP entries ='||badips.0||' ('||nwilds||' wildcards )')
     end
  end 
end 

/* check for daemon life? */
daemon_check=daemon_check+1
if daemon_check>daemon_check_freq then do

   if daemon_check_warning<>0  then do  /* double check suspicious daemon */
        admnid=dmnlist.daemon_check_warning
        astat=sre_dmn_command(admnid,'VERIFY',4000)
        if astat<>1 then do
              foo=sre_write_error('SRE2003. ERROR: non responding daemon 'admnid,,1) 
              call syssleep(20)
              call pmprintf('Exit due to daemon problem at 'daemon_check_warning)
              return 2   /* second error -- quit! */
         end
   end 

/* even if suspicious daemon is okay, check all of them again */
    do ww=1 to  words(dmnlist.0)
        aw=strip(word(dmnlist.0,ww))
        admnid=dmnlist.aw
        astat=sre_dmn_command(admnid,'VERIFY',2000)
        if astat<>1 then do
            foo=sre_write_error('SRE2003. Warning: non responding daemon 'aw,1,1) 
            daemon_check_warning=aw
            daemon_check=Max(daemon_check_freq-2,1)  /* check again soon */
            return 0
        end
    end 

/* if here, daemons are okay */
    daemon_check=0    ;daemon_check_warning=0                  /* reset the clock ... */
    call pmprintf('SRE2003:  daemon check okay ')
end                     /* daemon_check > check_freq */

return 0


/******************************/
/* initialize, load various dlls, etc. */
sre_ini:

crlf='0d0a'x
tsreparams.=''
dmn_tid=0               /* signals no daemon manager */
blank = ' '
null = ''
asep='01'x
daemon_check=0
kdaemon_check_warning=0 
daemon_check_warning=0
badquit=0
num_pre_transaction=0
num_pre_request=0

parse value scrsize() with scrrows scrcols

basicqueue=rxqueue('G')

call pmprintf(' ==== SRE2003 started at '||time('n')||' '||date('n')||' ===== ')


/* currently required variables in SRE2003_CFG file */
srevars='PORT DATADIR LIMITBODY LIMITCLIENTS LIMITHEADER LIMITTIMETOTAL ' ,
        'LIMITTIMEWAIT LIMITTIMEINACTIVE FILTER FAST_FILTER  EXIT_PROC INIT_PROC ' ,
        'DEFAULT_SOCKET_TIMEOUT  SERVER_SOFTWARE STATUS_ITEMS ERRORFILE AUDITFILE AUDIT_ITEMS ',
        'SERVER_SOFTWARE_SHORT UNALLOWED_FILE NO_MODIFY_ONTHEFLY AUDIT_DELAY ' ,
        ' MAXMD5S MAXCOUNTERS MAXCLIENTNAMES MAXSTATVALS', 
        ' REQ_CACHE_SIZE REQ_CACHE_CALL_ANYWAYS REQ_CACHE_ENABLE ',
        ' REQ_CACHE_VERIFY REQ_CACHE_RECORD REQ_CACHE_HITFILE '  ,
        ' STATUS_MESSAGE TRACKING_ON FILTER_VERSION SECURITY_LEVEL ',
        ' IM_TYPES IM_DEFAULT NO_TASKS ENTITY_HEADERS_IGNORE ' ,
        ' SERVERADDR_USE SERVERADDR_INHOUSE SERVERNAME_USE DEFAULT_HOSTS PRE_TRANSACTION PRE_REQUEST '



say "            "cy_ye"SRE2003 ver 1.12d "normal
say "    To view options. enter "bold"x:>SRE2003 ? "normal

say
say bold" Initializing ... "normal

pid=dospid()

taopts=translate(aopts)

sre_watch_on=0
if wordpos('-WATCH',taopts)>0 then do
    say "... launched by SRE_WATCH! "
   sre_watch_on=1
end 

/* alternative SRE2003_CFG file? */
if pos('-I ',taopts)>0 then do
   parse var taopts  '-I' SRE2003_CFG
   SRE2003_CFG=strip(SRE2003_CFG)
   say "   Using initialization file: " SRE2003_CFG
end 

if pos('-P ',taopts)>0 then do
   parse var taopts  '-P' apriority
   parse var apriority lvl '_' clas ; lvl=strip(lvl) ; clas=strip(clas)
   if datatype(clas)<>'NUM' then do
        say "A Bad Priority Class (must be between 1 and 4): "clas
        exit
   end 
   if datatype(lvl)<>'NUM' then do
        say "A Bad Priority Level (must be between 0 and 31): "lvl
        exit
   end 
   if clas>4 | clas<1  then do
        say "Bad Priority Class (must be between 1 and 4): "clas
        exit
   end 
   if lvl>31 | lvl<0  then do
        say "Bad Priority Level (must be between 0 and 31): "lvl
        exit
   end 
   apid=dospid()
   foo=translate(strip(dospriority(lvl,clas,apid)),'/',' ')
   foo2=translate(strip(dospriority(,0,apid)),'/',' ')
   say "   Changed priority level/class from "foo " to " foo2
end 


/* read initialization parameters */

cfg_file=stream(cfg_file,'c','query exists')

call read_cfg_file              /* READ AND CLEANUP SRE2003 CFG file */

/* clear ini file */
appname='$SYSVARS'
sininame='temp\sre'||sreparams.!port||'.ini'
foo=sysini(sininame,appname,'DELETE:')   /* initialize 'SRE2003.INI */
if foo='ERROR:' then do
   say "Unable to clear 'appname'in 'SRE2003 INI file "
   exit
end 
sre2003_ini=stream(sininame,'c','query exists')
if sre2003_ini='' then do
   say "Error: problem creating sre2003_ini "
   exit
end 
foo=tsre_sysvars('SRE2003_INI',sre2003_ini)

foo=tsre_sysvars('SRE_WATCH_ON',sre_watch_on)


appname='$DMNLIST'
sininame='temp\sre'||sreparams.!port||'.ini'
foo=sysini(sininame,appname,'DELETE:')   /* initialize 'SRE2003.INI */
if foo='ERROR:' then do
   say "Unable to clear 'appname'in 'SRE2003 INI file "
   exit
end 
appname='$FLAGLIST'
foo=sysini(sininame,appname,'DELETE:')   /* initialize 'SRE2003.INI */
if foo='ERROR:' then do
   say "Unable to clear 'appname'in "sininame " file "
   exit
end 

foo=tsre_sysvars('LASTSTART',dstamp)
foo=tsre_sysvars('LISTEN_SOCK',sock1)


/* create some flags */
call do_flags


/* initialize  some static storage  */

/* temp storage, for use in creating macrospace proc 
   These are also stored to SRE2003.ini, and to SRESYS envronment */
do mm=1 to words(srevars)
   aw=strip(word(srevars,mm))
   aw2='!'||aw
   foo=tsre_sysvars(aw,sreparams.aw2)
end 

if default_gmtoffset_always=1 then do
    sreparams.!gmtoffset=default_gmtoffset
    say "  Using default GMT Offset = "sreparams.!gmtoffset
end
else do                 /* determine gmtoffset using TZ? */
   tz=value('TZ',,'os2environment')
   if tz='' then do
      say 'ERROR TZ variable is not available'
          say "    Using default GMTOFFSET= " default_gmtoffset
      say bold"    You should add TZ to CONFIG.SYS, or SET TZ before running SRE2003"normal
      sreparams.!gmtoffset=default_gmtoffset
      default_gmtoffset_always=1             /* don't try looking TZ up later */
   end
   else do
       sreparams.!gmtoffset=fig_gmtoffset(tz,default_gmtoffset)
       say "  Using GMT Offset = "sreparams.!gmtoffset
   end
end

oo=sreparams.!GMTOFFSET
foo=tsre_sysvars('GMTOFFSET',oo)  


/* set some directory stuff */
/* SERVDRIVE SERVDIR TEMPDIR BIN_DIR CFG_DIR LOG_DIR STORED_DATA*/

maindir=directory()
maindir=translate(maindir,'\','/')
maindir=strip(maindir,,'\')
foo=tsre_sysvars('SERVDIR',maindir)
foo=tsre_sysvars('SRV_DIR',maindir)

maindrive=filespec('D',maindir)
foo=tsre_sysvars('SERVDRIVE',maindrive)

/* check for existence of required subdirectories */

tempdir=maindir||'\TEMP'
if dosisdir(tempdir)=0 then do
    say "ERROR: no \TEMP subdirectory ("tempdir')'
    exit
end 
foo=tsre_sysvars('TEMPDIR',tempdir)
foo=tsre_sysvars('TMP_DIR',tempdir)
foo=tsre_sysvars('TEMP_DIR',tempdir)


wdatadir=maindir||'\DATA'
if dosisdir(wdatadir)=0 then do
    say "ERROR: no \DATA subdirectory ("wdatadir')'
    exit
end 
foo=tsre_sysvars('STORED_DATA_DIR',wdatadir)

FULL_SRE2003_CFG=stream(sre2003_cfg,'c','query exists')
foo=tsre_sysvars('SRE2003_CFG',full_SRE2003_CFG)

bin_dir=maindir||'\BIN'
if dosisdir(bin_dir)=0 then do
    say "ERROR: no \BIN subdirectory ("bin_dir')'
    exit
end 
foo=tsre_sysvars('BIN_DIR',bin_dir)

cfg_dir=maindir||'\CFG'
if dosisdir(cfg_dir)=0 then do
    say "ERROR: no \CFG subdirectory ("cfg_dir')'
    exit
end 
foo=tsre_sysvars('CFG_DIR',cfg_dir)

log_dir=maindir||'\LOG'
if dosisdir(log_dir)=0 then do
    say "ERROR: no \LOG subdirectory ("log_dir')'
    exit
end 
foo=tsre_sysvars('LOG_DIR',log_dir)


/*  cache hit file */

if pos(':',sreparams.!req_cache_hitfile)=0 then do
   if abbrev(sreparams.!req_cache_Hitfile,'\')=0 then do
       sreparams.!req_cache_hitfile=maindir'\'sreparams.!req_cache_hitfile
       arf=stream(sreparams.!req_cache_hitfile,'c','query exists')
       if arf='' then do
            aa=';SRE2003 cache hit file '
            foo=charout(sreparams.!req_cache_Hitfile,aa,1)
            foo2=stream(sreparams.!req_cache_hitfile,'c','close')
            if foo=0 then do
                 say 'Cache-hit file created: 'sreparams.!req_cache_hitfile
            end 
            else do
                 say 'ERROR: unable to use, or create, cache-hit file: 'sreparams.!req_cache_hitfile
                exit
            end 
       end 
       foo=tsre_sysvars('REQ_CACHE_HITFILE',sreparams.!req_cache_hitfile)  
       say '  Using hit-cache file: 'sreparams.!req_cache_hitfile
   end
end

/* check existence of datadir (root of web tree) */
datadir=sreparams.!DATADIR
datadir=translate(datadir,'\','/')
datadir=strip(strip(datadir,'t','\'))
if pos(':',datadir)=0 then do
   if abbrev(datadir,'\')=1 then do
        datadir=maindrive||datadir
   end
   else do
      datadir=maindir||'\'||datadir
   end /* do */
end
dd=dosisdir(datadir)
if dd=0 then do
   say 'ERROR: no such datadir ('datadir
   exit
end
sreparams.!datadir=datadir
foo=tsre_sysvars('DATADIR',datadir)  
say "  Using data directory: "datadir

/* fix up errorfile and auditfile */
errorfile=sreparams.!ERRORFILE
if pos(':',errorfile)=0 then
  errorfile=maindir||'\'||strip(errorfile,,'\')
sreparams.!errorfile=errorfile
foo=tsre_sysvars('ERRORFILE',errorfile)  

auditfile=sreparams.!AUDITFILE
if pos(':',auditfile)=0 then
   auditfile=maindir||'\'||strip(auditfile,,'\')
sreparams.!auditfile=auditfile
foo=tsre_sysvars('AUDITFILE',auditfile)  

/* say " pre f1"
filter=sreparams.!FILTER
filter=maindir||'\'||strip(filter,,'\')
sreparams.!filter=filter
foo=tsre_sysvars('FILTER',filter)  
call pmprintf(" failter "filter) */

/* check for existence of filter */
filter=stream(maindir||'\'||sreparams.!FILTER,'c','query exists')
if filter='' then do
   say 'ERROR: no such filter file ('filter
   exit
end
sreparams.!FILTER_DIR=strip(filespec('D',filter)||filespec('P',filter),,'\')
foo=tsre_sysvars('FILTER_DIR',sreparams.!FILTER_DIR)  
sreparams.!FILTER=filter
foo=tsre_sysvars('FILTER',sreparams.!FILTER)  


/* check for existence of FAST filter */
fast_filter=sreparams.!FAST_FILTER
if FAST_FILTER<>0 then do
  fast_filter=stream(maindir||'\'||FAST_FILTER,'c','query exists')
   if fast_filter='' then do
     say 'ERROR: no such fast filter file ('fast_filter
     exit
   end
end
if fast_filter<>0 then do
  foo=macrodrop('SRE_FAST_FILTER')
  foo=macroadd2('SRE_FAST_FILTER',fast_filter,'B')
  if foo<>1 then do
     say 'ERROR: unable to load fast filter ('fast_filter
     exit
  end
  dd=sysfiletree(fast_filter,'dd2.')
  fastfilter_stamp=dd2.1
end


/* load sre_filter */
foo=macrodrop('SRE_FILTER')
foo=macroadd2('SRE_FILTER',filter,'b')
if foo=0 then do
 say "ERROR could not load filter into macrospace "
 exit
end
dd=sysfiletree(filter,'dd2.')
filter_stamp=dd2.1

say "  Using filter: "filter
if fast_filter<>0 then
   say '    and fast filter:'fast_filter||normal

/* cache "request daemon procedure" in mspace */
foo=macrodrop("SRE_MOD3")
foo=macroadd2("SRE_MOD3",bin_dir'\SRE_REQ.RXX','B')
if foo=0 then do
  say "ERROR could not load "bin_dir"\SRE_REQ.RXX into macrospace "
  exit
end

/* cache "transaction daemon procedure" in mspace */
foo=macrodrop("SRE_MOD2")
foo=macroadd2("SRE_MOD2",bin_dir'\SRE_TRAN.RXX','B')
if foo=0 then do
  say 'ERROR could not load ' bin_dir'\SRE_TRAN.RXX into macrospace '
  exit
end



hnames.=''

/* Read unallowed ips */
badips.=''
badips.0=0
if sreparams.!unallowed_File<>0 then do
   call read_unalloweds
   nwilds=0
   if badips.!wild<>'' & badips.!wild<>0 then nwilds=words(badips.!wild)
   say '  # of unallowed IP entries: '||badips.0 ||' ( '||nwilds||' wildcards )'
end 


/* set default servername and serveraddress */

serveraddr=sockgethostid()
rc=sockgethostbyaddr(serveraddr,'foo.!')
if rc=1 then
  servername=foo.!name
else
  servername=serveraddr


/*aa=sockgethostbyaddr(asaddr,"ahost.!")
call pmprintf(" asaddr "asaddr ','ahost.!name) */


foo=tsre_sysvars('SERVERADDR_CANONICAL',serveraddr)  
foo=tsre_sysvars('SERVERNAME_CANONICAL',servername)  

amess1='0D0A'X||'0d0a'x||'**** SRE2003 started at '||time('n')||' '||date('n')
amess1=  amess1||'0d0a'x||'             Port='sreparams.!port||'     Process='pid||'  Socket='sock1
foo=sre_append_file(sreparams.!auditfile,amess1,2,1)
parse var foo sz aresp
if sz < 0 then do
    say "ERROR: Problem writing to audit file: " foo
    exit
end

amess1='0D0A'X||'0d0a'x||'**** SRE2003 started at '||time('n')||' '||date('n')||'  '||'0d0a'x
foo=sre_append_file(sreparams.!errorfile,amess1,2,1)  
parse var foo sz aresp
if sz<0 then do
    say "ERROR: Problem writing to error file: " foo
    exit
end

/* save "tsreparams" parameters "into SRESYE "environment" */
foo=save_tsreparams()


/* save some stuff to the USER.INI system file. This is ONLY used by
   installation and other programs -- losing it will NOT effect
   SRE2003 functionality */

foo=sysini('USER','SRE2K','SRV_DIR',maindir)
foo=sysini('USER','SRE2K','FILTER',sreparams.!FILTER)
foo=sysini('USER','SRE2K','FILTER_DIR',sreparams.!FILTER_DIR)
foo=sysini('USER','SRE2K','DATADIR',sreparams.!DATADIR)
foo=sysini('USER','SRE2K','STATUS','Start: '||date('n')||' '||time('n'))


say bold 'Initialization completed for 'normal||'"'||sreparams.!server_software||'"'
call sre_syssleep(1)
return 0


/*************/
/* load some IM procedures */
do_im_procs:
if sreparams.!IM_TYPES=0 then do
     sreparams.!IM_TYPES2=0
     return 0
end
aa=sreparams.!im_types
nims=0
t2=''
aport=sreparams.!port
do until aa=''
   nims=nims+1
    parse var aa a1 ',' aa
    parse var a1 aid afile
    afile=translate(strip(afile),'\','/')
    if abbrev(afile,'\')=1 then afile=maindrive||afile
    if pos(':',afile)=0 then do   /* relative to maindir, or to bin subdir */
       if pos('\',afile)=0 then 
            afile=bin_dir||'\'||afile
       else
            afile=maindir||'\'||afile
    end 
    aname=filespec('n',afile)
    foo=sre_write_message(' Loading IM procedure  ('aname')')
    nm1='SRE2_IM_'||aport||'_'||nims
    foo=macroadd2(nm1,afile,'b')
    if foo=0 then do
       foo=sre_write_error("Error: unable to load IM procedure "afile 'as 'nm1,,1)
       foo=macrodrop(nm1)
       return 'QUIT' 
    end 
/* initialize it */
    ss='a='||nm1||'("!INIT",afile)'
    interpret ss
    if a<>1 then do
       foo=sre_write_error("SRE2003. Error: unable to initialize IM procedure "aname,,1)
       foo=macrodrop(nm1)
       return 'QUIT'
    end

    t2=t2' '||strip(translate(aid))
end
sreparams.!IM_TYPES2=t2
return 1


/*************/
/* load some PRE_TRANSACTION procedures */
do_pre_procs:
if sreparams.!PRE_TRANSACTION=0 then return 0
aa=sreparams.!PRE_TRANSACTION

nims=0
t2=''
aport=sreparams.!port
do until aa=''
   nims=nims+1
    parse var aa afile ','  aa
    afile=translate(strip(afile),'\','/')
    if abbrev(afile,'\')=1 then afile=maindrive||afile
    if pos(':',afile)=0 then do   /* relative to maindir, or to bin subdir */
       if pos('\',afile)=0 then 
            afile=bin_dir||'\'||afile
       else
            afile=maindir||'\'||afile
    end 
    aname=filespec('n',afile)
    foo=sre_write_message(' Loading PRE_TRANSACTION procedure  ('aname')')
    nm1='SRE2_PRETRAN_'||aport||'_'||nims
    foo=macroadd2(nm1,afile,'b')
    if foo=0 then do
       foo=sre_write_error("Error: unable to load pre-transaction procedure "aname 'as 'nm1,,1)
       foo=macrodrop(nm1)
       return 'QUIT' 
    end 
end
num_pre_transaction=nims
return 1



/*************/
/* load some pre_request procedures */
do_prereq_procs:
if sreparams.!pre_request=0 then return 0
aa=sreparams.!pre_request

nims=0
t2=''
aport=sreparams.!port
do until aa=''
   nims=nims+1
    parse var aa afile ','  aa
    afile=translate(strip(afile),'\','/')
    if abbrev(afile,'\')=1 then afile=maindrive||afile
    if pos(':',afile)=0 then do   /* relative to maindir, or to bin subdir */
       if pos('\',afile)=0 then 
            afile=bin_dir||'\'||afile
       else
            afile=maindir||'\'||afile
    end 
    aname=filespec('n',afile)
    foo=sre_write_message(' Loading PRE_REQUEST procedure  ('aname')')
    nm1='SRE2_PREREQ_'||aport||'_'||nims
    foo=macroadd2(nm1,afile,'b')
    if foo=0 then do
       foo=sre_write_error("Error: unable to load pre-request procedure "aname 'as 'nm1,,1)
       foo=macrodrop(nm1)
       return 'QUIT' 
    end 
end
num_PRE_REQUEST=nims
return 1





/*************/
/* run some initialization procedures */
do_init_procs:
if sreparams.!init_proc<>0 & sreparams.!init_proc<>'' then do
  plist=sreparams.!init_proc
  do until plist=''
    parse var plist aplist ',' plist
    parse var aplist aproc aargs
    aproc=strip(translate(strip(aproc),'\','/'))
    if abbrev(aproc,'\')=1 then aproc=maindrive||aproc 
    if pos(':',aproc)=0 then do   /* relative to maindir, or to bin subdir */
       if pos('\',aproc)=0 then 
            aproc=bin_dir||'\'||aproc
       else
            aproc=maindir||'\'||aproc
    end 
    aname=filespec('n',aproc)
    foo=sre_write_message(' Calling initialization procedure  ('aproc')')
    foo=macrodrop('SRE2_INITPROC')
    foo=macroadd2('SRE2_INITPROC',aproc,'b')
    if foo=0 then do
       foo=sre_write_error("SRE2003. Error: unable to load initialization procedure "aproc,,1)
       foo=sre_screen_write('ERROR',"  unable to load init proc: "aname)
       foo=macrodrop('SRE2_INITPROC')
       return 'QUIT'
    end 
    ss=servername
    if sreparams.!servername_use<>'' then ss=sreparams.!servername_use
    foo=sre2_initproc(sreparams.!port,ss,sreparams.!filter_dir,aargs)
    if foo=0  then do
        call pmprintf('Failure in initialization procedure '||filespec('n',aproc))
        foo=sre_screen_write('ERROR','Failure in initialization procedure '||filespec('n',aproc))
       foo=macrodrop('SRE2_INITPROC')
        return 'QUIT'
    end
    foo=sre_write_message("  Init_Proc completed: "aname)
    foo=macrodrop('SRE2_INITPROC')
  end

end
                
 foo=sre_write_message('Ready to accept new connections ',1)

return 1




/*************/
/* run some exit procedures */

do_exit_procs:
if sreparams.!exit_proc=0 | sreparams.!exit_proc='' then return ' '
plist=sreparams.!exit_proc
do until plist=''
    parse var plist aplist ',' plist
    aproc=translate(strip(aplist),'\','/')
    if abbrev(aproc,'\')=1 then aproc=maindrive||aproc 
    if pos(':',aproc)=0 then do   /* relative to maindir, or to bin subdir */
       if pos('\',aproc)=0 then 
            aproc=bin_dir||'\'||aproc
       else
            aproc=maindir||'\'||aproc
    end 
    aname=filespec('n',aproc)
    say ' Calling custom exit procedure 'aproc
    call pmprintf('Calling custom exit procedure 'aproc)

    foo=macrodrop('SRE2_EXITPROC')
    foo=macroadd2('SRE2_EXITPROC',aproc,'b')
    if foo=0 then do
       say "Error: unable to load "aproc
       foo=macrodrop('SRE2_EXITPROC')
       iterate
    end 
    ss=servername
    if sreparams.!servername_use<>'' then ss=sreparams.!servername_use
    foo=sre2_exitproc(sreparams.!port,ss,sreparams.!filter_dir)
    foo=macrodrop('SRE2_EXITPROC')
end 

return 0



/*********************/
/* read initialization parameters */
read_cfg_file:

dd=sysfiletree(SRE2003_CFG,'dd2.')
sre2003_cfg_stamp=dd2.1

stf=read_file(sre2003_cfg,2)
parse var stf isz ainfo '0d0a'x stuff
if isz=0 then do 
   say reverse'ERROR:'normal' empty or missing initialization file: 'SRE2003_CFG
   exit
end
if isz<0 then do
   say reverse'ERROR:'normal' problem opening initialization file: 'ainfo
   exit
end 

sreparams.=''

/* now parse the file */

do until stuff=''
   parse var stuff aline (crlf) stuff
   if aline='' then iterate
   aline=strip(translate(aline,' ','0d0a09'x))
   if abbrev(aline,';')=1 then iterate
   parse var aline avar '=' aval ; 
   avar=translate(strip(avar)) ; aval=strip(aval)
   if wordpos(avar,srevars)=0 then do
      say "  "reverse"Warning:"normal"Unknown SRE2003_CFG variable: "aline
      exit
   end
   cname='!'||avar
   sreparams.cname=aval
end 

/* quality checks */

sreparams.!status_items=translate(space(sreparams.!status_items,1))
sreparams.!audit_items=translate(space(sreparams.!audit_items,1))

if datatype(sreparams.!default_socket_timeout)<>'NUM' then do
   say 'ERROR Bad socket timeout value : 'sreparams.!default_socket_timeout
   exit
end 

if wordpos(sreparams.!no_tasks,'0 1 2')=0 then sreparams.!no_tasks=1

nerrs=0
do mm=1 to words(srevars)
   aw=strip(word(srevars,mm))
   aw2='!'||aw
   if sreparams.aw2='' then do
      say "ERROR: Unspecified Configuration variable: "aw
      say "Please edit "sre2003_cfg
      say "(or run SRE2003 -mall if you want to use a simple parameter editor)"
      exit
   end
end /* do */
if nerrs>0 then exit            /* missing ini variables */


/* check a few parameters */

sreparams.!entity_headers_ignore=translate(space(sreparams.!entity_headers_ignore,1))

aa=sreparams.!serveraddr_use
sreparams.!serveraddr_use=strip(sreparams.!serveraddr_use)
if sreparams.!serveraddr_use=0 then sreparams.!serveraddr_use=' '
if sreparams.!serveraddr_use<>' ' then do
  if verify(sreparams.!serveraddr_use,'0123456789.')>0 then do
      say "ERROR: bad value for SERVERADDR_USE parameter: "aa
     exit
  end 
end

aa=sreparams.!serveraddr_inhouse
sreparams.!serveraddr_inhouse=strip(sreparams.!serveraddr_inhouse)
if sreparams.!serveraddr_inhouse=0 then sreparams.!serveraddr_inhouse=' '
if sreparams.!serveraddr_inhouse<>' ' then do
  if verify(sreparams.!serveraddr_inhouse,'0123456789. ')>0 then do
      say "ERROR: bad value for SERVERADDR_INHOUSE parameter: "aa
     exit
  end 
end


aa=sreparams.!servername_use
sreparams.!servername_use=strip(sreparams.!servername_use)
if sreparams.!servername_use=0 then sreparams.!servername_Use=' '

if datatype(sreparams.!req_cache_size)<>'NUM' then sreparams.!req_cache_size=0

if sreparams.!req_cache_size=0 | datatype(sreparams.!req_cache_enable)<>'NUM' then
        sreparams.!req_cache_enable=0
if datatype(sreparams.!req_cache_record)<>'NUM' then sreparams.!req_cache_record=0

if sreparams.!SERVER_SOFTWARE='' | sreparams.!SERVER_SOFTWARE=0 then
   sreparams.!SERVER_SOFTWARE=default_server_software

if sreparams.!SERVER_SOFTWARE_SHORT='' | sreparams.!SERVER_SOFTWARE_SHORT=0 then
   sreparams.!SERVER_SOFTWARE_SHORT=default_server_software_short

if sreparams.!IM_DEFAULT=''  then sreparams.!IM_DEFAULT='RANGE'

/* check limitbody and limitheader */
if datatype(sreparams.!limitbody)<>'NUM' then do
   say 'ERROR: LIMITBODY must be an integer > 0 '
   exit
end 
sreparams.!limitbody=sreparams.!limitbody*1000

/* check limitbody and limitheader */
if datatype(sreparams.!limitheader)<>'NUM' then do
   say 'ERROR: LIMITHEADER must be an integer > 0 '
   exit
end 
sreparams.!limitheader=sreparams.!limitheader*1000

sreparams.!unallowed_file=stream(sreparams.!unallowed_file,'c','query exists')
if sreparams.!unallowed_file='' then sreparams.!unallowed_file=0

/* set startup date */
Foo=date('S')
adate=left(foo,4)||'.'||substr(foo,5,2)||'.'||substr(foo,7,2)
asec=time('N')
dstamp=adate||' '||asec


return 1


/****************/
/* read unallowed_file
   save non-wildcards to badips stem var
   save wildcards to SRE global var : WILD_BADIPS */

read_unalloweds:

badips.=''
badips.0=0

tuff=read_file(sreparams.!unallowed_file,1)
parse var tuff ilen idate fname '0d0a'x tuff
if ilen<0 then do
    say "ERROR: could not find (' ilen ') UnAllowed IP addresses file:  "sreparams.!unallowed_File 
   exit
end 
badips.!datetime=stream(sreparams.!unallowed_file,'c','query datetime')
do until tuff=''
   parse var tuff anip . '0d0a'x tuff ; 
   if anip='' then iterate
   anip=strip(word(anip,1))
   if abbrev(anip,';')=1 then iterate
   if pos('*',anip)>0 then do
       badips.!wild=badips.!wild||' '||anip
   end 
   else do
     badips.anip=1
     badips.0=badips.0+1
   end
end
xx=sre_value('BADIPS_WILD',badips.!wild,'SREBEST')

/* ----
if length(badips.!WILD)>120 then do
   foo=sre_value('BADIPS_WILD','*','SRE')
   xx=sre_value("BADIPS_WILD",badips.!wild,'SRELARGE')
end
else do
  if length(badips.!wild)=0 then badips.!wild=0
  foo=sre_value('BADIPS_WILD',badips.!wild,'SRE')
end
****/

return 0


/**************************/
/* update SRE2003_CFG vars */
update_sre_ini:procedure expose sreparams. SRE2003_CFG maindir maindrive sock1  pid tz , 
                 default_gmtoffset basicqueue filter fast_filter tsreparams. tempdir sre2003_ini ,
                 sre2003_cfg_stamp filter_stamp fastfilter_stamp default_gmtoffset_always ,
                 default_server_software default_server_software_short verbose own_id

crlf='0d0a'x
didreset=0

/* wait until no requests are active, or 1 minute */
iok=0

srevars_resetable='DATADIR LIMITBODY LIMITCLIENTS LIMITHEADER LIMITTIMETOTAL ' ,
        'LIMITTIMEWAIT LIMITTIMEINACTIVE SECURITY_LEVEL ' ,
        'SERVER_SOFTWARE SERVER_SOFTWARE_SHORT REQ_CACHE_ENABLE REQ_CACHE_RECORD ' 

/* read initialization parameters */

dd=sysfiletree(SRE2003_CFG,'dd2.')
if dd2.0=0 then signal no_cfg_change
if dd2.1=sre2003_cfg_stamp then signal no_cfg_change

sre2003_cfg_stamp=dd2.1

/* if here, sre2003_cfg has changed ... */
stf=read_file(sre2003_cfg,2)
parse var stf isz ainfo '0d0a'x stuff
if isz<0 then do
   foo=sre_write_error('SRE2003 error: Can not open configuration file',,1)
   return 1
end 
if isz=0 then do 
   foo=sre_write_error('SRE2003 error: Empty or missing configuration file',,1)
   return 1
end 

/* now parse the file, eventually to save to SRE_SYSVARS  */

do until stuff=''
   parse var stuff aline (crlf) stuff
   if aline='' then iterate
   aline=strip(translate(aline,' ','0d0a09'x))
   if abbrev(aline,';')=1 then iterate
   parse var aline avar '=' aval ; 
   avar=translate(strip(avar)) ; aval=strip(aval)
   if wordpos(avar,srevars_resetable)=0 then iterate  /* only change "resetable" variables */
   cname='!'||avar
   sreparams.cname=aval
end 

if sreparams.!SERVER_SOFTWARE='' | sreparams.!SERVER_SOFTWARE=0 then
   sreparams.!SERVER_SOFTWARE=default_server_software

if sreparams.!SERVER_SOFTWARE_SHORT='' | sreparams.!SERVER_SOFTWARE_SHORT=0 then
   sreparams.!SERVER_SOFTWARE_SHORT=default_server_software_short


do mm=1 to words(srevars_resetable)
   aw=strip(word(srevars_resetable,mm))
   aw2='!'||aw
   foo=tsre_sysvars(aw,sreparams.aw2)
end 

/* determine gmtoffset using TZ? */
if default_gmtoffset_always<>1 then do
    xx=fig_gmtoffset(tz,default_gmtoffset)
    if xx<>sreparams.!gmtoffset then do
       sreparams.!gmtoffset=xx
       foo=sre_screen_write('RESET','RESET Using GMT Offset = 'sreparams.!gmtoffset)
       foo=tsre_sysvars('GMTOFFSET',xx)
    end
end


/* check existence of datadir */
datadir=sreparams.!DATADIR
datadir=translate(datadir,'\','/')
datadir=strip(strip(datadir,'t','\'))
if pos(':',datadir)=0 then do
   if abbrev(datadir,'\')=1 then do
        datadir=maindrive||datadir
   end
   else do
      datadir=maindir||'\'||datadir
   end /* do */
end
dd=dosisdir(datadir)
if dd=0 then do
   foo=sre_write_error( 'SRE2003. FATAL configuration error: no such datadir ('datadir,,1)
   return 0
end
sreparams.!datadir=datadir
foo=tsre_sysvars('DATADIR',datadir)

/* fix up errorfile and auditfile */
errorfile=sreparams.!ERRORFILE
if pos(':',errorfile)=0 then
    errorfile=maindir||'\'||strip(errorfile,,'\')
sreparams.!errorfile=errorfile
foo=tsre_sysvars('ERRORFILE',errorfile)  

auditfile=sreparams.!AUDITFILE
if pos(':',auditfile)=0 then
   auditfile=maindir||'\'||strip(auditfile,,'\')
sreparams.!auditfile=auditfile
foo=tsre_sysvars('AUDITFILE',auditfile)  

/* say " pre f2"
filter=sreparams.!FILTER
filter=maindir||'\'||strip(filter,,'\')
sreparams.!filter=filter
foo=tsre_sysvars('FILTER',filter)  
call pmprintf(" filter "filter) */


/* check limitbody and limitheader */
if datatype(sreparams.!limitbody)<>'NUM' then do
   foo=sre_write_error('SRE2003. FATAL configuration error: LIMITBODY must be an integer > 0 ',,1)
   return 0
end 
sreparams.!limitbody=sreparams.!limitbody*1000

/* check limitbody and limitheader */
if datatype(sreparams.!limitheader)<>'NUM' then do
   foo=sre_write_error( 'SRE2003. FATAL configuration error: LIMITHEADER must be an integer > 0 ',,1)
   exit
end 
sreparams.!limitheader=sreparams.!limitheader*1000

/* check cache_enable */
if sreparams.!req_cache_size=0 then sreparams.!req_cache_enable=0
if datatype(sreparams.!req_cache_record)<>'NUM' then sreparams.!req_cache_record=0

/* save "tsreparams" parameters "into SRESYS "environment" */
foo=save_tsreparams()           

foo=sre_pmprintf('SRE2003: parameters reset at '||date('n')||' '||time('n'))

didreset=1

no_cfg_change:
dd=sysfiletree(filter,'dd2.')
if dd2.1<>filter_stamp then do
  filter_stamp=dd2.1
  if didreset=0 then call syssleep 4
  foo=macrodrop('SRE_FILTER')
  foo=macroadd2('SRE_FILTER',filter,'B')
  if foo<>1 then do
      foo=sre_write_error( 'ERROR: unable to re-load main filter ('filter,,1)
      return 0
  end
  fii=sre_pmprintf('SRE2003: filter reloaded at 'date('n')||' '||time('n'))
  didreset=1
end

/* reload fast-filter? */
if fast_filter<>0 then do
  dd=sysfiletree(fast_filter,'dd2.')
  if dd2.1<>fastfilter_stamp then do
     fastfilter_stamp=dd2.1
     if didreset=0 then call syssleep 4
     foo=macrodrop('SRE_FAST_FILTER')
     foo=macroadd2('SRE_FAST_FILTER',fast_filter,'B')
     if foo<>1 then do
         foo=sre_write_error( 'ERROR: unable to re-load fast filter ('fast_filter,,1)
         return 0
     end
     fii=sre_pmprintf('SRE2003: fast filter reloaded at 'date('n')||' '||time('n'))
  end
  didreset=1
end

if didreset=1 then  do
   foo=sysini('USER','SRE2K','STATUS','Reset: '||date('n')||' '||time('n'))

/* zap request cache, because datadir and other stuff might have changed */
  if sreparams.!REQ_CACHE_ENABLE=1 then do
     foo=sre_cache('REQUEST','RESET',sreparams.!req_cache_size,,,own_id)
  end
  foo=sre_screen_write('RESET',' (SRE2003 parameters updated at '||time('n')||')')
end


return 1


/***********/
/* determine gmtoffset given tz variable */
fig_gmtoffset:procedure expose basicqueue  sreparams.  tsreparams.  sock1  sre2003_ini  pid verbose
parse upper arg atz,defg
atz=strip(atz)

signal on syntax name foo2 
signal on error  name  foo2
signal on failure name foo2
signal on notready name foo2
curqueue=rxqueue('S',basicqueue)
'@bin\TZSET | RXQUEUE 2> nul '
do until queued()=0
   pull foo1
end 
foo=rxqueue('S',curqueue)

signal on syntax name abend
signal on error name abend
signal on failure name abend

foo1=space(foo1)
if abbrev(foo1,'THE CURRENT TIME ZONE')=0 then do
   foo=sre_audit('SRE2003.CMD',"ERROR Unexpected output from TZSET.EXE: "foo1)
   foo=sre_audit('SRE2003.CMD',"Using default gmtoffset= " defg,'111')
   return defg
end 
oo=word(foo1,words(foo1))
isneg=1
if left(oo,1)='-' then do 
  isneg=-1
  oo=substr(oo,2)
end 
if left(oo,1)='+' then do
   isneg=1
   oo=substr(oo,2)
end 
ii=length(oo)
minn=substr(oo,ii-1)
hrr=left(oo,ii-2)
aoff=-isneg*((hrr*3600)+(minn*60))
return aoff

foo2:
foo=sre_audit('SRE2003.CMD',"ERROR Unexpected output from TZSET.EXE: "foo1)
foo=sre_audit('SRE2003.CMD',"Using default gmtoffset= " defg,'111')
return defg

/*******/
showopts:
say
say "             "cy_ye"SRE2003 : An http/1.1 server for OS/2 "normal
say 
say cy_ye"SRE2003 Startup Options: "normal
say bold"    no options :"normal" start the server, using options in "SRE2003_CFG
say bold"           ?   :"normal"  View this help screen "
say bold"   -i filename :"normal" Specify an initializaton file (instead of "SRE2003_CFG")"
say bold"   -p class_lvl :"normal" Specify priority class & level"
say bold"  -install [filename] :"normal" Change the values of SRE2003 PlugIn variables"
say bold"       -edit   :"normal" Edit one of three configuration files "
say bold"     -m [filename] :"normal" Modify most important initialization parameters -- "
say "    do NOT start the server (if filename not specified, modify "SRE2003_CFG")"
say bold"  -mall [filename] :"normal" Modify all initialization parameters -- "
say "    do NOT start the server (if filename not specified, modify "SRE2003_CFG")"
say bold"       -watch  :"normal"  Signal that SREWATCH program started SRE2003"

say bold"         -cvt  :"normal"  Convert a file from GoServe-syntax to SRE2003-syntax "

say 
say "Examples (assuming the SRE2003 working directory is D:\SRE2003)"
say   bold"   D:\SRE2003>SRE2003 "normal
say   bold"   D:\SRE2003>SRE2003 -i SRE2003.in2 "normal
say   bold"   D:\SRE2003>SRE2003  -cvt  "normal
say   bold"   D:\SRE2003>SRE2003  -m  "normal
say   bold"   D:\SRE2003>SRE2003  -mall  "normal
return 0



/**********/
/* store "sysvars" for eventual writing 
Also, write them to SRE2003.ini         */

tsre_sysvars:procedure expose tsreparams.   sock1   sre2003_ini  pid verbose
parse arg a1,a2
a1=strip(translate(a1))
aa='!'||a1
if wordpos(a1,tsreparams.0)=0 then tsreparams.0=tsreparams.0' 'a1
tsreparams.aa=a2
foo=sysini(sre2003_ini,'$SYSVARS',a1,a2)
return 0



/**********/
/* save tsreparams "into environment" */
save_tsreparams:procedure expose tsreparams.  sock1  sre2003_ini  sreparams. pid verbose
alist=tsreparams.0
do mm=1 to words(alist)
  aw=strip(word(alist,mm))
  aa='!'||aw
  foo=value('SRE_$1_'||aw,tsreparams.aa,'os2environment')
end

return 1

/*****************/
/* load the various dlls and rxls  */
load_dlls: procedure expose  sre2003_ini  pid verbose 

/* add current directory to the libpath of this process */
/* this convoluted code is needed due to flakiness of early versions 
   of REXX. Note that on os/2 3.0 systems, you'll have to
   add the DLL subdirectory to your libpath statement */


aa=rxqueue('S','SESSION')
do forever
 if queued()=0 then leave
 pull goo
end
address cmd '@SET BEGINLIBPATH  | rxqueue '
goo=''
if queued() then do
  pull goo
end 
parse var goo . '=' goo 
goo=strip(goo)
aa=rxqueue('S',aa)
maindir=directory()
maindir=translate(maindir,'\','/')
maindir=strip(maindir,,'\')
dlldir=maindir||'\DLL'
if pos(translate(dlldir),translate(goo))=0 then do /*add dll subdir */
  foo=dlldir||';'||goo
  address cmd '@SET BEGINLIBPATH = 'foo
end

/* Load various dlls  -- note that SRE2003\dll dir is checked first! */
foo=rxfuncquery('sysloadfuncs')
if foo=1 then do
  foo=RxFuncAdd( 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs')
  if foo=1 then do
     say "ERROR: could not find RexxUtil.DLL " 
     exit
  end /* do */
  call SysLoadFuncs
   
end

parse upper version rexxtype .
os2ver=sysos2ver()
say "  Using REXX version: " rexxtype ', under OS/2 ver 'os2ver


foo=rxfuncquery('rexxlibregister')
if foo=1 then do
 foo=rxfuncadd( 'rexxlibregister','rexxlib', 'rexxlibregister')
  if foo=1 then do
     say "ERROR: could not find RexxLib.DLL " 
     exit
  end /* do */
 call rexxlibregister
end

/* since syssleep is odd on older os/2 boxes */
if rxfuncquery('filedosleep')<>0 then do
  ik=rxfuncadd('filedosleep','filerexx','filedosleep')
  if ik<>0 then say "ERROR: unable to register FILEDOSLEEP"
end



foo=RxFuncQuery("SockLoadFuncs") 
if foo=1 then do
    foo=RxFuncAdd( "SockLoadFuncs","rxSock","SockLoadFuncs")
    if foo=1 then do
       say "ERROR: could not find rxSock.DLL " 
       exit
    end 
    call SockLoadFuncs
end
ver=sockversion()
if ver<2.0 then do
   say 'WARNING: old version of rxsocket ('ver'). We recommend using 2.0 or above'
end 


if rxfuncquery('srx_md5')=1  then do
  foo=RXFuncAdd( 'SRXLoadFuncs', 'SRXFUNC', 'SRXLoadFuncs')
   if foo=1 then do
       say "ERROR: could not find srxFunc.DLL " 
       exit
   end /* do */
  call SRXLoadFuncs
end
if rxfuncquery('srx_md5')=1  then do
       say "ERROR: could not find srx_Md5 in srxfunc.DLL " 
       exit
end

/* Load the rxgzlib functions */
if rxfuncquery('rxgzLoadFuncs')=1 then do
   foo=RxFuncAdd( 'rxgzLoadFuncs', 'rxgzLIB', 'rxgzLoadFuncs')
   if foo=1 then do
       say "ERROR: could not find rxGZlib.DLL " 
       exit
   end 
   call rxgzLoadFuncs
end 

if rxfuncquery('RxPrcLoadFuncs')=1 then do
 foo=RxFuncAdd('RxPrcLoadFuncs', 'RXPROC', 'RxPrcLoadFuncs')
 if foo=1 then do
    say "ERROR: could not find rxProc.DLL "
   exit
 end 
 call RxPrcLoadFuncs
end

/* load keyboard poller */
if rxfuncquery('Mkey')=1 then do
  foo=RxFuncAdd("MKey","MKey","MKey")
  if foo=1 then do
    say "ERROR: could not find Mkey.DLL "
    exit
 end 
end

/* load basic .rxl file */

arf='bin\SRE2003.IDX'       /* find list of procedures */
aa=read_file(arf,2,2)
if aa='' then do
   say "ERROR: unable to clear procedures from macrospace"
   exit
end 
else do                 /* zap old versions of procedures */
   idid=0
   do until aa=''
      parse var aa aline '0d0a'x aa
      if aline='' then iterate
      aline=strip(aline)
      if abbrev(aline,';')=1 then iterate
      if words(aline)>1 then iterate
      foo=macrodrop(aline)
      if foo<>1 then do
            if macroquery(aline)<>' ' then do
              say "ERROR: unable to macro_drop " aline
              exit
            end         /* otherwise, it's not there */
      end 
      else do
          idid=idid+1
      end
   end 
   say '  'idid' old versions of macrospace procedures removed.'
end 


/* load macrospace library */

rxlfile='bin\SRE2003.RXL'
if stream(rxlfile,'c','query exists')='' then do
      say "ERROR: "|| rxlfile ||" not available"
      exit
end 
aa=macroload(rxlfile)
if aa=0 then do
      say "ERROR: "|| rxlfile ||" was not loaded ("|| aa
      exit
end


if goserve_compatability<>1 then return 1

/* load "compatability" version of basic .rxl file */

arf='bin\SRE2003A.IDX'       /* find list of procedures */
aa=read_file(arf,2,2)
if aa=' ' then do
   say "ERROR: unable to clear compatability procedures from macrospace"
   exit
end 
else do                 /* zap old versions of procedures */
   idid=0
   do until aa=''
      parse var aa aline '0d0a'x aa
      if aline='' then iterate
      aline=strip(aline)
      if abbrev(aline,';')=1 then iterate
      if words(aline)>1 then iterate
      foo=macrodrop(aline)
      if foo<>1 then do
            if macroquery(aline)<>' ' then do
              say "ERROR: unable to macro_drop " aline
              exit
            end         /* otherwise, it's not there */
      end 
      else do
          idid=idid+1
      end
   end 
   say '  'idid' old versions of macrospace compatability procedures removed.'
end 


/* load Goserve compatability macrospace  library */

arxlfile='bin\SRE2003A.RXL'
if stream(arxlfile,'c','query exists')='' then do
      say "ERROR: "|| arxlfile ||" not available"
      exit
end 
aa=macroload(arxlfile)
if aa=0 then do
      say "ERROR: "|| arxlfile ||" was not loaded ("|| aa
      exit
end

return 1


macroadd2:procedure expose verbose 
parse arg a,b,c
foo= macroadd(a,b,c)
if verbose>0 then 
   call pmprintf("SRE2003: Saving "||filespec('n',b)||" to macrospace "||a||" = " foo)
return foo



read_file:procedure
parse arg filename,ntries,status1

fulln=stream(filename,'c','query exists')
if fulln='' then do
   if status1=2 then return ''
   return '-1 '||filename' was not found '
end

asize=stream(fulln,'c','query size')
if asize='' then do
  if status1=2 then return ''
  return '-2 '||filename' could not be found '
end

atime=stream(fulln,'c','query datetime')
if atime='' then do
  if status1=2 then return ''
  return '-2 '||filename' could not be found '
end
else do
  parse var atime mon '-' day '-' yr ahr ':' amin ':' asec
  if yr<80 then
    yr='20'||yr
  else
    yr='19'||yr
  bb=yr||mon||day                 
  cc=dateconv(bb,'S','B')-726467  /*  726467 is 1 jan 1990 */
  ss=((strip(ahr)*3600)+(amin*60)+asec)/86400
  parse var ss . '.' ss
  adate=cc||'.'||ss
end

if asize=0 then do
  if status1=2 then return ''
  return '0 '||adate||' '||strip(fulln)||'0d0a'x
end

do jj=1 to ntries
   astat=stream(fulln,'c','open read')
   if abbrev(strip(translate(astat)),'READY')=0 then do
        call syssleep(1)
        iterate
   end
   
/* if here, successful open */
   if status1=1 then do            /* status line only */
      aa=stream(fulln,'c','close')
      return asize||' '||adate||' '||strip(fulln)||'0d0a'x
   end

/* if here, read the file */
   stuff=charin(fulln,1,asize)
   aa=stream(fulln,'c','close')

   if status1=2 then return stuff
   return asize||' '||adate||' '||strip(fulln)||'0d0a'x||stuff

end

/* if here, timed out waiting for file to become available */
if status1=2 then return ''
return '-3 Unable to open: 'astat
 
