/* 25 Sep 2002 -- Demo of the SREH2_DIGITS and SREH2_XBITMAP
   procedures.

  This will print a message, and also display the transaction
  number.

You can invoke this with:

1) The demo format: /TSTDIGIT?a_message
   A default set of messages will be displayed, including:
       * "a_message" (url-encoded), using the GOLDBLOK digits
       *  the current transaction number, using
           i) GOLDODO digits
           ii) Regular and inverse XBITMAP
       * some notes on calling syntax     

2) The full format:
     /TSTDIGIT?option_list

   Where option list has the form:
      var1=val1&var2=val2&..

   Currently accepted VARN:
      MESS = a url-encoded message (with + used for spaces)
      FONT = a "digits" font to display message with 
             If valn="XBITMAP", make an XBITMAP image
             If valn="XBITMAP_INV", make an inverse XBITMAP
             Note that XBITMAP and XBITMAP_INV only work with
             numeric digits
      XBITMAP=nn
             Same as FONT=XBITMAP (nn=0) or FONT=XBITMAP_INV (nn=1)

  For example:
         mess=hello+world&font=Goldblok

Note: This addon  assumes that "digit/character" sets are installed 
      in the /SRE2K/SREHTTPE/IMSG/DIGITS subdirectory of the
      SRE2003 data directory.

*/

parse arg list,servername,verb,tempfile,,
          prog_file,reqnum,verbose,client_ip,privset,,
          uri,host_nickname,id_info,aiter,attribs

if verb='' then do
   say 'Sorry, this SREhttp/2 addon is not meant to be run in stand alone mode'
   exit
end 


/* defaults */
amess='Test' ; doxbm=''  /* initialize */
dname='GOLDBLOK' 
trans=strip(translate(reqnum,' ','ABCDEFGHIJ'))

/* Extract  options */

gotmess=0
do forever
   if list='' then leave
   parse var list a1 '&' list
   parse var a1 a1a '=' a1b ;
   a1a=strip(translate(a1a))
   if abbrev(translate(a1a),"MESS")=1 then gotmess=1
   a1b=sre_packur(translate(a1b,' ','+'))
   if a1b='' then do
       a1b=a1a
       a1a="MESS" 
   end 
    
   select
         when  abbrev(translate(a1a),"MESS")=1 then do
             amess=a1b    /* the message */
         end
         when  a1a="XBITMAP" then   doxbm=strip(a1b)
         when  a1a="FONT"  then do
            dname=strip(translate(a1b))
            if dname='XBITMAP' then doxbm=0
            if dname='XBITMAP_INV' then doxbm=1
         end
         otherwise nop
   end
end 

/* if XBITMAP in list, then return an xbitmap of amess */
if doxbm<>'' then do
   rcode=sreh2_xbitmap(amess,length(amess),doxbm) 
   return rcode
end 


/* else, create and html document that contains the <IMG elements */


/* Write <head> of response */
call lineout tempfile,'<html><head><title>Demo of SREH2_DIGITS and SREH2_XBITMAP</title>'
call lineout tempfile, '</head>'

if gotmess=0 then
  call lineout tempfile,' <h3>Demo of the SREH2_DIGITS and SREH2_XBITMAP procedures</h3>'
if gotmess=0 then call lineout tempfile,'<h4>Examples:</h4> '

call lineout tempfile,'<table border=1><tr><td>'
if gotmess=0 then call lineout tempfile,'Message:<br>'

/* create the "list" message, using the dname font (aligned in the middle) */

/* sreh2_digits(message,dname,ndig,useframe,nobr,opts,imgsel,imgdir) */
ssel='/sre2k/srehttp2/imgs/digits/'
call lineout tempfile,' <tt>txt=sreh2_digits("'amess'","'dname'",,,,''VALIGN="MIDDLE"'',<br>"'||ssel||'") </tt></td> '
call lineout tempfile,'<td>'
fooo=sreh2_digits(amess,dname,,,,' VALIGN="MIDDLE"',ssel)
call lineout tempfile,fooo||' </td>'

if gotmess=0 then do

/* write digit message (the current request #), with min of 4 digits and use a frame. */

  call lineout tempfile,'<tr><td> <tt>txt=sreh2_digits('trans',"'dname'",4,1,0,''VALIGN="MIDDLE"'') </tt>:'
  call lineout tempfile,' <td>'
  atxt=sreh2_digits(trans,dname,4,1,0,' VALIGN="MIDDLE" ')
  call lineout tempfile,atxt||'</td>'

/*  invoke XBITMAP calls back to this addon (not recursive, these are new requests)! */

  call lineout tempfile,'<tr><td><tt>rcode=sreh2_xbitmap('trans',5,0): </tt>'
  call lineout tempfile,'<br><tt>rcode=sreh2_xbitmap('trans',5,1): </tt><br>'
  call lineout tempfile,'<font size=-1>Using &lt;img src=/tstdigit?mess='trans'&XBITMAP=n&nm=a.xbm&gt;</font></td>'
  call lineout tempfile,'<td><img src="/tstdigit?mess='trans'&XBITMAP=0&nm=a.xbm"></br>'
  call lineout tempfile,'<img src="/tstdigit?mess='trans'&XBITMAP=1&nm=a.xbm"> </td>'
end
call lineout tempfile,'</table>'


if gotmess=0 then do            /* and some notes ... */
 call lineout tempfile,' '
 call lineout tempfile,'<hr><b>Notes</b><menu> '
 call lineout tempfile,'<li> The calling syntax for SREH2_DIGITS is: <p><code>'
 call lineout tempfile,' txt=sreh2_digits(message,dname,ndig,useframe,nobr,opts,imgsel,imgdir)</code>'
 call lineout tempfile,'<br><em>where</em> <tt>txt</tt> is a string of HTML.<p> '
 call lineout tempfile,' <li>and for SREH2_XBITMAP: <p><code>'
 call lineout tempfile,'     rcode=SREH2_XBITMAP(anumber,ndigits,doreverse) </code>'
 call lineout tempfile,' <br><em>where</em> <tt>rcode</tt> is a 2 word <tt>response code</tt>'
 call lineout tempfile,' </menu>'
 call lineout tempfile,'See <a href="/sre2k/srehttp2/counter.txt">COUNTER.TXT</a> for the details '
end

call lineout tempfile,' </body></html> '
call lineout tempfile

/* tell srehttp/2 to send this document to the client */
return 'file type text/html name ' tempfile


                                                                        




