/* This will create SRE2003.RXL : basic SRE2003
functions to be loaded into MacroSpace.  Run this if
you modify the source code of the library files (the .SRF files).
*/

parse arg doit .
foo=rxfuncquery('rexxlibregister')
if foo=1 then do
 say ' loading REXXLIB '
 call rxfuncadd 'rexxlibregister','rexxlib', 'rexxlibregister'
 call rexxlibregister
end
/*--------------   Load REXX libraries ----- */
/* Load up advanced REXX functions */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs


procname_list='DO NOT MODIFY this list of procedures in the SRE2003.RXL macrospace library '
totprocs=0

say " Create SRE2003 macrospace procedure libraries. "
say " This requires that macrospace be cleared (which might effect"
say " other OS/2 programs)"

if doit=1 then signal go1
call charout,'  Enter 1 if you wish to proceed: '
parse pull gogo
if gogo<>1 then do
   say "Nothing done."
   exit
end
go1:
foo=macroclear()
if foo=0 then
    say "Warning: Problem clearing macrospace. "
else
  say "Macrospace cleared ... "


say "Loading  procedures "
retc=macroadd2('SRE_COMMAND','COMMAND.SRF','Before')
retc=macroadd2('SRE_SOCKIN','SOCKIN.SRF','Before')
retc=macroadd2('SRE_SOCK_NONCHUNK','BODYNON.SRF','Before')
retc=macroadd2('SRE_SOCK_CHUNK','BODYCHUN.SRF','Before')
retc=macroadd2('SRE_CHUNK','CHUNK.SRF','Before')
retc=macroadd2('SRE_UNCHUNK','UNCHUNK.SRF','Before')

retc=macroadd2('SRE_GET_URL','GET_URL.SRF','Before')
retc=macroadd2('SRE_GET_URL_ADV','GET_URL2.SRF','Before')

retc=macroadd2('SRE_FIX_URL','FIX_URL.SRF','Before')

retc=macroadd2('SRE_AUDIT','AUDITLOG.SRF','Before')
retc=macroadd2('SRE_CACHERECORD','CSHLOG.SRF','Before')
retc=macroadd2('SRE_CACHE','CACHEIT.SRF','Before')
retc=macroadd2('SRE_LIST','SRE_LIST.SRF','Before')
retc=macroadd2('SRE_LIST_STATS','LISTSTAT.SRF','Before')

retc=macroadd2('SRE_TASK','SRETASK.SRF','Before')
retc=macroadd2('SRE_TASK_DAEMON','SRETASK2.SRF','Before')
retc=macroadd2('SRE_CACHE_DATA','DATACSH.SRF','Before')


retc=macroadd2('SRE_SAY','SRESAY.SRF','Before')
retc=macroadd2('SRE_SCREEN_WRITE','SCRWRITE.SRF','Before')
retc=macroadd2('SRE_WRITE_MESSAGE','WRITMESS.SRF','Before')
retc=macroadd2('SRE_WRITE_ERROR','writeerr.srf','Before')
retc=macroadd2('SRE_READ_FILE','READFILE.SRF','Before')
retc=macroadd2('SRE_FILE_READ','READFILE.SRF','Before')
retc=macroadd2('SRE_APPEND_FILE','FILEAPP.SRF','Before')

retc=macroadd2('SRE_TRACKIT','TRACKIT.SRF','Before')
retc=macroadd2('SRE_DATADIR','DATADIR.SRF','BEFORE')
retc=macroadd2('SRE_MD5','MD5D.SRF','Before')
retc=macroadd2('SRE_ETAG','ETAG.SRF','Before')

retc=macroadd2('SRE_PACKUR','PACKUR.SRF','Before')
retc=macroadd2('SRE_PACKUR_MAKE','PACKUR2.SRF','Before')

retc=macroadd2('SRE_COMPLETED','COMPLETD.SRF','Before')
retc=macroadd2('SRE_REQFIELD','REQFIELD.SRF','BEFORE') 
retc=macroadd2('SRE_STILL_ALIVE','ALIVE.SRF','BEFORE') 

retc=macroadd2('SRE_TEMPFILE','TEMPFILE.SRF','BEFORE') 
retc=macroadd2('SRE_CVTDATE','CVTDATE.SRF','BEFORE') 
retc=macroadd2('SRE_DORANGE','DORANGE.SRF','BEFORE') 

retc=macroadd2('SRE_CLIENTNAME','CLIENTNA.SRF','BEFORE')
retc=macroadd2('SRE_EXTRACT','EXTRACT.SRF','Before')
retc=macroadd2('SRE_CACHED','CACHED.SRF','Before')
retc=macroadd2('SRE_GMTOFFSET','GMTOFF.SRF','Before')
retc=macroadd2('SRE_PACK64','PACK64.SRF','Before')
retc=macroadd2('SRE_PACK64_MAKE','MKPACK64.SRF','Before')
retc=macroadd2('SRE_AUTH_RESPONSE','AUTHRESP.SRF','Before')
retc=macroadd2('SRE_MOVE_RESPONSE','ISAMOVE.SRF','Before')
retc=macroadd2('SRE_ERROR_RESPONSE','ERRRESP.SRF','Before')

/* retc=macroadd2('SRE_NOTFOUND_RESPONSE','NOTFOUND.SRF','Before') */


retc=macroadd2('SRE_EXTRACT_USERNAME','USERNAM1.SRF','Before')
retc=macroadd2('SRE_CHECK_USERNAME','USERNAM2.SRF','Before')

retc=macroadd2('SRE_DOIFS','DOIFS.SRF','Before')


retc=macroadd2('SRE_SERVER','SERVSOFT.SRF','Before')
retc=macroadd2('SRE_CONTROL','CONTROL.SRF','Before')
retc=macroadd2('SRE_SERVERNAME','SERVERNM.SRF','Before')
retc=macroadd2('ADD_TH','ADDTH.SRF','Before')
retc=macroadd2('SRE_DATESTAMP','GMTDATE.SRF','Before')
retc=macroadd2('SRE_GMT','SRE_GMT.SRF','Before')

retc=macroadd2('SRE_ADDCOMMA','ADDCOMMA.SRF','Before')
retc=macroadd2('SRE_PAUSE','pause.SRF','Before')

retc=macroadd2('SRE_SYSSLEEP','DOSLEEP.SRF','BEFORE') 

retc=macroadd2('SRE_SHUTDOWN','shutdown.SRF','Before')
retc=macroadd2('SRE_CLIENTS','numcli.SRF','Before')
retc=macroadd2('SRE_COUNTVARS','ctvars.SRF','Before')
retc=macroadd2('SRE_EVENTVARS','eventvar.SRF','Before')
retc=macroadd2('SRE_VALUE','srevalue.srf','Before')

retc=macroadd2('SRE_REPLACEWILD','repwild.srf','Before')
retc=macroadd2('SRE_WILD_MATCH','wildmtch.srf','Before')
retc=macroadd2('SRE_REPLACESTRG','repstrg.srf','Before')

retc=macroadd2('SRE_EXTRACT_BLOCK','extractb.srf','Before')

retc=macroadd2('SRE_HTML_REPLACE','htmlsub.srf','Before')
retc=macroadd2('SRE_HTML_ENCODE','entref.srf','Before')

retc=macroadd2('SRE_PMPRINTF','pmprintf.srf','Before')
retc=macroadd2('SRE_ABBREV','sreabbr.srf','Before')

retc=macroadd2('SRE_FIX_URL','fix_url.srf','Before')


retc=macroadd2('SRE_HOSTINFO','hostinfo.srf','Before')
retc=macroadd2('SRE_REQUEST_ID_INFO','reqinfo.srf','Before')
retc=macroadd2('SRE_REQUEST_INFO','reqinfo1.srf','Before')

retc=macroadd2('SRE_DMN_launch','sred_lau.SRF','Before')
retc=macroadd2('SRE_DMN_own','sred_own.SRF','Before')
retc=macroadd2('SRE_DMN_ask','sred_ask.SRF','Before')
retc=macroadd2('SRE_DMN_listen','sred_lis.SRF','Before')
retc=macroadd2('SRE_DMN_timeleft','sred_tim.SRF','Before')
retc=macroadd2('SRE_DMN_respond','sred_rsp.SRF','Before')
retc=macroadd2('SRE_DMN_command','sred_cmd.SRF','Before')
retc=macroadd2('SRE_DMN_kill','sred_kil.SRF','Before')
retc=macroadd2('SRE_DMN_monitor','sred_mon.SRF','Before')
retc=macroadd2('SRE_DMN_monitor_core','sred_mn2.SRF','Before')

retc=macroadd2('SRE_FLAG_open','flag_opn.SRF','Before')
retc=macroadd2('SRE_FLAG_set','flag_set.SRF','Before')
retc=macroadd2('SRE_FLAG_close','flag_clo.SRF','Before')

retc=macroadd2('SRE_Q_open','q_open.SRF','Before')
retc=macroadd2('SRE_Q_set','q_set.SRF','Before')
retc=macroadd2('SRE_Q_close','q_close.SRF','Before')



/**** END OF PROCEDURES ********/

/* now create procname list */
foo=sysfiledelete('SRE2003.IDX')
foo=stream('SRE2003.IDX','c','open write')
procname_list='; ('||totprocs') '||procname_list
wow=charout('SRE2003.IDX',procname_list,1)
foo=stream('SRE2003.IDX','c','close')


say " saving macrospace procedures to SRE2003.RXL"
foo=macrosave('SRE2003.RXL')
if foo<>1 then 
   say "Error creating SRE2003.RXL : " foo
else
   say " success creating sre2003.rxl! "

/*********/
/* create the compatability library */

foo=macroclear()
if foo=0 then
    say "Warning: Problem clearing macrospace. "
else
  say "Macrospace cleared ... "

procname_list=';DO NOT MODIFY this list of procedures in the SRE2003A.RXL macrospace library '
say "Loading compatability procedures "

retc=macroadd2('DATADIR','DATADIR.SRF','BEFORE')
retc=macroadd2('PACKUR','PACKUR.SRF','Before')
retc=macroadd2('COMPLETED','COMPLETD.SRF','Before')
retc=macroadd2('REQFIELD','REQFIELD.SRF','BEFORE') 
retc=macroadd2('STILL_ALIVE','ALIVE.SRF','BEFORE') 

retc=macroadd2('CLIENTNAME','CLIENTNA.SRF','BEFORE')
retc=macroadd2('EXTRACT','EXTRACT.SRF','Before')
retc=macroadd2('CACHED','CACHED.SRF','Before')
retc=macroadd2('GMTOFFSET','GMTOFF.SRF','Before')
retc=macroadd2('PACK64','PACK64.SRF','Before')
retc=macroadd2('PACK64_MAKE','MKPACK64.SRF','Before')

retc=macroadd2('SERVER','SERVSOFT.SRF','Before')
retc=macroadd2('SERVERNAME','SERVERNM.SRF','Before')
retc=macroadd2('ADD_TH','ADDTH.SRF','Before')

/**** END OF PROCEDURES ********/

/* now create procname list */
foo=sysfiledelete('SRE2003A.IDX')
foo=stream('SRE2003A.IDX','c','open write')
wow=charout('SRE2003A.IDX',procname_list,1)
foo=stream('SRE2003A.IDX','c','close')


say " saving macrospace procedures to SRE2003A.RXL"
foo=macrosave('SRE2003A.RXL')
if foo<>1 then 
   say "Error creating SRE2003A.RXL : " foo
else
   say " success creating sre2003a.rxl! "

exit





/****/
macroadd2:procedure expose procname_list totprocs
parse arg a1,a2,a3
procname_list=procname_list||'0d0a'x||a1
if stream(a2,'c','query exists')='' then do
   say "ERROR: could not find " a2
   exit
end
else do
  foo=macroadd(a1,a2,a3)
  totprocs=totprocs+1
end
return foo





