/* sample of a custom-username procedure
   This looks for a NTIMES=xxx cookie.
   If not found, then return X (normal logon)
   If found, then check xxx (xxx should be an integer)
      If xxx > 10, deny acess
      Otherwise, allow access and return value of xxx 

   Hint: to test how this works, you can use DOGET.CMD -- include a 
      Cookie: NTIMES=? 
    or 
      Cookie: NTIMES=xxx
    request header

*/

parse arg auth_header,client_address,servername,host_nickname,request,requires

username=sre_extract_username(auth_header)

foo=sre_pmprintf(' Sample Custom Username Proc. ',,1)
foo=sre_pmprintf('             Username: '||username,,1)
foo=sre_pmprintf('   length auth_header: '||length(auth_header),,1)
foo=sre_pmprintf('    Client IP address: '||client_address,,1)
foo=sre_pmprintf('           Servername: '||servername,,1)
foo=sre_pmprintf('        Host Nickname: '||host_nickname,,1)
foo=sre_pmprintf('       Request String: '||request,,1)
foo=sre_pmprintf('             Requires: '||requires,,1)

/* not check cookie request header */
acookie=sre_reqfield('COOKIE')

if acookie='' then return 'X'           /* no cookie, so do normal logon stuff */

/* look for  NTIMES cookie. */
do forever
  if acookie='' then leave
  parse var acookie c1 ';' acookie
  parse upper var c1 aname '=' aval

  if strip(aname)='?' then do         /* send an explanation */
      ans='To test the CUST_USR.REX custom username procedure, add a NTIMES=xxx'        
      ans=ans||'0d0a'x||'in a Cookie: request header. If NTIMES<10 '
      ans=ans||'0d0a'x||'then access is granted (and the value of NTIMES is returned). '
      ans=ans||'0d0a'x||'Otherwise, access is denied.'
      vv=sre_command('VAR type text/plain ',ans)
      return '0 '||vv           /* signal that a response has been sent */
  end

  if strip(aname)<>'NTIMES' then iterate

  if strip(aval)>10 then return 0               /* too many times */
  return '1 ntimes'                             /* success ! */
end  

return 'X'

