/* 6 July 2002


This is a sample user-specific "server side" content
negotiation procedure. It closely emulates SREhttp/2's default 
algorithim, with a few cookie checks thrown in, and a some
comments (written to PMPRINTF window).

To enable this, include the following in PRELOADS.CFG

  LOAD_EXEC = SREH2_NEGOTIATE_1  procs\negot.rex

To use it, include the following 3 lines in a variant-list file
   
  PROC: SREH2_NEGOTIATE_1

(note that this PROC: line must have blank lines both before and
 after).


The arguments that SREhttp/2 sends here are:
   sel -- the request selector, after possible "aliasing" within
          SRE-http
  file -- the fully qualified "variant list" filename that sel maps to
          (varilist is pulled from file)
    n  -- number of entries in the variant list
  varilist -- the variant list
 

Although you can work directly with varilist (see NEGOTIAT.HTM for
the details), we recommend using the NEGOTIATE_EXTRACT
and NEGOTIATE_SEARCH procedures instead -- see the bottom of this
file.

Also, note the use of the sre_reqfield and SREH2_GET_COOKIE procedures.



********************************************************/

negot:          

parse arg sel,file,n,varilist

signal on syntax name errn 
signal on error name errn

call sre_pmprintf("NEGOT: For variant list in selector: "sel )
call sre_pmprintf('NEGOT:      (' file)
call sre_pmprintf("NEGOT: # alternatives: " n)

call sre_pmprintf ("NEGOT: Step 1: look for accept: header matches (weighted) ")
acc=sre_reqfield('accept')
ind1=negotiate_search(acc,'type',n,varilist,2)
call sre_pmprintf("NEGOT: After accept, matching variants are: " ind1)
if ind1=0 then return ind1
if words(ind1)=1 then return ind1' Accept'


call sre_pmprintf("NEGOT: Step 2: look for accept-language: header matches (weighted) ")
acc=sre_reqfield('accept-language')
if acc<>'' then do
  ind2=negotiate_search(acc,'language',n,varilist,2,ind1)
  call sre_pmprintf("NEGOT: After accept-language, matching variants are: " ind2)
  if ind2=0 then return ind2
  if words(ind2)=1 then return ind2' Accept Accept-language'
end
else do
   ind2=ind1
end /* do */

call sre_pmprintf ("NEGOT: Step 2.2: look for a language cookie ")
acc=sreh2_get_cookie('language')
if acc<>'' then do
  ind2a=negotiate_search(acc,'language',n,varilist,2,ind2)
  call sre_pmprintf ("NEGOT: After cookie: language, matching variants are: " ind2a)
  if words(ind2a)=1 & ind2a<>0  then return ind2a' Accept Accept-language Cookie'
  ind2=ind2a
end


call sre_pmprintf("NEGOT: Step 3: look for accept-encoding: header matches (weighted) ")
acc=sre_reqfield('accept-encoding')
if acc<>'' then do
  ind3=negotiate_search(acc,'encoding',n,varilist,2,ind2)
  call sre_pmprintf("NEGOT: After accept-encoding, matching variants are: " ind3)
  if ind3=0 then return ind3
  if words(ind3)=1 then return ind3' Accept Accept-language Accept-Encoding Cookie'
end
else do
   ind3=ind2
end


call sre_pmprintf("NEGOT: Step 4: look for accept-charset: header matches (weighted) ")
acc=sre_reqfield('accept-charset')
if acc<>''  then do
   ind4=negotiate_search(acc,'charset',n,varilist,2,ind3)
   call sre_pmprintf("NEGOT: After accept-charset, matching variants are: " ind4)
   if ind4=0 then return ind4
   if words(ind4)=1 then 
      return ind4' Accept Accept-language Accept-Encoding Accept-Charset Cookie'
end
else do
   ind4=ind3
end /* do */

call sre_pmprintf("NEGOT: Step 5: use remaining variant with smallest length from:"ind4)
alist=negotiate_extract('length',ind4,varilist)
usemm=1
if alist<>'' then do
  aw0=111111111111
  do mm=1 to words(ind4)
     parse var alist aw '0d0a'x alist
     aw=strip(aw)
     if aw='' then iterate  /* none defined */
     if aw<aw0 then do
        usemm=mm
        aw0=aw
     end /* do */
  end
end /* do */
useit=word(ind4,usemm)
return useit' Accept Accept-language Accept-Encoding Accept-Charset Cookie'




return 0



/************************************************

Some useful procedures:

For both these procedures, afield can take the following values:

  SEL -- the variant's selector
     Q --  the quality rating
    TYPE -- content-type
  LANGUAGE -- comma delimited list of languages
    CHARSET -- the character set
    ENCODING -- the content encoding
    FEATURES -- Features.  Can be used for miscellaneous features
  DESCRIPTION -- Description of variant

                        ----------


NEGOTIATE_SEARCH:

Syntax:
   matchlist=NEGOTIATE_SEARCH(avalue,afield,n,varilist,best,onlyin)

where:
    avalue : a value, or a set of values, to examine
    afield : the name of the "field" in the variant list, values
             from this field will be compared against values in
             avalue. 
        n:   # elements in varilist
  varilist : the "variant list" (as provided by sre-http)
    best   : optional. If 1 or 2, then do a "quality weighted" best
             match, and return only the top scoring variant
             (or variants, if a tie for top)
   onlyin  : optional. A  space delimited index of the 
             entries in the variant list to examine. 

   matchlist: a space delimited list of integers

Description:

Matchlist is an index to the variant list -- the indicated
variants have a value in "afield" that is a match (or a best
match) to a value in "avalue".

If no matches, returns a 0.

Basically, this procedure eases the comparison of Accept- headers
against the variant list; a typical use is to read an
accept- header, and use its value as "avalue".

Values in "avalue" can contain * wildcards. However, values in
"afield" should NOT contain * characters.
 
For both avalue and afield, values are seperated by commas.
Values in "avalue" may also be "modified" by ;q=n.nn -- these modifiers
are used as the "weighting factor" for that value. Thus,
different values within "avalue" can have different weights.

If an "afield" is missing from a variant, it is skipped.
Note that the "language" and "features" fields may contain
more then one value; all other fields contain 1 value (or
0 values, if they are not defined).

If best=1, then instead of returning all variants that "match", only
return the variants with the highest match (if a tie for highest, return
all the top matches).  

The "highest match" is determined by using the "q" weighting factors that 
may appear in "avalue".  Note if a value in avalue does not have an
explicit q factor:
   a) if it does not contain a *, q=1 is used.
   b) if it has one * (say, text/*), q=0.02
   c) if it has two * (say, */*), q=0.01

If best=2, then modify this by multiplying the q weighting factor of the
value from "avalue"  by the "Q" field of the variant.

If onlyin is specified, then only the records indexed by onlyin 
are searched (records not indexed by onlyin can NEVER appear
in matchlist).

Examples:
   
   kth=negotiate_search('fr;q=0.5, sp','language',n,varilist,1)
   mth=negotiate_search('text/plain','type',n,varilist,2,'1 3 6 7')
   mth=negotiate_search('text/plain, text/* , */* ','type',n,varilist)

                        ----------

NEGOTIATE_EXTRACT:

Syntax:
  avalue=NEGOTIATE_EXTRACT(afield,j,varilist)

where:
   afield = a "field name"
   j      = an index into the variant list
  varilist = the variant list

Description:

  Extract the value of the "afield" field from the j'th entry in the
  variant list. If no such field, or if j is invalid (less then 1 or 
  greater then the number of variants, then return '')

  Alternatively, j can be a space delimited list of entry numbers,
  in which case avalue will be a CRLF ('0d0a'x) delimited
  list of the values of afield from these entries.

  Lastly, if j='*', the values of afield for all entries will be returned
  in a CRLF delimited list.

Examples:
  
   alang=negotiate_extract('language',2,varilist)
   atype=negotiate_extract('type',3,varilist)
   sels=negotiate_extract('sel','1 4',varilist)


************************************************************************/

/**************/
/* NEGOTIATE_SEARCH(avalue,afield,varilist)
   Search for the matches to "avalue" in the "afield" fields of 
   the variant list. Return a space delimited list of integers pointing to
   the  matches (more then one if several matches), or 0 if 
   there are no matches. 
*******/


negotiate_search:procedure
parse upper arg lookat_list,infield,n,varilist,best,onlyin

crlf='0d0a'x
infield='!'||strip(infield)

list1=''

/* make an array of varilist */

matchs.=0
varray.=''

ip=0
istart=0
ith=0
parse var varilist n2 (crlf) varilist
do mm=1 to n
   parse var varilist aline (crlf) varilist
   if onlyin<>'' then do
      if wordpos(mm,onlyin)=0 then iterate
   end
   parse var aline '"'varray.mm.!SEL '"'  aq aline
   if datatype(aq)<>'NUM' then aq=0
   varray.mm.!Q=strip(aq)         /* note: fallback variant will not have an aq */
   do forever
       if aline='' then leave    
       parse var aline '{' bb '}' aline
       parse var bb ffield fvalue
       ffield='!'ffield
       select
            when ffield='!LANGUAGE' then do  /* clean it up */
              tmp=''
              do forever
                 if fvalue='' then leave
                 parse var fvalue a1 ',' fvalue
                 parse var a1 a1 ';' . 
                 tmp=tmp' 'a1
              end
              varray.mm.ffield=tmp
            end 
            when ffield='!FEATURES' then do
               varray.mm.ffield=translate(fvalue,' ','[],!')
            end /* do */
            otherwise do
               varray.mm.ffield=strip(fvalue)
            end
       end              /* select */
    end                 /* aline */
end   /* 1 to n */



/* parse the lookat_list */
ilat=0
do forever
  if lookat_list='' then leave
  parse var lookat_list a1 ',' lookat_list
  parse var a1 a1a ';' . '=' a1b
  ilat=ilat+1
  lookats.ilat=strip(a1a)
  if a1b='' then do
     a1b=1
     jim=pos('*',a1a)
     if jim>0 then do
        jim2=lastpos('*',a1a)
        if jim2<>jim1 then
           a1b=0.01
        else
           a1b=0.02
     end
  end 
 lookats.ilat.!q=strip(a1b)
end

do illat=1 to ilat
    haystack=lookats.illat
    hayvalue=lookats.illat.!q

/* see if an element in each varray.mm.!infield matches this haystack*/
  do mm=1 to n

     if matchs.mm=1 then iterate /* already got a top quality match, so skip */
     thisfield=varray.mm.infield
     if thisfield='' then iterate

/* look at each of several elements in this field of the variant list
   Note that the haystack might have wildcards */

     do mm3=1 to words(thisfield)
        aword=strip(word(thisfield,mm3))
        if sre_wild_match(aword,haystack)<>0 then do
           select 
              when best=1 then
                matchs.mm=max(matchs.mm,hayvalue)
              when best=2 then
                matchs.mm=max(matchs.mm,hayvalue*varray.mm.!q)
              otherwise
                matchs.mm=1
           end                   /* select */
        end                     /* wild match */
     end                        /* mm3 words in thisfield */
  end                           /* mm variants */
end                     /* ilat words in lookat_list  */

isbest=0
do jj=1 to n
  if matchs.jj>0 then isbest=max(isbest, matchs.jj)
end

if isbest=0 then return 0          /* no matches */

/* extract the best matches */
list1=''
do jj=1 to n
   if matchs.jj=isbest then list1=list1||jj||' '
end
return list1   



/*******************************************/

/************/
/* NEGOTIATE_EXTRACT(afield,j,varilist)
    Extract the value of the "afield" field from the j'th entres in the
    variant list.
*******/

negotiate_extract:procedure
parse arg bfield,jth,varilist
crlf='0d0a'x

if jth<1 then return ''
bfield=strip(translate(bfield))

parse var  varilist n (crlf) varilist
if jth>n then return ''

vals=''
do mm=1 to n
  parse var varilist aline (crlf) varilist
  if pos(mm,jth)=0 & jth<>'*' then iterate
  parse var aline '"'asel '"' aq aline
  avalue=''
  select
    when  abbrev(bfield,'Q')=1 then do
        avalue=aq
    end
    when abbrev(bfield,'SEL') then do 
        avalue=asel
    end /* do */
    otherwise do
     do forever
        if aline='' then leave /* no match to desired field */
        parse var aline '{' aa '}' aline
        parse var aa afield qvalue ; afield=strip(translate(afield))
        if afield=bfield then do
          avalue=qvalue
          leave
        end
     end        /* forever */
    end         /* otherwise */
  end           /* select */
  if vals='' then 
     vals=avalue
  else
    vals=vals||'0d0a'x||avalue
end             /* 1 to n */
return vals



errn:
call sre_pmprintf(' NEGOT.REX error at line 'sigl)
return 0
