/****************************************************************/
/*              Creation of WebServe desktop folder             */
/****************************************************************/

/* Register with REXX API extensions. */

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

/* Create the desktop objects. */

/*Call SysCls*/

Say 'WebServe for OS/2 - Installation Script.'
Say
Say 'Creates desktop folder.'
Say
CreateCollision = 'Update'

Call CreateObjects
Exit

/****************************************************************/
/*          Two general-purpose "create" operations             */
/****************************************************************/

CreateObject: procedure
    Parse Arg Class, Title, Location, Setup, Collision
    Say 'Creating ['Title']'
    rc = SysCreateObject( Class, Title, Location, Setup, Collision )
    If rc <> 1 Then
        Say ' > failed to create ['Title' | 'Class'] at location ['Location']'
    return rc

/****************************************************************/

CreateShadow: procedure
    Parse Arg Class, Location
    Say 'Creating Shadow ['Class']'
    rc = SysCreateShadow( Class, Location )
    If rc <> 1 Then
        Say ' > failed to create ['Class'] at location ['Location']'
    return rc

/****************************************************************/
/*             The specific creations for this job              */
/****************************************************************/

CreateObjects:

current_dir = directory()

/***************/
/* MAIN FOLDER */

rc = CreateObject( 'WPFolder',,
    'WebServe',,
    '<WP_DESKTOP>',,
    'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'SELFCLOSE=1;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,NORMAL;'||,
        'ALWAYSSORT=YES;'||,
        'ICONFILE='||current_dir||'\folder.ico;'||,
        'OBJECTID=<WebServe_folder>',,
    CreateCollision )

/*******************/
/* PROGRAM OBJECTS */

  rc = CreateObject( 'WPProgram',,
      'WebServe HTTP server',,
      '<WebServe_folder>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||current_dir||'\WEBSERVE.EXE;'||,
          'STARTUPDIR='||current_dir||';'||,
          'MINIMIZED=YES;'||,
          'OBJECTID=<WebServe_Program>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'Configuration program',,
      '<WebServe_folder>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||current_dir||'\Setup.EXE;'||,
          'STARTUPDIR='||current_dir||';'||,
          'OBJECTID=<WebServe_Admin>',,
      CreateCollision )

  rc = CreateObject( 'WPProgram',,
      'WebServe Manual',,
      '<WebServe_folder>',,
      'NOPRINT=YES;'||,
          'DEFAULTVIEW=RUNNING;'||,
          'EXENAME='||'VIEW.EXE;'||,
          'PARAMETERS='||current_dir||'\DOC\WEBSERVE.INF;'||,
          'STARTUPDIR='||current_dir||';'||,
          'MINIMIZED=NO;'||,
          'OBJECTID=<WebServe_Manual>',,
      CreateCollision )

  rc = CreateObject( 'WPURL',,
      'Updates',,
      '<WebServe_folder>',,
      'NOPRINT=YES;'||,
          'URL=http://www.pmoylan.org/pages/os2/webserve.html',,
      CreateCollision )

return
