/* P6MTRR.h  definitions for DosDevIOCtl() using P6MTRR.sys
   Copyright 1999 January June / 鉾P(Yotogi-Hime) / Beliefia Productions. */

#ifndef __P6MTRR
#define __P6MTRR

/* IOCtl category & functions */
#define IOCTL_P6MTRR                0xc4
#define P6MTRR_QRYMTRRCAP           0x60  /* Query MTRR capabilities */
#define P6MTRR_QRYMTRRDEFTYPE       0x61  /* Query MTRR default type */
#define P6MTRR_QRYMTRRFIXEDRANGE    0x62  /* Query MTRR fixed ranges */
#define P6MTRR_QRYMTRRVARIABLERANGE 0x63  /* Query MTRR variable range */
#define P6MTRR_SETMTRRDEFTYPE       0x41  /* Set MTRR default type */
#define P6MTRR_SETMTRRFIXEDRANGE    0x42  /* Set MTRR fixed ranges */
#define P6MTRR_SETMTRRVARIABLERANGE 0x43  /* Set MTRR variable range */

/* Memory types */
#define P6MTRR_MEMTYPE_UNCACHEABLE    0
#define P6MTRR_MEMTYPE_WRITECOMBINING 1
#define P6MTRR_MEMTYPE_WRITETHROUGH   4
#define P6MTRR_MEMTYPE_WRITEPROTECTED 5
#define P6MTRR_MEMTYPE_WRITEBACK      6

/* P6 MTRR capabilities
     for P6MTRR_QRYMTRRCAP */
typedef struct
{
    UINT VCNT:8;  /* # of MTRR variable ranges */
    UINT FIX:1;   /* MTRR fixed range support flag */
    UINT :1;
    UINT WC:1;    /* Write-combining support flag */
    UINT :21;
    UINT :32;
} P6MTRRCAPDATA;

/* P6 MTRR default type
     for P6MTRR_QRYMTRRDEFTYPE / P6MTRR_SETMTRRDEFTYPE */
typedef struct
{
    UINT Type:8;     /* Default memory type */
    UINT :2;
    UINT FE:1;       /* MTRR fixed range enabled flag */
    UINT E:1;        /* MTRR enabled flag */
    UINT :20;
    UINT :32;
} P6MTRRDEFTYPEDATA;  /* other bits should be 0 when set */

/* P6 MTRR fixed ranges
     for P6MTRR_QRYMTRRFIXEDRANGE / P6MTRR_SETMTRRFIXEDRANGE */
typedef struct
{
    UCHAR Range_00000_64K[8];  /* Memory types, 00000-7FFFF, 64k each */
    UCHAR Range_80000_16K[8];  /* Memory types, 80000-9FFFF, 16k each */
    UCHAR Range_A0000_16K[8];  /* Memory types, A0000-BFFFF, 16k each */
    UCHAR Range_C0000_4K[8];   /* Memory types, C0000-C7FFF, 4k each */
    UCHAR Range_C8000_4K[8];   /* Memory types, C8000-CFFFF, 4k each */
    UCHAR Range_D0000_4K[8];   /* Memory types, D0000-D7FFF, 4k each */
    UCHAR Range_D8000_4K[8];   /* Memory types, D8000-DFFFF, 4k each */
    UCHAR Range_E0000_4K[8];   /* Memory types, E0000-E7FFF, 4k each */
    UCHAR Range_E8000_4K[8];   /* Memory types, E8000-EFFFF, 4k each */
    UCHAR Range_F0000_4K[8];   /* Memory types, F0000-F7FFF, 4k each */
    UCHAR Range_F8000_4K[8];   /* Memory types, F8000-FFFFF, 4k each */
} P6MTRRFIXEDRANGEDATA;

/* P6 MTRR variable range
     for P6MTRR_QRYMTRRVARIABLERANGE / P6MTRR_SETMTRRVARIABLERANGE */
typedef struct
{
    UCHAR Index;  /* Index of MTRR variable range */
} P6MTRRVARIABLERANGEPARM;
typedef struct
{
    UINT Type:8;       /* Memory type */
    UINT :4;
    UINT PhysBase:24;  /* Physical Memory base, most 24bits of 36bits */
    UINT :28;
    UINT :11;
    UINT V:1;          /* Valid flag */
    UINT PhysMask:24;  /* Physical memory mask, most 24bits of 36bits */
    UINT :28;
} P6MTRRVARIABLERANGEDATA;  /* other bits should be 0 when set */

#endif

