//
// $Header: d:\\32bits\\ext2-os2\\uext2\\rcs\\uext2.c,v 1.3 1997/03/16 13:15:54 Willm Exp $
//

// 32 bits Linux ext2 file system driver for OS/2 WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996, 1997  Matthieu WILLM (willm@ibm.net)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

/*
#define INCL_DOS
#include <os2.h>
*/
#include <stdio.h>
#include <stdlib.h>
#include <process.h>
#include <string.h>

char banner[] ="ͻ\n"
               "      Linux ext2 file system driver for OS/2           \n"
               "  (Built on "__DATE__" at "__TIME__ " in Paris - France) \n"
               "                                                       \n"
               "       EXT2-OS2 VERSION " EXT2OS2_VER " (32 BITS EDITION)         \n"
               "                                                       \n"
               "     Copyright (C) Matthieu WILLM 1995, 1996, 1997     \n"
               "                                                       \n"
               "ͼ\n";

typedef char *_Seg16 __pchar16;

char format_program[] = "mke2fs.exe";
char chkdsk_program[] = "e2fsck.exe";

char *chkdsk_options[] = {
    "/F",
    "/C",
    "/V",
    "/F:"
};

int start_program(char *program, short argc, __pchar16 *_Seg16 argv, __pchar16 *_Seg16 envp) {
    int    rc;
    int    i;
    int    c;
    char **__argv_32 = 0;
    char **__envp_32 = 0;
    __pchar16 *__argv_16 = (__pchar16 *)argv;
    __pchar16 *__envp_16 = (__pchar16 *)envp;

    __argv_32 = malloc((argc + 1) * sizeof(char *));
    if (__argv_32) {
        __argv_32[0] = program;
        for (i = 1 ; i < argc ; i++) {
            __argv_32[i] = (char *)(__argv_16[i]);
        }
        __argv_32[argc] = 0;
        if (__envp_16) {
            c = 0; 
            while ((char *)(__envp_16[c])) c++;
            __envp_32 = malloc((c + 1) * sizeof(char *));
            if (__envp_32) {
                for (i = 0 ; i < c ; i++) {
                    __envp_32[i] = (char *)(__envp_16[i]);
                }
                __envp_32[c] = 0;
                rc = spawnvpe(P_WAIT, program, __argv_32, __envp_32);
                if (rc == -1) {
                    fprintf(stderr, "Couldn't start %s. ", program);
                    perror("");
                }
                free(__envp_32);
            } else {
                rc = 1;
            }
        } else {
            rc = spawnvp(P_WAIT, "e2fsck.exe", __argv_32);
            if (rc == -1) {
                    fprintf(stderr, "Couldn't start %s. ", program);
                    perror("");
            }
        }
     
        free(__argv_32);
    } else {
        rc = 1;
    }

    return rc;
}

short _Far16 _Pascal CHKDSK(short argc, __pchar16 *_Seg16 argv, __pchar16 *_Seg16 envp) {
    printf(banner);
    return start_program("e2fsck.exe", argc, argv, envp);
}

/*
 * This entry point is necessary to make BOOTOS2 happy, even if it does nothing. The boot
 * record actually needs to be installed from Linux by LILO.
 */
short _Far16 _Pascal SYS(short argc, char *_Seg16 *_Seg16 argv, char *_Seg16 *_Seg16 envp) {
    fprintf(stderr, "SYS not implemented for ext2-os2 yet. To install OS/2 on a Linux partition please follow the instructions in ext2-os2.inf.\n");
    /*
     * Maybe in the future there will be a port of lilo here.
     */
    return 0;
}

short _Far16 _Pascal FORMAT(short argc, char *_Seg16 *_Seg16 argv, char *_Seg16 *_Seg16 envp) {
    int    rc;
    int    i, j, k;
    int    c;
    char **__argv_32 = 0;
    char **__envp_32 = 0;
    __pchar16 *__argv_16 = (__pchar16 *)argv;
    __pchar16 *__envp_16 = (__pchar16 *)envp;
    char *tmp, *drive;

    printf(banner);

    if (argc >= 2) {
        drive = (char *)(__argv_16[1]);
        if (drive[0]                                        &&
            (((drive[0] >= 'A') && (drive[0] <= 'Z')) ||
             ((drive[0] >= 'a') && (drive[0] <= 'z')))        &&
            drive[1]                                        &&   
            (drive[1] == ':') ) {                              
                          
    __argv_32 = malloc((argc + 1) * sizeof(char *));
    if (__argv_32) {	
        __argv_32[0] = format_program;
	j = 1;
        for (i = 2 ; i < argc ; i++) {
            tmp = (char *)(__argv_16[i]);

	    /*
	     * Skips FORMAT.COM standard parameters
             */
            if (strnicmp(tmp, "/ONCE", sizeof("/ONCE") - 1)) {
              if (strnicmp(tmp, "/4",    sizeof("/4") - 1))    {
                if (strnicmp(tmp, "/T:",   sizeof("/T:") - 1))   {
                  if (strnicmp(tmp, "/N:",   sizeof("/N:") - 1))   {
                    if (strnicmp(tmp, "/F:",   sizeof("/F:") - 1))   {
                      if (strnicmp(tmp, "/FS:",  sizeof("/FS:") - 1))  {
                        if (strnicmp(tmp, "/L",    sizeof("/L") - 1))    {
                          if (strnicmp(tmp, "/V",    sizeof("/V") - 1))    {
                            __argv_32[j++] = tmp;
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
        }

	/*
         * Puts the device name at the end of argument list
         */
        __argv_32[j++] = drive;

        /*
         * trailing NULL argument
         */
        __argv_32[j] = 0;

	for (i = 0;i<j;i++) printf("---> %s\n", __argv_32[i]);


        if (__envp_16) {
            c = 0; 
            while ((char *)(__envp_16[c])) c++;
            __envp_32 = malloc((c + 1) * sizeof(char *));
            if (__envp_32) {
                for (i = 0 ; i < c ; i++) {
                    __envp_32[i] = (char *)(__envp_16[i]);
                }
                __envp_32[c] = 0;
                rc = spawnvpe(P_WAIT, format_program, __argv_32, __envp_32);
                if (rc == -1) {
                    fprintf(stderr, "Couldn't start %s. ", format_program);
                    perror("");
                }
                free(__envp_32);
            } else {
                rc = 1;
            }
        } else {
            rc = spawnvp(P_WAIT, format_program, __argv_32);
            if (rc == -1) {
                    fprintf(stderr, "Couldn't start %s. ", format_program);
                    perror("");
            }
        }
     
        free(__argv_32);
    } else {
        rc = 1;
    }
    } else {
        /*
         * Normally we should never reach this point, as FORMAT.COM should
         * have already reported the error.
         */
    }
    } else {
        /*
         * Normally we should never reach this point, as FORMAT.COM should
         * have already reported the error.
         */
    }
    return rc;
}

short _Far16 _Pascal RECOVER(short argc, char *_Seg16 *_Seg16 argv, char *_Seg16 *_Seg16 envp) {
    fprintf(stderr, "RECOVER not implemented for ext2-os2 yet.\n");
    /*
     * No known undelete yet ...
     */
    return 0;
}

