/* REXX interface ti cipherkey.exe - random key generator */

parse arg algo keylen filename

filename = strip(strip(filename),,'"')
if (filename = '') | (datatype(keylen, 'W') = 0) then 
 do
  say 'Wrong arguments' 
  usage();
 end
if keylen < 1 then 
  do
   say 'Wrong key length. Should be > 0'
   usage();
  end
select
  when algo == 'blowfish' then
   if keylen > 56 then
    do
     say 'Wrong key length. Should be between 1 - 56 bytes'
     usage();
    end 
  when algo == 'cast256' then 
   if keylen > 32 then
    do
     say 'Wrong key length. Should be between 1 - 32 bytes'
     usage();
    end 
  when algo == 'gost' then 
   if keylen \= 32 then
    do
     say 'Wrong key length. Should be 32 bytes'
     usage();
    end 
  when algo == 'mars' then
   if (keylen > 56) | (keylen < 4) then
    do
     say 'Wrong key length. Should be between 4 - 56 bytes'
     usage();
    end 
  when algo == 'rc6' then 
   if keylen > 255 then
    do
     say 'Wrong key length. Should be between 1 - 255 bytes'
     usage();
    end 
  when algo == 'rijndael' then
   if keylen > 32 then
    do
     say 'Wrong key length. Should be between 1 - 32 bytes'
     usage();
    end 
  when algo == 'serpent' then  
   if (keylen > 32) | (keylen / 4 \= keylen % 4) then
    do
     say 'Wrong key length. Should be between 4 - 32 bytes by 4 bytes'
     usage();
    end 
  when algo == 'tripdes' then  
   if keylen \= 24 then
    do
     say 'Wrong key length. Should be 24 bytes'
     usage();
    end 
  when algo == 'twofish' then  
   if (keylen \= 24) & (keylen \= 16) & (keylen \= 32) then
    do
     say 'Wrong key length. Should be 16, 24 or 32 bytes'
     usage();
    end 
otherwise
  say 'Unknown cipher specified. Use cipherkey.exe to generate key for it.'
  usage();  
end

'@cipherkey.exe 'keylen' > 'filename
if rc \= 0 then say 'Key generation was failed'
else say 'Key file was successfully generated'

exit rc

usage:
  say ''
  say 'Usage: cipherkey.cmd <cipher name> <key length> <key file name>'
  say ''
  say 'Known ciphers are:'
  say ''
  say '  blowfish - valid key lengths are 1 - 56     bytes'
  say '  cast256  - valid key lengths are 1 - 32     bytes'
  say '  gost     - valid key length  is  32         bytes'
  say '  loki97   - valid key lengths are 1 - 32     bytes'
  say '  gost     - valid key length  is  32         bytes'
  say '  mars     - valid key length  are 4 - 56     bytes'
  say '  rc6      - valid key length  are 1 - 255    bytes'
  say '  rijndael - valid key length  are 1 - 32     bytes'
  say '  serpent  - valid key length  are 4 - 32     bytes by 4 bytes'
  say '  tripdes  - valid key length  is  24         bytes'
  say '  twofish  - valid key length  is  16, 24, 32 bytes'
exit 1
