
#define INCL_DOS
#define INCL_WIN
#define INCL_GPI
#define INCL_WINWORKPLACE

#include <os2.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
/*
C70000403001                 mov         d,[eax],001304000
66C740040203                 mov         w,[eax][00004],00302
8B54240C                     mov         edx,[esp][0000C]
C70206000000                 mov         d,[edx],000000006
8B542408                     mov         edx,[esp][00008]
8902                         mov         [edx],eax
8B442404                     mov         eax,[esp][00004]
C700010000C0                 mov         d,[eax],0C0000001
C21000                       retn        00010
*/
#define SIGN_LEN 22
BYTE search[SIGN_LEN]= { 0x8B,0x54,0x24,0x0C,0xC7,0x02,0x06,0x00,0x00,0x00,0x8B,0x54,
                         0x24,0x08,0x89,0x02,0x8B,0x44,0x24,0x04,0xC7,0x00 };

MRESULT EXPENTRY SetupDlgProc (HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2);

ULONG fsize(FILE *fp) {
  ULONG save_pos, size_of_file;
  save_pos=ftell(fp);
  fseek(fp,0,SEEK_END);
  size_of_file=ftell(fp);
  fseek(fp,save_pos,SEEK_SET);
  return size_of_file;
}

HAB   hab;                              /* Anchor block handle          */
HMQ   hmq;                              /* Message queue handle         */
BYTE *gm=0;
BYTE *patch=0;

int main(void) {
  QMSG  qmsg;
  ULONG res, ii;
  char  path[200];
  FILE *ff;

  hab = WinInitialize( 0 );
  if(!hab) {
    DosBeep(2000, 200);
    exit(1);
  }

  hmq = WinCreateMsgQueue( hab, 0 );
  if(!hmq) {
    DosBeep(2000, 200);
    WinTerminate(hab);
    exit(1);
  }
  DosQuerySysInfo(QSV_BOOT_DRIVE,QSV_BOOT_DRIVE,&res,4);
  sprintf(path,"%c:\\IBMCOM\\MACS\\GENM32W.OS2",'A'+res-1);
  ff=fopen(path,"r+b");
  if (!ff) {
     WinMessageBox(HWND_DESKTOP,HWND_DESKTOP,path,"Unable to open file!",0,MB_OK|MB_ERROR);
     exit(2);
  }
  res=fsize(ff);
  gm =malloc(res);
  fread(gm,1,res,ff);
  fseek(ff,0,SEEK_SET);

  ii=0;;
  while (ii<res-SIGN_LEN)
    if (gm[ii]==search[0]) {
      if (memcmp(gm+ii,search,SIGN_LEN)==0&&ii>12&&gm[ii-6]==0x66&&gm[ii-12]==0xC7) break;
        else ii++;
    } else ii++;

  do {
    if (ii>=res-SIGN_LEN) {
       WinMessageBox(HWND_DESKTOP,HWND_DESKTOP,path,"Unable to find signature in file!",0,MB_OK|MB_ERROR);
       break;
    }
    patch=gm+ii;
    ii=WinDlgBox(HWND_DESKTOP,HWND_DESKTOP,(PFNWP)SetupDlgProc,(HMODULE)0,
      100,NULL);
    if (ii==DID_OK) fwrite(gm,1,res,ff);
  } while(0);
  free(gm);
  fclose(ff);

  WinDestroyMsgQueue( hmq );            /* and                          */
  WinTerminate( hab );                  /* terminate the application    */
  return(0);
}

MRESULT EXPENTRY SetupDlgProc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2) {
   char buf[24];
   switch(msg) {
      case WM_INITDLG: {
        WinSendDlgItemMsg(hwnd,102,BM_SETCHECK,(void*)(*(ULONG*)(patch+SIGN_LEN)?0:1),0);
        sprintf(buf,"%2.2X-%2.2X-%2.2X-%2.2X-%2.2X-%2.2X",
          patch[-10],patch[-9],patch[-8],patch[-7],patch[-2],patch[-1]);
        WinSetWindowText(WinWindowFromID(hwnd,101),buf);
        break;
      }
      case WM_COMMAND:
        if ((USHORT)mp1==DID_OK) {
          ULONG addrs[6];
          WinQueryWindowText(WinWindowFromID(hwnd,101),24,buf);
          sscanf(buf,"%x-%x-%x-%x-%x-%x",addrs+0,addrs+1,addrs+2,addrs+3,addrs+4,addrs+5);
          patch[-10]=addrs[0];
          patch[- 9]=addrs[1];
          patch[- 8]=addrs[2];
          patch[- 7]=addrs[3];
          patch[- 2]=addrs[4];
          patch[- 1]=addrs[5];

          sprintf(buf,"%2.2X-%2.2X-%2.2X-%2.2X-%2.2X-%2.2X",
            patch[-10],patch[-9],patch[-8],patch[-7],patch[-2],patch[-1]);

          if (WinMessageBox(HWND_DESKTOP,HWND_DESKTOP,buf,"Is MAC address correct?",0,MB_YESNO|MB_QUERY)==MBID_YES)
          {
             ULONG rc=(ULONG)WinSendDlgItemMsg(hwnd,102,BM_QUERYCHECK,0,0);
             *(ULONG*)(patch+SIGN_LEN)=rc==1?0:0xC0000001;
          } else break;
        }
      default:
        return(WinDefDlgProc(hwnd, msg, mp1, mp2));
        break;
   }
   return (MRESULT)0;
}


