/* SoundMax Integrated Digital Audio MMPM/2 driver install REXX script */
Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs

say "Installing the SoundMax Integrated Digital Audio MMPM/2 drivers"
say 'Copyright 1999 Analog Devices Inc.'

os2bootPath = SysSearchPath('PATH', 'os2boot')
if os2bootpath \= ''
then bootDrive = filespec('drive', os2bootPath)
else
do
 say "Can't find boot drive! Aborting..."
 exit 1
end

Say "Starting minstall..."
minstall
    
call SysFileTree  bootDrive'\OS2\MDOS\WINOS2\*.ini', file
if file.0 \= 0
then do
	Say 'Installing WinOS/2 driver'
	start '/win wininst' ' i ' || bootDrive'\OS2\MDOS\WINOS2\SYSTEM.INI'
end

Say 'Creating SoundMax Audio folder'
If SysCreateObject("WPFolder", "SoundMax Audio", "<WP_DESKTOP>",,
                   "OBJECTID=<ICHAUDIO>") 
Then Do
 If SysCreateObject("WPProgram", "WarpMix", "<ICHAUDIO>",,
                    "PROGTYPE=PM;OBJECTID=<WARPMIX>;ICONFILE=WARPMIX.ICO;EXENAME="||bootDrive||"\MMOS2\WARPMIX.EXE")  
  Then Say 'SoundMax Audio folder and WarpMix object have been created'
  Else Say 'Could not create WarpMix object'
End
Else Say 'Could not create SoundMax Audio folder'           

Say 'Adding Warpmix to Startup folder'
If SysCreateObject("WPProgram", "WarpMix", "<WP_START>",,
                   "PROGTYPE=PM;OBJECTID=<WARPMIXSTRT>;ICONFILE=WARPMIX.ICO;EXENAME="||bootDrive||"\MMOS2\WARPMIX.EXE;PARAMETERS=restoremix")  
Then Say 'Warpmix has been added to the Startup folder'
Else Say 'Could not add Warpmix to the Startup folder'

Say 'SoundMax Integrated Digital Audio MMPM/2 drivers successfully installed'
Say 'Please shutdown OS/2 and reboot to use the SoundMax Audio driver'

Exit 0