/********************************************************/
/* For how to write an minstall installation DLL see    */
/* "Multimedia Subsystem Programming Guide"             */
/* -> Installation Requirements                         */
/* -> Writing an Installation DLL                       */
/********************************************************/

#define INCL_BASE
#define INCL_PM
#include <os2.h>
#include <minstall.h>

#define INCL_OS2MM
#include <os2me.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

char lineBuffer[1024]={0};
char errBuf[1024]={0};
char retBuf[MAX_DEVICE_NAME]={0};

void DeleteDevices(HWND hwndMinstallHandle,ULONG ulDevType,PSZ devInstallName)
{
    INSTMCISENDCOMMAND  cmd;
    MCI_SYSINFO_PARMS   sysParms;
    ULONG res = NO_ERROR;

    memset(&cmd,0,sizeof(cmd));
    memset(&sysParms,0,sizeof(sysParms));
    cmd.wMessage    = MCI_SYSINFO;
    cmd.dwParam1    = MCI_SYSINFO_QUANTITY|MCI_WAIT;
    cmd.dwParam2    = (ULONG)&sysParms;

    sysParms.usDeviceType   = ulDevType;
    sysParms.pszReturn      = retBuf;
    sysParms.ulRetSize      = sizeof(retBuf);

    res = LONGFROMMR(WinSendMsg(hwndMinstallHandle,IM_MCI_SEND_COMMAND,MPVOID,MPFROMP(&cmd)));
    if (res == NO_ERROR)
    {
        ULONG i;
        ULONG res2 = NO_ERROR;
        ULONG ulNumDevices = atoi(sysParms.pszReturn);
        for (i=0;i<ulNumDevices;i++)
        {
            memset(&cmd,0,sizeof(cmd));
            memset(&sysParms,0,sizeof(sysParms));
            cmd.wMessage    = MCI_SYSINFO;
            cmd.dwParam1    = MCI_SYSINFO_INSTALLNAME|MCI_WAIT;
            cmd.dwParam2    = (ULONG)&sysParms;

            sysParms.usDeviceType   = ulDevType;
            sysParms.ulNumber       = i;
            sysParms.pszReturn      = retBuf;
            sysParms.ulRetSize      = sizeof(retBuf);

            res = LONGFROMMR(WinSendMsg(hwndMinstallHandle,IM_MCI_SEND_COMMAND,MPVOID,MPFROMP(&cmd)));
            if ((res == NO_ERROR) && strstr(sysParms.pszReturn,devInstallName))
            {
                res = LONGFROMMR(WinSendMsg(hwndMinstallHandle,IM_MCI_EXTENDED_SYSINFO,MPFROMLONG(MCI_SYSINFO_DELETE_DRIVER),MPFROMP(sysParms.pszReturn)));
                mciGetErrorString(res,errBuf,sizeof(errBuf));
                sprintf(errBuf,"%s(device %s)",errBuf,sysParms.pszReturn);
                res2 = LONGFROMMR(WinSendMsg(hwndMinstallHandle,IM_LOG_ERROR,MPFROMP(errBuf),MPVOID));
            }
        }
    }
    return;
}

void DeleteConfigSysEntries(HWND hwndMinstallHandle,ULONG ulNum,PSZ StringArray[])
{
    CONFIGDATA conf;
    ULONG ulNumFound;
    APIRET res=NO_ERROR;

    /* find and REM out the DEVICE= device driver entries */
    memset(&conf,0,sizeof(conf));
    conf.lLine      = CONFIG_TOP;
    conf.lBufferLen = sizeof(lineBuffer);
    conf.pszBuffer  = lineBuffer;
    res = LONGFROMMR(WinSendMsg(hwndMinstallHandle,IM_CONFIGENUMERATE,MPFROMP(&conf),MPVOID));
    ulNumFound = 0;
    while(res == NO_ERROR)
    {
        ULONG i;

        strupr(conf.pszBuffer);
        for (i=0;i<ulNum;i++)
        {
            if (strstr(conf.pszBuffer,StringArray[i]))
            {
                ulNumFound++;
                res = LONGFROMMR(WinSendMsg(hwndMinstallHandle,IM_CONFIGDELETE,MPFROMP(&conf),MPVOID));
            }
        }
        if (ulNumFound >= ulNum)
        {
            break;
        }

        conf.lLine = CONFIG_NEXT;
        conf.lBufferLen = sizeof(lineBuffer);
        res = LONGFROMMR(WinSendMsg(hwndMinstallHandle,IM_CONFIGENUMERATE,MPFROMP(&conf),MPVOID));
    }
    return;
}


ULONG APIENTRY Install(
                        HWND hwndOwnerHandle,
                        PSZ pszSourcePath,
                        PSZ pszTargetDrive,
                        PSZ pszMyParms,
                        HWND hwndMinstallHandle,
                        PSZ pszResponseFile)
{
    ULONG res=NO_ERROR;
    INSTOBJECTDATA wpsObj;

    MM_DISPATCHVARS;
    MM_DISPATCHMESSAGES();

    /*create WPS objects */
    memset(&wpsObj,0,sizeof(wpsObj));
    strcpy(wpsObj.achClassName,"WPFolder");
    strcpy(wpsObj.achTitle,"UniMixer");
    strcpy(wpsObj.achSetupString,"OBJECTID=<UNIMIXER_FOLDER>;");
    strcpy(wpsObj.achLocation,"<WP_DESKTOP>");
    wpsObj.ulFlags = 1UL; /* Replace */
    res = LONGFROMMR(
                        WinSendMsg(
                            hwndMinstallHandle,
                            IM_CREATE_WPS_OBJECT,
                            MPVOID,
                            MPFROMP(&wpsObj)
                        )
                    );

    memset(&wpsObj,0,sizeof(wpsObj));
    strcpy(wpsObj.achClassName,"WPProgram");
    strcpy(wpsObj.achTitle,"UniMixer");
    strcpy(wpsObj.achSetupString,"EXENAME=$(DEST)unimix.exe");
    strcpy(wpsObj.achLocation,"<UNIMIXER_FOLDER>");
    wpsObj.ulFlags = 1UL; /* Replace */
    res = LONGFROMMR(
                        WinSendMsg(
                            hwndMinstallHandle,
                            IM_CREATE_WPS_OBJECT,
                            MPVOID,
                            MPFROMP(&wpsObj)
                        )
                    );

    memset(&wpsObj,0,sizeof(wpsObj));
    strcpy(wpsObj.achClassName,"WPProgram");
    strcpy(wpsObj.achTitle,"UniMixerPM");
    strcpy(wpsObj.achSetupString,"EXENAME=$(DEST)unimixpm.exe");
    strcpy(wpsObj.achLocation,"<UNIMIXER_FOLDER>");
    wpsObj.ulFlags = 1UL; /* Replace */
    res = LONGFROMMR(
                        WinSendMsg(
                            hwndMinstallHandle,
                            IM_CREATE_WPS_OBJECT,
                            MPVOID,
                            MPFROMP(&wpsObj)
                        )
                    );

    memset(&wpsObj,0,sizeof(wpsObj));
    strcpy(wpsObj.achClassName,"WPShadow");
    strcpy(wpsObj.achTitle,"");
    strcpy(wpsObj.achSetupString,"SHADOWID=$(DEST)unimix.txt");
    strcpy(wpsObj.achLocation,"<UNIMIXER_FOLDER>");
    wpsObj.ulFlags = 1UL; /* Replace */
    res = LONGFROMMR(
                        WinSendMsg(
                            hwndMinstallHandle,
                            IM_CREATE_WPS_OBJECT,
                            MPVOID,
                            MPFROMP(&wpsObj)
                        )
                    );

    memset(&wpsObj,0,sizeof(wpsObj));
    strcpy(wpsObj.achClassName,"WPShadow");
    strcpy(wpsObj.achTitle,"");
    strcpy(wpsObj.achSetupString,"SHADOWID=$(DEST)example.cmd");
    strcpy(wpsObj.achLocation,"<UNIMIXER_FOLDER>");
    wpsObj.ulFlags = 1UL; /* Replace */
    res = LONGFROMMR(
                        WinSendMsg(
                            hwndMinstallHandle,
                            IM_CREATE_WPS_OBJECT,
                            MPVOID,
                            MPFROMP(&wpsObj)
                        )
                    );

    memset(&wpsObj,0,sizeof(wpsObj));
    strcpy(wpsObj.achClassName,"WPShadow");
    strcpy(wpsObj.achTitle,"");
    strcpy(wpsObj.achSetupString,"SHADOWID=$(DEST)unimixpm.txt");
    strcpy(wpsObj.achLocation,"<UNIMIXER_FOLDER>");
    wpsObj.ulFlags = 1UL; /* Replace */
    res = LONGFROMMR(
                        WinSendMsg(
                            hwndMinstallHandle,
                            IM_CREATE_WPS_OBJECT,
                            MPVOID,
                            MPFROMP(&wpsObj)
                        )
                    );

    MM_DISPATCHMESSAGES();

    return NO_ERROR;
}


ULONG APIENTRY Deinstall(
                        HWND hwndOwnerHandle,
                        PSZ pszSourcePath,
                        PSZ pszTargetDrive,
                        PSZ pszMyParms,
                        HWND hwndMinstallHandle,
                        PSZ pszResponseFile)
{
    ULONG res=NO_ERROR;
    PSZ StringArray[2] = {"UNIAUD32.SYS","UNIAUD16.SYS"};

    MM_DISPATCHVARS;
    MM_DISPATCHMESSAGES();

    /* find and REM out the DEVICE= device driver entries */
    DeleteConfigSysEntries(hwndMinstallHandle,sizeof(StringArray)/sizeof(StringArray[0]),StringArray);

    MM_DISPATCHMESSAGES();

    /* remove the WPS folder with contents */
    res = LONGFROMMR(
            WinSendMsg(
                    hwndMinstallHandle,
                    IM_DESTROY_WPS_OBJECT,
                    MPVOID,
                    MPFROMP("<UNIMIXER_FOLDER>")
                    )
            );

    MM_DISPATCHMESSAGES();

    /* remove the UniAud supported device entries in MMPM2.INI */
    DeleteDevices(hwndMinstallHandle,MCI_DEVTYPE_WAVEFORM_AUDIO,"UNIAUDWAVE");
    DeleteDevices(hwndMinstallHandle,MCI_DEVTYPE_AUDIO_AMPMIX,"UNIAUDAMPMIX");
    DeleteDevices(hwndMinstallHandle,MCI_DEVTYPE_AUDIO_AMPMIX,"UNIFMAMPMIX");   /* delete junk entry, UniAud does not support MIDI ! */
    DeleteDevices(hwndMinstallHandle,MCI_DEVTYPE_SEQUENCER,"UNIAUDFM");         /* delete junk entry, UniAud does not support MIDI ! */

    MM_DISPATCHMESSAGES();

    return NO_ERROR;
}

