/* read from the USBECD.SYS device driver */
rc=RxFuncAdd('SysGetMessage','RexxUtil','SysGetMessage')

/* obtain device driver name */
parse upper arg ddName SuperfluousArguments
if ddName = '' then ddName = '$' /* default device driver name */

/* build device driver name parameter */
if ddName = '$' then nParm = ''; else nParm = '/N:' || ddName

/* ensure that the device driver statement exists in config.sys */
if stream(ddName,'command','query exists') \= '\DEV\' || ddName
then do
  say
  say 'Missing DEVICE=C:\OS2\BOOT\USBECD.SYS' nParm 'statement in CONFIG.SYS'
  say
  /* wait */
  '@pause'
  exit
  end

/* acquire the device driver */
rc=stream(ddName,'command','open')
if rc \= 'READY:'
then do
  say
  say rc 'Device driver' ddName 'currently in use. Please try later.'
  say
  /* wait */
  '@pause'
  exit
  end

/* get device descriptor */
iiBuffer=charin(ddName,,26)
rc=stream(ddName,'description')
/* check completion code */
if rc \= 'READY:'
then do
  say
  /* obtain and issue error message */
  parse value rc with sState ':' mNumber
  say SysGetMessage(mNumber,,ddName)
  /* wait */
  '@pause'
  exit
  end

/* release the device driver */
rc=stream(ddName,'command','close')

/* identify last attached usb device */
idVendor = c2x(reverse(substr(iiBuffer,17,2)))
idProduct = c2x(reverse(substr(iiBuffer,19,2)))
bcdDevice = c2x(reverse(substr(iiBuffer,21,2)))

/* build device driver usb device parameter */
dParm = '/D:' || idVendor || ':' || idProduct || ':' || bcdDevice

say
say 'devDescriptor='c2x(substr(iiBuffer,9,18))
say
say 'idVendor='idVendor', idProduct='idProduct', bcdDevice='bcdDevice'.'
say
say 'To control this device through the' ddName 'driver you need:'
say
say 'DEVICE=C:\OS2\BOOT\USBECD.SYS' dParm nParm
say
say 'to be present in your CONFIG.SYS file'.
say
/* wait */
'@pause'
exit
