* Weitek P9100 WIN

:TITLE
Weitek P9100 WINCFG DSP

:KEY
WEITEK_P9100WIN

:FILES :MODE=PRIMARY :MODE=WINDOWS
P9100          %WINPATH%
P9100SYS       %WINPATH%\SYSTEM\
FONTS          %WINPATH%\SYSTEM

:WININI :MODE=PRIMARY :MODE=WINDOWS
SYSTEM.INI
*
* Set the seamless windows driver.
*
boot sdisplay.drv sp91_08.drv
boot.description sdisplay.drv "Power 9100 Seamless Driver Version 2.00"
*
* Set the Seamless P9100 specific entries
*
SP9100.DRV Font small
*
* Set the windows system fonts.
* fonts.drv is used by OS/2 Full-Pack.
*
boot fonts.fon vgasys.fon
*
* Set the full screen windows driver.
* display.drv is used by OS/2 Full-Pack.
*
boot display.drv p9100_08.drv
boot.description display.drv "Power 9100 Full Screen Driver Version 2.00"
*
* Set the P9100 specific entries
*
P9100.DRV Resolution 640x480
P9100.DRV Refresh 60Hz
P9100.DRV Font small
P9100.DRV Cursors 32
P9100.DRV DevBits Off
P9100.DRV MemClkInDecaKHz 4975
P9100.DRV BusType DETECT
P9100.DRV BoardType VesaHigh
P9100.DRV MemAddr C000
P9100.DRV wBase C0
P9100.DRV MemSize 4
P9100.DRV DacType DETECT
P9100.DRV CursorUpdate Off
P9100.DRV Cursor Power
P9100.DRV Speed 33.00mHz
P9100.DRV Monitor Generic
P9100.DRV DefMode 640x480x8
P9100.DRV CfgBA 9100
P9100.DRV OEMString WEITEK
P9100.DRV Version 1.0
P9100.DRV TmgFileName P9X00RES.INI
P9100.DRV ClockType DETECT
P9100.DRV IBM525PLL On


****************************************************************************
*
* From this point on is the modifications to be made to the OS2.INI file
* in order to support updating the WIN-OS/2 Full Screen and Seamless
* display drivers when using the OS/2 System Object to change the
* display resolution and/or color depth.
*
* Notes:
*  1) When this method is used, only one refresh rate per resolution will
*     be able to be set.
*
*  2) The OS/2 System Object normally refers to the various color depths
*     in terms of number of colors available rather than the number of
*     bits per pixel.  However, this is not good enough for the Power
*     9x00 driver because it is possible to run in either 24 Bpp mode
*     or 32 Bpp mode.  Each of these modes supports the same number of
*     colors however the frame buffer is organazied differently.  As a
*     result, when 24 Bpp modes are supported (i.e. on a Power 9100
*     board with an IBM RGB525 DAC) it is necessary to be able to
*     distinguish between these two different color depths in order to
*     update both the Full Screen and Seamless WIN-OS/2 drivers properly.
*     As a result of this minor oversight, instead of refering to the
*     display modes based on the number of colors available, the Power
*     9x00 drivers will refer to the number of Bits Per Pixel.
*
****************************************************************************
:OS2INI :MODE=PRIMARY :MODE=WINDOWS
OS2.INI
PM_DISPLAYDRIVERS RESOLUTION_CHANGED 1

*
* Define all the possible display modes.
*
WIN_RES_640x480x8    WIN_RES_SET    WIN_RES_P9_0
WIN_RES_800x600x8    WIN_RES_SET    WIN_RES_P9_1
WIN_RES_1024x768x8   WIN_RES_SET    WIN_RES_P9_2
WIN_RES_1280x1024x8  WIN_RES_SET    WIN_RES_P9_3
WIN_RES_1600x1200x8  WIN_RES_SET    WIN_RES_P9_4
WIN_RES_640x480x16   WIN_RES_SET    WIN_RES_P9_5
WIN_RES_800x600x16   WIN_RES_SET    WIN_RES_P9_6
WIN_RES_1024x768x16  WIN_RES_SET    WIN_RES_P9_7
WIN_RES_1280x1024x16 WIN_RES_SET    WIN_RES_P9_8
WIN_RES_1600x1200x16 WIN_RES_SET    WIN_RES_P9_9
WIN_RES_640x480x24   WIN_RES_SET    WIN_RES_P9_10
WIN_RES_800x600x24   WIN_RES_SET    WIN_RES_P9_11
WIN_RES_1024x768x24  WIN_RES_SET    WIN_RES_P9_12
WIN_RES_1280x1024x24 WIN_RES_SET    WIN_RES_P9_13
WIN_RES_640x480x32   WIN_RES_SET    WIN_RES_P9_14
WIN_RES_800x600x32   WIN_RES_SET    WIN_RES_P9_15
WIN_RES_1024x768x32  WIN_RES_SET    WIN_RES_P9_16
"Power 9000 Mode Info"     "BPP24"        "OFF"
WIN_RES_640x480x256        WIN_RES_SET    WIN_RES_P9_0
WIN_RES_800x600x256        WIN_RES_SET    WIN_RES_P9_1
WIN_RES_1024x768x256       WIN_RES_SET    WIN_RES_P9_2
WIN_RES_1280x1024x256      WIN_RES_SET    WIN_RES_P9_3
WIN_RES_1600x1200x256      WIN_RES_SET    WIN_RES_P9_4
WIN_RES_640x480x65536      WIN_RES_SET    WIN_RES_P9_5
WIN_RES_800x600x65536      WIN_RES_SET    WIN_RES_P9_6
WIN_RES_1024x768x65536     WIN_RES_SET    WIN_RES_P9_7
WIN_RES_1280x1024x65536    WIN_RES_SET    WIN_RES_P9_8
WIN_RES_1600x1200x65536    WIN_RES_SET    WIN_RES_P9_9
WIN_RES_640x480x16777216   WIN_RES_SET    WIN_RES_P9_14
WIN_RES_800x600x16777216   WIN_RES_SET    WIN_RES_P9_15
WIN_RES_1024x768x16777216  WIN_RES_SET    WIN_RES_P9_16

*
* Define modifications required for 640x480x8 60Hz.
*
WIN_RES_P9_0   1  "system.ini boot display.drv  p9100_08.drv"
WIN_RES_P9_0   2  "system.ini boot sdisplay.drv sp91_08.drv"
WIN_RES_P9_0   3  "system.ini SP9100.DRV Font Small"
WIN_RES_P9_0   4  "system.ini P9100.DRV Resolution 640x480"
WIN_RES_P9_0   5  "system.ini P9100.DRV Refresh 60Hz"
WIN_RES_P9_0   6  "system.ini P9100.DRV Font Small"
WIN_RES_P9_0   7  "system.ini P9100.DRV Cursors 32"
WIN_RES_P9_0   8  "system.ini P9100.DRV MemClkInDecaKHz 4975"
WIN_RES_P9_0   9  "system.ini P9100.DRV BusType DETECT"
WIN_RES_P9_0  10  "system.ini P9100.DRV BoardType VesaHigh"
WIN_RES_P9_0  11  "system.ini P9100.DRV MemAddr C000"
WIN_RES_P9_0  12  "system.ini P9100.DRV wBase C0"
WIN_RES_P9_0  13  "system.ini P9100.DRV MemSize 4"
WIN_RES_P9_0  14  "system.ini P9100.DRV DacType DETECT"
WIN_RES_P9_0  15  "system.ini P9100.DRV CursorUpdate Off"
WIN_RES_P9_0  16  "system.ini P9100.DRV Cursor Power"
WIN_RES_P9_0  17  "system.ini P9100.DRV Speed 33.00mHz"
WIN_RES_P9_0  18  "system.ini P9100.DRV Monitor Generic"
WIN_RES_P9_0  19  "system.ini P9100.DRV DefMode 640x480x8"
WIN_RES_P9_0  20  "system.ini P9100.DRV CfgBA 9100"
WIN_RES_P9_0  21  "system.ini P9100.DRV OEMString WEITEK"
WIN_RES_P9_0  22  "system.ini P9100.DRV Version 1.0"
WIN_RES_P9_0  23  "system.ini P9100.DRV TmgFileName P9X00RES.INI"
WIN_RES_P9_0  24  "system.ini P9100.DRV ClockType DETECT"
WIN_RES_P9_0  25  "system.ini P9100.DRV IBM525PLL On"
WIN_RES_P9_0  26  "p9x00res.ini 640x480x8 link 640x480"
WIN_RES_P9_0  27  "p9x00res.ini 640x480 hdr 25.17mHz"
WIN_RES_P9_0  28  "p9x00res.ini 640x480 hsp 96"
WIN_RES_P9_0  29  "p9x00res.ini 640x480 hbp 48"
WIN_RES_P9_0  30  "p9x00res.ini 640x480 had 640"
WIN_RES_P9_0  31  "p9x00res.ini 640x480 hfp 16"
WIN_RES_P9_0  32  "p9x00res.ini 640x480 hco 0"
WIN_RES_P9_0  33  "p9x00res.ini 640x480 hp  negative"
WIN_RES_P9_0  34  "p9x00res.ini 640x480 vlr 60Hz"
WIN_RES_P9_0  35  "p9x00res.ini 640x480 vsp 2"
WIN_RES_P9_0  36  "p9x00res.ini 640x480 vbp 33"
WIN_RES_P9_0  37  "p9x00res.ini 640x480 vad 480"
WIN_RES_P9_0  38  "p9x00res.ini 640x480 vfp 10"
WIN_RES_P9_0  39  "p9x00res.ini 640x480 vco 0"
WIN_RES_P9_0  40  "p9x00res.ini 640x480 vp  negative"
WIN_RES_P9_0  41  "system.ini boot fonts.fon vgasys.fon"
                 
*
* Define modifications required for 800x600x8 60Hz.
*
WIN_RES_P9_1   1  "system.ini boot display.drv  p9100_08.drv"
WIN_RES_P9_1   2  "system.ini boot sdisplay.drv sp91_08.drv"
WIN_RES_P9_1   3  "system.ini SP9100.DRV Font Small"
WIN_RES_P9_1   4  "system.ini P9100.DRV Resolution 800x600"
WIN_RES_P9_1   5  "system.ini P9100.DRV Refresh 60Hz"
WIN_RES_P9_1   6  "system.ini P9100.DRV Font Small"
WIN_RES_P9_1   7  "system.ini P9100.DRV Cursors 32"
WIN_RES_P9_1   8  "system.ini P9100.DRV MemClkInDecaKHz 4975"
WIN_RES_P9_1   9  "system.ini P9100.DRV BusType DETECT"
WIN_RES_P9_1  10  "system.ini P9100.DRV BoardType VesaHigh"
WIN_RES_P9_1  11  "system.ini P9100.DRV MemAddr C000"
WIN_RES_P9_1  12  "system.ini P9100.DRV wBase C0"
WIN_RES_P9_1  13  "system.ini P9100.DRV MemSize 4"
WIN_RES_P9_1  14  "system.ini P9100.DRV DacType DETECT"
WIN_RES_P9_1  15  "system.ini P9100.DRV CursorUpdate Off"
WIN_RES_P9_1  16  "system.ini P9100.DRV Cursor Power"
WIN_RES_P9_1  17  "system.ini P9100.DRV Speed 33.00mHz"
WIN_RES_P9_1  18  "system.ini P9100.DRV Monitor Generic"
WIN_RES_P9_1  19  "system.ini P9100.DRV DefMode 640x480x8"
WIN_RES_P9_1  20  "system.ini P9100.DRV CfgBA 9100"
WIN_RES_P9_1  21  "system.ini P9100.DRV OEMString WEITEK"
WIN_RES_P9_1  22  "system.ini P9100.DRV Version 1.0"
WIN_RES_P9_1  23  "system.ini P9100.DRV TmgFileName P9X00RES.INI"
WIN_RES_P9_1  24  "system.ini P9100.DRV ClockType DETECT"
WIN_RES_P9_1  25  "system.ini P9100.DRV IBM525PLL On"
WIN_RES_P9_1  26  "p9x00res.ini 800x600x8 link 800x600"
WIN_RES_P9_1  27  "p9x00res.ini 800x600 hdr 40mHz"
WIN_RES_P9_1  28  "p9x00res.ini 800x600 hsp 128"
WIN_RES_P9_1  29  "p9x00res.ini 800x600 hbp 88"
WIN_RES_P9_1  30  "p9x00res.ini 800x600 had 800"  
WIN_RES_P9_1  31  "p9x00res.ini 800x600 hfp 40"
WIN_RES_P9_1  32  "p9x00res.ini 800x600 hco 0"
WIN_RES_P9_1  33  "p9x00res.ini 800x600 hp  negative"
WIN_RES_P9_1  34  "p9x00res.ini 800x600 vlr 60Hz"
WIN_RES_P9_1  35  "p9x00res.ini 800x600 vsp 4"
WIN_RES_P9_1  36  "p9x00res.ini 800x600 vbp 23"
WIN_RES_P9_1  37  "p9x00res.ini 800x600 vad 600" 
WIN_RES_P9_1  38  "p9x00res.ini 800x600 vfp 1"
WIN_RES_P9_1  39  "p9x00res.ini 800x600 vco 0"
WIN_RES_P9_1  40  "p9x00res.ini 800x600 vp  negative"
WIN_RES_P9_1  41  "system.ini boot fonts.fon vgasys.fon"

*
* Define modifications required for 1024x768x8 60Hz.
*
WIN_RES_P9_2   1  "system.ini boot display.drv  p9100_08.drv"
WIN_RES_P9_2   2  "system.ini boot sdisplay.drv sp91_08.drv"
WIN_RES_P9_2   3  "system.ini SP9100.DRV Font Large"
WIN_RES_P9_2   4  "system.ini P9100.DRV Resolution 1024x768"
WIN_RES_P9_2   5  "system.ini P9100.DRV Refresh 60Hz"
WIN_RES_P9_2   6  "system.ini P9100.DRV Font Large"
WIN_RES_P9_2   7  "system.ini P9100.DRV Cursors 32"
WIN_RES_P9_2   8  "system.ini P9100.DRV MemClkInDecaKHz 4975"
WIN_RES_P9_2   9  "system.ini P9100.DRV BusType DETECT"
WIN_RES_P9_2  10  "system.ini P9100.DRV BoardType VesaHigh"
WIN_RES_P9_2  11  "system.ini P9100.DRV MemAddr C000"
WIN_RES_P9_2  12  "system.ini P9100.DRV wBase C0"
WIN_RES_P9_2  13  "system.ini P9100.DRV MemSize 4"
WIN_RES_P9_2  14  "system.ini P9100.DRV DacType DETECT"
WIN_RES_P9_2  15  "system.ini P9100.DRV CursorUpdate Off"
WIN_RES_P9_2  16  "system.ini P9100.DRV Cursor Power"
WIN_RES_P9_2  17  "system.ini P9100.DRV Speed 33.00mHz"
WIN_RES_P9_2  18  "system.ini P9100.DRV Monitor Generic"
WIN_RES_P9_2  19  "system.ini P9100.DRV DefMode 640x480x8"
WIN_RES_P9_2  20  "system.ini P9100.DRV CfgBA 9100"
WIN_RES_P9_2  21  "system.ini P9100.DRV OEMString WEITEK"
WIN_RES_P9_2  22  "system.ini P9100.DRV Version 1.0"
WIN_RES_P9_2  23  "system.ini P9100.DRV TmgFileName P9X00RES.INI"
WIN_RES_P9_2  24  "system.ini P9100.DRV ClockType DETECT"
WIN_RES_P9_2  25  "system.ini P9100.DRV IBM525PLL On"
WIN_RES_P9_2  26  "p9x00res.ini 1024x768x8 link 1024x768"
WIN_RES_P9_2  27  "p9x00res.ini 1024x768 hdr 65mHz"
WIN_RES_P9_2  28  "p9x00res.ini 1024x768 hsp 136"
WIN_RES_P9_2  29  "p9x00res.ini 1024x768 hbp 160"
WIN_RES_P9_2  30  "p9x00res.ini 1024x768 had 1024" 
WIN_RES_P9_2  31  "p9x00res.ini 1024x768 hfp 24"
WIN_RES_P9_2  32  "p9x00res.ini 1024x768 hco 0"
WIN_RES_P9_2  33  "p9x00res.ini 1024x768 hp  negative"
WIN_RES_P9_2  34  "p9x00res.ini 1024x768 vlr 60Hz"
WIN_RES_P9_2  35  "p9x00res.ini 1024x768 vsp 6"
WIN_RES_P9_2  36  "p9x00res.ini 1024x768 vbp 29"
WIN_RES_P9_2  37  "p9x00res.ini 1024x768 vad 768" 
WIN_RES_P9_2  38  "p9x00res.ini 1024x768 vfp 3"
WIN_RES_P9_2  39  "p9x00res.ini 1024x768 vco 0" 
WIN_RES_P9_2  40  "p9x00res.ini 1024x768 vp  negative"
WIN_RES_P9_2  41  "system.ini boot fonts.fon 8514sys.fon"

*
* Define modifications required for 1280x1024x8 60Hz.
*
WIN_RES_P9_3   1  "system.ini boot display.drv  p9100_08.drv"
WIN_RES_P9_3   2  "system.ini boot sdisplay.drv sp91_08.drv"
WIN_RES_P9_3   3  "system.ini SP9100.DRV Font Large"
WIN_RES_P9_3   4  "system.ini P9100.DRV Resolution 1280x1024"
WIN_RES_P9_3   5  "system.ini P9100.DRV Refresh 60Hz"
WIN_RES_P9_3   6  "system.ini P9100.DRV Font Large"
WIN_RES_P9_3   7  "system.ini P9100.DRV Cursors 32"
WIN_RES_P9_3   8  "system.ini P9100.DRV MemClkInDecaKHz 4975"
WIN_RES_P9_3   9  "system.ini P9100.DRV BusType DETECT"
WIN_RES_P9_3  10  "system.ini P9100.DRV BoardType VesaHigh"
WIN_RES_P9_3  11  "system.ini P9100.DRV MemAddr C000"
WIN_RES_P9_3  12  "system.ini P9100.DRV wBase C0"
WIN_RES_P9_3  13  "system.ini P9100.DRV MemSize 4"
WIN_RES_P9_3  14  "system.ini P9100.DRV DacType DETECT"
WIN_RES_P9_3  15  "system.ini P9100.DRV CursorUpdate Off"
WIN_RES_P9_3  16  "system.ini P9100.DRV Cursor Power"
WIN_RES_P9_3  17  "system.ini P9100.DRV Speed 33.00mHz"
WIN_RES_P9_3  18  "system.ini P9100.DRV Monitor Generic"
WIN_RES_P9_3  19  "system.ini P9100.DRV DefMode 640x480x8"
WIN_RES_P9_3  20  "system.ini P9100.DRV CfgBA 9100"
WIN_RES_P9_3  21  "system.ini P9100.DRV OEMString WEITEK"
WIN_RES_P9_3  22  "system.ini P9100.DRV Version 1.0"
WIN_RES_P9_3  23  "system.ini P9100.DRV TmgFileName P9X00RES.INI"
WIN_RES_P9_3  24  "system.ini P9100.DRV ClockType DETECT"
WIN_RES_P9_3  25  "system.ini P9100.DRV IBM525PLL On"
WIN_RES_P9_3  26  "p9x00res.ini 1280x1024x8 link 1280x1024"
WIN_RES_P9_3  27  "p9x00res.ini 1280x1024 hdr 115mHz"
WIN_RES_P9_3  28  "p9x00res.ini 1280x1024 hsp 224"
WIN_RES_P9_3  29  "p9x00res.ini 1280x1024 hbp 256"
WIN_RES_P9_3  30  "p9x00res.ini 1280x1024 had 1280" 
WIN_RES_P9_3  31  "p9x00res.ini 1280x1024 hfp 32"
WIN_RES_P9_3  32  "p9x00res.ini 1280x1024 hco 0"
WIN_RES_P9_3  33  "p9x00res.ini 1280x1024 hp  negative"
WIN_RES_P9_3  34  "p9x00res.ini 1280x1024 vlr 60Hz"
WIN_RES_P9_3  35  "p9x00res.ini 1280x1024 vsp 3"
WIN_RES_P9_3  36  "p9x00res.ini 1280x1024 vbp 42"
WIN_RES_P9_3  37  "p9x00res.ini 1280x1024 vad 1024" 
WIN_RES_P9_3  38  "p9x00res.ini 1280x1024 vfp 1"
WIN_RES_P9_3  39  "p9x00res.ini 1280x1024 vco 0"
WIN_RES_P9_3  40  "p9x00res.ini 1280x1024 vp  negative"
WIN_RES_P9_3  41  "system.ini boot fonts.fon 8514sys.fon"

*
* Define modifications required for 1600x1200x8 60Hz.
*
WIN_RES_P9_4   1  "system.ini boot display.drv  p9100_08.drv"
WIN_RES_P9_4   2  "system.ini boot sdisplay.drv sp91_08.drv"
WIN_RES_P9_4   3  "system.ini SP9100.DRV Font Large"
WIN_RES_P9_4   4  "system.ini P9100.DRV Resolution 1600x1200"
WIN_RES_P9_4   5  "system.ini P9100.DRV Refresh 60Hz"
WIN_RES_P9_4   6  "system.ini P9100.DRV Font Large"
WIN_RES_P9_4   7  "system.ini P9100.DRV Cursors 32"
WIN_RES_P9_4   8  "system.ini P9100.DRV MemClkInDecaKHz 4975"
WIN_RES_P9_4   9  "system.ini P9100.DRV BusType DETECT"
WIN_RES_P9_4  10  "system.ini P9100.DRV BoardType VesaHigh"
WIN_RES_P9_4  11  "system.ini P9100.DRV MemAddr C000"
WIN_RES_P9_4  12  "system.ini P9100.DRV wBase C0"
WIN_RES_P9_4  13  "system.ini P9100.DRV MemSize 4"
WIN_RES_P9_4  14  "system.ini P9100.DRV DacType DETECT"
WIN_RES_P9_4  15  "system.ini P9100.DRV CursorUpdate Off"
WIN_RES_P9_4  16  "system.ini P9100.DRV Cursor Power"
WIN_RES_P9_4  17  "system.ini P9100.DRV Speed 33.00mHz"
WIN_RES_P9_4  18  "system.ini P9100.DRV Monitor Generic"
WIN_RES_P9_4  19  "system.ini P9100.DRV DefMode 640x480x8"
WIN_RES_P9_4  20  "system.ini P9100.DRV CfgBA 9100"
WIN_RES_P9_4  21  "system.ini P9100.DRV OEMString WEITEK"
WIN_RES_P9_4  22  "system.ini P9100.DRV Version 1.0"
WIN_RES_P9_4  23  "system.ini P9100.DRV TmgFileName P9X00RES.INI"
WIN_RES_P9_4  24  "system.ini P9100.DRV ClockType DETECT"
WIN_RES_P9_4  25  "system.ini P9100.DRV IBM525PLL On"
WIN_RES_P9_4  26  "p9x00res.ini 1600x1200x8 link 1600x1200"
WIN_RES_P9_4  27  "p9x00res.ini 1600x1200 hdr 160mHz"
WIN_RES_P9_4  28  "p9x00res.ini 1600x1200 hsp 224"
WIN_RES_P9_4  29  "p9x00res.ini 1600x1200 hbp 200"
WIN_RES_P9_4  30  "p9x00res.ini 1600x1200 had 1600" 
WIN_RES_P9_4  31  "p9x00res.ini 1600x1200 hfp 88"
WIN_RES_P9_4  32  "p9x00res.ini 1600x1200 hco 0" 
WIN_RES_P9_4  33  "p9x00res.ini 1600x1200 hp  negative"
WIN_RES_P9_4  34  "p9x00res.ini 1600x1200 vlr 60Hz"
WIN_RES_P9_4  35  "p9x00res.ini 1600x1200 vsp 3"
WIN_RES_P9_4  36  "p9x00res.ini 1600x1200 vbp 42"
WIN_RES_P9_4  37  "p9x00res.ini 1600x1200 vad 1200" 
WIN_RES_P9_4  38  "p9x00res.ini 1600x1200 vfp 1"
WIN_RES_P9_4  39  "p9x00res.ini 1600x1200 vco 0" 
WIN_RES_P9_4  40  "p9x00res.ini 1600x1200 vp  negative"
WIN_RES_P9_4  41  "system.ini boot fonts.fon 8514sys.fon"

*
* Define modifications required for 640x480x16 60Hz.
*
WIN_RES_P9_5   1  "system.ini boot display.drv  p9100_16.drv"
WIN_RES_P9_5   2  "system.ini boot sdisplay.drv sp91_16.drv"
WIN_RES_P9_5   3  "system.ini SP9100.DRV Font Small"
WIN_RES_P9_5   4  "system.ini P9100.DRV Resolution 640x480"
WIN_RES_P9_5   5  "system.ini P9100.DRV Refresh 60Hz"
WIN_RES_P9_5   6  "system.ini P9100.DRV Font Small"
WIN_RES_P9_5   7  "system.ini P9100.DRV Cursors 32"
WIN_RES_P9_5   8  "system.ini P9100.DRV MemClkInDecaKHz 4975"
WIN_RES_P9_5   9  "system.ini P9100.DRV BusType DETECT"
WIN_RES_P9_5  10  "system.ini P9100.DRV BoardType VesaHigh"
WIN_RES_P9_5  11  "system.ini P9100.DRV MemAddr C000"
WIN_RES_P9_5  12  "system.ini P9100.DRV wBase C0"
WIN_RES_P9_5  13  "system.ini P9100.DRV MemSize 4"
WIN_RES_P9_5  14  "system.ini P9100.DRV DacType DETECT"
WIN_RES_P9_5  15  "system.ini P9100.DRV CursorUpdate Off"
WIN_RES_P9_5  16  "system.ini P9100.DRV Cursor Power"
WIN_RES_P9_5  17  "system.ini P9100.DRV Speed 33.00mHz"
WIN_RES_P9_5  18  "system.ini P9100.DRV Monitor Generic"
WIN_RES_P9_5  19  "system.ini P9100.DRV DefMode 640x480x8"
WIN_RES_P9_5  20  "system.ini P9100.DRV CfgBA 9100"
WIN_RES_P9_5  21  "system.ini P9100.DRV OEMString WEITEK"
WIN_RES_P9_5  22  "system.ini P9100.DRV Version 1.0"
WIN_RES_P9_5  23  "system.ini P9100.DRV TmgFileName P9X00RES.INI"
WIN_RES_P9_5  24  "system.ini P9100.DRV ClockType DETECT"
WIN_RES_P9_5  25  "system.ini P9100.DRV IBM525PLL On"
WIN_RES_P9_5  26  "p9x00res.ini 640x480x16 link 640x480"
WIN_RES_P9_5  27  "p9x00res.ini 640x480 hdr 25.17mHz"
WIN_RES_P9_5  28  "p9x00res.ini 640x480 hsp 96"
WIN_RES_P9_5  29  "p9x00res.ini 640x480 hbp 48"
WIN_RES_P9_5  30  "p9x00res.ini 640x480 had 640"
WIN_RES_P9_5  31  "p9x00res.ini 640x480 hfp 16"
WIN_RES_P9_5  32  "p9x00res.ini 640x480 hco 0"
WIN_RES_P9_5  33  "p9x00res.ini 640x480 hp  negative"
WIN_RES_P9_5  34  "p9x00res.ini 640x480 vlr 60Hz"
WIN_RES_P9_5  35  "p9x00res.ini 640x480 vsp 2"
WIN_RES_P9_5  36  "p9x00res.ini 640x480 vbp 33"
WIN_RES_P9_5  37  "p9x00res.ini 640x480 vad 480"
WIN_RES_P9_5  38  "p9x00res.ini 640x480 vfp 10"
WIN_RES_P9_5  39  "p9x00res.ini 640x480 vco 0"
WIN_RES_P9_5  40  "p9x00res.ini 640x480 vp  negative"
WIN_RES_P9_5  41  "system.ini boot fonts.fon vgasys.fon"
                 
*
* Define modifications required for 800x600x16 60Hz.
*
WIN_RES_P9_6   1  "system.ini boot display.drv  p9100_16.drv"
WIN_RES_P9_6   2  "system.ini boot sdisplay.drv sp91_16.drv"
WIN_RES_P9_6   3  "system.ini SP9100.DRV Font Small"
WIN_RES_P9_6   4  "system.ini P9100.DRV Resolution 800x600"
WIN_RES_P9_6   5  "system.ini P9100.DRV Refresh 60Hz"
WIN_RES_P9_6   6  "system.ini P9100.DRV Font Small"
WIN_RES_P9_6   7  "system.ini P9100.DRV Cursors 32"
WIN_RES_P9_6   8  "system.ini P9100.DRV MemClkInDecaKHz 4975"
WIN_RES_P9_6   9  "system.ini P9100.DRV BusType DETECT"
WIN_RES_P9_6  10  "system.ini P9100.DRV BoardType VesaHigh"
WIN_RES_P9_6  11  "system.ini P9100.DRV MemAddr C000"
WIN_RES_P9_6  12  "system.ini P9100.DRV wBase C0"
WIN_RES_P9_6  13  "system.ini P9100.DRV MemSize 4"
WIN_RES_P9_6  14  "system.ini P9100.DRV DacType DETECT"
WIN_RES_P9_6  15  "system.ini P9100.DRV CursorUpdate Off"
WIN_RES_P9_6  16  "system.ini P9100.DRV Cursor Power"
WIN_RES_P9_6  17  "system.ini P9100.DRV Speed 33.00mHz"
WIN_RES_P9_6  18  "system.ini P9100.DRV Monitor Generic"
WIN_RES_P9_6  19  "system.ini P9100.DRV DefMode 640x480x8"
WIN_RES_P9_6  20  "system.ini P9100.DRV CfgBA 9100"
WIN_RES_P9_6  21  "system.ini P9100.DRV OEMString WEITEK"
WIN_RES_P9_6  22  "system.ini P9100.DRV Version 1.0"
WIN_RES_P9_6  23  "system.ini P9100.DRV TmgFileName P9X00RES.INI"
WIN_RES_P9_6  24  "system.ini P9100.DRV ClockType DETECT"
WIN_RES_P9_6  25  "system.ini P9100.DRV IBM525PLL On"
WIN_RES_P9_6  26  "p9x00res.ini 800x600x16 link 800x600"
WIN_RES_P9_6  27  "p9x00res.ini 800x600 hdr 40mHz"
WIN_RES_P9_6  28  "p9x00res.ini 800x600 hsp 128"
WIN_RES_P9_6  29  "p9x00res.ini 800x600 hbp 88"
WIN_RES_P9_6  30  "p9x00res.ini 800x600 had 800"  
WIN_RES_P9_6  31  "p9x00res.ini 800x600 hfp 40"
WIN_RES_P9_6  32  "p9x00res.ini 800x600 hco 0"
WIN_RES_P9_6  33  "p9x00res.ini 800x600 hp  negative"
WIN_RES_P9_6  34  "p9x00res.ini 800x600 vlr 60Hz"
WIN_RES_P9_6  35  "p9x00res.ini 800x600 vsp 4"
WIN_RES_P9_6  36  "p9x00res.ini 800x600 vbp 23"
WIN_RES_P9_6  37  "p9x00res.ini 800x600 vad 600" 
WIN_RES_P9_6  38  "p9x00res.ini 800x600 vfp 1"
WIN_RES_P9_6  39  "p9x00res.ini 800x600 vco 0"
WIN_RES_P9_6  40  "p9x00res.ini 800x600 vp  negative"
WIN_RES_P9_6  41  "system.ini boot fonts.fon vgasys.fon"

*
* Define modifications required for 1024x768x16 60Hz.
*
WIN_RES_P9_7   1  "system.ini boot display.drv  p9100_16.drv"
WIN_RES_P9_7   2  "system.ini boot sdisplay.drv sp91_16.drv"
WIN_RES_P9_7   3  "system.ini SP9100.DRV Font Large"
WIN_RES_P9_7   4  "system.ini P9100.DRV Resolution 1024x768"
WIN_RES_P9_7   5  "system.ini P9100.DRV Refresh 60Hz"
WIN_RES_P9_7   6  "system.ini P9100.DRV Font Large"
WIN_RES_P9_7   7  "system.ini P9100.DRV Cursors 32"
WIN_RES_P9_7   8  "system.ini P9100.DRV MemClkInDecaKHz 4975"
WIN_RES_P9_7   9  "system.ini P9100.DRV BusType DETECT"
WIN_RES_P9_7  10  "system.ini P9100.DRV BoardType VesaHigh"
WIN_RES_P9_7  11  "system.ini P9100.DRV MemAddr C000"
WIN_RES_P9_7  12  "system.ini P9100.DRV wBase C0"
WIN_RES_P9_7  13  "system.ini P9100.DRV MemSize 4"
WIN_RES_P9_7  14  "system.ini P9100.DRV DacType DETECT"
WIN_RES_P9_7  15  "system.ini P9100.DRV CursorUpdate Off"
WIN_RES_P9_7  16  "system.ini P9100.DRV Cursor Power"
WIN_RES_P9_7  17  "system.ini P9100.DRV Speed 33.00mHz"
WIN_RES_P9_7  18  "system.ini P9100.DRV Monitor Generic"
WIN_RES_P9_7  19  "system.ini P9100.DRV DefMode 640x480x8"
WIN_RES_P9_7  20  "system.ini P9100.DRV CfgBA 9100"
WIN_RES_P9_7  21  "system.ini P9100.DRV OEMString WEITEK"
WIN_RES_P9_7  22  "system.ini P9100.DRV Version 1.0"
WIN_RES_P9_7  23  "system.ini P9100.DRV TmgFileName P9X00RES.INI"
WIN_RES_P9_7  24  "system.ini P9100.DRV ClockType DETECT"
WIN_RES_P9_7  25  "system.ini P9100.DRV IBM525PLL On"
WIN_RES_P9_7  26  "p9x00res.ini 1024x768x16 link 1024x768"
WIN_RES_P9_7  27  "p9x00res.ini 1024x768 hdr 65mHz"
WIN_RES_P9_7  28  "p9x00res.ini 1024x768 hsp 136"
WIN_RES_P9_7  29  "p9x00res.ini 1024x768 hbp 160"
WIN_RES_P9_7  30  "p9x00res.ini 1024x768 had 1024" 
WIN_RES_P9_7  31  "p9x00res.ini 1024x768 hfp 24"
WIN_RES_P9_7  32  "p9x00res.ini 1024x768 hco 0"
WIN_RES_P9_7  33  "p9x00res.ini 1024x768 hp  negative"
WIN_RES_P9_7  34  "p9x00res.ini 1024x768 vlr 60Hz"
WIN_RES_P9_7  35  "p9x00res.ini 1024x768 vsp 6"
WIN_RES_P9_7  36  "p9x00res.ini 1024x768 vbp 29"
WIN_RES_P9_7  37  "p9x00res.ini 1024x768 vad 768" 
WIN_RES_P9_7  38  "p9x00res.ini 1024x768 vfp 3"
WIN_RES_P9_7  39  "p9x00res.ini 1024x768 vco 0" 
WIN_RES_P9_7  40  "p9x00res.ini 1024x768 vp  negative"
WIN_RES_P9_7  41  "system.ini boot fonts.fon 8514sys.fon"

*
* Define modifications required for 1280x1024x16 60Hz.
*
WIN_RES_P9_8   1  "system.ini boot display.drv  p9100_16.drv"
WIN_RES_P9_8   2  "system.ini boot sdisplay.drv sp91_16.drv"
WIN_RES_P9_8   3  "system.ini SP9100.DRV Font Large"
WIN_RES_P9_8   4  "system.ini P9100.DRV Resolution 1280x1024"
WIN_RES_P9_8   5  "system.ini P9100.DRV Refresh 60Hz"
WIN_RES_P9_8   6  "system.ini P9100.DRV Font Large"
WIN_RES_P9_8   7  "system.ini P9100.DRV Cursors 32"
WIN_RES_P9_8   8  "system.ini P9100.DRV MemClkInDecaKHz 4975"
WIN_RES_P9_8   9  "system.ini P9100.DRV BusType DETECT"
WIN_RES_P9_8  10  "system.ini P9100.DRV BoardType VesaHigh"
WIN_RES_P9_8  11  "system.ini P9100.DRV MemAddr C000"
WIN_RES_P9_8  12  "system.ini P9100.DRV wBase C0"
WIN_RES_P9_8  13  "system.ini P9100.DRV MemSize 4"
WIN_RES_P9_8  14  "system.ini P9100.DRV DacType DETECT"
WIN_RES_P9_8  15  "system.ini P9100.DRV CursorUpdate Off"
WIN_RES_P9_8  16  "system.ini P9100.DRV Cursor Power"
WIN_RES_P9_8  17  "system.ini P9100.DRV Speed 33.00mHz"
WIN_RES_P9_8  18  "system.ini P9100.DRV Monitor Generic"
WIN_RES_P9_8  19  "system.ini P9100.DRV DefMode 640x480x8"
WIN_RES_P9_8  20  "system.ini P9100.DRV CfgBA 9100"
WIN_RES_P9_8  21  "system.ini P9100.DRV OEMString WEITEK"
WIN_RES_P9_8  22  "system.ini P9100.DRV Version 1.0"
WIN_RES_P9_8  23  "system.ini P9100.DRV TmgFileName P9X00RES.INI"
WIN_RES_P9_8  24  "system.ini P9100.DRV ClockType DETECT"
WIN_RES_P9_8  25  "system.ini P9100.DRV IBM525PLL On"
WIN_RES_P9_8  26  "p9x00res.ini 1280x1024x16 link 1280x1024"
WIN_RES_P9_8  27  "p9x00res.ini 1280x1024 hdr 115mHz"
WIN_RES_P9_8  28  "p9x00res.ini 1280x1024 hsp 224"
WIN_RES_P9_8  29  "p9x00res.ini 1280x1024 hbp 256"
WIN_RES_P9_8  30  "p9x00res.ini 1280x1024 had 1280" 
WIN_RES_P9_8  31  "p9x00res.ini 1280x1024 hfp 32"
WIN_RES_P9_8  32  "p9x00res.ini 1280x1024 hco 0"
WIN_RES_P9_8  33  "p9x00res.ini 1280x1024 hp  negative"
WIN_RES_P9_8  34  "p9x00res.ini 1280x1024 vlr 60Hz"
WIN_RES_P9_8  35  "p9x00res.ini 1280x1024 vsp 3"
WIN_RES_P9_8  36  "p9x00res.ini 1280x1024 vbp 42"
WIN_RES_P9_8  37  "p9x00res.ini 1280x1024 vad 1024" 
WIN_RES_P9_8  38  "p9x00res.ini 1280x1024 vfp 1"
WIN_RES_P9_8  39  "p9x00res.ini 1280x1024 vco 0"
WIN_RES_P9_8  40  "p9x00res.ini 1280x1024 vp  negative"
WIN_RES_P9_8  41  "system.ini boot fonts.fon 8514sys.fon"

*
* Define modifications required for 1600x1200x16 60Hz.
*
WIN_RES_P9_9   1  "system.ini boot display.drv  p9100_16.drv"
WIN_RES_P9_9   2  "system.ini boot sdisplay.drv sp91_16.drv"
WIN_RES_P9_9   3  "system.ini SP9100.DRV Font Large"
WIN_RES_P9_9   4  "system.ini P9100.DRV Resolution 1600x1200"
WIN_RES_P9_9   5  "system.ini P9100.DRV Refresh 60Hz"
WIN_RES_P9_9   6  "system.ini P9100.DRV Font Large"
WIN_RES_P9_9   7  "system.ini P9100.DRV Cursors 32"
WIN_RES_P9_9   8  "system.ini P9100.DRV MemClkInDecaKHz 4975"
WIN_RES_P9_9   9  "system.ini P9100.DRV BusType DETECT"
WIN_RES_P9_9  10  "system.ini P9100.DRV BoardType VesaHigh"
WIN_RES_P9_9  11  "system.ini P9100.DRV MemAddr C000"
WIN_RES_P9_9  12  "system.ini P9100.DRV wBase C0"
WIN_RES_P9_9  13  "system.ini P9100.DRV MemSize 4"
WIN_RES_P9_9  14  "system.ini P9100.DRV DacType DETECT"
WIN_RES_P9_9  15  "system.ini P9100.DRV CursorUpdate Off"
WIN_RES_P9_9  16  "system.ini P9100.DRV Cursor Power"
WIN_RES_P9_9  17  "system.ini P9100.DRV Speed 33.00mHz"
WIN_RES_P9_9  18  "system.ini P9100.DRV Monitor Generic"
WIN_RES_P9_9  19  "system.ini P9100.DRV DefMode 640x480x8"
WIN_RES_P9_9  20  "system.ini P9100.DRV CfgBA 9100"
WIN_RES_P9_9  21  "system.ini P9100.DRV OEMString WEITEK"
WIN_RES_P9_9  22  "system.ini P9100.DRV Version 1.0"
WIN_RES_P9_9  23  "system.ini P9100.DRV TmgFileName P9X00RES.INI"
WIN_RES_P9_9  24  "system.ini P9100.DRV ClockType DETECT"
WIN_RES_P9_9  25  "system.ini P9100.DRV IBM525PLL On"
WIN_RES_P9_9  26  "p9x00res.ini 1600x1200x16 link 1600x1200"
WIN_RES_P9_9  27  "p9x00res.ini 1600x1200 hdr 160mHz"
WIN_RES_P9_9  28  "p9x00res.ini 1600x1200 hsp 224"
WIN_RES_P9_9  29  "p9x00res.ini 1600x1200 hbp 200"
WIN_RES_P9_9  30  "p9x00res.ini 1600x1200 had 1600" 
WIN_RES_P9_9  31  "p9x00res.ini 1600x1200 hfp 88"
WIN_RES_P9_9  32  "p9x00res.ini 1600x1200 hco 0" 
WIN_RES_P9_9  33  "p9x00res.ini 1600x1200 hp  negative"
WIN_RES_P9_9  34  "p9x00res.ini 1600x1200 vlr 60Hz"
WIN_RES_P9_9  35  "p9x00res.ini 1600x1200 vsp 3"
WIN_RES_P9_9  36  "p9x00res.ini 1600x1200 vbp 42"
WIN_RES_P9_9  37  "p9x00res.ini 1600x1200 vad 1200" 
WIN_RES_P9_9  38  "p9x00res.ini 1600x1200 vfp 1"
WIN_RES_P9_9  39  "p9x00res.ini 1600x1200 vco 0" 
WIN_RES_P9_9  40  "p9x00res.ini 1600x1200 vp  negative"
WIN_RES_P9_9  41  "system.ini boot fonts.fon 8514sys.fon"

*
* Define modifications required for 640x480x24 60Hz.
*
WIN_RES_P9_10  1  "system.ini boot display.drv  p9100_24.drv"
WIN_RES_P9_10  2  "system.ini boot sdisplay.drv sp91_24.drv"
WIN_RES_P9_10  3  "system.ini SP9100.DRV Font Small"
WIN_RES_P9_10  4  "system.ini P9100.DRV Resolution 640x480"
WIN_RES_P9_10  5  "system.ini P9100.DRV Refresh 60Hz"
WIN_RES_P9_10  6  "system.ini P9100.DRV Font Small"
WIN_RES_P9_10  7  "system.ini P9100.DRV Cursors 32"
WIN_RES_P9_10  8  "system.ini P9100.DRV MemClkInDecaKHz 4975"
WIN_RES_P9_10  9  "system.ini P9100.DRV BusType DETECT"
WIN_RES_P9_10 10  "system.ini P9100.DRV BoardType VesaHigh"
WIN_RES_P9_10 11  "system.ini P9100.DRV MemAddr C000"
WIN_RES_P9_10 12  "system.ini P9100.DRV wBase C0"
WIN_RES_P9_10 13  "system.ini P9100.DRV MemSize 4"
WIN_RES_P9_10 14  "system.ini P9100.DRV DacType DETECT"
WIN_RES_P9_10 15  "system.ini P9100.DRV CursorUpdate Off"
WIN_RES_P9_10 16  "system.ini P9100.DRV Cursor Power"
WIN_RES_P9_10 17  "system.ini P9100.DRV Speed 33.00mHz"
WIN_RES_P9_10 18  "system.ini P9100.DRV Monitor Generic"
WIN_RES_P9_10 19  "system.ini P9100.DRV DefMode 640x480x8"
WIN_RES_P9_10 20  "system.ini P9100.DRV CfgBA 9100"
WIN_RES_P9_10 21  "system.ini P9100.DRV OEMString WEITEK"
WIN_RES_P9_10 22  "system.ini P9100.DRV Version 1.0"
WIN_RES_P9_10 23  "system.ini P9100.DRV TmgFileName P9X00RES.INI"
WIN_RES_P9_10 24  "system.ini P9100.DRV ClockType DETECT"
WIN_RES_P9_10 25  "system.ini P9100.DRV IBM525PLL On"
WIN_RES_P9_10 26  "p9x00res.ini 640x480x24 link 640x480"
WIN_RES_P9_10 27  "p9x00res.ini 640x480 hdr 25.17mHz"
WIN_RES_P9_10 28  "p9x00res.ini 640x480 hsp 96"
WIN_RES_P9_10 29  "p9x00res.ini 640x480 hbp 48"
WIN_RES_P9_10 30  "p9x00res.ini 640x480 had 640"
WIN_RES_P9_10 31  "p9x00res.ini 640x480 hfp 16"
WIN_RES_P9_10 32  "p9x00res.ini 640x480 hco 0"
WIN_RES_P9_10 33  "p9x00res.ini 640x480 hp  negative"
WIN_RES_P9_10 34  "p9x00res.ini 640x480 vlr 60Hz"
WIN_RES_P9_10 35  "p9x00res.ini 640x480 vsp 2"
WIN_RES_P9_10 36  "p9x00res.ini 640x480 vbp 33"
WIN_RES_P9_10 37  "p9x00res.ini 640x480 vad 480"
WIN_RES_P9_10 38  "p9x00res.ini 640x480 vfp 10"
WIN_RES_P9_10 39  "p9x00res.ini 640x480 vco 0"
WIN_RES_P9_10 40  "p9x00res.ini 640x480 vp  negative"
WIN_RES_P9_10 41  "system.ini boot fonts.fon vgasys.fon"
                 
*
* Define modifications required for 800x600x24 60Hz.
*
WIN_RES_P9_11  1  "system.ini boot display.drv  p9100_24.drv"
WIN_RES_P9_11  2  "system.ini boot sdisplay.drv sp91_24.drv"
WIN_RES_P9_11  3  "system.ini SP9100.DRV Font Small"
WIN_RES_P9_11  4  "system.ini P9100.DRV Resolution 800x600"
WIN_RES_P9_11  5  "system.ini P9100.DRV Refresh 60Hz"
WIN_RES_P9_11  6  "system.ini P9100.DRV Font Small"
WIN_RES_P9_11  7  "system.ini P9100.DRV Cursors 32"
WIN_RES_P9_11  8  "system.ini P9100.DRV MemClkInDecaKHz 4975"
WIN_RES_P9_11  9  "system.ini P9100.DRV BusType DETECT"
WIN_RES_P9_11 10  "system.ini P9100.DRV BoardType VesaHigh"
WIN_RES_P9_11 11  "system.ini P9100.DRV MemAddr C000"
WIN_RES_P9_11 12  "system.ini P9100.DRV wBase C0"
WIN_RES_P9_11 13  "system.ini P9100.DRV MemSize 4"
WIN_RES_P9_11 14  "system.ini P9100.DRV DacType DETECT"
WIN_RES_P9_11 15  "system.ini P9100.DRV CursorUpdate Off"
WIN_RES_P9_11 16  "system.ini P9100.DRV Cursor Power"
WIN_RES_P9_11 17  "system.ini P9100.DRV Speed 33.00mHz"
WIN_RES_P9_11 18  "system.ini P9100.DRV Monitor Generic"
WIN_RES_P9_11 19  "system.ini P9100.DRV DefMode 640x480x8"
WIN_RES_P9_11 20  "system.ini P9100.DRV CfgBA 9100"
WIN_RES_P9_11 21  "system.ini P9100.DRV OEMString WEITEK"
WIN_RES_P9_11 22  "system.ini P9100.DRV Version 1.0"
WIN_RES_P9_11 23  "system.ini P9100.DRV TmgFileName P9X00RES.INI"
WIN_RES_P9_11 24  "system.ini P9100.DRV ClockType DETECT"
WIN_RES_P9_11 25  "system.ini P9100.DRV IBM525PLL On"
WIN_RES_P9_11 26  "p9x00res.ini 800x600x24 link 800x600"
WIN_RES_P9_11 27  "p9x00res.ini 800x600 hdr 40mHz"
WIN_RES_P9_11 28  "p9x00res.ini 800x600 hsp 128"
WIN_RES_P9_11 29  "p9x00res.ini 800x600 hbp 88"
WIN_RES_P9_11 30  "p9x00res.ini 800x600 had 800"  
WIN_RES_P9_11 31  "p9x00res.ini 800x600 hfp 40"
WIN_RES_P9_11 32  "p9x00res.ini 800x600 hco 0"
WIN_RES_P9_11 33  "p9x00res.ini 800x600 hp  negative"
WIN_RES_P9_11 34  "p9x00res.ini 800x600 vlr 60Hz"
WIN_RES_P9_11 35  "p9x00res.ini 800x600 vsp 4"
WIN_RES_P9_11 36  "p9x00res.ini 800x600 vbp 23"
WIN_RES_P9_11 37  "p9x00res.ini 800x600 vad 600" 
WIN_RES_P9_11 38  "p9x00res.ini 800x600 vfp 1"
WIN_RES_P9_11 39  "p9x00res.ini 800x600 vco 0"
WIN_RES_P9_11 40  "p9x00res.ini 800x600 vp  negative"
WIN_RES_P9_11 41  "system.ini boot fonts.fon vgasys.fon"

*
* Define modifications required for 1024x768x24 60Hz.
*
WIN_RES_P9_12  1  "system.ini boot display.drv  p9100_24.drv"
WIN_RES_P9_12  2  "system.ini boot sdisplay.drv sp91_24.drv"
WIN_RES_P9_12  3  "system.ini SP9100.DRV Font Large"
WIN_RES_P9_12  4  "system.ini P9100.DRV Resolution 1024x768"
WIN_RES_P9_12  5  "system.ini P9100.DRV Refresh 60Hz"
WIN_RES_P9_12  6  "system.ini P9100.DRV Font Large"
WIN_RES_P9_12  7  "system.ini P9100.DRV Cursors 32"
WIN_RES_P9_12  8  "system.ini P9100.DRV MemClkInDecaKHz 4975"
WIN_RES_P9_12  9  "system.ini P9100.DRV BusType DETECT"
WIN_RES_P9_12 10  "system.ini P9100.DRV BoardType VesaHigh"
WIN_RES_P9_12 11  "system.ini P9100.DRV MemAddr C000"
WIN_RES_P9_12 12  "system.ini P9100.DRV wBase C0"
WIN_RES_P9_12 13  "system.ini P9100.DRV MemSize 4"
WIN_RES_P9_12 14  "system.ini P9100.DRV DacType DETECT"
WIN_RES_P9_12 15  "system.ini P9100.DRV CursorUpdate Off"
WIN_RES_P9_12 16  "system.ini P9100.DRV Cursor Power"
WIN_RES_P9_12 17  "system.ini P9100.DRV Speed 33.00mHz"
WIN_RES_P9_12 18  "system.ini P9100.DRV Monitor Generic"
WIN_RES_P9_12 19  "system.ini P9100.DRV DefMode 640x480x8"
WIN_RES_P9_12 20  "system.ini P9100.DRV CfgBA 9100"
WIN_RES_P9_12 21  "system.ini P9100.DRV OEMString WEITEK"
WIN_RES_P9_12 22  "system.ini P9100.DRV Version 1.0"
WIN_RES_P9_12 23  "system.ini P9100.DRV TmgFileName P9X00RES.INI"
WIN_RES_P9_12 24  "system.ini P9100.DRV ClockType DETECT"
WIN_RES_P9_12 25  "system.ini P9100.DRV IBM525PLL On"
WIN_RES_P9_12 26  "p9x00res.ini 1024x768x24 link 1024x768"
WIN_RES_P9_12 27  "p9x00res.ini 1024x768 hdr 65mHz"
WIN_RES_P9_12 28  "p9x00res.ini 1024x768 hsp 136"
WIN_RES_P9_12 29  "p9x00res.ini 1024x768 hbp 160"
WIN_RES_P9_12 30  "p9x00res.ini 1024x768 had 1024" 
WIN_RES_P9_12 31  "p9x00res.ini 1024x768 hfp 24"
WIN_RES_P9_12 32  "p9x00res.ini 1024x768 hco 0"
WIN_RES_P9_12 33  "p9x00res.ini 1024x768 hp  negative"
WIN_RES_P9_12 34  "p9x00res.ini 1024x768 vlr 60Hz"
WIN_RES_P9_12 35  "p9x00res.ini 1024x768 vsp 6"
WIN_RES_P9_12 36  "p9x00res.ini 1024x768 vbp 29"
WIN_RES_P9_12 37  "p9x00res.ini 1024x768 vad 768" 
WIN_RES_P9_12 38  "p9x00res.ini 1024x768 vfp 3"
WIN_RES_P9_12 39  "p9x00res.ini 1024x768 vco 0" 
WIN_RES_P9_12 40  "p9x00res.ini 1024x768 vp  negative"
WIN_RES_P9_12 41  "system.ini boot fonts.fon 8514sys.fon"

*
* Define modifications required for 1280x1024x24 60Hz.
*
WIN_RES_P9_13  1  "system.ini boot display.drv  p9100_24.drv"
WIN_RES_P9_13  2  "system.ini boot sdisplay.drv sp91_24.drv"
WIN_RES_P9_13  3  "system.ini SP9100.DRV Font Large"
WIN_RES_P9_13  4  "system.ini P9100.DRV Resolution 1280x1024"
WIN_RES_P9_13  5  "system.ini P9100.DRV Refresh 60Hz"
WIN_RES_P9_13  6  "system.ini P9100.DRV Font Large"
WIN_RES_P9_13  7  "system.ini P9100.DRV Cursors 32"
WIN_RES_P9_13  8  "system.ini P9100.DRV MemClkInDecaKHz 4975"
WIN_RES_P9_13  9  "system.ini P9100.DRV BusType DETECT"
WIN_RES_P9_13 10  "system.ini P9100.DRV BoardType VesaHigh"
WIN_RES_P9_13 11  "system.ini P9100.DRV MemAddr C000"
WIN_RES_P9_13 12  "system.ini P9100.DRV wBase C0"
WIN_RES_P9_13 13  "system.ini P9100.DRV MemSize 4"
WIN_RES_P9_13 14  "system.ini P9100.DRV DacType DETECT"
WIN_RES_P9_13 15  "system.ini P9100.DRV CursorUpdate Off"
WIN_RES_P9_13 16  "system.ini P9100.DRV Cursor Power"
WIN_RES_P9_13 17  "system.ini P9100.DRV Speed 33.00mHz"
WIN_RES_P9_13 18  "system.ini P9100.DRV Monitor Generic"
WIN_RES_P9_13 19  "system.ini P9100.DRV DefMode 640x480x8"
WIN_RES_P9_13 20  "system.ini P9100.DRV CfgBA 9100"
WIN_RES_P9_13 21  "system.ini P9100.DRV OEMString WEITEK"
WIN_RES_P9_13 22  "system.ini P9100.DRV Version 1.0"
WIN_RES_P9_13 23  "system.ini P9100.DRV TmgFileName P9X00RES.INI"
WIN_RES_P9_13 24  "system.ini P9100.DRV ClockType DETECT"
WIN_RES_P9_13 25  "system.ini P9100.DRV IBM525PLL On"
WIN_RES_P9_13 26  "p9x00res.ini 1280x1024x24 link 1280x1024"
WIN_RES_P9_13 27  "p9x00res.ini 1280x1024 hdr 115mHz"
WIN_RES_P9_13 28  "p9x00res.ini 1280x1024 hsp 224"
WIN_RES_P9_13 29  "p9x00res.ini 1280x1024 hbp 256"
WIN_RES_P9_13 30  "p9x00res.ini 1280x1024 had 1280" 
WIN_RES_P9_13 31  "p9x00res.ini 1280x1024 hfp 32"
WIN_RES_P9_13 32  "p9x00res.ini 1280x1024 hco 0"
WIN_RES_P9_13 33  "p9x00res.ini 1280x1024 hp  negative"
WIN_RES_P9_13 34  "p9x00res.ini 1280x1024 vlr 60Hz"
WIN_RES_P9_13 35  "p9x00res.ini 1280x1024 vsp 3"
WIN_RES_P9_13 36  "p9x00res.ini 1280x1024 vbp 42"
WIN_RES_P9_13 37  "p9x00res.ini 1280x1024 vad 1024" 
WIN_RES_P9_13 38  "p9x00res.ini 1280x1024 vfp 1"
WIN_RES_P9_13 39  "p9x00res.ini 1280x1024 vco 0"
WIN_RES_P9_13 40  "p9x00res.ini 1280x1024 vp  negative"
WIN_RES_P9_13 41  "system.ini boot fonts.fon 8514sys.fon"

*
* Define modifications required for 640x480x32 60Hz.
*
WIN_RES_P9_14  1  "system.ini boot display.drv  p9100_32.drv"
WIN_RES_P9_14  2  "system.ini boot sdisplay.drv sp91_32.drv"
WIN_RES_P9_14  3  "system.ini SP9100.DRV Font Small"
WIN_RES_P9_14  4  "system.ini P9100.DRV Resolution 640x480"
WIN_RES_P9_14  5  "system.ini P9100.DRV Refresh 60Hz"
WIN_RES_P9_14  6  "system.ini P9100.DRV Font Small"
WIN_RES_P9_14  7  "system.ini P9100.DRV Cursors 32"
WIN_RES_P9_14  8  "system.ini P9100.DRV MemClkInDecaKHz 4975"
WIN_RES_P9_14  9  "system.ini P9100.DRV BusType DETECT"
WIN_RES_P9_14 10  "system.ini P9100.DRV BoardType VesaHigh"
WIN_RES_P9_14 11  "system.ini P9100.DRV MemAddr C000"
WIN_RES_P9_14 12  "system.ini P9100.DRV wBase C0"
WIN_RES_P9_14 13  "system.ini P9100.DRV MemSize 4"
WIN_RES_P9_14 14  "system.ini P9100.DRV DacType DETECT"
WIN_RES_P9_14 15  "system.ini P9100.DRV CursorUpdate Off"
WIN_RES_P9_14 16  "system.ini P9100.DRV Cursor Power"
WIN_RES_P9_14 17  "system.ini P9100.DRV Speed 33.00mHz"
WIN_RES_P9_14 18  "system.ini P9100.DRV Monitor Generic"
WIN_RES_P9_14 19  "system.ini P9100.DRV DefMode 640x480x8"
WIN_RES_P9_14 20  "system.ini P9100.DRV CfgBA 9100"
WIN_RES_P9_14 21  "system.ini P9100.DRV OEMString WEITEK"
WIN_RES_P9_14 22  "system.ini P9100.DRV Version 1.0"
WIN_RES_P9_14 23  "system.ini P9100.DRV TmgFileName P9X00RES.INI"
WIN_RES_P9_14 24  "system.ini P9100.DRV ClockType DETECT"
WIN_RES_P9_14 25  "system.ini P9100.DRV IBM525PLL On"
WIN_RES_P9_14 26  "p9x00res.ini 640x480x32 link 640x480"
WIN_RES_P9_14 27  "p9x00res.ini 640x480 hdr 25.17mHz"
WIN_RES_P9_14 28  "p9x00res.ini 640x480 hsp 96"
WIN_RES_P9_14 29  "p9x00res.ini 640x480 hbp 48"
WIN_RES_P9_14 30  "p9x00res.ini 640x480 had 640"
WIN_RES_P9_14 31  "p9x00res.ini 640x480 hfp 16"
WIN_RES_P9_14 32  "p9x00res.ini 640x480 hco 0"
WIN_RES_P9_14 33  "p9x00res.ini 640x480 hp  negative"
WIN_RES_P9_14 34  "p9x00res.ini 640x480 vlr 60Hz"
WIN_RES_P9_14 35  "p9x00res.ini 640x480 vsp 2"
WIN_RES_P9_14 36  "p9x00res.ini 640x480 vbp 33"
WIN_RES_P9_14 37  "p9x00res.ini 640x480 vad 480"
WIN_RES_P9_14 38  "p9x00res.ini 640x480 vfp 10"
WIN_RES_P9_14 39  "p9x00res.ini 640x480 vco 0"
WIN_RES_P9_14 40  "p9x00res.ini 640x480 vp  negative"
WIN_RES_P9_14 41  "system.ini boot fonts.fon vgasys.fon"
                 
*
* Define modifications required for 800x600x32 60Hz.
*
WIN_RES_P9_15  1  "system.ini boot display.drv  p9100_32.drv"
WIN_RES_P9_15  2  "system.ini boot sdisplay.drv sp91_32.drv"
WIN_RES_P9_15  3  "system.ini SP9100.DRV Font Small"
WIN_RES_P9_15  4  "system.ini P9100.DRV Resolution 800x600"
WIN_RES_P9_15  5  "system.ini P9100.DRV Refresh 60Hz"
WIN_RES_P9_15  6  "system.ini P9100.DRV Font Small"
WIN_RES_P9_15  7  "system.ini P9100.DRV Cursors 32"
WIN_RES_P9_15  8  "system.ini P9100.DRV MemClkInDecaKHz 4975"
WIN_RES_P9_15  9  "system.ini P9100.DRV BusType DETECT"
WIN_RES_P9_15 10  "system.ini P9100.DRV BoardType VesaHigh"
WIN_RES_P9_15 11  "system.ini P9100.DRV MemAddr C000"
WIN_RES_P9_15 12  "system.ini P9100.DRV wBase C0"
WIN_RES_P9_15 13  "system.ini P9100.DRV MemSize 4"
WIN_RES_P9_15 14  "system.ini P9100.DRV DacType DETECT"
WIN_RES_P9_15 15  "system.ini P9100.DRV CursorUpdate Off"
WIN_RES_P9_15 16  "system.ini P9100.DRV Cursor Power"
WIN_RES_P9_15 17  "system.ini P9100.DRV Speed 33.00mHz"
WIN_RES_P9_15 18  "system.ini P9100.DRV Monitor Generic"
WIN_RES_P9_15 19  "system.ini P9100.DRV DefMode 640x480x8"
WIN_RES_P9_15 20  "system.ini P9100.DRV CfgBA 9100"
WIN_RES_P9_15 21  "system.ini P9100.DRV OEMString WEITEK"
WIN_RES_P9_15 22  "system.ini P9100.DRV Version 1.0"
WIN_RES_P9_15 23  "system.ini P9100.DRV TmgFileName P9X00RES.INI"
WIN_RES_P9_15 24  "system.ini P9100.DRV ClockType DETECT"
WIN_RES_P9_15 25  "system.ini P9100.DRV IBM525PLL On"
WIN_RES_P9_15 26  "p9x00res.ini 800x600x32 link 800x600"
WIN_RES_P9_15 27  "p9x00res.ini 800x600 hdr 40mHz"
WIN_RES_P9_15 28  "p9x00res.ini 800x600 hsp 128"
WIN_RES_P9_15 29  "p9x00res.ini 800x600 hbp 88"
WIN_RES_P9_15 30  "p9x00res.ini 800x600 had 800"  
WIN_RES_P9_15 31  "p9x00res.ini 800x600 hfp 40"
WIN_RES_P9_15 32  "p9x00res.ini 800x600 hco 0"
WIN_RES_P9_15 33  "p9x00res.ini 800x600 hp  negative"
WIN_RES_P9_15 34  "p9x00res.ini 800x600 vlr 60Hz"
WIN_RES_P9_15 35  "p9x00res.ini 800x600 vsp 4"
WIN_RES_P9_15 36  "p9x00res.ini 800x600 vbp 23"
WIN_RES_P9_15 37  "p9x00res.ini 800x600 vad 600" 
WIN_RES_P9_15 38  "p9x00res.ini 800x600 vfp 1"
WIN_RES_P9_15 39  "p9x00res.ini 800x600 vco 0"
WIN_RES_P9_15 40  "p9x00res.ini 800x600 vp  negative"
WIN_RES_P9_15 41  "system.ini boot fonts.fon vgasys.fon"

*
* Define modifications required for 1024x768x32 60Hz.
*
WIN_RES_P9_16  1  "system.ini boot display.drv  p9100_32.drv"
WIN_RES_P9_16  2  "system.ini boot sdisplay.drv sp91_32.drv"
WIN_RES_P9_16  3  "system.ini SP9100.DRV Font Large"
WIN_RES_P9_16  4  "system.ini P9100.DRV Resolution 1024x768"
WIN_RES_P9_16  5  "system.ini P9100.DRV Refresh 60Hz"
WIN_RES_P9_16  6  "system.ini P9100.DRV Font Large"
WIN_RES_P9_16  7  "system.ini P9100.DRV Cursors 32"
WIN_RES_P9_16  8  "system.ini P9100.DRV MemClkInDecaKHz 4975"
WIN_RES_P9_16  9  "system.ini P9100.DRV BusType DETECT"
WIN_RES_P9_16 10  "system.ini P9100.DRV BoardType VesaHigh"
WIN_RES_P9_16 11  "system.ini P9100.DRV MemAddr C000"
WIN_RES_P9_16 12  "system.ini P9100.DRV wBase C0"
WIN_RES_P9_16 13  "system.ini P9100.DRV MemSize 4"
WIN_RES_P9_16 14  "system.ini P9100.DRV DacType DETECT"
WIN_RES_P9_16 15  "system.ini P9100.DRV CursorUpdate Off"
WIN_RES_P9_16 16  "system.ini P9100.DRV Cursor Power"
WIN_RES_P9_16 17  "system.ini P9100.DRV Speed 33.00mHz"
WIN_RES_P9_16 18  "system.ini P9100.DRV Monitor Generic"
WIN_RES_P9_16 19  "system.ini P9100.DRV DefMode 640x480x8"
WIN_RES_P9_16 20  "system.ini P9100.DRV CfgBA 9100"
WIN_RES_P9_16 21  "system.ini P9100.DRV OEMString WEITEK"
WIN_RES_P9_16 22  "system.ini P9100.DRV Version 1.0"
WIN_RES_P9_16 23  "system.ini P9100.DRV TmgFileName P9X00RES.INI"
WIN_RES_P9_16 24  "system.ini P9100.DRV ClockType DETECT"
WIN_RES_P9_16 25  "system.ini P9100.DRV IBM525PLL On"
WIN_RES_P9_16 26  "p9x00res.ini 1024x768x32 link 1024x768"
WIN_RES_P9_16 27  "p9x00res.ini 1024x768 hdr 65mHz"
WIN_RES_P9_16 28  "p9x00res.ini 1024x768 hsp 136"
WIN_RES_P9_16 29  "p9x00res.ini 1024x768 hbp 160"
WIN_RES_P9_16 30  "p9x00res.ini 1024x768 had 1024" 
WIN_RES_P9_16 31  "p9x00res.ini 1024x768 hfp 24"
WIN_RES_P9_16 32  "p9x00res.ini 1024x768 hco 0"
WIN_RES_P9_16 33  "p9x00res.ini 1024x768 hp  negative"
WIN_RES_P9_16 34  "p9x00res.ini 1024x768 vlr 60Hz"
WIN_RES_P9_16 35  "p9x00res.ini 1024x768 vsp 6"
WIN_RES_P9_16 36  "p9x00res.ini 1024x768 vbp 29"
WIN_RES_P9_16 37  "p9x00res.ini 1024x768 vad 768" 
WIN_RES_P9_16 38  "p9x00res.ini 1024x768 vfp 3"
WIN_RES_P9_16 39  "p9x00res.ini 1024x768 vco 0" 
WIN_RES_P9_16 40  "p9x00res.ini 1024x768 vp  negative"
WIN_RES_P9_16 41  "system.ini boot fonts.fon 8514sys.fon"

* echo command to logfile in case cmd doesn't exist (error msg said bad path)
:RUN :MODE=PRIMARY :MODE=WINDOWS
CMD.EXE /C ECHO %BOOTDRIVE%:\OS2\INSTALL\TST4WOW.CMD %BOOTDRIVE%: %BOOTDRIVE%:\OS2\INSTALL\P91FU.DSA %BOOTDRIVE%:\OS2\INSTALL\P91WO.DSA 2>> %BOOTDRIVE%:\OS2\INSTALL\DSPINSTL.LOG 1>&2
CMD.EXE /C      %BOOTDRIVE%:\OS2\INSTALL\TST4WOW.CMD %BOOTDRIVE%: %BOOTDRIVE%:\OS2\INSTALL\P91FU.DSA %BOOTDRIVE%:\OS2\INSTALL\P91WO.DSA 2>> %BOOTDRIVE%:\OS2\INSTALL\DSPINSTL.LOG

*End of file*
