/*
 * Decompiled with CFR 0.152.
 */
package com.os2.comm;

import com.os2.comm.OS2SerialInputStream;
import com.os2.comm.OS2SerialNative;
import com.os2.comm.OS2SerialOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;

class OS2SerialPort
extends SerialPort
implements Runnable {
    private OS2SerialNative sn;
    private String portname;
    private int baudrate = 9600;
    private int databits = 8;
    private int stopbits = 1;
    private int parity = 0;
    private final int SP_DTR = 1;
    private final int SP_CTS = 16;
    private final int SP_DSR = 32;
    private final int SP_CD = 128;
    private final int SP_RI = 64;
    private final int SP_RTS = 2;
    private final int NM_DATAVAILABLE = 1;
    private final int NM_OUTPUTEMPTY = 4;
    private final int NM_CTSCHANGED = 8;
    private final int NM_DSRCHANGED = 16;
    private final int NM_RICHANGED = 256;
    private final int NM_CDCHANGED = 32;
    private final int NM_OVERRUNERROR = 4096;
    private final int NM_PARITYERROR = 16384;
    private final int NM_FRAMINGERROR = 32768;
    private final int NM_BREAKINTR = 64;
    private final int NS_CTS = 0x100000;
    private final int NS_DSR = 0x200000;
    private final int NS_RI = 0x400000;
    private final int NS_CD = 0x800000;
    private int flowmode = 0;
    private int rcvtimeout;
    private int rcvthreshold;
    private int notifymask;
    private int notifystate;
    private int lastnotifystate;
    private SerialPortEventListener SPEventListener;
    private Thread monThread;
    private InputStream inputstream;
    private OutputStream outputstream;

    public OS2SerialPort(String string) throws IOException {
        this.portname = string;
        this.sn = new OS2SerialNative();
        this.sn.fd = this.sn.spopen(string);
        if (this.sn.fd < 0) {
            throw new IOException("Could not Open Port " + string);
        }
        this.setDTR(true);
    }

    public String getName() {
        return this.portname;
    }

    public OutputStream getOutputStream() throws IOException {
        OS2SerialPort oS2SerialPort = this;
        synchronized (oS2SerialPort) {
            if (this.outputstream == null) {
                this.outputstream = new OS2SerialOutputStream(this.sn);
            }
        }
        return this.outputstream;
    }

    public InputStream getInputStream() throws IOException {
        OS2SerialPort oS2SerialPort = this;
        synchronized (oS2SerialPort) {
            if (this.inputstream == null) {
                this.inputstream = new OS2SerialInputStream(this.sn);
            }
        }
        return this.inputstream;
    }

    public void setSerialPortParams(int n, int n2, int n3, int n4) throws UnsupportedCommOperationException {
        int n5;
        int n6;
        int n7;
        switch (n2) {
            case 5: {
                n7 = 5;
                break;
            }
            case 6: {
                n7 = 6;
                break;
            }
            case 7: {
                n7 = 7;
                break;
            }
            case 8: {
                n7 = 8;
                break;
            }
            default: {
                throw new UnsupportedCommOperationException("Unsupported Data Bits");
            }
        }
        switch (n3) {
            case 1: {
                n6 = 0;
                break;
            }
            case 3: {
                n6 = 1;
                break;
            }
            case 2: {
                n6 = 2;
                break;
            }
            default: {
                throw new UnsupportedCommOperationException("Unsupported Stop Bits");
            }
        }
        switch (n4) {
            case 0: {
                n5 = 0;
                break;
            }
            case 1: {
                n5 = 1;
                break;
            }
            case 2: {
                n5 = 2;
                break;
            }
            case 3: {
                n5 = 3;
                break;
            }
            case 4: {
                n5 = 4;
                break;
            }
            default: {
                throw new UnsupportedCommOperationException("Unsupported Parity");
            }
        }
        if (this.sn.spsetSerialPortParams(n, n7, n6, n5) != 0) {
            throw new UnsupportedCommOperationException();
        }
        this.baudrate = n;
        this.databits = n2;
        this.stopbits = n3;
        this.parity = n4;
    }

    public int getBaudRate() {
        return this.baudrate;
    }

    public int getDataBits() {
        return this.databits;
    }

    public int getStopBits() {
        return this.stopbits;
    }

    public int getParity() {
        return this.parity;
    }

    public void setFlowControlMode(int n) throws UnsupportedCommOperationException {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        if ((n & 2) != 0) {
            n2 |= 2;
        }
        if ((n & 4) != 0) {
            n2 |= 4;
        }
        if ((n & 8) != 0) {
            n2 |= 8;
        }
        this.sn.spsetFlowMode(n2);
        this.flowmode = n;
    }

    public int getFlowControlMode() {
        return this.flowmode;
    }

    public void enableReceiveFraming(int n) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException("Not supported");
    }

    public void disableReceiveFraming() {
    }

    public boolean isReceiveFramingEnabled() {
        return false;
    }

    public int getReceiveFramingByte() {
        return 0;
    }

    public void enableReceiveTimeout(int n) throws UnsupportedCommOperationException {
        if (n > 300000) {
            n = 300000;
        }
        this.sn.spsetReceiveTimeout(n);
        this.rcvtimeout = n;
    }

    public void disableReceiveTimeout() {
        this.sn.spsetReceiveTimeout(0);
        this.rcvtimeout = 0;
    }

    public boolean isReceiveTimeoutEnabled() {
        return this.rcvtimeout > 0;
    }

    public int getReceiveTimeout() {
        return this.rcvtimeout;
    }

    public void enableReceiveThreshold(int n) throws UnsupportedCommOperationException {
        this.sn.spsetReceiveThreshold(n);
        this.sn.readthreshold = n;
        this.rcvthreshold = n;
    }

    public void disableReceiveThreshold() {
        this.sn.spsetReceiveThreshold(0);
        this.sn.readthreshold = 50000000;
        this.rcvthreshold = 0;
    }

    public boolean isReceiveThresholdEnabled() {
        return this.rcvthreshold > 0;
    }

    public int getReceiveThreshold() {
        return this.rcvthreshold;
    }

    public void setInputBufferSize(int n) {
    }

    public int getInputBufferSize() {
        return 1024;
    }

    public void setOutputBufferSize(int n) {
    }

    public int getOutputBufferSize() {
        return 1024;
    }

    public boolean isDTR() {
        return (this.sn.spgetState() & 1) != 0;
    }

    public boolean isCTS() {
        return (this.sn.spgetState() & 0x10) != 0;
    }

    public boolean isDSR() {
        return (this.sn.spgetState() & 0x20) != 0;
    }

    public boolean isCD() {
        return (this.sn.spgetState() & 0x80) != 0;
    }

    public boolean isRI() {
        return (this.sn.spgetState() & 0x40) != 0;
    }

    public boolean isRTS() {
        return (this.sn.spgetState() & 2) != 0;
    }

    public void setDTR(boolean bl) {
        this.sn.spsetDTR(bl);
    }

    public void setRTS(boolean bl) {
        this.sn.spsetRTS(bl);
    }

    public void sendBreak(int n) {
        this.sn.spsendBreak(n);
    }

    public void close() {
        OS2SerialPort oS2SerialPort = this;
        synchronized (oS2SerialPort) {
            this.SPEventListener = null;
            if (this.monThread != null) {
                this.monThread.interrupt();
                this.monThread = null;
            }
            this.notifymask = 0;
        }
        this.setDTR(false);
        this.sn.spclose();
        super.close();
        this.inputstream = null;
        this.outputstream = null;
    }

    protected void finalize() {
        this.close();
    }

    private synchronized void setNotifyMask(int n, boolean bl) {
        if (bl) {
            this.notifymask |= n;
            return;
        }
        this.notifymask &= ~n;
    }

    private void eventNotify(int n, int n2) {
        if ((n & this.notifystate) != 0) {
            SerialPortEventListener serialPortEventListener;
            int n3;
            OS2SerialPort oS2SerialPort = this;
            synchronized (oS2SerialPort) {
                n3 = this.notifymask;
                serialPortEventListener = this.SPEventListener;
            }
            if ((n & n3) != 0) {
                serialPortEventListener.serialEvent(new SerialPortEvent((SerialPort)this, n2, false, true));
            }
        }
    }

    private void eventNotify(int n, int n2, int n3) {
        if ((n & this.notifystate) != 0) {
            SerialPortEventListener serialPortEventListener;
            int n4;
            OS2SerialPort oS2SerialPort = this;
            synchronized (oS2SerialPort) {
                n4 = this.notifymask;
                serialPortEventListener = this.SPEventListener;
            }
            if ((n & n4) != 0) {
                boolean bl = (this.lastnotifystate & n3) != 0;
                boolean bl2 = (this.notifystate & n3) != 0;
                serialPortEventListener.serialEvent(new SerialPortEvent((SerialPort)this, n2, bl, bl2));
            }
        }
    }

    private void eventLoop() {
        this.lastnotifystate = this.sn.spgetNotifyState();
        while (true) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            this.notifystate = this.sn.spgetNotifyState();
            this.eventNotify(1, 1);
            this.eventNotify(4, 2);
            this.eventNotify(8, 3, 0x100000);
            this.eventNotify(16, 4, 0x200000);
            this.eventNotify(256, 5);
            this.eventNotify(32, 6, 0x800000);
            this.eventNotify(4096, 7);
            this.eventNotify(16384, 8);
            this.eventNotify(32768, 9);
            this.eventNotify(64, 10);
            this.lastnotifystate = this.notifystate;
        }
    }

    public void run() {
        this.eventLoop();
    }

    public void addEventListener(SerialPortEventListener serialPortEventListener) throws TooManyListenersException {
        if (this.SPEventListener != null) {
            throw new TooManyListenersException();
        }
        this.SPEventListener = serialPortEventListener;
        this.monThread = new Thread(this);
        this.monThread.start();
    }

    public void removeEventListener() {
        OS2SerialPort oS2SerialPort = this;
        synchronized (oS2SerialPort) {
            this.SPEventListener = null;
            if (this.monThread != null) {
                this.monThread.interrupt();
                this.monThread = null;
            }
            this.notifymask = 0;
            return;
        }
    }

    public void notifyOnDataAvailable(boolean bl) {
        this.setNotifyMask(1, bl);
    }

    public void notifyOnOutputEmpty(boolean bl) {
        this.setNotifyMask(4, bl);
    }

    public void notifyOnCTS(boolean bl) {
        this.setNotifyMask(8, bl);
    }

    public void notifyOnDSR(boolean bl) {
        this.setNotifyMask(16, bl);
    }

    public void notifyOnRingIndicator(boolean bl) {
        this.setNotifyMask(256, bl);
    }

    public void notifyOnCarrierDetect(boolean bl) {
        this.setNotifyMask(32, bl);
    }

    public void notifyOnOverrunError(boolean bl) {
        this.setNotifyMask(4096, bl);
    }

    public void notifyOnParityError(boolean bl) {
        this.setNotifyMask(16384, bl);
    }

    public void notifyOnFramingError(boolean bl) {
        this.setNotifyMask(32768, bl);
    }

    public void notifyOnBreakInterrupt(boolean bl) {
        this.setNotifyMask(64, bl);
    }

    static {
        System.loadLibrary("os2serpt");
    }
}

