/**********************************************************/
/***        Install BASECSD files                       ***/
/***  Files pakced with PKZIP -r -P options             ***/
/***  Files self extract with -o -d options             ***/
/***                                                    ***/
/**********************************************************/

/* Check where to install (from SET ETC statement) */
ENV = 'OS2ENVIRONMENT'
ETC = VALUE('ETC',,ENV)
if ETC = '' then
    do
    say ""
    say "WARNING!"
    say "You do NOT have the environment variable ETC defined!"
    say "You should have already installed the OS/2 TCP/IP 1.2.1 refresh"
    say "CSD installation will not continue."
    say ""
    exit 1
    end

/*  User CNTRL.EXE instructions  */
 say " This CSD cannot replace executables or DLL's that are in use."
 say " Be sure to stop all active TCP/IP services before installing this CSD."
 say " "
 say " CNTRL.EXE was updated in this CSD upgrade.  This will require  "
 say " you to REM out the RUN=C:\TCPIP\BIN\CNTRL.EXE line in your     "
 say " CONFIG.SYS and reboot before installing this CSD.  After"
 say " installing this CSD be sure to remove the REM from the"
 say " RUN=C:\TCPIP\BIN\CNTRL.EXE and reboot again."
 say " "
 say " If you have not already added the REM to your CONFIG.SYS, press"
 say " CNTRL-C to abort this CMD file.  Otherwise press any other key to"
 say " continue."
 '@echo off'
 pause
 echo on

/*************************************************/
/*  Find directory where INSTALL.CMD is located  */
/*************************************************/
cmdloc = getinstalldir()

/*************************/
/*  Find BASE directory  */
/*************************/
BASE=filespec("drive",ETC)||filespec("path",ETC)
if substr(BASE, length(BASE), 1) = '\' then
    BASE = substr(BASE, 1, length(BASE) - 1)




/***********************************/
/* Unpack disk to proper directory */
/***********************************/
'@echo off'
attrib BASE'\syslevel.bem -r'
'@echo on'
cmdloc'BASECSD1.EXE -o -d ' BASE'\'

 say " "
 say " Please insert disk 2 of 2"
 '@echo off'
 pause
 echo on
cmdloc'BASECSD2.EXE -o -d ' BASE'\'

/**  Repeat for next disk. Remove "rems" to enable **/
/* say " "
 say " Please insert disk 3 of 3"
 '@echo off'
 pause
 echo on
cmdloc'BASECSD3.EXE -o -d ' BASE'\'   */

'@echo off'
attrib BASE'\syslevel.bem +r'
'@echo on'

/*****************************************/
/* Update IBMCOM Directory if using NDIS */
/*****************************************/
 IBMCOM = ' '
 if stream('c:\ibmcom\protocol\inet.sys','C','query exists') <> ''
   then IBMCOM='c:\ibmcom\protocol\'        /* IBMCOM on C: drive */
   else
    if stream('d:\ibmcom\protocol\inet.sys','C','query exists') <> ''
     then IBMCOM='d:\ibmcom\protocol\'      /* IBMCOM on D: drive */
     else
      if stream('e:\ibmcom\protocol\inet.sys','C','query exists') <> ''
       then IBMCOM='e:\ibmcom\protocol\'    /* IBMCOM on E: drive */

 if IBMCOM <> ' '
  then do
/*   'BASECSD1.EXE -o ' IBMCOM' BIN\INET.SYS'       */
/*   'BASECSD2.EXE -o ' IBMCOM' BIN\IFNDIS.SYS'     */

   copy  BASE'\bin\inet.sys'  IBMCOM
   copy  BASE'\bin\ifndis.sys'  IBMCOM

  end
  else do
   say "IBMCOM directory could not be located.  If you are using the NDIS"
   say "interface, you will need to copy the INET.SYS and IFNDIS.SYS     "
   say "files from your tcpip\BIN directory to the IBMCOM\PROTOCOL       "
   say "directory after the CSD has been applied. "
  end


loop:
do until ((answer = "Y") | (answer = "N"))
                       /*      Do Until User enters YES or NO */
"cls"
"@echo [40m[2J[0;1;21;44m[1B"
Say "[10CĿ"
Say "[10CEnter a Y                                                "
Say "[10C                                                         "
Say "[10CTo install the IBM FDDI Device Driver support, or        "
Say "[10Cor the IBM Busmaster Ethernet Device Driver support      "
Say "[10C                                                         "
Say "[10C +*+*+*+*    AND/OR                                      "
Say "[10C                                                         "
Say "[10CIf this system being used for the OFFLOAD feature.       "
Say "[10C                                                         "
Say "[10C +*+*+*+*    OTHERWISE                                   "
Say "[10C                                                         "
Say "[10CEnter a N                                                "
Say "[10C                                                         "
Say "[10C    If you are not sure, enter N                         "
Say "[10C                                                         "
Say "[10C"

do until (answer <> "")
parse upper pull answer
end
"@echo [0;2;40;40m"
if answer = "YES" then answer = "Y"
if answer = "NO" then answer = "N"
if ((answer <> "Y")  & (answer <> "N"))
   then call loop
end  /*    End of do until user enters Yes or No      */

"cls"

if answer = "N" then
  return

 if IBMCOM <> ' '
  then do
    IBMCOM = substr(IBMCOM, 1, length(IBMCOM) - 9)
    cmdloc'OFFLOAD.EXE -o -d 'IBMCOM
  end
  else do
   say "The following files are for the 'OFFLOAD' feature with the       "
   say "MVS or VM systems.  It is not necessary to apply these files     "
   say "unless the system is used for OFFLOAD.  You must also have       "
   say "installed this complete BASECSD package.                         "
   say "IBMCOM directory could not be located.  You are using the NDIS   "
   say "interface, you will need to install the IBMFDDI.OS2              "
   say "                                        IBMFDDI.NIF              "
   say "                                        IBMFDDI.BIN              "
   say "                                        ENETBM.OS2               "
   say "                                        ENETBM.NIF               "
   say "files from the OFFLOAD diskette to the IBMCOM\MACS directory     "
   say "Execute OFFLOAD.EXE with -o -d <ibmcom path> options             "
   say "   ie: OFFLOAD.EXE -o -d c:\ibmcom                               "
  end
exit 0

getinstalldir: procedure
parse source system calltype cmdloc
cmddir = filespec("drive",cmdloc)||filespec("path",cmdloc)
return cmddir

