/* RPLSETD.CMD - REXX program to convert an existing OS/2 Remote IPL client  */
/*               to use one of the 32 bit graphics engine device drivers.    */
/*                                                                           */
/*    Copyright: (C) Copyright IBM Corp. 1992                                */
/*                                                                           */
/*               Note 1: All the variables are global to all subroutines.    */
/*               Note 2: This command procedure will only run on OS/2 2.0.   */
driver = ''
client = ''
logfile = ''
currentOS2 = 'OS2.20'
newOS2 = 'OS2.20a'
changeOS2 = 0
msg.0 = 0
msg.1 = ''
msg.2 = ''
ddbootdrv = ''
dd_data.0 = 0

Parse Arg  p1 p2 p3 p4 p5 .
/* Check for help request (p1 = ? or '') */
If p1 = '?' | p1 = '' Then Call Syntax_Help

parm.1 = p1
parm.2 = p2
parm.3 = p3
parm.4 = p4
parm.5 = p5

Do i = 1 to 5
   If parm.i = '' Then Leave
   parmtype = translate(substr(parm.i,1,2))
   select
      when parmtype = '/D' Then Do
         if substr(parm.i, 3, 1) = ':' Then driver = substr(parm.i, 4)
         else driver = substr(parm.i, 3)
         driver = translate(driver)
      end

      when parmtype = '/C' Then Do
         if substr(parm.i, 3, 1) = ':' Then client = substr(parm.i, 4)
         else client = substr(parm.i, 3)
         client = translate(client)
      end

      when parmtype = '/O' Then Do
         if substr(parm.i, 3, 1) = ':' Then currentOS2 = substr(parm.i, 4)
         else currentOS2 = substr(parm.i, 3)
         changeOS2 = 1
      end

      when parmtype = '/N' Then Do
         if substr(parm.i, 3, 1) = ':' Then newOS2 = substr(parm.i, 4)
         else newOS2 = substr(parm.i, 3)
         changeOS2 = 1
      end

      when parmtype = '/L' Then Do
         if substr(parm.i, 3, 1) = ':' Then logfile = substr(parm.i, 4)
         else logfile = substr(parm.i, 3)
      end

      otherwise Do
        msg.0 = 1
        msg.1 = 'The option 'parm.i' is not a valid option.'
        Call Display_Log_Msg
        Call Error_Exit
      end
   end
end

/* ensure that the REXXUTIL functions are registered. */
Call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
Call SysLoadFuncs

/* if logfile specified, delete old log file (if it exists) */
If logfile <> '' Then Call SysFileDelete logfile

/* were required parameters  entered ?*/
If driver = '' | client = '' Then Call Syntax_Help

/* Initialize INI variables. */
key.1  = 'CURRENTDRIVER'
key.2  = 'DEFAULTDRIVER'
key.3  = 'IBMVGA'
key.4  = 'IBMVGA32'
key.5  = 'IBMXGA32'
key.6  = 'IBM8514'
keydata.1  = 'IBMVGA'||'00'x
keydata.2  = 'IBMVGA'||'00'x
keydata.3  = 'IBMVGA'||'00'x
keydata.4  = 'IBMVGA32'||'00'x
keydata.5  = 'IBMXGA32'||'00'x
keydata.6  = 'IBM8514'||'00'x
max = 6
fontkey.1 = 'COURIER'
fontkey.2 = 'HELV'
fontkey.3 = 'TIMES'
fontkeydata.1 = 'COURIER.FON'||'00'x
fontkeydata.2 = 'HELV.FON'||'00'x
fontkeydata.3 = 'TIMES.FON'||'00'x
fontapp.1 = 'PM_Fonts'
fontapp.2 = 'PM_Fonts'
fontapp.3 = 'PM_Fonts'
keys = 3

/* validate driver parameter */
flag = 0
Do i=3 to max
   If driver=key.i Then Do
      flag = 1
      leave
   end
end
if flag = 0 Then Call Syntax_Help

/* determine the bootdrive id */
fspec = SysSearchPath('PATH', 'CMD.EXE')
bootdrv = substr(fspec, 1, 1)

/* get path to IBMLAN directory */
ibmlvlp = bootdrv':\IBMLVL.INI'
laninip = SysIni(ibmlvlp, 'IBM_LS', 'PATH')
If laninip = '' Then Do
   msg.0 = 1
   msg.1 = 'LAN Server is not installed.'
   Call Display_Log_Msg
   Call Error_Exit
end
if substr(laninip, length(laninip), 1) = '00'x Then Do
   /* get rid of x00 at end of string */
   laninip = substr(laninip, 1, length(laninip)-1)
end

/* get rpldir parameter from IBMLAN.INI */
Call SysFileSearch 'rpldir', laninip'\IBMLAN.INI', 'rpldirl.'
if rpldirl.0 = 0 | rpldirl.0 = 'RPLDIRL.0' Then Do
   msg.0 = 1
   msg.1 = 'OS/2 Remote IPL support is not installed'
   Call Display_Log_Msg
   Call Error_Exit
end
position = pos('=', rpldirl.1)
rpldir = substr(rpldirl.1, position+1)
rpldir = strip(rpldir)

/* determine if desired device driver is installed */
If changeOS2 = 1 Then ddpath = rpldir'\'newOS2'\OS2\DLL\'
else  ddpath = rpldir'\'currentOS2'\OS2\DLL\'
Call SysFileTree ddpath||driver||'.DLL', 'devdrv', 'S'
if result = 'ERROR:' Then Do
   msg.0 = 1
   msg.= 'Error 'rc'occurred while trying to locate 'ddpath
   Call Display_Log_Msg
   Call Error_Exit
end
if devdrv.0 = 0 Then Do
   msg.0 = 2
   msg.1 = 'The display driver 'driver'.DLL is not installed in the Remote IPL'
   msg.2 = 'directory 'ddpath'.'
   Call Display_Log_Msg
   Call Error_Exit
end

/* get LAN Server version */
Call Get_LAN_Server_Version
if result <> 0 Then Exit

/* determine if client is a single name or list of names */
/* assume it is a client name to start with */
cltlst.0 = 0
if length(client) > 8 | lines(rpldir'\FITS\'client'.FIT') = 0 Then Do
   Call SysFileTree client, 'cltlst', 'S'
   if result = 'ERROR:' | cltlst.0 = 0 Then Do
      msg.0 = 1
      msg.1 = client' is not valid client name or list file.'
      Call Display_Log_Msg
      Call Error_Exit
   end
end

if cltlst.0 = 0 Then Do
   /* single client specified */
   Call Update_Client_Files
end
else Do
   /* a list of client names was provided in a list file */
   clientlist = client
   do until lines(clientlist) = 0
      client = translate(linein(clientlist))
      Call Update_Client_Files
   end
end
If logfile <> '' Then Call Lineout logfile
exit
/* end of main routine */


/*************** Start of subroutines ***************************/
/* Subroutine Syntax_Help */
/* This subroutine displays the syntax help panel. */
Syntax_Help:
  If logfile = '' Then Do
     Say 'RPLSETD  /D:driver  /C:client  [/O:current_OS2]  [/N:new_OS2]  [/L:logfile]'
     Say '    where driver is the new display type for the client definition.'
     Say '                 The following display types are valid:'
     Say '                   IBMVGA32  - 32 bit VGA display driver'
     Say '                   IBMXGA32  - 32 bit XGA display driver'
     Say '                   IBM8514   - 32 bit 8514 display driver'
     Say '          client is the name of the OS/2 Remote IPL client workstation'
     Say '                 or it is the fully qualified name of a file containing'
     Say '                 a list of client workstations.'
     Say '          current_OS2 (optional) is the root directory for the current OS/2 2.0'
     Say '                      operating system the client is booting.  This parameter'
     Say '                      is case sensitive.  The default is OS2.20'.
     Say '          new_OS2 (optional) is the root directory for the OS/2 2.0 operating'
     Say '                  system that the client is to be switched to.  This parameter'
     Say '                  is case sensitive.  The default is OS2.20a.'
     Say '          logfile (optional) is the name of a file to which all messages and'
     Say '                  errors are to be logged.  If logfile is specified, no'
     Say '                  messages or errors will be displayed on the screen.'
     exit
  end
  else Do
     msg.0 = 2
     msg.1 = 'An error was detect in the following RPLSETD command syntax:'
     msg.2 = '  RPLSETD' p1  p2  p3  p4  p5
     Call Display_Log_Msg
     Call Error_Exit
  end



/* Subroutine Error_Exit */
/* This subroutine cleans up on an error exit. */
Error_Exit:
If logfile <> '' Then Do
   Call Lineout logfile
   Say 'Error detected.  Check log file: 'logfile
end
exit 4


/* Subroutine Display_Log_Msg */
/* This subroutine displays messages to the screen or logs them to the */
/* log file. */
Display_Log_Msg:
Do i = 1 to msg.0
   If logfile = '' Then Say msg.i
   else Call Lineout logfile, msg.i
end
msg.0 = 0
return 0



/* Subroutine Get_LAN_Server_Version */
/* This subroutine determine the version of LAN Server installed in  */
/* the Remote IPL directory. */
Get_LAN_Server_Version:
/* get path to IBMLAN directory */
ibmlvlp = bootdrv':\IBMLVL.INI'
LS_version = ''
lanrel = SysIni(ibmlvlp, 'IBM_LS', 'RELEASE')
If result <> 'ERROR:' Then Do
   lanver = SysIni(ibmlvlp, 'IBM_LS', 'VERSION')
   If result <> 'ERROR:' Then Do
      if substr(lanrel, length(lanrel), 1) = '00'x Then Do
         /* get rid of x00 at end of string */
         lanrel = substr(lanrel, 1, length(lanrel)-1)
      end
      if substr(lanver, length(lanver), 1) = '00'x Then Do
         /* get rid of x00 at end of string */
         lanver = substr(lanver, 1, length(lanver)-1)
      end
      LS_version = lanrel || lanver
   end
end
If LS_version = '' Then Do
   msg.0 = 1
   msg.1 = 'Unable to determine the version of LAN Server in the Remote IPL directory.'
   Call Display_Log_Msg
   return 4
end
return 0



/* Subroutine Update_Client_Files */
/* This subroutine calls the subroutines to update each client file. */
Update_Client_Files:
/* update the client copy of OS2INI.20 */
Call Update_Client_Ini
If result = 0 Then Do
   msg.0 = 1
   msg.1 = client' copy of OS2INI.20 was updated.'
   Call Display_Log_Msg
end
else Do
   msg.0 = 1
   msg.1 = client' copy of OS2INI.20 was not updated.'
   Call Display_Log_Msg
end

/* update the client CONFIG.20 file.  If the client is DEFALT20, then */
/* there is special processing to update each of the master CONFIG.20 */
/* files in the RPL\IBMCOM tree. */
if client = 'DEFALT20' Then Do
   /* get list of directories in RPL\IBMCOM */
   Call SysFileTree rpldir'\IBMCOM\*.*', 'lanlist', D

   /* for DEFALT20 update each of the lantype CONFIG.20 files */
   Do lli = 1 to lanlist.0
      lanpath = word(lanlist.lli, 5)
      lanpos = lastpos('\', lanpath)
      lantype = translate(substr(lanpath, lanpos + 1))
      /* exclude the normal IBMCOM directories, process only the special */
      /* RPL directories. */
      If (lantype <> 'DLL' & lantype <> 'INCLUDE' & lantype <> 'MACS' & lantype <> 'PROTOCOL') Then Do
         If lines(rpldir'\IBMCOM\'lantype'\CONFIG.20') Then Do
            /* a CONFIG.20 file is present, update it */
            Call Update_Client_Config_20
            If result = 0 Then Do
               msg.0 = 1
               msg.1 = client lantype 'copy of CONFIG.20 was updated.'
               Call Display_Log_Msg
            end
            else Do
               msg.0 = 1
               msg.1 = client lantype 'copy of CONFIG.20 was not updated.'
               Call Display_Log_Msg
            end
         end
      end
   end
end
else Do
   /* not the DEFALT20 client */
   Call Update_Client_Config_20
   If result = 0 Then Do
      msg.0 = 1
      msg.1 = client' copy of CONFIG.20 was updated.'
      Call Display_Log_Msg
   end
   else Do
      msg.0 = 1
      msg.1 = client' copy of CONFIG.20 was not updated.'
      Call Display_Log_Msg
   end
end

/* Update the client.FIT file */
Call Update_Client_Fit
If result = 0 Then Do
   msg.0 = 1
   msg.1 = client'.FIT was updated.'
   Call Display_Log_Msg
end
else Do
   msg.0 = 1
   msg.1 = client'.FIT was not updated.'
   Call Display_Log_Msg
end
msg.0 = 1
msg.1 = '  '
Call Display_Log_Msg
return 0



/* Subroutine Update_Client_Ini */
/* This subroutine updates the OS2INI.20 file for a client workstation */
/* to add the required profile data to support the specified device driver. */
Update_Client_Ini:

/* build fully qualified path name for OS2INI.20 */
ininame = rpldir'USER\'client'\OS2\OS2INI.20'

/* Update client copy of OS2.INI (OS2INI.20) */
error = 4
Do i=1 to max
   If 'ERROR:' = SysIni(ininame,'PM_DISPLAYDRIVERS',key.i,keydata.i) Then Do
      msg.0 = 1
      msg.1 = client 'Error setting key "'key.i'" in OS2INI.20.'
      Call Display_Log_Msg
      return 4
   End  /* Do */
End /* do */

If driver <> '' Then Do
   Do i=3 to max
      If driver=key.i Then Do
         Call SysIni ininame,'PM_DISPLAYDRIVERS',key.1,keydata.i
         Call SysIni ininame,'PM_DISPLAYDRIVERS',key.2,keydata.i
         If driver='IBMXGA32' Then Do j=1 to keys
            Call SysIni ininame,fontapp.j,fontkey.j,'\OS2\DLL\'fontkeydata.j
         End
      End  /* Do */
   End /* do */
End  /* Do */
return 0




/* Subroutine Update_Client_Fit */
/* This subroutine creates a new client.FIT by making the following */
/* changes to the original FIT: */
/*   - Comment out the DISPLAY.DLL entries. */
/*   - Enables the correct .FON entries for the specified display driver. */
/*   - If requested, changes the target OS2 root directory. */
Update_Client_Fit:

/* build fully qualified path names for client.??? */
fitname = rpldir'\FITS\'client'.FIT'
tmpfitname = rpldir'\FITS\'client'.TMP'
bakfitname = rpldir'\FITS\'client'.BAK'
Call SysFileDelete tmpfitname
Call SysFileDelete bakfitname

If lines(fitname) Then Do
   /* client.FIT does exists, build a new FIT */
   do until lines(fitname) = 0
      data = linein(fitname)
      If data <> '' & substr(data, 1, 2) <> '\\' Then Do
         /* not a null line or a UNC line, check line */
         datap = pos(':\OS2\DLL\DISPLAY.DLL', data)
         if datap <> 0 Then Do
            if substr(data,1,1) <> ';' Then Do
               /* comment out DISPLAY.DLL entry */
               newdata = ';'data
               data = newdata
            end
         end
         else Do
            /* check for .FON entry and enable/disable the entry */
            /* depending on the driver type */
            helvp = 0
            courp = 0
            timesp = 0
            helvp = pos(':\OS2\DLL\HELV.FON', data)
            If helvp = 0 Then Do
               courp = pos(':\OS2\DLL\COURIER.FON',data)
               If courp = 0 Then Do
                  timesp = pos(':\OS2\DLL\TIMES.FON',data)
               end
            end
            If helvp <> 0 | courp <> 0 | timesp <> 0 Then Do
              datal = length(data)
              If driver = 'IBMVGA32' | DRIVER = 'IBMVGA' Then Do
                 If substr(data, datal-2, 3) <> 'VGA' Then Do
                    If substr(data, 1,1) <> ';' Then Do
                       /* disable non-VGA .FON entry */
                       newdata = ';'data
                       data = newdata
                    end
                 end
                 else If substr(data, 1, 1) = ';' Then Do
                    /* enable VGA .FON entry */
                    data = substr(data, 2)
                 end
              end
              else If driver = 'IBMXGA32' | driver = 'IBM8514' Then Do
                 If substr(data, datal-2, 3) <> 'BGA' Then Do
                    If substr(data, 1, 1) <> ';' Then Do
                       /* disable non-XGA/8514 .FON entry */
                       newdata = ';'data
                       data = newdata
                    end
                 end
                 else If substr(data, 1, 1) = ';' Then Do
                    /* enable XGA/8514 .FON entry */
                    data = substr(data, 2)
                 end
              end
            end
         end
         /* check for possible operating system change */
         if changeOS2 = 1 Then Do
            If substr(data, 1, 2) = '; ' Then srvfname = word(data, 3)
            else srvfname = word(data, 2)
            os2p = pos(currentOS2'\', srvfname)
            if os2p <> 0 Then Do
               /* old OS2 entry found, update it */
               os2p = pos(currentOS2, data, length(word(data,1))+1)
               newdata = substr(data, 1, os2p-1)
               newdata = newdata || newOS2
               newdata = newdata || substr(data, os2p+length(currentOS2))
               data = newdata
            end
         end
      end
      /* write data record to new FIT */
      Call Lineout tmpfitname, data
   end
   Call Lineout tmpfitname   /* close file */
   Call Lineout fitname      /* close file */

   /* rename original client.FIT */
   cmdstr = '@rename 'fitname' 'client'.BAK'
   address CMD cmdstr
   if rc = 0 Then Do
      /* rename client.TMP to be client.FIT */
      cmdstr = '@rename 'tmpfitname' 'client'.FIT'
      address CMD cmdstr
      if rc = 0 Then Do
         /* delete orginal client.FIT */
         Call SysFileDelete bakfitname
      end
      else Do
         /* rename error, try to restore original */
         cmdstr = '@rename 'bakfitname'  'client'.FIT'
         address CMD cmdstr
   end
end
else return 4
return 0



/* Subroutine Update_Client_Config_20 */
/* This subroutine creates a new CONFIG.20 for the client that has the */
/* appropriate display device drivers enabled. */
Update_Client_Config_20:

/* if LS 2.0 file, convert it to new format */
If LS_version = '200' Then Call Update_LS20_Config_20
If result <> 0 Then Do
   msg.0 = 1
   msg.1 = 'An error occurred while updating the file 'rpldir'\IBMCOM\'lantype'\CONFIG.20'
   Call Display_Log_Msg
   return 4
end

/* build fully qualified path names for client CONFIG.20 */
If client = 'DEFALT20' Then Do
   /* DEFALT20 is special case, it must be called for each lantype */
   configname = rpldir'\IBMCOM\'lantype'\CONFIG.20'
   tmpconfigname = rpldir'\IBMCOM\'lantype'\CONFIG.20T'
   bakconfigname = rpldir'\IBMCOM\'lantype'\CONFIG.20B'
end
else Do
   configname = rpldir'\MACHINES\'client'\CONFIG.20'
   tmpconfigname = rpldir'\MACHINES\'client'\CONFIG.20T'
   bakconfigname = rpldir'\MACHINES\'client'\CONFIG.20B'
end
Call SysFileDelete tmpconfigname
Call SysFileDelete bakconfigname

If lines(configname) Then Do
   /* copy records to first DEVINFO (XGA) */
   flag = 0
   do until lines(configname) = 0
      data = linein(configname)
      If pos('DEVINFO=', data) <> 0 Then Leave
      xgacomp = pos('ing 6 state', data)
      If xgacomp <> 0 & driver = 'IBMXGA32' Then Do
         /* update XGA comment statement */
         newdata = substr(data, 1, xgacomp+3)||'7'||substr(data, xgacomp+5)
         data = newdata
      end
      Call Lineout tmpconfigname, data
   end

   /* process XGA statements */
   position = pos(':\OS2\', data)
   bootdrv2 = substr(data, position-1, 1)
   flag = 0
   Do while flag = 0
      If driver = 'IBMXGA32' Then Do
         If translate(substr(data, 1, 4)) = 'REM ' Then Do
            data = substr(data, 5)
         end
         if pos('\OS2\MDOS\VVGA.SYS', data) <> 0 Then Do
            If pos('\OS2\XGA.SYS', lastrecord) = 0 Then Do
               /* insert the XGA.SYS record */
               newdata = 'DEVICE='bootdrv2':\OS2\XGA.SYS'
               Call Lineout tmpconfigname, newdata
            end
         end
      end
      else Do
         /* make sure records are REMed out */
         if substr(data, 1, 4) <> 'REM ' Then Do
            newdata = 'REM '||data
            data = newdata
         end
      end
      Call lineout tmpconfigname, data
      lastrecord = data
      if pos('SET VIO_XGA=', data) <> 0 Then flag = 1
      else data = linein(configname)
   end

   /* copy records to next DEVINFO (8514) */
   flag = 0
   do until lines(configname) = 0
      data = linein(configname)
      If pos('DEVINFO=', data) <> 0 Then Leave
      Call Lineout tmpconfigname, data
   end

   /* process 8514 statements */
   flag = 0
   Do while flag = 0
      If driver = 'IBM8514' Then Do
         If translate(substr(data, 1, 4)) = 'REM ' Then Do
            data = substr(data, 5)
         end
      end
      else Do
         /* make sure records are REMed out */
         if substr(data, 1, 4) <> 'REM ' Then Do
            newdata = 'REM '||data
            data = newdata
         end
      end
      Call lineout tmpconfigname, data
      lastrecord = data
      if pos('\V8514A.SYS', data) <> 0 Then flag = 1
      else data = linein(configname)
   end

   /* copy records to the VGA DEVINFO */
   do until lines(configname) = 0
      data = linein(configname)
      newdata = translate(data)
      If pos('DEVINFO=SCR,VGA', newdata) <> 0 Then Leave
      Call Lineout tmpconfigname, data
   end
   newdata = ''

   /* process VGA statements */
   flag = 0
   Do while flag = 0
      If driver = 'IBMVGA' | driver = 'IBMVGA32' Then Do
         If translate(substr(data, 1, 4)) = 'REM ' Then Do
            data = substr(data, 5)
         end
      end
      else Do
         /* make sure records are REMed out */
         if substr(data, 1, 4) <> 'REM ' Then Do
            newdata = 'REM '||data
            data = newdata
         end
      end
      Call lineout tmpconfigname, data
      lastrecord = data
      if pos('\VVGA.SYS', data) <> 0 Then flag = 1
      else data = linein(configname)
   end

   /* copy remaining records */
   do until lines(configname) = 0
      data = linein(configname)
      Call Lineout tmpconfigname, data
   end

   Call Lineout tmpconfigname   /* close file */
   Call Lineout configname      /* close file */

   /* rename original CONFIG.20 */
   cmdstr = '@rename 'configname' CONFIG.20B'
   address CMD cmdstr
   if rc = 0 Then Do
      /* rename CONFIG.20T to be CONFIG.20 */
      cmdstr = '@rename 'tmpconfigname' CONFIG.20'
      address CMD cmdstr
      if rc = 0 Then Do
         /* delete orginal CONFIG.20 */
         Call SysFileDelete bakconfigname
      end
      else Do
         /* rename error, try to restore original */
         cmdstr = '@rename 'bakconfigname' CONFIG.20'
         address CMD cmdstr
      end
   end
end
else return 4   /* file not found */
return 0



/* Subroutine Update_LS20_Config_20 */
/* This subroutine converts a LAN Server 2.0 CONFIG.20 file to the new format */
Update_LS20_Config_20:

/* build fully qualified path names for client CONFIG.20 */
If client = 'DEFALT20' Then Do
   /* DEFALT20 is special case, it must be called for each lantype */
   configname = rpldir'\IBMCOM\'lantype'\CONFIG.20'
   tmpconfigname = rpldir'\IBMCOM\'lantype'\CONFIG.20T'
   bakconfigname = rpldir'\IBMCOM\'lantype'\CONFIG20.BAK'
end
else Do
   configname = rpldir'\MACHINES\'client'\CONFIG.20'
   tmpconfigname = rpldir'\MACHINES\'client'\CONFIG.20T'
   bakconfigname = rpldir'\MACHINES\'client'\CONFIG20.BAK'
end
Call SysFileDelete tmpconfigname
Call SysFileDelete bakconfigname

/* determine bootdrive id from PROTSHELL statement */
do until lines(configname) = 0
   data = translate(linein(configname))
   If substr(data, 1, 9) = 'PROTSHELL' Then Do
      ddi = pos(':\', data)
      newbootdrv = substr(data,ddi - 1, 1)
      Leave
   end
end
Call Lineout configname     /* close file */
if newbootdrv = '' Then return 4

/* check to see if file has already been updated with new device driver */
/* statements */
Call SysFileSearch '\OS2\XGA.SYS', configname, 'xgasys.'
If xgasys.0 = 0 Then Do
   /* file has not been updated, update it */

   /* check to see if dd_data needs to be initialized */
   If ddbootdrv <> newbootdrv Then Do
      dd_data.0 = 0
      ddbootdrv = newbootdrv
   end
   If dd_data.0 = 0 Then Do
      /* initialize dd_data */
      dd_data.0 = 21
      dd_data.1 = 'REM Use the following 7 statements for workstations with XGA displays:'
      dd_data.2 = 'REM DEVINFO=SCR,BGA,'ddbootdrv':\OS2\VIOTBL.DCP'
      dd_data.3 = 'REM DEVICE='ddbootdrv':\OS2\XGARING0.SYS'
      dd_data.4 = 'REM DEVICE='ddbootdrv':\OS2\XGA.SYS'
      dd_data.5 = 'REM DEVICE='ddbootdrv':\OS2\MDOS\VVGA.SYS'
      dd_data.6 = 'REM DEVICE='ddbootdrv':\OS2\MDOS\VXGA.SYS '
      dd_data.7 = 'REM SET VIDEO_DEVICES=VIO_XGA'
      dd_data.8 = 'REM SET VIO_XGA=DEVICE(BVHVGA,BVHXGA)'
      dd_data.9 = ' '
      dd_data.10 = 'REM Use the following 5 statements for workstations with 8514/A adapters:'
      dd_data.11 = 'REM DEVINFO=SCR,BGA,'ddbootdrv':\OS2\VIOTBL.DCP'
      dd_data.12 = 'REM SET VIDEO_DEVICES=VIO_8514A'
      dd_data.13 = 'REM SET VIO_8514A=DEVICE(BVHVGA,BVH8514A)'
      dd_data.14 = 'REM DEVICE='ddbootdrv':\OS2\MDOS\VVGA.SYS'
      dd_data.15 = 'REM DEVICE='ddbootdrv':\OS2\MDOS\V8514A.SYS'
      dd_data.16 = ' '
      dd_data.17 = 'REM Use the following 4 statements for workstations with VGA displays:'
      dd_data.18 = 'DEVINFO=SCR,VGA,'ddbootdrv':\OS2\VIOTBL.DCP'
      dd_data.19 = 'SET VIDEO_DEVICES=VIO_VGA'
      dd_data.20 = 'SET VIO_VGA=DEVICE(BVHVGA)'
      dd_data.21 = 'DEVICE='ddbootdrv':\OS2\MDOS\VVGA.SYS'
   end

   If lines(configname) Then Do
      /* copy records until the DEVINFO=SCR,.. statement */
      do until lines(configname) = 0
         data = translate(linein(configname))
         If substr(data, 1, 12) = 'DEVINFO=SCR,' Then Leave
         Call Lineout tmpconfigname,data
      end

      Call Lineout tmpconfigname, ' '   /* blank line */

      /* write new device driver statements to file */
      do ddi= 1 to dd_data.0
        Call lineout tmpconfigname, dd_data.ddi
      end

      Call Lineout tmpconfigname, ' '   /* blank line */

      /* skip display records until POINTDD.SYS statement */
      do until lines(configname) = 0
         data = translate(linein(configname))
         skip = 0
         ddp1 = pos('XGARING0.SYS', data)
         If ddp1 <> 0 Then skip = 1
         else Do
            ddp1 = pos('VXGA.SYS', data)
            if ddp1 <> 0 Then skip = 1
            else Do
               ddp1 = pos('VIO_XGA', data)
               if ddp1 <> 0 Then skip = 1
               else Do
                  ddp1 = pos('VIO_VGA', data)
                  if ddp1 <> 0 Then skip = 1
                  else Do
                     ddp1 = pos('VVGA.SYS', data)
                     if ddp1 <> 0 Then skip = 1
                     else Do
                        ddp1 = pos('VGA DISPLAYS:', data)
                        if ddp1 <> 0 Then skip = 1
                        else Do
                           ddp1 = pos('XGA DISPLAYS:', data)
                           if ddp1 <> 0 Then skip = 1
                        end
                     end
                  end
               end
            end
         end
         If substr(data, 15, 11) = 'POINTDD.SYS' Then Leave
         If skip = 0 Then Do
           If data <> '' Then Call Lineout tmpconfigname, data
         end
      end

      Call Lineout tmpconfigname, data  /* write pointdd.sys */

      /* copy remaining records */
      do until lines(configname) = 0
         data = linein(configname)
         Call Lineout tmpconfigname, data
      end

      Call Lineout configname
      Call Lineout tmpconfigname

      /* rename original CONFIG.20 */
      cmdstr = '@rename 'configname' CONFIG20.BAK'
      address CMD cmdstr
      if rc = 0 Then Do
         /* rename CONFIG.20T to be CONFIG.20 */
         cmdstr = '@rename 'tmpconfigname' CONFIG.20'
         address CMD cmdstr
         if rc <> 0 Then Do
            /* rename error, try to restore original */
            cmdstr = '@rename 'bakconfigname' CONFIG.20'
            address CMD cmdstr
            return 4
         end
      end
      else return 4
   end
end
return 0
