/*Rexx*/
/***********************************************************************
 *  December 1993 RLM -- HOOKINST.CMD -- installs new PMX GREHOOK.DLLL
 *  Copyright (C) 1993, 1994 IBM Corporation
 ***********************************************************************
 */
   parse arg newHookPath .

   if (newHookPath='?') then do
      say "HOOKINST.CMD --"
      say "   A PMX 2.0 utility for installing a PMX Graphics Engine Hook DLL"
      say "   This is a prerequisite for enabling PMX"
      say "   PseudoColor support using PM Palette Manager functions."
      say "   An entry in OS2.INI must point to the PMX GREHOOK DLL."
      say " "
      say "   HOOKINST manipulates the OS2.INI entry for the PMX GREHOOK DLL."
      say " "
      say "Command formats:"
      say "   hookinst            -- displays current PMX GREHOOK DLL path"
      say "   hookinst delete     -- deletes PMX GREHOOK entry in OS2.INI"
      say "   hookinst d:\tcpip\dll\grehook.dll"
      say "                       -- creates a PMX GREHOOK entry in OS2.INI"
      exit 1
   end

   RC=RXFUNCQUERY('SysIni')
   if (RC<>0) then do
     RC=RXFUNCADD('SysIni','REXXUTIL','SysIni')
     if (RC<>0) then do
        say "Rexx failure: rxfuncadd(sysini,rexutil,sysini) rc=" rc
        say "Please check that Rexx has been properly installed on your OS/2 system."
        exit rc
     end
   end

   /* -- Check to see if there is a hook currently installed: */
   currHook = SysIni('USER','PM_ED_HOOKS','GREHOOK')
   if (currHook='ERROR:') then do
      say "There is no current PMX GREHOOK installed!"
   end
   else do
      say "The current PMX GREHOOK is located at" currHook "."
   end

   if (length(newHookPath)=0) then do
      exit 0
   end
   else if ('DELETE'=translate(newHookPath)) then do
      say "Deleting OS2.INI entry for current PMX GREHOOK.DLL..."
      delHook = SysIni('USER','PM_ED_HOOKS','GREHOOK','DELETE:')
      say "... PMX GREHOOK deleted from OS2.INI."
      say "You now need to reboot OS/2 in order to actually unload the DLL."
      exit 0
   end
   else do
      newHook = stream( newHookPath, 'C', 'query exists' )

      if (0=length(newHook)) then do
         say "Cannot locate this PMX GREHOOK file:" newHookPath
         exit 10
      end

      say "Adding PMX GREHOOK to OS2.INI:" newHook
      newHook = newHook || d2c(0) /* place NULL char at end */
      okHook = SysIni('USER','PM_ED_HOOKS','GREHOOK', newHook )

      if (length(okHook)=0) then do
         say "Successfully added PMX GREHOOK to OS2.INI."
         say "You now need to reboot OS/2 in order to actually load the DLL."
         exit 0
      end
      else do
         say "Error occurred when adding PMX GREHOOK to OS2.INI."
         exit 20
      end

      exit 0
   end
