/*Rexx*/
/*
 * Oct 1994 -- ALLFONTS.cmd is a REXX program that converts fonts from PMX
 *           X11r5 format to .xfn (OS/2 PM private) format.  The input
 *           directory is the current directory.
 *         The following flags are supported:
 *         Flag         Default    Description
 *         ----         -------    -----------
 *         -bdf           NO        Convert all *.bdf files to .xfn format
 *         -pcf           YES       Convert all *.pcf files to .xfn format
 *         -o directory   CURRENT   Output/target, subdirectory.
 *                                  If not specified, the current directory is used.
 *         -m             NO        Execute MKFONTDR.EXE on output directory.
 *         -erase         NO        Delete converted .pcf fontfiles in output dir.
 *                                  As each font (.bdf and/or .pcf) is converted,
 *                                  under control of the -bdf and -pcf flags, the
 *                                  filename.pcf file is searched for in the output
 *                                  directory.  If found, it is deleted, when the -erase
 *                                  flag is specified.
 *    Note - When -m is specified, only one font format may exist in the same directory.
 *           Therefore the same font in .pcf and .xfn format will cause an error in mkfontdr.exe.
 *           To avoid this, use the -erase flag, or manually move or rename files in the
 *           output directory BEFORE executing mkfontdr.exe.
 */

/*trace r*/

tempFile = 'temp_dir.tmp'
dobdf = 0
dopcf = 1
domk  = 0
doe   = 0
count = 0
outdir = directory()
startdir = outdir

arg arglist
do forever
    parse var arglist nextarg arglist
    select
    when nextarg = '-BDF' then do
        dobdf = 1
        end
    when nextarg = '-PCF' then do
        dopcf = 1
        end
    when nextarg = '-M' then do
        domk = 1
        end
    when nextarg = '-O' then do
        parse var arglist nextarg arglist
        outdir = directory(nextarg)
        if outdir = "" then do
           say "ERROR:  Invalid output directory, " nextarg
           exit 1
        end
         /* Restore original drive:directory */
        call directory(startdir)
        end
    when nextarg = '-ERASE' then do
        doe = 1
        end
    when nextarg = "" then
        leave
    otherwise
        say "ALLFONTS.CMD is a REXX program that converts fonts from PMX "
        say "  X11r5 format to .xfn (OS/2 PM private) format.  The input"
        say "  directory is the current directory."
        say "The following flags are supported:"
        say "Flag         Default    Description"
        say "----         -------    -----------"
        say "-bdf           NO        Convert all *.bdf files to .xfn format"
        say "-pcf           YES       Convert all *.pcf files to .xfn format"
        say "-o directory   CURRENT   Output/target, subdirectory."
        say "-m             NO        Execute MKFONTDR.EXE on output directory."
        say "-erase         NO        Delete converted .pcf fontfiles in output dir."
        say " "
        exit 1
    end /* select */
end

if (domk & (\doe)) then do
   say "WARNING:  The MKFONTDR.EXE utility does not permit the same "
   say " font, in different formats (such as .pcf, .xfn), in the "
   say " same directory.  If mkfontdr.exe fails, check for the same "
   say " font in .pcf and .xfn format in the " outdir " directory."
   say " Using the -erase flag with ALLFONTS.CMD will erase any .pcf "
   say " font with a corresponding .xfn format, converted wih ALLFONTS.CMD."
   pause
   end

if dopcf then do
   /* -- get a list of all the .PCF files in the current directory:*/
   'dir /b /f *.pcf >' tempFile

   fileName = linein(tempFile)
   do while length(fileName)<>0
      parse var fileName fName '.' fType other
   
      /* -- run PCFTOPM on each .pcf file:*/
      'pcftopm -o 'outdir'\'fName'.xfn 'fileName
      count = count + 1
      if (doe & fileexists(outdir'\'fName'.pcf')) then
         'ERASE' outdir'\'fName'.pcf'
      fileName = linein(tempFile)
      end
    /* close the stream */ 
   call LINEOUT(tempFile)  
end

if dobdf then do
   /* -- get a list of all the .BDF files in the current directory:*/
   'dir /b /f *.bdf >' tempFile

   fileName = linein(tempFile)
   do while length(fileName)<>0
      parse var fileName fName '.' fType other
   
      /* -- run PCFTOPM on each .pcf file:*/
      'bdftopm -o 'outdir'\'fName'.xfn 'fileName
      count = count + 1
      if (doe & fileexists(outdir'\'fName'.pcf')) then
         'ERASE' outdir'\'fName'.pcf'
      fileName = linein(tempFile)
      end
    /* close the stream */ 
   call LINEOUT(tempFile)  
end

if domk then do
   /* -- Create the FONTS.DIR file:*/
   'mkfontdr' outdir
   end
else if count > 0 then do
   say "WARNING: MKFONTDR.EXE has NOT executed."
   say "  MKFONTDR.EXE must be run in output directory " outdir
   say "  before the fonts are available for use by PMX."
end

'ERASE' tempFile
return

fileexists: procedure
arg file
progname = STREAM(file, 'C', 'QUERY EXISTS')
return progname \= ''
