Unit String3;

{$H-}

Interface

Uses Dos,Objects
{$IFDEF VIRTUALPASCAL}
,Use32
{$ENDIF};

Type
   StCollection = Object(TStringCollection)
       Procedure Add(s : String);
       Function Get(index : Word) : String;
   End;

   PStCollection = ^StCollection;

Function StrX(l : LongInt) : string;
Function ValX(s1 : String) : Word;
Function Right(st : string; x : byte) : string;
Function Left(st : string; x : byte) : string;
Procedure Trim(var s : string);
Function Trimmed(s : string) : String;
Function ToDate : string;
Function RAToDate : String;
Function Now : string;
Function LPos(c : Char; s : string) : Byte;
Function PadTo(w : Word; s : string) : string;
Function Hex(s : string) : LongInt;
Function WildCompare(s1, s2 : string) : Boolean;
{$IFDEF VIRTUALPASCAL}
Function Digit3(b : word) : string;
Function Digit2(b : word) : string;
{$ELSE}
Function Digit3(b : byte) : string;
Function Digit2(b : byte) : string;
{$ENDIF}
Procedure Parse(var s1, s2  : String);
Procedure Range(s1 : String; Var Lo, Hi : Word);
Function HexStr(Number:longint):string;
Function Upper(s : String) : String;
Function ArrayCompare(s : String; a : Array Of Char; offset : Word) : Boolean;
Function LeftOf(s,s2 : String) : String;
Function RightOf(s,s2 : String) : String;

Implementation

Procedure StCollection.Add(s : String);
Var
   p : PString;
Begin;
   p := New(PString);
   p^ := s;
   Insert(p);
End;

Function StCollection.Get(Index : Word) : String;
Var
   p : PString;
Begin;
   p := At(Index - 1);
   Get := p^;
End;

Function StrX(l : LongInt) : string;
Var
   s : string[20];
Begin;
   Str(l,s);
   StrX := s;
End;

Function ValX(s1 : string) : Word;
Var
   w : Word;
   I : Integer;
Begin;
   Val(s1,w,i);
   If i <> 0 Then ValX := 0 Else ValX := w;
End;

Function Right(st : string; x : byte) : string;
Var
   y : byte;
Begin;
   y := Length(st);
   Right := Copy(st,x+1,y-x);
End;

Function Left(st : string; x : byte) : string;
Begin;
   Left := Copy(st,1,x-1);
End;

Procedure Trim(var s : string);
Var
   s2 : string;
   x,y : Byte;
Begin
   x := Length(s);
   If (x = 1) And (s = ' ') Then s := '';
   While (s[x]=' ') And (x > 0) Do Dec(x);
   y := 1;
   While (s[y]=' ') And (y <= Length(s)) Do Inc(y);
   If (x < y) Or ((x = y) And (s[x] = ' ')) Then s := '' Else Begin
      s2 := Copy(s,y,x-y+1);
      s := s2;
   End;
End;

Function Trimmed(s : String) : String;
{ Function version of 'Trim,' which is non-destructive. }
Var
   s2 : String;
Begin;
   s2 := s;
   Trim(s2);
   Trimmed := s2;
End;

Function ToDate : string;
Var
   s,s2 : string[20];
   y, m, d, dw : word;
Begin;
   GetDate(y,m,d,dw);
   Str(m,s);
   If Length(s)=1 Then s := '0' + s;
   Str(d,s2);
   If Length(s2)=1 Then s2 := '0' + s2;
   s := Concat(s,'/',s2);
   y := y MOD 100;
   Str(y,s2);
   If Length(s2)=1 Then s2 := '0' + s2;
   s := Concat(s,'/',s2);
   ToDate := s;
End;

Function RaToDate : String;
Var
   s, s2 : String[20];
   y, m, d, dw : Word;
Begin;
   GetDate(y,m,d,dw);
   Str(m,s);
   If Length(s)=1 Then s := '0' + s;
   Case m Of
      1 : s := s + '-Jan';
      2 : s := s + '-Feb';
      3 : s := s + '-Mar';
      4 : s := s + '-Apr';
      5 : s := s + '-May';
      6 : s := s + '-Jun';
      7 : s := s + '-Jul';
      8 : s := s + '-Aug';
      9 : s := s + '-Sep';
     10 : s := s + '-Oct';
     11 : s := s + '-Nov';
     12 : s := s + '-Dec';
   End;
   RAToDate := s;
End;

Function Now : string;
Var
   s, s2 : string[20];
   h,m,se,s1 : word;
Begin;
   GetTime(h,m,se,s1);
   Str(h,s);
   Str(m,s2);
   If m<10 Then s2 := '0' + s2;
   s := Concat(s,':',s2);
   If Length(s)<5 Then s := '0' + s;
   Now := s;
End;

Function RaNow : string;
Var
   s, s2 : string[20];
   h,m,se,s1 : word;
Begin;
   GetTime(h,m,se,s1);
   Str(h,s);
   Str(m,s2);
   If m<10 Then s2 := '0' + s2;
   s := Concat(s,':',s2);
   If Length(s)<5 Then s := '0' + s;
   s := s + Digit2(se);
   RaNow := s;
End;

Function LPos(c : Char; s : string) : Byte;
Var
   x : Byte;
Begin;
   x := Length(s);
   While (s[x] <> c) and (x>0) Do Dec(x);
   LPos := x;
End;

Function PadTo(w : Word; s : string) : string;
Var
   s2 : string;
Begin;
   s2 := s;
   While Length(s2) < w Do s2 := s2 + ' ';
   PadTo := s2;
End;

Function Hex(s : string) : LongInt;
Var
   long : LongInt;
   x : Byte;
   s2 : string;
Begin;
   s2 := '0123456789ABCDEF';
   long := 0;
   For x := 1 to Length(s) Do Begin;
       long := (long SHL 4) + (Pos(UpCase(s[x]),s2) - 1);
   End;
   Hex := long;
End;

Function WildCompare(s1, s2 : string) : Boolean;
{ Compare two strings, using wildcards }
Var
   v, w : Char;
   x, y : Byte;
Begin;
   If Length(s1) = Length(s2) Then
      WildCompare := True Else WildCompare := False;
   If Length(s1) < Length(s2) Then y := Length(s1) Else y := Length(s2);
   For x := 1 to y Do Begin;
       v := UpCase(s1[x]);
       w := UpCase(s2[x]);
       If (v <> w) And (w <> '?') And (w <> '*') Then Begin;
          WildCompare := False;
          Exit;
       End;
       If w = '*' Then Begin;
          WildCompare := True;
          Exit;
       End;
   End;
End;

{$IFDEF VIRTUALPASCAL}
Function Digit3(b : word) : string;
{$ELSE}
Function Digit3(b : byte) : string;
{$ENDIF}
Var
   s : string;
Begin;
   s := StrX(b);
   While Length(s) < 3 Do s := '0' + s;
   Digit3 := s;
End;

{$IFDEF VIRTUALPASCAL}
Function Digit2(b : word) : string;
{$ELSE}
Function Digit2(b : byte) : string;
{$ENDIF}
Var
   s : string;
Begin;
   s := StrX(b);
   While Length(s) < 2 Do s := '0' + s;
   Digit2 := s;
End;

Procedure Parse(var s1, s2  : String);
Var
   a : Word;
Begin;
   a := Pos(' ',s1);
   If a > 0 Then Begin;
      s2 := Left(s1,a);
      s1 := Right(s1,a);
      Trim(s2);
      Trim(s1);
   End Else Begin;
      s2 := s1;
      Trim(s2);
      s1 := '';
   End;
End;

Procedure Range(s1 : String; Var Lo, Hi : Word);
Var
   a, x : Word;
   s2, s3 : String;
Begin;
   a := Pos('-',s1);
   If a = 0 Then Begin;
      Lo := ValX(s1);
      Hi := Lo;
   End Else Begin;
      s2 := Left(s1,a);
      s3 := Right(s1,a);
      Trim(s2);
      Trim(s3);
      Lo := ValX(s2);
      Hi := ValX(s3);
   End;
End;

Function HexStr(Number:longint):string;
const
   HEXChars: array [0..15] of char = '0123456789abcdef';
var
   I : integer;
   Str : string;
   BitsToShift: byte;
   Chr : char;
   rem : byte;
begin
   Str := '';
   for I := 7 downto 0 do
   begin
      BitsToShift := I*4;
      Chr := HEXChars[ (Number shr BitsToShift) and $F];
      if not ((Str = '') and (Chr = '0')) then
         Str := Str + Chr;
   end;
   while length(str) < 8 do str := '0' + str;
   HexStr := Str;
end;

Function Upper(s : String) : String;
Var
   s2 : String;
   x : Word;
Begin;
   s2 := '';
   For x := 1 To Length(s) Do s2 := s2 + UpCase(s[x]);
   Upper := s2;
End;

Function ArrayCompare(s : String; a : Array Of Char; offset : Word) : Boolean;
Var
   match : Boolean;
   y : Word;
Begin;
   match := True;
   For y := 1 To Length(s) Do If s[y] <> a[offset + y - 1] Then match := False;
   ArrayCompare := match;
End;

Function LeftOf(s,s2 : String) : String;
{ Return the string to the left of the specified substring }
Begin;
   LeftOf := Left(s,Pos(s2,s));
End;

Function RightOf(s,s2 : String) : String;
{ Same thing, but to the right }
Begin;
   RightOf := Right(s,Pos(s2,s) + Length(s2) - 1);
End;

End.
