:userdoc.
:docprof toc=1234.
:title.FleetStreet anvndarhandbok

.***************************************************************************
.* Einfhrung - inledning
.* 1997-10-22
.* @1@

:h1.Allmnt
:p.
:lines align=center.
Vlkommen till

:font facename='Tms Rmn' size=24x18.:color fc=red.
FleetStreet 1.27.1
:font facename=default size=0x0.:color fc=default.
:elines.
:p.
FleetStreet r en FTS-kompatibel meddelanderedigerare fr OS/2 2.x PM.
FleetStreet kan bearbeta meddelandebaser i *.MSG-, Squish och JAM-format.
:elines.
:p.
:p.
Denna dokumentation beskriver konfigurationen av Fleetstreet och
grundlggande anvndning av programmet. Detaljerad information om
FleetStreets olika dialogrutor hittar Du i programmets onlinehjlp. Denna
dokumentation och onlinehjlpen kompletterar varandra.
:p.
Denna dokumentation frutstter att Du redan har grundlggande kunskaper i
Fidonet eller Fidokompatibla nt.
:p.
Open Source version
:p.
versttning (C) Copyright 1995-1998 Peter Karlsson

.***************************************************************************
.* Features - funktioner
.* @2@
.*
:h2.Funktioner
:p.
Funktioner i FleetStreet&colon.
:ul compact.
:li.OS/2 2.x/3.x PM-program
:li.100% 32-bitars-kod
:li.Optimierad fr Pentium-processorer
:li.Multitrdad
:li.WPS-liknande anvndargrnssnitt
:li.Anvndning via
:ul compact.
:li.menyer
:li.snabbtangenter
:li.knapprad (valbar position, tv storlekar)
:eul.
:li.Enkelt anvndande genom utfrlig onlinehjlp samt hjlptexter i
statusraden
:li.Standardfunktioner som
:ul compact.
:li.lsa meddelanden
:li.skriva meddelanden
:li.ta bort meddelanden
:li.frndra meddelanden
:li.kopiera meddelanden
:li.flytta meddelanden
:li.vidaresnda meddelanden
:li.svara p meddelanden
:li.exportera meddelanden
:li.importera ASCII-texter till meddelanden
:eul.
:li.Stder fljande meddelandebasformat&colon.
:ul compact.
:li.*.MSG
:li.Squish
:li.JAM
:eul.
:li.Lser in konfigurationsfiler frn
:ul compact.
:li.Squish
:li.Fastecho
:li.HPT
:li.IMail
.*:li.GEcho
:li.LoraBBS
:li.FMail
:li.TerMail
:li.WMail
:li.NewsWave
:li.BBToss
:li.ShotgunBBS
:eul.
:li.Utskrift av meddelande via PM-skrivardrivrutinen
:li.Skapar en ECHOTOSS.LOG-fil
:li.Visar meddelanden i frg
:li.Korspostar ett nytt meddelande i flera mten
:li.Skapar filbegran frn meddelanden
:li.Skriver till flera mottagare via sndlistor
:li.Snabbsndlista
:li.Kortnamnslista
:li.Stder broadcast-funktionerna hos Squish 1.1x
:li.Stder version-7-nodlistor
:li.Nodlistevisare
:li.Text kan fritt kopplas till funktionstangenterna
:li.Omdirigering av enhetsbokstver fr anvndning via ntverk
:li.Fritt definierbara meddelandemallar
:li.Komfortabel skfunktion, ven ver flera mten
:li.Skning efter personliga meddelanden
:li.Trdlista fr att lsa enligt meddelandetrd
:li.mneslista
:li.Flera instllningar fr varje mte
:li.Omvandling av nationella tecken vid skrivning
:li.Stder CHRS-kludgen
:li.Manuell markering av meddelanden
:li.Fjrrstyrning via named pipe
:li.Makroprogrammering via Rexxprogram
:li.Flerfaldiga drag-and-drop-funktioner
:li.Program och anvndarhandbok p
:ul compact.
:li.tyska
:li.engelska
:li.italienska
:li.svenska
:eul.
:eul.
:p.
&dot.&dot.&dot. och detta var bara en grov versikt &colon.-)

.* @2@ **********************************************************************
:h2.Systemkrav
:p.
FleetStreet har dessa krav p Din hrd- och mjukvara&colon.
:p.
:hp2.Hrdvara&colon.:ehp2.
:ul compact.
:li.PC som kr under OS/2 (386DX, 6 MB)
:li.ca. 1,5 MB hrddiskuttrymme, meddelandebaser tillkommer
:li.VGA-grafikkort
:eul.
:p.
:hp2.Mjukvara&colon.:ehp2.
:ul compact.
:li.OS/2 2.x/3.x (2.0 har ej testats, men borde fungera)
:eul.
:p.
:hp2.Testade mjukvarumiljer&colon.:ehp2.
:ul compact.
:li.OS/2 2.1 (diverse sprk)
:li.OS/2 2.11 (2.1 med Service Pack)
:li.OS/2 2.99 (WARP II)
:li.OS/2 Warp 3.0
:li.OS/2 Warp Connect (Peer To Peer)
:li.OS/2 Warp 4.0
:li.ZipStream 1.03 (med meddelandebas i en komprimerad katalog)
:li.LAN Server 4.0 Entry
:eul.

.***************************************************************************
.* Design Goals - designml
.* @2@
.*

:h2 id=design.Designml
:p.Vid utvecklingen av FleetStreet hade vi flera ml i bakhuvudet. Hr
nedan kan du lsa lite om dem.
:parml.
:pt.:hp2.Varfr en PM-redigerare?:ehp2.
:pd.Presentation Manager (tm) r visserligen lngsammare n textlge (s
lnge det startas som en fullskrmsapplikation), men har vissa andra
frdelar framfr dessa. Urklipp r fullt anvndbart (Urklipp i
textlgesapplikationer r ett stort problem) och anvndaren kan fritt
vlja typsnitt och frger tmligen enkelt. Dessutom r man inte begrnsad
till 80x25 (m.fl) - formatet. Frutom detta tillter PM oss att implementera
alla de dialogrutor som gr FleetStreet ltt att arbeta med.
:pt.:hp2.Integrerad setup:ehp2.
:pd.I andra redigeringsprogram mste Du arbeta med ndlsa
ASCII-konfigurationsfiler. Om Du redan r van vid att
anvnda spiralblocken och dialogrutorna i Workplace Shell kommer inte
konfigureringen av FleetStreet vlla ngra som helst problem. Dessutom
behver Du inte starta om FleetStreet bara fr att p nytt lsa in
konfigurationen.
:p.
Om Du inte vet hur en instllning fungerar, trycker du helt enkelt p F1,
eller p en av hjlpknapparna, som finns tillgngliga verallt. Detta
besparar ven den trkiga blddringen av lnga textdokumentationer.
:pt.:hp2.Support fr Squish (tm):ehp2.
:pd.FleetStreet stder tossern Squish p tv stt. Det frsta r att det
anvnder Squish' API (MSGAPI.DLL), och det andra r att FleetStreet direkt kan
lsa in Squish' konfigurationsfil (SQUISH.CFG).
:i2 refid=squish.MSGAPI.DLL
:pt.:hp2.Enkelt att anvnda:ehp2.
:pd.De flesta PM-applikationer r enkla att anvnda. Om Du kan anvnda WPS
kan Du ven anvnda FleetStreet, eftersom vi anvnder spiralblocken,
popup-menyer, "containers", osv.
:pt.:hp2.Alla funktioner Du behver:ehp2.
:pd.Vi har implementerat en hel del funktioner vi tyckt vara anvndbara frn
andra meddelanderedigerare, och drutver ngra vi inte hittade ngon
annanstans.
:pt.:hp2.Kraftfullt:ehp2.
:pd.FleetStreet r ett 32-bitars-program som anvnder multipla trdar och
CUA'91.
:eparml.


.* @2@ **********************************************************************
:h2.Copyright o.s.v.
:p.
Squish och MsgAPI r varumrken hos Lanius Corporation.
:p.
OS/2 och Workplace Shell r varumrken hos IBM.
:p.
JAM(mbp) - Copyright 1993 Joaquim Homrighausen, Andrew Milner, Mats Birch,
Mats Wallin. ALL RIGHTS RESERVED.

.* @2@ **********************************************************************
:h2.Tack
:p.
Fljande personer har speciellt bidragit till uppkomsten och
vidareutvecklingen av FleetStreet&colon.
:sl.
:li.:hp4.Harry Herrmannsdrfer:ehp4. - Echomailhantering, alfa/beta-test,
programmering
:li.:hp4.Harald Kamm:ehp4. - Italiensk versttning, italiens
registreringshantering
:li.:hp4.Jason Meaden:ehp4. - tidigare registreringshantering Australien
:li.:hp4.Helmut Renner:ehp4. - Registreringshantering och echo-link i
sterrike
:li.:hp4.Marty Duplissey:ehp4. - tidigare registreringshantering USA
:li.:hp4.Siegfried Hentschel, Jens Holm, Richard Douglas,
Jose M. Guglieri:ehp4. - Registreringshantering.
:li.:hp4.Rasmus Foged Hansen:ehp4. - tidigare registreringshantering
:li.:hp4.Peter Karlsson:ehp4. - Svensk versttning [man tackar &colon.-)]
:li.:hp4.Alla deltagare i den slutna betafasen, speciellt Michael Siebke,
Joachim Loehrl-Thiel, Hajo Kirchhoff, Robert Glckner:ehp4. m.fl.
:li.:hp4.Thomas Jachmann:ehp4. - Betatest och diverse Rexxprogram
:li.:hp4.Torsten Grimme:ehp4. - Test av IMail-stdet
:li.:hp4.Dirk Brenken:ehp4. - Test av Fastecho-stdet
:li.:hp4.Carsten Ellwart:ehp4. - Buggfinnare
:li.:hp4.speciellt tack till alla registerade anvndare:ehp4., utan vilka
shareware inte kan verleva.
:esl.
:p.
Den svenske versttaren nskar tacka:
:sl.
:li.:hp4.Bengt sterdahl:ehp4. - Fr betatestning av den frsta
versttningen, och fr all uppmuntran.
:li.:hp4.Deltagarna i R20_OS2:ehp4. - Fr vnliga svar p mina frgor om
vettiga svenska termer
:esl.

.***************************************************************************
.* Installation - Installation
.* @1@
.*

:h1.Grundinstllning
:p.
Nr Du startar FleetStreet fr frsta gngen visas meddelandet att
INI-filen inte kunde hittas. Detta r normalt i denna situation, och r
ingen skl till oro. Klicka helt enkelt p :hp2.OK:ehp2.-knappen.
FleetStreet ppnar d automatiskt de allmnna instllningarna, och Du kan
pbrja den grundlggande konfigureringen.
:p.
Den hr beskrivna grundlggande konfigureringen rcker gott fr att
installera FleetStreet i en vanlig nod- eller pointkonfiguration, och fr
att ta de frsta stegen med den. Konfigurationen kan senare nr som helst
ndras fr att anpassas till Dina speciella nskeml.
:p.
Om Du inte kommer vidare i konfiguration klickar Du helt enkelt p en av de
:hp2.Hjlp:ehp2.-knappar som finns p varje sida i instllningsblocket.

.* @2@ **********************************************************************
:h2.Namn
:p.
Nr Du skriver nya meddelanden infogar FleetStreet automatiskt Ditt namn
som avsndare.
:p.
P instllningsblockets frsta sida kan Du ange alla de namn som Du nskar
anvnda tillsammans med FleetStreet. Det frsta namnet i listan r ditt
standardnamn. Det kommer alltid frst att anges p de stllen Ditt namn
efterfrgas. Du kan gra valfritt namn ur listan till ditt standardnamn
genom att Du markerar det och klickar p :hp2.Standard:ehp2.-knappen.

.* @2@ **********************************************************************
:h2.Adresser
:p.
P den andra sidan i instllningsblocket kan Du ange samtliga ntadresser
som Du nskar anvnda tillsammans med FleetStreet. Den frsta adressen i
listan r ven hr din standardadress.

.* @2@ **********************************************************************
:h2.Tosserkonfiguration
:p.
Om Du redan har installerat en tosser som stds av FleetStreet kan Du helt
enkelt lta FleetStreet lsa in dess konfigurationsfil. FleetStreet lser
drur samtliga definierade adresser, mten och kataloger, s att Du inte
behver ange dina meddelandemten ytterligare en gng, i FleetStreet.
:p.
FleetStreet kommer ven i framtiden att lsa in den angivna filen vid
uppstart. P s stt kommer mtena i FleetStreet alltid att verensstmma
med de mten du har definierade i din tosser.
:p.
Fljande tossers stds&colon.
:table cols='10 20 30'.
:row.
:c.Tosser
:c.Versioner
:c.Fil som anvnds
:row.
:row.
:c.Squish
:c.1.01, 1.10, 1.11
:c.SQUISH.CFG (eller namnet p en ekvivalent fil)
:row.
:c.Fastecho
:c.1.30, 1.41, 1.45, 1.46
:c.FASTECHO.CFG
:row.
:c.HPT
:c.?
:c.?
:row.
:c.IMail
:c.1.60, 1.70, 1.75
.* , 1.85, 1.87
:c.IMAIL.CF
:row.
:c.GEcho
:c.1.10, 1.20
:c.SETUP.GE
:row.
:c.LoraBBS
:c.2.34, 2.35, 2.40, 2.42
:c.CONFIG.DAT
:row.
:c.FMail
:c.0.98, 1.02ff
:c.FMAIL.CFG
:row.
:c.TerMail
:c.3.0
:c.TM.CFG
:row.
:c.WMail
:c.3.0
:c.WMAIL.PRM
:row.
:c.NewsWave PM
:c.0.99
:c.NEWSWAVE.INI
:row.
:c.BBToss
:c.2.06
:c.BBTOSS.CFG
:row.
:c.BBToss
:c.2.40
:c.BBTOSS.INI
:row.
:c.ShotgunBBS
:c.1.36+
:c.SYSTEM.DAT
:etable.
:p.
Aktivera hrnst instllningen :hp2."ls":ehp2. p den fjrde sidan i
instllningsblocket. Drefter vljer Du ut den nskade tossern. Klicka
drefter p knappen :hp2."Sk...":ehp2., och sk upp konfigurationsfilen.
Nr Du har hittat den klickar Du p :hp2.OK:ehp2..
:p.
FleetStreet har nu lst in filen. Drmed r grundinstllningen frdig.
Stng instllningsblocket. FleetStreet ska nu ppna den frsta mtet, och
visa det frsta meddelandet i huvudfnstret.

.* @1@ **********************************************************************
:h1.Anvndning
:p.

.* @2@ **********************************************************************
:h2 id=mainwin.Huvudfnstret
:p.
Nr Du lser meddelanden visas fljande delar i huvudfnstret&colon.
:p.
:hp2.Titelraden:ehp2.
:artwork name='titlebar.bmp' align=center.
:p.
Hr visas&colon.
:ul compact.
:li.Programmnamn och -version
:li.Aktuellt mte
:eul.
:p.
:hp2.Meddelandehuvud:ehp2.
:artwork name='header.bmp' align=center.
:p.
Hr visas&colon.
:ul compact.
:li.Namn och adress p avsndaren
:li.Namn och adress p mottagaren (adress endast i netmailareor)
:li.mnesrad
:li.Meddelandeattribut
:li.Datum och tid fr skapandet av meddelandet
:li.Datum och tid fr meddelandets ankomst
:eul.
:p.
:hp2.Knapprad:ehp2.
:p.
Knapparnas betydelse r&colon.
:parml compact break=none tsize=6.
:pt.:artwork runin name='home.bmp'.
:pd.Tillbaka till den tidigare lastreadpekaren i mtet
:pt.:artwork runin name='nextarea.bmp'.
:pd.Till nsta mte med nya meddelanden
:pt.:artwork runin name='prevmsg.bmp'.
:pd.Till fregende meddelande
:pt.:artwork runin name='nextmsg.bmp'.
:pd.Till nsta meddelande
:pt.:artwork runin name='prevreply.bmp'.
:pd.Till det meddelande p vilket det aktuella svarar
:pt.:artwork runin name='nextreply.bmp'.
:pd.Till svaret p detta meddelande
:pt.:artwork runin name='firstmsg.bmp'.
:pd.Till frsta meddelandet
:pt.:artwork runin name='lastmsg.bmp'.
:pd.Till sista meddelandet
:pt.:artwork runin name='ok.bmp'.
:pd.Spara meddelandet
:pt.:artwork runin name='cancel.bmp'.
:pd.Avbryt (spara inte) meddelandet eller ndringarna
:pt.:artwork runin name='newmsg.bmp'.
:pd.Skriv nytt meddelande
:pt.:artwork runin name='edit2.bmp'.
:pd.ndra det aktuella meddelandet
:pt.:artwork runin name='importfile.bmp'.
:pd.Importera en textfil till meddelandet
:pt.:artwork runin name='exportfile.bmp'.
:pd.Exportera meddelandet till en textfil
:pt.:artwork runin name='reply2.bmp'.
:pd.Svara p det aktuella meddelandet
:pt.:artwork runin name='printmsg.bmp'.
:pd.Skriv ut det aktuella meddelandet
:pt.:artwork runin name='find.bmp'.
:pd.Aktivera skfunktionen
:pt.:artwork runin name='msglist.bmp'.
:pd.ppna mneslistan
:pt.:artwork runin name='msgtree.bmp'.
:pd.ppna meddelandetrdet
:pt.:artwork runin name='area.bmp'.
:pd.ppna mteslistan
:pt.:artwork runin name='showkludges.bmp'.
:pd.ppna fnstret med "kludge"-raderna
:pt.:artwork runin name='delmsg.bmp'.
:pd.Ta bort det aktuella meddelandet
:pt.:artwork runin name='bookm.bmp'.
:pd.Vxla till bokmrkesfnstret
:pt.:artwork runin name='help.bmp'.
:pd.Allmn hjlp fr FleetStreet
:pt.:artwork runin name='cut.bmp'.
:pd.Kopiera markering till Urklipp, och ta sedan bort den
:pt.:artwork runin name='copy.bmp'.
:pd.Kopiera markering till Urklipp
:pt.:artwork runin name='paste.bmp'.
:pd.Infoga innehllet i Urklipp till markrens nuvarande position
:pt.:artwork runin name='copymsg.bmp'.
:pd.Kopiera det aktuella meddelandet till annat mte
:pt.:artwork runin name='movemsg.bmp'.
:pd.Flytta meddelandet till ett annat mte
:pt.:artwork runin name='fwdmsg.bmp'.
:pd.Vidarebefordra det aktuella meddelandet till annat mte
:pt.:artwork runin name='shell.bmp'.
:pd.Starta en ny kommandoprompt
:pt.:artwork runin name='script.bmp'.
:pd.Rexxprogram
:pt.:artwork runin name='browser.bmp'.
:pd.Visa innehllet i nodlistan/-listorna
:pt.:artwork runin name='request.bmp'.
:pd.Efterfrga filer frn det aktuella meddelandet
:pt.:artwork runin name='catchup.bmp'.
:pd.Markera alla meddelanden som "lsta"
:eparml.
:p.
:hp2.Statusrad:ehp2.
:artwork name='statline.bmp' align=center.
:p.
Hr visas (frn vnster till hger)&colon.
:ul compact.
:li.Hjlptexter, meddelanden
:li.Markeringstecken (nr meddelandet r markerat)
:li.Markrposition (endast vid skrivning)
:li.Infognings-/verskrivningslge (endast vid skrivning)
:li.Nummer p det aktuella meddelandet, antal meddelanden i mtet
:li.Aktuell adress
:eul.

.* @2@ **********************************************************************
.* :h2.Lesen
.* :p.
.* ---> Lsa meddelanden


.* @2@ **********************************************************************
:h2 id=writemsg.Skriva meddelanden
:p.Det finns tv stt att skapa nya meddelanden p&colon.
:parml.
:pt.:hp2.Skriva nytt meddelande:ehp2.
:pd.Nr du vill skriva ett nytt meddelande klickar du p knappen
:artwork name='help01.bmp' runin. eller trycker p INS.
Meddelandefnstret rensas, och din avsndaradress lggs in i motsvarande
avsndarflt. Du kan nu skriva in mottagarnamnet, dennes ntadress (se ven
:link reftype=hd refid=enteraddr."Skriva in FTN-adresser":elink.) och
mnesraden. Efter att Du gjort detta skriver du in texten i
meddelandefnstret.
:p.Nr Du r klar med ditt meddelande klickar du p knappen
:artwork name='help04.bmp' runin. eller trycker p tangenterna Ctrl-S.
Meddelandet kommer d att sparas i Din meddelandebas. Du kan under
inskrivningen klicka p :artwork name='help05.bmp' runin. eller trycka p
Esc-knappen fr att avbryta inskrivningen utan att spara.
:pt.:hp2.Svara p ett meddelande:ehp2.
:pd.Fr att svara p ett mottaget meddelande klickar Du p knappen
:artwork name='help03.bmp' runin. eller trycker p Ctrl-R, eller Ctrl-N om
Du vill svara i ett annat mte (ex.vis privata brev). Om Du anvnder
knappradsknappen kan Du nu vlja om Du vill svara till avsndaren eller
mottagaren av meddelandet. Du har ocks mjligheten att vlja att svara p
meddelandet i ett annat mte.
:p.Nr Du r klar med ditt meddelande klickar du p knappen
:artwork name='help04.bmp' runin. eller trycker p tangenterna Ctrl-S.
Meddelandet kommer d att sparas i Din meddelandebas. Du kan under
inskrivningen klicka p :artwork name='help05.bmp' runin. eller trycka p
Esc-knappen fr att avbryta inskrivningen utan att spara.
:eparml.

.* @2@ **********************************************************************
:h2 id=changemsg.ndra meddelanden
:p.Du kan ndra meddelanden efter det att de har sparats. Klicka p knappen
:artwork name='help06.bmp' runin. fr att redigera om Ditt meddelande. Du
kan ndra bde meddelandetext och -huvud.
:p.Fr att ndra p attributen klickar Du p :hp2.ndra:ehp2.-knappen. Ett
dialogfnster kommer att ppnas, i vilket Du kan stta p eller stnga av
de olika meddelandeattributen.
:p.Nr Du frsker ndra ett meddelande som redan har snts, eller som inte
r lokalt fr Du ett varningsmeddelande.
:p.Klicka p knappen :artwork name='help04.bmp' runin. fr att spara
ndringarna. Om Du nskar avbryta utan att spara ndringarna klickar Du p
knappen :artwork name='help05.bmp' runin.&dot.

.* @2@ **********************************************************************
:h2.Ta bort meddelanden
:p.
Du kan ta bort ett meddelande p fljande stt&colon.
:ul.
:li.Tryck p :hp2.Delete:ehp2.-tangenten. Efter en kontrollfrga kommer
meddelandet att tas bort.
:li.Klicka p raderingsknappen p :link reftype=hd refid=mainwin.knappraden:elink..
:li.Dra det aktuella meddelandet till tuggen. Brja med dragningen frn
meddelandefnstret.
.br
:artwork align=center name='shredmsg.bmp'.
:eul.
:p.
Meddelanden kan ven raderas frn :link reftype=hd refid=msglist.mneslistan:elink.,
:link reftype=hd refid=threadlist.trdlistan:elink. eller
:link reftype=hd refid=bookmarks.bokmrkeslistan:elink..

.* @2@ **********************************************************************
:h2.Skriva ut meddelanden
:p.Du kan skriva ut det aktuella meddelandet p fljande stt&colon.
:ul.
:li.Tryck p tangentkombinationen :hp2.Skift-PrintScreen:ehp2.
:li.Klicka p utskriftsknappen p :link reftype=hd refid=mainwin.knappraden:elink..
:li.Dra ett meddelande till skrivarobjektet. Brja med dragningen ver
meddelandefnstret.
:eul.
:p.
Meddelanden kan ven skrivas ut frn :link reftype=hd refid=msglist.mneslistan:elink.,
:link reftype=hd refid=threadlist.trdlistan:elink. eller
:link reftype=hd refid=bookmarks.bokmrkeslistan:elink..

.* @2@ **********************************************************************
:h2.Mteslista
:p.
Mteslistan innehller alla de mten, som r tillgngliga fr
FleetStreet. Du kan vxla till ett av dessa mten, skapa och ta bort mten,
samt stlla in mtenas attribut.
:p.
Klicka p ett av mtena, eller tryck p :hp2.Enter:ehp2., fr att vxla till
detta mte.
:p.
Tryck p :hp2.Avsk:ehp2., fr att starta en avskning av samtliga mten. Detta
kan vara ndvndigt om tossern har "tossat" (packat upp) nya meddelanden
efter det mtena senast avsktes. Avskningen sker i en separat trd,
vilket betyder att Du kan fortstta att lsa meddelanden under tiden
avskningen genomfrs i bakgrunden.
:p.
Se ven&colon.
:ul compact.
:li.:link reftype=hd refid=areacon.Mteslistans innehll:elink.
:li.:link reftype=hd refid=areacrea.Skapa och radera mten:elink.
:li.:link reftype=hd refid=areaset.Stlla in mtenas attribut:elink.
:li.:link reftype=hd refid=arealistset.Anpassa mteslistan:elink.
:li.:link reftype=hd refid=areafolders.Mtesmappar:elink.
:eul.

.***************************************************************************
.* Area List settings - Mteslisteinstllningar
.*
:h3 id=areacon.Mteslistans innehll
:p.
Fr varje mte i listan kommer
:ul compact.
:li.mtesbeskrivningen,
:li.antal meddelanden i mtet, samt
:li.antal :link reftype=fn refid=unrmsg.olsta meddelanden:elink. i mtet
:eul.
:fn id=unrmsg.
:p.Egentligen r inte det hr det :hp2.verkliga:ehp2. antalet olsta
meddelanden, det r helt enkelt antal meddelanden efter det som senast
lstes.
:efn.
:p.
att visas.
:p.
Fr ej avskta mten visas "-" i stllet fr antal meddelanden.
:p.
Mtesbeskrivningen r frn brjan samma som mtestagen. Mtesbeskrivningen
visas i huvudfnstret och kan :link reftype=fn refid=desccha.ndras:elink..

:fn id=desccha.
:p.Detta kan gras i instllningsblocket fr mtet, eller genom att Du
klickar p mtesnamnet med vnstra musknappen samtidigt som Du hller nere
Alt-tangenten. Du kan d direkt redigera mtesbeskrivningen.
:efn.


:h3 id=areacrea.Skapa och radera mten
:p.
:hp2.Skapa ett nytt mte:ehp2.
:p.
Du kan skapa ett nytt mte genom att vlja :hp2."Skapa ny":ehp2. i
tillgsmenyn. D ppnas ett tomt instllningsspiralblock. Fyll i alla
ndvndiga flt och stng spiralblocket. Den nya arean kommer d att fogas
in i mteslistan.
:p.
Alla mten som skapas i FleetStreet r :hp2.lokala mten:ehp2..

:p.
:hp2.Ta bort ett mte:ehp2.
:p.
Du kan endast ta bort de mten Du har skapat i FleetStreet. De som r
definierade i tosserns konfigurationsfil mste tas bort drifrn.
:p.
Fr att ta bort ett mte ppnar Du :link reftype=fn refid=areacon.mtets
tillgsmeny:elink. och vljer :hp2."Ta bort":ehp2.. Mtet tas d bort ur
mteslistan.

:fn id=areacon.
:p.Klicka med den hgra musknappen p mtet.
:efn.
:p.
Observera&colon. Filerna fr arean
.* (*.MSG fr *.MSG-areor, *.SQ? fr Squishareor och .*JH? fr JAM-areor)
kommer :hp2.inte:ehp2. att tas bort frn hrddisken.

:h3 id=areaset.Stlla in mtenas attribut
:p.
Varje mte har sin egen uppsttning attribut. Dessa r&colon.
:ul compact.
:li.Mtesbeskrivning
:li.Mtestag
:li.Standardanvndarnamn
:li.Standardadress
:li.Skvg
:li.Areaformat
:li.Mtestyp
:li.Standardmeddelandeattribut
:li.Ytterligare instllningar
:eul.
:p.
Nr det gller areror som r definierade i tosserns konfigruationsfil, kan
Du inte ndra mtestag, standardadress, skvg, areaformat eller
net/echomail-val.
:p.
Fr att ndra mtesattributen ppnar Du mtets tillgsmeny och vljer
:hp2."Instllningar":ehp2..

:h3 id=arealistset.Anpassa mteslistan
:p.
Sjlva mteslistan har ven den diverse attribut, vilka har inflytande p
dess utseende. Fr att ndra dessa ppnar du mteslistans tillgsmeny och
vljer :hp2."Instllningar":ehp2..
:p.
Hr kan du vlja&colon.
:ul compact.
:li.standardvisning
:li.sortering
:li.frgerna som anvnds fr de olika mtestyperna.
:eul.

:h3 id=areafolders.Mtesmappar
:p.
Mten kan grupperas i mappar. En mapp r ppen t gngen. Mteslistan visar
bara mtena i den aktuella mappen.
:p.
Det finns en :hp2.standardmapp:ehp2. som har ngra speciella
egenskaper&colon.
:ul compact.
:li.Den r hgst i mapphierarkin. Alla andra mappar grupperas under denna.
:li.Den kan inte tas bort eller flyttas.
:li.Mten som inte har flyttats till ngon mapp (d.v.s. nya mten lsta
frn tosserkonfigurationen) hamnar i standardmappen.
:eul.
:p.
Mtesmappar har flera instllningsmjligheter&colon.
:ul compact.
:li.Ett namn. Du kan ndra det genom att ALT-klicka p det.
:li.En sorteringsordning fr mten inom mappen.
:li.En instllning fr automatisk avskning.
:eul.
:p.
Du kan skapa nya eller ta bort existerande mappar genom att anvnda
tillggsmenyn. Du kan flytta mappar genom att dra dem till en annan mapp.
:p.
Mten kan flyttas till en mapp genom att dra det till mappen.

.***************************************************************************
.* Message liste - mneslista
.* @2@
:h2 id=msglist.mneslista
:p.
mneslista visar samtliga meddelanden i mtet. Meddelandena kommer att
visas i samma ordning som de str i meddelandebasen.
:p.
Ditt egen namn kommer att visas i en avvikande frg. Lsta och olsta
meddelanden har sina meddelandenummer i olika frger. De exakta frgerna
kan stllas in i mneslistans instllningsfnster.
:p.
Du kan vlja flera meddelanden med musen eller med tangentbordet och
manipulera dessa. Dessa manipulationsmjligheter finns&colon.
:ul compact.
:li.Ta bort
:li.Kopiera
:li.Flytta
:li.Skriv ut
:li.Exportera
:eul.
:p.
Om det uppstr ett fel vid lsning av ett meddelande frn meddelandebasen,
kommer samtliga flt att visa en :hp2."*":ehp2..
:p.
Du kan flytta spaltavskiljaren, fr att stlla in bredden p spalterna.
:p.
:artwork align=center name='movesepa.bmp'.

.***************************************************************************
.* Threadlist - Trdlista
.* @2@
.*
:h2 id=threadlist.Trdlistan
:p.
Hr visas meddelandetrdet fr det aktuella mtet. Lsta och olsta
meddelanden visas i olika frger.
:p.
Trd r meddelanden i ett mte vilka hnger samman p stt, att ett
meddelande r svar p ett annat meddelande, eller att det sjlv har svar.
Om ett meddelande i trdlistan har svar visas ett :artwork name='plus.bmp'
runin. framfr det. Du kan klicka p :artwork name='plus.bmp'
runin.-tecknet med musen eller trycka p :hp2.+:ehp2.-tangenten. Svaren
kommer d att visas i en trdstruktur. :artwork name='plus.bmp'
runin.-tecknet kommer d att bytas ut mot ett :artwork name='minus.bmp'
runin.&dot. Om du trycker p :hp2.mellanslagstangenten:ehp2. kommer hela
trdstrukturen att komprimeras (d.v.s. bara "roten" visas).
:p.
Se ven&colon.
:ul compact.
:li.:link reftype=hd refid=thdisp.Visningstyper:elink.
:li.:link reftype=hd refid=thmani.Manipuleringsmjligheter:elink.
:li.:link reftype=hd refid=thlink.REPLY-lnkare:elink.
:li.:link reftype=hd refid=markmsg.Markera samtliga meddelanden:elink.
:eul.

:h3 id=thdisp.Visningstyper
:p.
Det finns tre olika visningstyper&colon. Alla trd, trd med olsta
meddelanden, och endast olsta meddelanden.
:parml.
:pt.:hp2.Alla trd:ehp2.
:pd.Alla trd i mtet visas i sin fullstndiga form.

:pt.:hp2.Trd med olsta meddelande:ehp2.
:pd.Endast de trd som har minst ett olst meddelande visas. Dessa
trd visas i sin fullstndiga form.

:pt.:hp2.Endast olsta meddelanden:ehp2.
:pd.Endast de olsta meddelandena visas. Om flera olsta meddelanden skapar
ett helt meddelandetrd, kommer de att visas som en sdan. Om ett trd
avbryts av ett lst meddelande kommer delarna att visas som tv olika trd.
:eparml.
:p.
nskad visningstyp vljs i trdlistans tillggsmeny. Standardvisningen
stller du in i instllningarna fr trdlistan.
:p.

:h3 id=thmani.Manipuleringsmjligheter
:p.
Om Du manipulerar meddelanden i trdlistan manipulerar du alltid
:hp2.trd:ehp2. eller :hp2.delar av trd:ehp2.. Det betyder att inte bara
ett enda meddelande manipuleras, utan ven alla p det fljande svar.
:p.
"Syster"-trd, eller meddelanden fre det markerade meddelandet kommer dock
:hp2.inte:ehp2. att manipuleras.
:p.
Endast ett trd kan vid varje given tidpunkt manipuleras. Detta r en
begrnsning hos OS/2.
:p.
Du kan
:ul compact.
:li.Ta bort trd
:li.Flytta trd till ett annat mte
:li.Kopiera trd till ett annat mte
:li.Exportera trd till en fil
:li.Skriva ut ett trd
:li.Markera ett trd som "lst"
:li.Expandera ett trd
:eul.

:h3 id=thlink.REPLY-lnkare
:p.
FleetStreet utvrderar endast den lnkinformation som str att finna i
meddelandebasen, och lnkar allts inte sjlvmant. Fr lnkningen mste Du
anvnda ett externt program, vilket lmpligen anropas direkt efter
tossning av meddelanden i ett kommandoprogram ("batchfil").
:p.
REPLY-lnkare r bl.a.&colon.
:ul compact.
:li.Squish
:li.SqmLink
:li.SqLink
:li.QQLink
:eul.
:p.
Squish 1.01 lnkar meddelanden m.h.a mnesraden. Detta har frdelen att
ven meddelanden utan MSGID/REPLY-kludge lnkas. En nackdel r dock att om
mnesraden ndras s kan det inte lngre lnkas till det brev p vilket det
svarar. Det gr inte heller att p trdstrukturen se vem det r som svarar
p vilket brev, eller om ett meddelandet har mer n ett svar (svaren lnkas
alltid linjrt).
:p.
Squish 1.10, SqmLink, SqLink och QQLink lnkar meddelandena m.h.a
MSGID/REPLY-kludgarna. D kan verkligen ett meddelande kopplas samman med
det p vilket det svarar, samt med de som svarar p det. Trden r ej
heller lngre linjra, utan mer trdartade. Squishmeddelandebasformatet
tillter att ett meddelande maximalt har 10 svar lnkade till det.
:p.
Nackdelen med denna metod r att meddelanden inte kan kopplas samman om
svaret inte innehller ngon REPLY-kludge (t.ex om det skrivits med en
QWK-lsare, om det kommit via ngon typ av gateway, eller om REPLY-kludgen
inte riktigt hller sig till standarden).


:h3 id=markmsg.terhmta
:p.Om du tidigare inte anvnt FleetStreet fr att lsa en speciell
meddelandebas, kommer nstan alla meddelanden att vara markerade som
"olsta". Drfr kommer alla meddelanden att visas i mneslistan. Efter det
att du utfrt denna funktion kommer endast de meddelanden som verkligen r
olsta att visas, d.v.s. meddelanden som tossas in i mtet av tossern
senare.
:p.Denna funktion r vanligtvis bara behvlig efter det att Du har bytt
till FleetStreet och vill uppdatera de gamla meddelandemtena till nyaste
lget. FleetStreet kommer i framtiden att hantera "olst"-attributet helt
automatiskt.

.* @2@ **********************************************************************
:h2 id=bookmarks.Bokmrken
:p.Bokmrkesfnstret kan innehlla tre typer av meddelanden&colon.
:ul compact.
:li.Skresultat
:li.Resultat av skning av personliga brev
:li.Markerade meddelanden
:eul.
:p.
Anvnd listans tillgsmeny fr att vxla mellan de tre visningstyperna.
:p.
Om du vljer "Spara innehll" i tillgsmenyn kommer innehllet i listan att
sparas p hrddisken nr Du avslutar FleetStreet. Den kommer att laddas in
igen nr du startar FleetStreet p nytt nsta gng.
:p.
Klicka p ett meddelande, eller tryck p :hp2.Till meddelande:ehp2.-knappen
fr att visa hela meddelandet.
:p.
Tryck p knappen :hp2.Ta bort alla:ehp2. fr att nollstlla den aktuella
visningen, d.v.s. alla meddelanden i den aktuella visningen tas bort ur
listan.
:p.
Anvnd tillgsmenyn hos ett meddelande fr att
:ul compact.
:li.ta bort meddelandet
:li.exportera meddelandet
:li.skriva ut meddelandet
:li.flytta meddelandet till ett annat mte
:li.kopiera meddelandet till ett annat mte
:li.ta bort meddelandet ur listan
:eul.

.* @2@ **********************************************************************
:h2.Skfunktion
:p.Med skfunktionen kan meddelanden i ett eller flera mten avskas efter
en bestmt teckenkombination.
:p.Skdialogrutan ppnas bl.a via menyvalet "Meddelande/Sk". Ange sedan
den efterskta texten, och alla nskade skval. Med knappen "Start" kommer
skningen att startas. Skningen sker i bakgrunden. Varje gng ett mte har
genomsks kommer skresultaten att lggas in i
:link reftype=hd refid=bookmarks.bokmrkeslistan:elink. (i visningstypen
"Skresultat").
:p.Med skdialogen startas ven skningen efter personliga meddelanden.
Skresultatet kommer ven det att lggas in i bokmrkeslistan (i
visningstypen "Personliga meddelanden").

.* @1@ **********************************************************************
:h1.Avancerade funktioner

.* @2@ **********************************************************************
:h2 id=enteraddr.Skriva in FTN-adresser
:p.Nr du skriver meddelanden i netmailmten mste Du ange mottagarens
ntadress. Detta sker vanligen genom att Du matar in dennes kompletta 3D- resp.
4D-adress.
:p.FleetStreet lter Dig ven ange ofullstndiga adresser. De delar som
saknas kommer automatiskt att ersttas med motsvarande delar ur Din egen
adress.
:p.Fljande exempel visar hur denna adresskomplettering fungerar. Som
standardadress anvnds 2&colon.2490/2520.17&colon.
:table cols='12 15 30'.
:row.
:c.Angivet
:c.Resultat
:c.Kommentar
:row.
:c.2&colon.2490/2520
:c.2&colon.2490/2520
:c.3D-adress matades in
:row.
:c.2520
:c.2&colon.2490/2520
:c.Nodnummer inmatat, nt &amp. zon kopierades
:row.
:c.247/2099
:c.2&colon.247/2099
:c.Nt &amp. nod inmatades, zon kopierades
:row.
:c.1030.42
:c.2&colon.2490/1030.42
:c.Nod &amp. punkt angavs, zon &amp. nt kopierades
:row.
:c..42
:c.2&colon.2490/2520.42
:c.Punkt angavs, samma bossnod
:etable.
:p.:hp2.De globala reglerna r&colon.:ehp2.
:ol.
:li.Ett ensamt tal gller som "nod".
:li.Om inget punktnummer anges kommer "0" automatiskt att fyllas i.
:eol.

.* @2@ **********************************************************************
:h2.Knappraden
:p.Knappraden i FleetStreet kan visas i tv olika storlekar p fyra olika
platser. Dessa instllningar stller du in med hjlp av knappradens
tillggsmeny. ppna denna genom att klicka med musknapp 2 (vanligen den
hgra) p ett tomt utrymme inom knapprades omrde.


.* @2@ **********************************************************************
:h2.Mteshanteraren
:p.Mteshanteraren r till fr frenklad kommunikation med
mteshanterarprogrammet hos Din upplnk.
:p.Vanligtvis bestller man echomailmten genom att man skickar ett netmail
till upplnkens mteshanteringsprogram. I detta innehller mtesraden
lsenordet, och meddelandetexten innehller namnen p de nskade mtena.
:p.Man kan ven p ett liknande stt avbestlla mten igen, och ven begra
en lista ver frfogbara mten, m.m.
:p.FleetStreets mteshanterare frenklar denna procedur&colon.
:ul compact.
:li.Man behver inte ha namnet, adressen och lsenordet fr mteshanteraren tillgnligt,
:li.Man kan p ett enkelt stt via tillggsmenyer bestlla resp. avbestlla mten,
:li.Meddelanden till mteshanteraren kommer att skapas automatiskt,
:li.De bestllda mtena lggs in i tosserns konfigurationsfil.
:eul.

:h3.Lista ver mten
:p.Fr att mteshanteraren ska fungera behver den en lista ver de mten
som finns tillgngliga hos Din upplnk. Om denna saknas, mste den manuellt
begras via ett meddelande till upplnken.
:p.Svaret frn mteshanteraren innehller en lista ver echomailmten.
Dessa mste nu verfras i FleetStreets mteshanterare. Fr att gra det
vljer man menyvalet "Alternativ/Hmta mtestitlar". FleetStreet genomsker
nu det aktuella meddelandet efter mtesnamn och anvnder dessa i sin
mteshanterare.
:p.FleetStreet sparar undan avsndaradressen fr varje mteslista. Nr
mtestitlarna hmtas och det redan finns en lista fr denna avsndare,
kommer den gamla listan att ersttas med den nya. Annars kommer avsndaren
att infogas som en ny upplnk.

:h3.Konfiguration
:p.Fr att kommunicera med mteshanteraren hos upplnken krvs dess namn
och adress. ppna frst FleetStreets mteshanterare, sedan listans
tillggsmeny och dr vljer Du "Instllningar". P instllningsblockets
frsta sida finns en lista ver knda upplnkar. Du kan fr var och en av
dessa infoga namn och lsenord fr deras mteshanterare.
:p.
:hp8.Observera&colon.:ehp8. Posterna fr namn och lsenord krvs fr att Du
senare ska kunna anvnda FleetStreets mteshanterare.

:h3.Anvnda mteshanteraren
:p.Fr att bestlla eller avbestlla mten med hjlp av FleetStreets
mteshanterare gr du som fljer&colon.
:ol.
:li.Stll som aktuell adress in den adress med vilken Du vill skriva till
upplnken. Om Du har flera upplnkar resp. nt, och har separata
netmailmten fr varje upplnk vxlar du till motsvarande netmailmte.
:li.ppna FleetStreets mteshanterare via menyn. Nu ska upplnkes
mteslista visas. Om listan r tom mste Du frst manuellt begra en lista
frn upplnken.
:li.ppna tillggsmenyn fr det mte Du vill bestlla, och vlj
:hp2."bestll":ehp2..
:li.Om Du vill bestlla eller avbestlla fler mten gr Du p samma stt.
De nskade kommandona visas p samma rad som mtestitlarna.
:li.Klicka p :hp2.OK:ehp2. s skapas det netmailbrev som ska skickas till
upplnken.
:eol.

:h3.Utknings-DLL
:p.Squish kan inte automatiskt lgga in mten i sin konfigurationsfil.
Drfr kan FleetStreet ladda en DLL vid bestllning eller avbestllning av
mten, och anropa funktioner frn den. DLL&colon.en kan sedan lgga in
mtena t Dig.
:p.
Vilken DLL som ska anvndas kan stllas in i mteshanterarens
instllningsblock.
:p.
Filen :hp2.FLTCF_SQ.DLL:ehp2. som kommer med FleetStreet kan anvndas som
utknings-DLL nr (och endast nr) Du anvnder Squish som tosser,
tillsammans med en standard-SQUISH.CFG. Fr andra konstellationer (ex.vis
pointpaket, andra tossers osv.) finns ev. motsvarande DLL&colon.er frn
tredjepartsleverantrer till frfogande.
:p.
Teknisk information om hur du skapar en utknings-DLL kan fs frn
:link reftype=hd refid=support.frfattaren:elink..


.* @2@ **********************************************************************
:h2 id=cclists.Anvnda sndlistor
:p.Att anvnda en sndlista innebr att samma meddelande skickas
till mer n en mottagare (p engelska kallas detta vanligen "carbon copy").
Sndlistor kan endast anvndas i netmail.
:p.Ponera fljande exempel&colon.
:p.Du sammanstller ett nyhetsbrev, vilket Du regelbundet skickar till ett
antal personer. Fr att lsa denna uppgift med FleetStreet kan kan Du skapa
en sndlista med namnet "Newsletter". Nr Du gjort detta skriver
Du in alla personer som ska ta emot nyhetsbrevet i listan.
:p.Nr Du nu vill skicka nyhetsbrevet via netmail sammanstller Du ditt
brev, p precis samma stt som Du skulle gjort det vanligtvis. Men istllet
fr att skriva in en mottagare vljer Du :hp2.Skicka med sndlista:ehp2.
frn menyn. Nu kan Du vlja sndlistan "Newsletter" som Du skapade
tidigare. Texten "*** Newsletter ***" kommer att visas i stllet fr
mottagarnamnet, vilket visar att Du anvnder denna sndlista.
:p.Nr nsta utgva av nyhetsbrevet kommer ut behver Du inte skapa ngon
ny sndlista, Du kan enkelt anvnda den Du tillverkade tidigare.

:h3.Frvalta sndlistor
:p.Alla sndlistor finns i sndlistefnstret. Denna kan
ppnas frn meny via :hp2."Alternativ/Sndlistor":ehp2..
Sndlistorna visas dr som ikoner.
:p.Anvnd listornas tillggsmenyer fr att ta bort eller skapa en ny lista.
Du kan ppna en lista, fr att visa och redigera innehllet, genom att
dubbelklicka p den.
:p.Hll nere Alt-tangenten och klicka p en sndlista fr att
ndra dess namn.

:h3.Importera
:p.Vlj den fil som Du ska importera. Filen mste vara en textfil, och
mste ha fljande format&colon.
:ul compact.
:li.Varje rad innehller precis ett namn och en adress
:li.Fltena p en rad mste avdelas av minst ett mellanslag
:li.Tomrader ignoreras
:li.Rader med inledande semikolon ignoreras
:li.Rader med ogiltigt format ignoreras.
:eul.
:p.
Exempel&colon.
:xmp.
; Kommentar
Michael Hohner 2&colon.2490/2520.17
Hans Dampf 1&colon.234/567
Peter Karlsson 2&colon.204/145.42
:exmp.

:h3.Snabbsndlista
:p."Normala" sndlistor sparas undan, och str alltid till Ditt
frfogande. Detta r dock inte alltid nskvrt. Drfr finns funktionen
:hp2."Snabbsndlista":ehp2. i menyn :hp2."Special":ehp2..
:p.Snabbsndlistan fungerar i princip likadant som de normala
sndlistorna, frutom att den skapas frst vid skrivning av det
meddelande som ska sndas till flera mottagare. Dessutom kommer den inte
att sparas efter det att meddelandet har sparats.

.* @2@ **********************************************************************
:h2 id=crosspost.Korspostning av meddelanden
:p.Korspostning betyder, att samma meddelande sparas i mer n ett mte.
:p.Du kan aktivera korspostning genom att vlja :hp2.Korsposta:ehp2. i
menyn. Denna funktion r bara tillgnglig d Du skriver ett meddelande.
:p.Mteslistan kommer att ppnas, och Du kan drur vlja mten i vilka Du
nskar spara meddelandet.
:p.:hp8.Observera&colon.:ehp8. Du ska inte vlja det aktuella mtet i
listan. Meddelandet kommer alltid att sparas i det aktuella mtet. Vlj
helt enkelt bara vriga mten.
:p.Nr korspostningslget r aktivt kommer det att visas med en bock
framfr :hp2.Korsposta:ehp2. i menyn.
:p.Du kan sl av korspostningslget igen genom att Du vljer
:hp2.Korsposta:ehp2. frn menyn en gng till. Bocken kommer d att
frsvinna, vilket betyder att Du r i det vanliga redigeringslget igen.

.* @2@ **********************************************************************
:h2.Kortnamn
:p.I FleetStreet r det mjligt att definiera kortnamn fr de anvndare
till vilka man skriver ofta.
:p.
Fr att anvnda dessa kortnamn skriver du helt enkelt kortnamnet i
mottagarfltet och trycker p "Enter". Kortnamnet kommer d automatiskt att
ersttas med det riktiga namnet, och anvndarens adress kommer att matas in
i adressfltet. Om Du har angett en mnesrad fr kortnamnet, kommer denna
ven att infogas i mnesfltet.
:p.:hp2.Fr att definiera ett kortnamn gr Du fljande&colon.:ehp2.
:ol compact.
:li.Klicka p "Infoga"-knappen,
:li.Fyll i flten,
:li.Tryck p "Ok".
:eol.
:p.:hp2.Fr att ndra ett kortnamn gr Du fljande&colon.:ehp2.
:ol compact.
:li.Markera kortnamnet i listan,
:li.Tryck p "ndra"-knappen, eller dubbelklicka p posten,
:li.Gr nskade ndringar,
:li.Tryck p "Ok".
:eol.
:p.:hp2.Fr att ta bort ett kortnamn gr Du fljande&colon.:ehp2.
:ol compact.
:li.Vlj kortnamnet i listan,
:li.Tryck p "Ta bort"-knappen.
:eol.

.* @2@ **********************************************************************
:h2 id=nodelists.Anvnda nodlistor
:p.:hp2.Vad r de bra fr?:ehp2.
:p.Nodlistor innehller bl.a namn och ntadresser fr samtliga deltagare i
ett nt. FleetStreet kan ska upp adressen fr ett namn i en sdan
nodlista, och ven gra det motsatta.
:p.Fr att gra detta behver Du en kompilerad nodlista i formatet "Version
7". Detta format skapas bl.a av FastLst. FleetStreet behver datafilen och
sysopindexet. Nodlistekompilatorn mste stllas in p motsvarande stt.
:p.:hp2.Hur hittar FleetStreet nodlistorna?:ehp2.
:p.I instllningarna finns en sida avsedd fr nodlistor. Fr varje nodlista
mste Du skapa en "domn". En domnpost innehller domnens titel, och
skvg till nodlistefilerna. Du mste ange komplett skvg, inklusive
enhetsbokstav och filnamnstillgg.
:p.:hp2.Vad behver jag mer gra?:ehp2.
:p.Om Du vill kan Du ven ange beteckningarna fr de olika nodlisteflaggorna.
:p.:hp2.Hur kan jag anvnda nodlistan?:ehp2.
:p.Nr Du skriver ett netmail anger du mottagarens hela namn, eller en del
av efternamnet, fljt av Enter. Om namnet hittas kommer adressen direkt att
lggas in i adressfltet. Om flera snarlika poster hittas visas ett fnster
dr Du kan vlja vilken du vill anvnda.
:p.I vissa dialogfnster som krver en inmatad adress finns det ven en
"?"-knapp. Klicka p den fr att ska tillhrande adress fr det namn Du
redan skrivit in.

.* @2@ **********************************************************************
:h2 id=templates.Mall
:p.Meddelandemallar anvnds fr att stlla in ett speciellt utseende p nya
meddelanden, svar eller vidarebefordrade brev. Nr Du skriver ett nytt
meddelande, svarar eller vidarebefordrar kommer motsvarande delar av mallen
att kombineras med meddelandetexten. Speciella :link reftype=hd
refid=tokens.frkortningar:elink. i mallen kommer att ersttas med
bestmda delar av originalmeddelandet nr mallen bearbetas.
:p.Meddelandemallen bearbetas nr Du vid skapande av ett nytt meddelande,
svarande eller vidarebefordran fr frsta gngen betrder
redigeringsfnstret. Om Du innan det angett ett mne eller ett mottagarnamn
kommer dessa att anvndas som ersttning fr frkortningarna. Om de nnu
inte har definierats kommer frkortningarna att ersttas med tomrum.
:p.:hp2.Allmnn ordningsfljd&colon.:ehp2.
.br
:hp2.Nytt meddelande&colon.:ehp2.
:xmp.
[Huvudtext]
[Meddelandetext]
[Fottext]
:exmp.
:p.:hp2.Svar&colon.:ehp2.
:xmp.
[Huvudtext]
[Svarstext]
[Meddelandetext]
[Fottext]
:exmp.
:p.:hp2.Svar i annat mte&colon.:ehp2.
:xmp.
[Text fr svar i annat mte]
[Huvudtext]
[Svarstext]
[Meddelandetext]
[Fottext]
:exmp.
:p.:hp2.Korspostning&colon.:ehp2.
:xmp.
[Korspostningstext]
[Huvudtext]
[Meddelandetext]
[Fottext]
:exmp.
:p.:hp2.Sndlistetext&colon.:ehp2.
:xmp.
[Sndlistetext]
[Huvudtext]
[Meddelandetext]
[Fottext]
:exmp.
:p.:hp2.Vidarebefordran&colon.:ehp2.
:xmp.
[Text fr vidarebefordran]
[Text frn det ursprungliga meddelandet]
[Fottext fr vidarebefordran]
[Huvudtext]
[Fottext]
:exmp.
:p.:hp2.Tilldela mallar till mten:ehp2.
:p.Du kan dra en mallikon till mteslistan och slppa den p den nskade
mtestiteln. Den tilldelade mallen kommer att anvndas nr meddelanden
skapas i destinationsmtet.
:p.
:artwork align=center name='atttpl.bmp'.


:h3 id=tokens.Frkortningar
:p.Fljande frkortningar finns till ditt frfogande i
meddelandemallarna&colon.
:parml break=none.
:pt.:hp2.%T:ehp2.
:pd.Mottagarens namn (originalbrev).
:pt.:hp2.%Z:ehp2.
:pd.Mottagarens frnamn (originalbrev).
:pt.:hp2.%R:ehp2.
:pd.Mottagarens adress (originalbrev). Vid svar eller vidarebefordran av
echomail ignoreras denna frkortning.
:pt.:hp2.%O:ehp2.
:pd.Mottagarens namn (nytt brev).
:pt.:hp2.%P:ehp2.
:pd.Mottagarens frnamn (nytt brev).
:pt.:hp2.%F:ehp2.
:pd.Avsndarens namn.
:pt.:hp2.%G:ehp2.
:pd.Avsndarens frnamn.
:pt.:hp2.%J:ehp2.
:pd.Avsndarens adress.
:pt.:hp2.%A:ehp2.
:pd.Mtestag. Om ett meddelande korspostas r detta destinationsmtet. Nr Du
svarar i ett annat mte, eller om meddelandet vidarebefordras, r detta
ursprungsmtet.
:pt.:hp2.%E:ehp2.
:pd.Mtesbeskrivning. Om ett meddelande kortspost r detta destinationsmtet.
Nr Du svarar i ett annat mte, eller om meddelandet vidarebefordras, r detta
ursprungsmtet.
:pt.:hp2.%U:ehp2.
:pd.Ditt eget namn.
:pt.:hp2.%I:ehp2.
:pd.Ditt frnamn.
:pt.:hp2.%W:ehp2.
:pd.Din egen adress.
:pt.:hp2.%C:ehp2.
:pd.Namn p personerna i sndlistan.
:pt.:hp2.%D:ehp2.
:pd.Datum fr det meddelande p vilket Du svarar.
:pt.:hp2.%M:ehp2.
:pd.Tid fr det meddelande p vilket Du svarar.
:pt.:hp2.%S:ehp2.
:pd.mne p det meddelande p vilket Du svarar.
:pt.:hp2.%%:ehp2.
:pd.Ett %-tecken
:eparml.

.* @2@ **********************************************************************
:h2.Omdirigering
:p.
Om meddelandebaserna befinner sig p en annan dator i ett lokalt nt r den
nskvrt att bara ha en tosserkonfigurationsfil p den datorn att redigera.
Om denna konfigurationsfil ska anvndas i FleetStreet, och
ntverksenheterna r kopplade till andra enhetsbokstver p de olika
datorerna, kommer FleetStreet att anvnda fel enhetsbokstver vid anrop
till meddelandebaserna.
:p.
Enhetsomdirigeringen ger en lsning till problemet. Du kan omdirigera
ntverkseneheterna till andra lokala enhetsbokstver. FleetStreet erstter
d enhetsbokstverna fr ntverksenheterna med den angivna bokstaven innan
meddelandebasen anropas.
:p.
Exempel&colon.
:p.
Meddelandebasen befinner sig p dator A p enhet D&colon.. FleetStreet krs
p dator B, dr dator As enhet D&colon. befinner sig p enhet E&colon..
SQUISH.CFG befinner sig dock p dator A, s areafilnamnen r angivna med
D&colon. som enhetsbokstav.
:p.
Om FleetStreet r s installerat att enhet D&colon. erstts med enhet
E&colon. kommer enhetsbokstverna i areafilnamnen frn den SQUISH.CFG som
lses frn dator A att ndras till E&colon., och korrekta filnamn kommer
att anvndas.
:p.
Observera&colon. Bara de filnamns enhetsbokstver som lses frn SQUISH.CFG
kommer att omdirigeras. Om du skapar mten i FleetStreet mste du sjlv
ange korrekt enhet, FleetStreet omdirigerar inte dessa filnamn.

.* @2@ **********************************************************************
:h2 id=colorsetup.ndra frger och typsnitt
:i2 refid=setup.Frger och typsnitt
:p.Du kommer inte att hitta ngon meny eller dialogruta fr att ndra
frg och typsnitt fr huvudfnstret. Det beror p att FleetStreet anvnder
WPS-objekten fr att stlla in dessa saker.
:parml tsize=3.
:pt.:hp2.Frgpaletten:ehp2.
:pd.ppna frgpaletten och dra en frg till nskat element i
FleetStreetfnstret, och lt den 'falla ned' dr du vill ha den. Om det r
frgrundsfrgen som ska ndras hller du nera Ctrl-tangenten samtidigt.
:pt.:hp2.Fontpaletten:ehp2.
:pd.ppna fontpaletten och dra ett typsnitt till nskat element i
FleetStreetfnstret, och lt den 'falla ned' dr du vill ha den.
:eparml.

.* @2@ **********************************************************************
:h2.Importera, exportera
:p.
Nr Du skriver ett meddelande kan Du infoga en textfil vid den aktuella
markrpositionen.
:ul.
:li.Dra filen frn ett WPS-fnster till redigerarfnstret.
:artwork align=center name='dropfile.bmp'.
:li.Anvnd importeringsfunktionen i "Arkiv"-menyn.
:eul.
:p.
Vid lsning kan Du skriva meddelandet till en vanlig textfil.
:ul.
:li.Dra meddelandet till ett WPS-fnster. Brja dragningen ver
meddelandefnstret.
:li.Anvnd exporteringsfunktionen i "Arkiv"-menyn.
:eul.


.* @1@ **********************************************************************
:h1.Avancerade mnen, tips
:p.
Fljande mnen kan mjligen vara intressanta, nr du har vant dig vid FleetStreet&colon.
:ul.
:li.:link reftype=hd refid=multinst.Flera instanser:elink.
:li.:link reftype=hd refid=perform.Frbttra prestanda:elink.
:li.:link reftype=hd refid=multuser.Fleranvndarfunktion:elink.
:eul.

.***************************************************************************
.* Mehrere Instanzen - Flera instanser
.* @2@
.*

:h2 id=multinst.Flera instanser
:p.
Det r mjligt att starta FleetStreet vid mer n en gng samtidigt. Om du gr
det br du beakta fljande punkter&colon.
:ul.
:li.Endast den frst startade instansen sparar sina instllningar vid
avslut. Drfr br Du endast ndra instllningarna i den frsta instansen, om
du nskar bibehlla dem.
:li.Sekundra instanser knnetecknas av en :hp2.[*]:ehp2. i sin titelrad.
:li.Det r inte mjligt att vid krning av flera instanser av FleetStreet
arbeta med olika versioner. Det r heller inte mjligt att kra en svensk och en
engelsk version samtidigt. D kommer DLL&colon.erna frn den frsta instansen att anvndas
fr alla de pfljande. Detta r en begrnsning hos OS/2. Upptrdandet hos en
sekundr instans vid anvndandet av flera versioner r ej definierat.
:li.Sekundra instanser har ingen pipe-server.
:eul.

.***************************************************************************
.* Performance - prestanda
.* @2@
.*

:h2 id=perform.Frbttra prestanda
:p.FleetStreets prestanda beror till stor del p tv olika faktorer&colon.
Prestanda hos Squish' MSGAPI, och Dina hrddiskars prestanda. Medan MSGAPI str
utanfr vrt inflytande, kan frndringar av den andra punkten frbttrea
FleetStreets sammantagna prestanda.
:p.Ngra kortfattade tips&colon.
:ul.
:li.Anvnd om mjligt meddelandebaser av Squish-typ i stllet fr *.MSG.
:li.Packa Squish-meddelandebaserna regelbundet med SqPackP. Efter en
sdan packning ligger meddelandena i meddelandebasen utan luckor, och ordnade i
stigande nummerordning.
:li.Anvnd HPFS.
:li.Exkludera mten i vilka du inte lser sjlv frn mteslistan.
Aktivera "Gm exkluderade mten".
:li.Om mjligt nr du sker efter text, sk endast i meddelandehuvudet,
inte i huvud och text.
:eul.

.***************************************************************************
.* Multi-User - Fleranvndarfunktion
.* @2@
.*

:h2 id=multuser.Fleranvndarfunktion
:p.FleetStreet kan stllas in fr att nyttjas av flera anvndare, men med vissa
begrnsningar. Fljande punkter mste beaktas fr att gra detta&colon.
:ol.
:li.Skapa en programkatalog fr FleetStreet och kopiera EXE-filen och alla
DLL&colon.er till denna katalog.
:li.Skapa en separat konfigurationsfilskatalog fr varje anvndare.
:li.Skapa ett programobjekt fr varje anvndare. Ange den kompletta skvgen
till FLTSTRT.EXE som programnamn.
:li.Skriv den :link reftype=hd refid=cmdlin.kommandoradsparameter:elink. som
anger konfigurationskatalogen fr varje anvndare, t.ex.
"-Cd&colon.\fleet\user1".
:li.FleetStreet kan nu konfigureras separat fr varje anvndare. Varje
konfigurationskatalog innehller sin egen uppsttning INI-filer.
:li.Anvnd olika lastread-offsets fr varje anvndare.
:eol.
:p.:hp2.Begrnsningar&colon.:ehp2.
:ul.
:li.Det finns bara en "lst"-flagga per meddelande, den r allts
samma fr varje anvndare.
:li."Privat"-flaggan behandlas inte p ngot speciellt stt.
:eul.

.***************************************************************************
.* Howto - Hur gr man...
.* @2@
.*
:h2.Hur gr man fr att...
:p.
Fljande avsnitt beskriver ofta anvnda procedurer, och hur man realiserar
dem med FleetStreet.

:h3.skicka filer med ett meddelande?
:p.
Filer kan skickas tillsammans med ett meddelande. Namnen p de filerna
ska st p meddelandets renderad. Flera filnamn separeras med minst ett
mellanslag. Dessutom mste Du stta attributet "Fil bifogad" fr att
tossern och mailern ska tolka mnesraden p korrekt stt.
:p.
Du kan dra filer frn valfritt WPS-fnster till renderaden fr att bifoga
dem med meddelandet. Filnamnen kommer automatiskt att lggas till, "Fil
bifogad"-attributet sttas och en sammanfattning ver de bifogade filerna
kommer att visas. Detta fungerar endast vid skrivning av meddelanden!
:artwork align=center name='attfile.bmp'.

.***************************************************************************
.* Rexx
.* @1@
.*

:h1.Rexxprogram
:p.FleetStreet kan utfra program (scripts) i sprket Rexx, vilket
medfljer OS/2. Rexxsprket har utkats med :hp2.frdefinierade
variabler:ehp2. samt extra :hp2.funktioner:ehp2..


.* @2@ **********************************************************************
:h2.Programmeringsreferens
:p.Denna referens listar samtliga :link reftype=hd refid=rexxvar.frdefinierade
variabler:elink., och extra :link reftype=hd refid=rexxfunc.funktioner:elink..
:p.Ls onlinehjlpen fr Rexx' standardfunktioner.

:h3.FleetStreetmiljn
:p.Rexxprogram som krs under FleetStreet krs inte i standardmiljn
CMD.EXE. Rexxmiljn fr program under FleetStreet heter
:hp2.FLEETSTREET:ehp2..
:p.Detta betyder, att om du anvnder ett icke-Rexx-kommando i ett
Rexxprogram kommer det att analyseras av FleetStreet. Om Du vill att
CMD.EXE ska utvrdera kommandot mste du explicit anropa CMD.EXE-miljn med
Rexxkommandot :hp2.ADDRESS:ehp2..
:p.Exempel&colon.
:xmp.
/* FELAKTIGT! */
'dir'

/* riktigt */
address CMD 'dir'

/* ocks riktigt */
address CMD
'dir'
address FLEETSTREET
:exmp.
:p.Ls Rexx' onlinehjlp fr vidare information om Rexxmiljer och
ADDRESS-kommandot.

.***************************************************************************
.* Variablen - Variabler
.*

:h3 id=rexxvar.Frdefinierade variabler
:p.Nr ett Rexxprogram startas r redan ngra variabler initierade med
vrden. Dessa variabler och deras tillhrande vrden kan anvndas i
programmet.
:p.:hp8.Observera&colon.:ehp8. Om Du i ett program ndrar vrdet p en
frdefinierade variablerna kommer inte frndringen att terspeglas i
FleetStreet, om inte du anvnder en av FleetStreets funktioner eller
kommandon som gr ndringen verksam.
:p.De frdefinierade variablerna r&colon.
:sl compact.
:li.:hp4.:link reftype=hd refid=rvar01.FleetSetup.Names:elink.:ehp4.
:li.:hp4.:link reftype=hd refid=rvar02.FleetSetup.Addresses:elink.:ehp4.
:li.:hp4.:link reftype=hd refid=rvar03.FleetSetup.Echotoss:elink.:ehp4.
:li.:hp4.:link reftype=hd refid=rvar04.FleetSetup.Tosser:elink.:ehp4.
:li.:hp4.:link reftype=hd refid=rvar05.FleetStatus.Area:elink.:ehp4.
:li.:hp4.:link reftype=hd refid=rvar06.FleetStatus.DestArea:elink.:ehp4.
:li.:hp4.:link reftype=hd refid=rvar07.FleetStatus.Name:elink.:ehp4.
:li.:hp4.:link reftype=hd refid=rvar08.FleetStatus.Address:elink.:ehp4.
:li.:hp4.:link reftype=hd refid=rvar09.FleetStatus.Mode:elink.:ehp4.
:li.:hp4.:link reftype=hd refid=rvar10.FleetStatus.Monitor:elink.:ehp4.
:li.:hp4.:link reftype=hd refid=rvar11.FleetStatus.Cursor:elink.:ehp4.
:li.:hp4.:link reftype=hd refid=rvar12.FleetMsg.Header:elink.:ehp4.
:li.:hp4.:link reftype=hd refid=rvar13.FleetMsg.Text:elink.:ehp4.
:li.:hp4.:link reftype=hd refid=rvar16.FleetMsg.Kludges:elink.:ehp4.
:li.:hp4.:link reftype=hd refid=rvar17.FleetMsg.Seenbys:elink.:ehp4.
:li.:hp4.:link reftype=hd refid=rvar14.FleetCCopy:elink.:ehp4.
:li.:hp4.:link reftype=hd refid=rvar15.NewMail:elink.:ehp4.
:esl.

:h4 id=rvar01.FleetSetup.Names
:p.Detta r en vektor med anvndarnamn. :hp4.FleetSetup.Names.0:ehp4.
innehller antal element i vektorn. :hp4.FleetSetup.Names.1:ehp4. osv.
innehller namnen.
:p.Exempel&colon.
:table cols='20 10'.
:row.
:c.Variabel
:c.Vrde
:row.
:row.
:c.FleetSetup.Names.0
:c.2
:row.
:c.FleetSetup.Names.1
:c.Joe User
:row.
:c.FleetSetup.Names.2
:c.Joe
:etable.

:h4 id=rvar02.FleetSetup.Addresses
:p.Detta r en vektor med anvndaradresser.
:hp4.FleetSetup.Addresses.0:ehp4. innehller antal element i vektorn.
:hp4.FleetSetup.Addresses.1:ehp4. osv. innehller adresserna.
:p.Exempel&colon.
:table cols='22 14'.
:row.
:c.Variabel
:c.Vrde
:row.
:row.
:c.FleetSetup.Addresses.0
:c.2
:row.
:c.FleetSetup.Addresses.1
:c.2&colon.2490/2520.17
:row.
:c.FleetSetup.Addresses.2
:c.21&colon.100/1016.17
:etable.

:h4 id=rvar03.FleetSetup.Echotoss
:p.:hp4.FleetSetup.Echotoss:ehp4. innehller namnet p filen Echotoss.Log.

:h4 id=rvar04.FleetSetup.Tosser
:p.:hp4.FleetSetup.Tosser:ehp4. innehller namnet p din tossers
konfigurationsfil.

:h4 id=rvar05.FleetStatus.Area
:p.:hp4.FleetStatus.Area:ehp4. r en grupp variabler som innehller
information om det aktuella mtet.
:p.Variablerna r&colon.
:parml.
:pt.:hp4.FleetStatus.Area.Tag:ehp4.
:pd.Mtestag
:pt.:hp4.FleetStatus.Area.Desc:ehp4.
:pd.Mtesbeskrivning
:pt.:hp4.FleetStatus.Area.File:ehp4.
:pd.Skvg och/eller filnamn fr arean
:pt.:hp4.FleetStatus.Area.Format:ehp4.
:pd.Areaformat. Vrdet kan vara ngot av "*.MSG", "Squish" eller "JAM"
:pt.:hp4.FleetStatus.Area.Type:ehp4.
:pd.Mtestyp. Vrdet kan vara ngot av "Echo", "Net", "Local" eller "Private".
:eparml.

:h4 id=rvar06.FleetStatus.DestArea
:p.:hp4.FleetStatus.DestArea:ehp4. innehller mtestag&colon.en fr det mte i
vilket svaret eller det vidarebefordrade kommer att sparas.
:p.Denna variabel r endast definierad nr ett meddelande redigeras!

:h4 id=rvar07.FleetStatus.Name
:p.:hp4.FleetStatus.Name:ehp4. innehller det fr tillfllet aktiva
anvndarnamnet.

:h4 id=rvar08.FleetStatus.Address
:p.:hp4.FleetStatus.Address:ehp4. innehller den fr tillfllet aktiva
anvndaradressen.

:h4 id=rvar09.FleetStatus.Mode
:p.:hp4.FleetStatus.Mode:ehp4. innehller aktuell programstatus. Den kan vara
ngon av fljande&colon.
:sl compact.
:li.No Setup
:li.Edit Single
:li.Edit XPost
:li.Edit CCopy
:li.Read
:li.Cleanup
:esl.
:p.Nr du redigerar ett meddelande r variabelns frsta ord "Edit". Det
andra ordet visar om det r ett enkelt meddelande, ett brev till flera
mottagare (via en sndlista, carbon copy), eller om korspostningsfunktionen
anvnds.

:h4 id=rvar10.FleetStatus.Monitor
:p.:hp4.FleetStatus.Monitor:ehp4. r "0" om inget vervakningsfnster
anvnds, och "1" om programmet utfrs i ett sdant.
:hp4.FleetStatus.Monitor:ehp4. kan anvndas direkt som ett booleiskt uttryck.

:h4 id=rvar11.FleetStatus.Cursor
:p.Nr du redigerar ett meddelande innehllre :hp4.FleetStatus.Cursor:ehp4.
tv tal, vilka beskriver den aktuella markrpositionen. Det frsta talet r
styckenumret, det andra talet r teckenpositionen inom stycket.
Exempelvis betyder "46 3" att markren r p det tredje tecknet i det
fyrtiosjtte stycket.
:p.Fljande program visar texten efter markren&colon.
:xmp.
para = word(FleetStatus.Cursor, 1)
offs = word(FleetStatus.Cursor, 2)
say substr(FleetMsg.Text.para, offs)
:exmp.
:p.
Vid lsning av meddelanden r :hp4.FleetStatus.Cursor:ehp4. ej definierat.

:h4 id=rvar12.FleetMsg.Header
:p.:hp4.FleetMsg.Header:ehp4. r en grupp variabler vilka innehller
information om huvudet (headern) fr det aktuella meddelandet.
:p.Variablerna r&colon.
:parml.
:pt.:hp4.FleetMsg.Header.Attrib:ehp4.
:pd.Meddelandeattribut, previs som p "Attrib"-raden.
:pt.:hp4.FleetMsg.Header.From:ehp4.
:pd.Avsndarens namn.
:pt.:hp4.FleetMsg.Header.FromAddress:ehp4.
:pd.Avsndarens adress.
:pt.:hp4.FleetMsg.Header.To:ehp4.
:pd.Mottagarens namn.
:pt.:hp4.FleetMsg.Header.ToAddress:ehp4.
:pd.Mottagarens adress. Frsk inte att anvnda denna variabel i ett
echomailmte!
:pt.:hp4.FleetMsg.Header.Subj:ehp4.
:pd.mnesraden.
:pt.:hp4.FleetMsg.Header.DateWritten:ehp4.
:pd.Datum och tidpunkt fr meddelandets skapelse.
:pt.:hp4.FleetMsg.Header.DateReceived:ehp4.
:pd.Datum och tidpunkt fr meddelandets tossning.
:eparml.

:h4 id=rvar13.FleetMsg.Text
:p.:hp4.FleetMsg.Text:ehp4. r en vektor med textparafrafer.
:hp4.FleetMsg.Text.0:ehp4. innehller antal element i vektorn.
:hp4.FleetMsg.Text.1:ehp4. osv. innehller meddelandets text.

:p.:hp8.Observera&colon.:ehp8. Vektorns element r :hp2.inte:ehp2.
textrader, utan stycken. Ett stycke i originaltexten avslutas med ett
radbrytningstecken. Om Du exempelvis genom infogning eller borttagning
ndrar ord kan texten ombrytas korrekt igen. Om Du behver ett eget format
med en bestmt radlngd mste Du programmera egna funktioner fr
radombrytning. Detta borde vara ganska enkelt i Rexx.

:h4 id=rvar16.FleetMsg.Kludges
:p.:hp4.FleetMsg.Kludges:ehp4. r en vektor vilken innehller meddelandets
"kludgar". Vektorn r endast definierad vid lsning av meddelanden.
:p.
:hp4.FleetMsg.Kludges:ehp4.' flt r som fljer &colon.
:parml.
:pt.:hp2.FleetMsg.Kludges.0:ehp2.
:pd.Antal element i vektorn
:pt.:hp2.FleetMsg.Kludges.1:ehp2.
:pd.Frsta kludgeraden
:pt.:hp2.FleetMsg.Kludges.*:ehp2.
:pd.Alla vidare kludgerader
:eparml.
:p.
Kludgeraderna r oftast p formen
:xmp.
NAMN: Vrde
:exmp.
:p.
eller
:xmp.
NAMN Vrde
:exmp.
:p.
En kludgerad kan frekomma p flera platser. Kludgarna har ingen speciell
ordning. Det inledande specialtecknet :hp2.01 hex:ehp2. medtas inte i
variabeln.

:h4 id=rvar17.FleetMsg.Seenbys
:p.:hp4.FleetMsg.Seenbys:ehp4. r en vektor som innehller meddelandets
SEEN-BY- och @PATH-rader. Vektorn r endast definierad vid lsning av
meddelanden.
:p.
:hp4.FleetMsg.Seenbys:ehp4.' flt r som fljer&colon.
:parml.
:pt.:hp2.FleetMsg.Seenbys.0:ehp2.
:pd.Antal element i vektorn
:pt.:hp2.FleetMsg.Seenbys.1:ehp2.
:pd.Frsta raden
:pt.:hp2.FleetMsg.Seenbys.*:ehp2.
:pd.Alla vidare rader
:eparml.
:p.
SEEN-BY-raderna r p formen
:xmp.
SEEN-BY&colon. noder
:exmp.

:h4 id=rvar14.FleetCCopy
:p.Nr du redigerar ett meddelande och anvnder ngon av
sndlistorna (carbon copy lists) (eller
snabbsndfunktionen) innehller vektorn :hp4.FleetCCopy:ehp4.
namnen och adresserna till personerna i sndlistan. Om ingen
sndlista anvnds r dessa variabler inte definierade.
:p.
:hp4.FleetCCopy:ehp4.s flt r som fljer&colon.
:parml.
:pt.:hp2.FleetCCopy.0:ehp2.
:pd.Antal poster i sndlistan.
:pt.:hp2.FleetCCopy.1.Name:ehp2.
:pd.Namnet p frsta posten.
:pt.:hp2.FleetCCopy.1.Address:ehp2.
:pd.Adressen fr den frsta posten.
:pt.:hp2.&dot.&dot.&dot.:ehp2.
:pd.
:eparml.

:h4 id=rvar15.NewMail
:p.:hp4.NewMail:ehp4. kan anta en kombination av fljande vrden (avdelade
med mellanslag)&colon.
:parml break=none.
:pt.:hp2.'Echo':ehp2.
:pd.Nya echomailmeddelanden har skrivits in
:pt.:hp2.'Net':ehp2.
:pd.Nya netmailmeddelanden har skrivits in
:pt.:hp2.'Local':ehp2.
:pd.Nya lokala meddelanden har skrivits in
:eparml.
:p.
Om inga meddelanden har skrivits r variabeln tom.
:p.
:hp8.Observera&colon.:ehp8. Dessa variabler har bara vrden nr programmet
hller p att avslutas, d.v.s. nr programmet anropats som "Exit-hook".
Annars r de ej definierade.

.***************************************************************************
.* Funktionen - funktioner
.*

:h3 id=rexxfunc.Funktioner
:p.FleetStreet tillhandahller ngra nya Rexxfunktioner. Dessa r&colon.
:sl compact.
:li.:hp4.FSCls:ehp4.
:li.:hp4.FSLookupAddress:ehp4.
:li.:hp4.FSLookupName:ehp4.
:li.:hp4.FSSetEntryField:ehp4.
:li.:hp4.FSSetHeader:ehp4.
:li.:hp4.FSSetText:ehp4.
:esl.

:h4.FSCls
:p.:hp4.FSCls:ehp4. rensar vervakningsfnstret.
:p.:hp2.Syntax&colon.:ehp2.
:xmp.
result = FSCls()
:exmp.
:p.:hp2.Parametrar&colon.:ehp2.
:p.
FSCls behver inga parametrar.
:p.:hp2.Svarskoder&colon.:ehp2.
:p.:hp4.FSCls:ehp4. ger svaret "OK" om vervakningsfnstret rensades. Om
programmet inte krs i ett vervakningsfnstret ges svaret "NoMonitor".
:p.:hp2.Exempel&colon.:ehp2.
:xmp.
call FSCls
:exmp.

:h4.FSSetHeader
:p.:hp4.FSSetHeader:ehp4. frvntar sig en Rexx-vektor som parameter, och
anvnder innehllet i dessa variabler som nytt meddelandehuvud.
:p.:hp2.Syntax&colon.:ehp2.
:xmp.
result = FSSetHeader(stem)
:exmp.
:p.:hp2.Parametrar&colon.:ehp2.
:parml break=none tsize=15.
:pt.:hp2.stem:ehp2.
:pd.En Rexx-vektor som innehller meddelandehuvudet. stem har fljande
flt&colon.
:ul compact.
:li.From
:li.FromAddress
:li.To
:li.ToAddress
:li.Subj
:eul.
:p.
Det r samma flt som :hp4.FleetMsg.Header:ehp4. anvnder, men det r bara
ovan angivna flt som kommer att anvndas.
:eparml.
:p.
:hp2.Svarskoder&colon.:ehp2.
:p.:hp4.FSSetHeader:ehp4. ger svaret "OK".
:p.
:p.:hp2.Anmrkningar&colon.:ehp2.
:ul.
:li.Alla element i vektorn mste ha vrden, ven om det bara r
nullstrngar.
:li.Stt alltid stamnamnet inom cituationstecken, s att det inte
erstts med dess vrde.
:li.Vid lsning sparas inte den nya headern p hrddisken. Vid
redigering kommer den nya headern endast att sparas nr hela meddelandet
sparas (ctrl-S).
:eul.
:p.
:p.:hp2.Exempel&colon.:ehp2.
:xmp.
/* Erstt avsndarnamnet */
FleetMsg.Header.From = 'Joe user'
RetVal = FSSetHeader('FleetMsg.Header')
:exmp.

:h4.FSSetText
:p.:hp4.FSSetText:ehp4. frvntar sig en Rexx-vektor som parameter, och
anvnder dess text som ny meddelandetext. Texten i vektorn erstter den
tidigarevarande texten.
:p.:hp2.Syntax&colon.:ehp2.
:xmp.
result = FSSetText(stem)
:exmp.
:p.
:p.:hp2.Parametrar&colon.:ehp2.
:parml break=none tsize=15.
:pt.:hp2.stem:ehp2.
:pd.En Rexx-vektor som innehller meddelandetexten. stem.0 innehller
antalet stycken, stem.1 ... stem.n innehller styckena.
:eparml.
:p.
:p.:hp2.Svarskoder&colon.:ehp2.
:p.:hp4.FSSetText:ehp4. ger svaret "OK".
:p.
:p.:hp2.Anmrkningar&colon.:ehp2.
:ul.
:li.Formatet p vektorn r detsamma som hos FleetMsg.Text.
:li.Element 0 i vektorn mste ha ett numeriskt vrde.
:li.Alla element i vektorn mste ha ett vrde, ven om det r
nullstrngar.
:li.Stt alltid stamnamnet inom cituationstecken, s att det inte
erstts med dess vrde.
:li.Vid lsning sparas inte den nya texten p hrddisken. Vid
redigering kommer den nya texten endast att sparas nr hela meddelandet
sparas (ctrl-S).
:eul.
:p.
:p.:hp2.Exempel&colon.:ehp2.
:xmp.
NewText.0 = 2
NewText.1 = 'Detta r bara ett'
NewText.2 = 'kort meddelande.'
RetVal = FSSetText('NewText')
:exmp.


:h4.FSLookupAddress
:p.:hp4.FSLookupAddress:ehp4. sker efter en FTN-adress i nodlistan. Svaret
sparas i en stamvariabel.
:p.:hp2.Syntax&colon.:ehp2.
:xmp.
result = FSLookupAddress(ftnaddress, stem)
:exmp.
:p.
:p.:hp2.Parametrar&colon.:ehp2.
:parml break=none tsize=15.
:pt.:hp2.ftnaddress:ehp2.
:pd.FTN-adressen p den nod som ska efterskas.
:pt.:hp2.stem:ehp2.
:pd.Stamnamn fr den variabel i vilken resultatet ska sparas.
:p.Variabeln har fljande flt&colon.
:parml.
:pt.:hp4.Stem.Address:ehp4.
:pd.Nodadressen
:pt.:hp4.Stem.Name:ehp4.
:pd.SysOpens namn
:pt.:hp4.Stem.System:ehp4.
:pd.Systemets namn
:pt.:hp4.Stem.Phone:ehp4.
:pd.Telefonnummer
:pt.:hp4.Stem.Location:ehp4.
:pd.Systemets hemort
:pt.:hp4.Stem.Password:ehp4.
:pd.Sessionslsenord. Om detta flt r tomt har Du inte definierat ngot
lsenord fr denna nod.
:pt.:hp4.Stem.Modem:ehp4.
:pd.Modemtyp. Detta r ett numeriskt vrde.
:pt.:hp4.Stem.Baud:ehp4.
:pd.Hgsta baudhastighet.
:pt.:hp4.Stem.UserCost:ehp4.
:pd.Kostnad fr anvndaren att skicka ett meddelande till noden.
:pt.:hp4.Stem.CallCost:ehp4.
:pd.Kostnad fr att ringa upp noden.
:pt.:hp4.Stem.Flags:ehp4.
:pd.Nodflaggor, en kombination av "ZC, "RC", "MO", "Hub", "Host" och "CM".
:eparml.
:eparml.
:p.
:p.:hp2.Svarskoder&colon.:ehp2.
:p.:hp4.FSLookupAddress:ehp4. ger som svar ett av fljande vrden&colon.
:parml break=none tsize=15.
:pt."OK"
:pd.Noden hittades. Data fr noden har sparats i den andra parametern.
:pt."NotFound"
:pd.Noden hittades inte.
:pt."Error"
:pd.Ett fel uppstod vid skningen.
:eparml.
:p.
:p.:hp2.Anmrkningar&colon.:ehp2.
:ul.
:li.Om adresstrngen r fr lng kommer den att trunkeras. Fltet
"Stem.Address" innehller den resulterande adressen.
:li.Stt alltid stamnamnet inom cituationstecken, s att det inte
erstts med dess vrde.
:eul.
:p.
:p.:hp2.Exempel&colon.:ehp2.
:xmp.
RetVal = FSLookupAddress('2&colon.2490/2520', 'NodeData')
say 'Systemnamn&colon.' NodeData.System
:exmp.


:h4.FSLookupName
:p.:hp4.FSLookupName:ehp4. sker efter ett SysOpnamn i nodlistan. Svaret
sparas i en stamvariabel.
:p.:hp2.Syntax&colon.:ehp2.
:xmp.
result = FSLookupName(name, stem)
:exmp.
:p.
:p.:hp2.Parametrar&colon.:ehp2.
:parml break=none tsize=15.
:pt.:hp2.name:ehp2.
:pd.Det skta SysOpnamnet.
:pt.:hp2.stem:ehp2.
:pd.Stamnamn fr den variabel i vilken resultatet ska sparas.
:p.Variabeln har fljande flt&colon.
:parml.
:pt.:hp4.Stem.0:ehp4.
:pd.Antal funna poster.
:pt.:hp4.Stem.1.Address:ehp4.
:pd.Nodadressen fr (frsta posten)
:pt.:hp4.Stem.1.Name:ehp4.
:pd.SysOpens namn fr (frsta posten)
:pt.:hp4.Stem.1.System:ehp4.
:pd.Systemets namn fr (frsta posten)
:pt.:hp4.Stem.1.Phone:ehp4.
:pd.Telefonnummer fr (frsta posten)
:pt.:hp4.Stem.1.Location:ehp4.
:pd.Systemets hemort fr (frsta posten)
:pt.:hp4.Stem.1.Password:ehp4.
:pd.Sessionslsenord (frsta posten). Om detta flt r tomt har Du inte
definierat ngot lsenord fr denna nod.
:pt.:hp4.Stem.1.Modem:ehp4.
:pd.Modemtyp (frsta posten). Detta r ett numeriskt vrde.
:pt.:hp4.Stem.1.Baud:ehp4.
:pd.Hgsta baudhastighet (frsta posten)
fr den frsta posten
:pt.:hp4.Stem.1.UserCost:ehp4.
:pd.Kostnad fr anvndaren att skicka ett meddelande till noden (frsta
posten)
:pt.:hp4.Stem.1.CallCost:ehp4.
:pd.Kostnad fr att ringa upp noden (frsta posten)
:pt.:hp4.Stem.1.Flags:ehp4.
:pd.Nodflaggor (frsta posten), en kombination av "ZC, "RC", "MO", "Hub", "Host" och "CM".
:eparml.
:eparml.
:p.Stem.2 osv. innehller vriga funna poster.
:p.
:p.:hp2.Svarskoder&colon.:ehp2.
:p.:hp4.FSLookupname:ehp4. ger som svar ett av fljande vrden&colon.
:parml break=none tsize=15.
:pt."OK"
:pd.Noden hittades. Data fr noden har sparats i den andra parametern.
:pt."NotFound"
:pd.Noden hittades inte.
:pt."Error"
:pd.Ett fel uppstod vid skningen.
:eparml.
:p.
:p.:hp2.Anmrkningar&colon.:ehp2.
:ul.
:li.Om namnet r fr lngt kommer det att trunkeras. Fltet
"Stem.x.Name" innehller det resulterande namnet.
:li.Stt alltid stamnamnet inom cituationstecken, s att det inte
erstts med dess vrde.
:li.Det gr ven bra att ska p en del av efternamnet.
:eul.
:p.
:p.:hp2.Exempel&colon.:ehp2.
:xmp.
RetVal = FSLookupName('Joe User', 'NodeData')
do i = 1 to NodeData.0
  say 'Adress&colon.' NodeData.i.Address
end
:exmp.

:h4.FSSetEntryField
:p.:hp4.FSSetEntryField:ehp4. stter in en text i vervakningsfnstrets
inmatningsflt. Detta kan anvndas fr att ange ett standardvrde fr
indata.
:p.:hp2.Syntax&colon.:ehp2.
:xmp.
result = FSSetEntryField(text)
:exmp.
:p.
:p.:hp2.Parametrar&colon.:ehp2.
:parml break=none tsize=15.
:pt.:hp2.text:ehp2.
:pd.Ny text fr inmatningsfltet.
:eparml.
:p.:hp2.Svarskoder&colon.:ehp2.
:p.:hp4.FSSetEntryField:ehp4. ger som svar ett av fljande vrden&colon.
:parml break=none tsize=15.
:pt."OK"
:pd.Texten har satts in.
:pt."NoMonitor"
:pd.Programmet krs utan vervakningsfnster. Drfr kunde texten i
inmatningsfltet inte sttas.
:eparml.
:p.
:p.:hp2.Anmrkningar&colon.:ehp2.
:ul.
:li.Texten trunkeras till maximalt 500 tecken.
:eul.
:p.
:p.:hp2.Exempel&colon.:ehp2.
:xmp.
RetVal = FSSetEntryField('C&colon.\')
if RetVal = 'OK' then
   do
   say 'Var vnlig ange skvg'
   parse pull mypath .
   end
:exmp.

.***************************************************************************
.* Hooks
.* @2@
.*

:h2.Hooks
:p.FleetStreet kan automatiskt starta specifika program i olika
situationer.
:p.
Fr att tilldela en hook ett speciellt program gr du som fljer&colon.
:ol compact.
:li.pnna Rexxprogramhanteraren
:li.Vlj "Instllningar" i fnstrets tillggsmeny
:li.Vxla till "Hooks"-sidan i instllningsblocket
:li.Vlj i "drop-down"-listan fr den hook du ska definiera nskat program.
:eol.
:p.
:p.Fr nrvarande finns fljande "hooks"&colon.
:ul compact.
:li.Programslut
:li.Innan sparande
:eul.

.***************************************************************************
.* Pipe-Server
.* @1@
.*

:h1.FleetStreets pipe-server
:p.
Detta avsnitt beskriver hur FleetStreets pipe-server fungerar.
:p.
FleetStreet startar automatiskt en trd som uteslutande betjnar en "named
pipe". ver denna kan FleetStreet styras.
:p.
Namnet p pipe&colon.n r
:xmp.
\PIPE\FleetStreetDoor
:exmp.
:p.
Pipe&colon.n r bidirektionell. Applikationer som vill kommunicera med
FleetStreet ver denna pipe mste anvnda ett speciellt protokoll, vilket
beskrivs i fljande avsnitt. I de flesta fall rcker dock FleetCom.
FleetCom r en speciellt utvecklad FleetStreetklient som ltt kan anvndas
i kommandoprogram, m.m.
:p.
Se ven&colon.
:ul compact.
:li.:link reftype=hd refid=proto.Protokollet:elink.
:li.:link reftype=hd refid=commands.Kommandon fr pipe-servern:elink.
:li.:link reftype=hd refid=fleetcom.FleetCom:elink.
:eul.

.* @2@ **********************************************************************
:h2 id=proto.Protokollet
:p.
En session med FleetStreet bestr av tre delar&colon. Upprttande av
frbindelse, kommandoutbyte och avveckling av frbindelsen.
:p.
Hrnst kommer de olika delarna att beskrivas. Till detta anvnds fljande
ASCII-tecken&colon.
:table cols='6 12 8'.
:row.
:c.Symbol
:c.Hexadecimalt
:c.Decimalt
:row.
:row.
:c.ACK
:c.06
:c.6
:row.
:c.NAK
:c.15
:c.21
:row.
:c.ENQ
:c.05
:c.5
:row.
:c.ETX
:c.03
:c.3
:row.
:c.EOT
:c.04
:c.4
:etable.
:p.
:hp2.Upprttande av frbindelse:ehp2.
:p.
Efter det att klienten har ppnat pipe&colon.n snder den frst en
:hp2.<ENQ>:ehp2. till FleetStreet. Som svar snder FleetStreet strngen
:hp2."FleetStreet"<ETX>:ehp2. till klienten. Denna mste nu kontrollera om
det verkligen r FleetStreet som gmmer sig bakom pipe&colon.n, d.v.s. om den
snda strngen verensstmmer med "FleetStreet". Om detta r fallet snder
klienten en :hp2.<ACK>:ehp2. till servern. Om det r fel snder klienten en
:hp2.<NAK>:ehp2., p vilket FleetStreet svarar med :hp2.<EOT>:ehp2. och
avslutar frbindelsen.
:p.
Om FleetStreet frn en :hp2.<ACK>:ehp2., snder det drp sitt
versionsnummer som text, t.ex :hp2."0.88"<ETX>:ehp2.. Om klienten bara
fungerar tillsammans med en speciell version kan den kontrollera denna
strng. D snder klienten antingen :hp2.<ACK>:ehp2. eller :hp2.<NAK>:ehp2.
till FleetStreet. Om strngen inte kontrolleras mste :hp2.<ACK>:ehp2.
sndas tillbaka.
:p.
Den frsta fasen r nu avslutad, och FleetStreet vntar p kommandon frn
klienten.
:p.
Schema ver upprttningsfasen&colon.
:xmp.

 Klient              FleetStreet

            ENQ
   ---------------------->

     "FleetStreet<ETX>"
   <----------------------

            ACK
   ---------------------->

        "0.88<ETX>"
   <----------------------

            ACK
   ---------------------->
:exmp.
:p.
Vid fel&colon.
:xmp.

            ENQ
   ---------------------->

     "FleetStreet<ETX>"
   <----------------------

            NAK
   ---------------------->

            EOT
   <----------------------
:exmp.


.* @2@ **********************************************************************
:hp2.Kommandoutbyte:ehp2.
:p.
Klienten snder kommandon som enkla ASCII-texter till FleetStreet. Varje
kommando avslutas med :hp2.<ETX>:ehp2..
:p.
Exempel&colon.
:xmp.
"SCAN *"<ETX>
:exmp.
:p.
Parametrar avdelas frn kommandot och sinsemellan med ett mellanslag.
:p.
FleetStreet kontrollerar sedan om kommandot r giltigt. Om ett fel uppstr
skickas sekvensen
:xmp.
<NAK><kod><ETX>
:exmp.
:p.
tillbaka. <Kod> r en av de tre bokstverna C, P och S. Betydelsen av de
olika bokstverna r&colon.
:parml break=none.
:pt.C
:pd.Kommandot kndes inte igen
:pt.P
:pd.Parametrar saknas eller r felaktiga (fr kommandot)
:pt.S
:pd.Fler parametrar angavs n vad som frvntades.
:eparml.
:p.
Om allting fungerar snds sekvensen
:xmp.
<ACK><ETX>
:exmp.
:p.
I s fall brjar FleetStreet med att utfra kommandot. Efter det att
kommandot utfrts meddelas resultatet. Om det under utfrandet uppstr ett
fel kommer sekvensen
:xmp.
<NAK>"felmeddelande"<ETX>
:exmp.
:p.
att sndas. "Felmeddelande" r en beskrivning av felet i klartext. Vid
felfri bearbetning kommer sekvensen
:xmp.
<ACK>"resultat"<ETX>
:exmp.
:p.
att sndas. "Resultat" r d den efterfrgade informationen, ett
statusmeddelande, eller kan eventuellt vara tom.
:p.
Efter det att ett kommando frdigbehandlats kan ytterligare kommandon
skickas till FleetStreet. Detta kan ske ett valfritt antal gnger fram till
avveckling av frbindelsen.
:p.
Schematiskt&colon.
:xmp.
 Klient              FleetStreet

       "SCAN *"<ETX>
   ---------------------->

         <ACK><ETX>
   <----------------------

      [Bearbetning]

     <ACK>"34 areas"<ETX>
   <----------------------
:exmp.
:p.
Felaktigt kommando&colon.
:xmp.
       "ABC XYZ"<ETX>
   ---------------------->

        <NAK>"C"<ETX>
   <----------------------
:exmp.
:p.
Fel vid utfrandet&colon.
:xmp.
       "SCAN *"<ETX>
   ---------------------->

         <ACK><ETX>
   <----------------------

       [Bearbetning]

    <NAK>"disk error"<ETX>
   <----------------------
:exmp.
:p.
:hp2.Avveckling av frbindelsen:ehp2.
:p.
Nr det klientens sista kommando har avklarats mste frbindelsen
avvecklas. Fr att gra detta snder klienten en
:xmp.
EOT
:exmp.
:p.
till servern. Denna snder d tillbaka en
:xmp.
EOT
:exmp.
:p.
och bda avbryter frbindelsen.
:p.
Schematiskt&colon.
:xmp.
 Klient              FleetStreet

            EOT
   ---------------------->

            EOT
   <----------------------
:exmp.


.* @2@ **********************************************************************
:h2 id=commands.Kommandon fr pipe-servern
:p.
Fr nrvarande r fljande kommandon implementerade&colon.
:lines.
   SCAN
   ETOSS
.*   LOCK
.*   UNLCK
:elines.

:h3.SCAN
:p.
:hp2.SCAN:ehp2.
:p.
De angivna mtena kommer att p nytt avskas. Som mte kan du ange&colon.
:parml break=none.
:pt.*
:pd.Alla mten
:pt.Mtestag
:pd.Bara de angivna mtena, t.ex TUB
:pt.@filnamn
:pd.Alla mten som anges i filen. Filens format r detsamma som vid en
Echotoss-fil, d.v.s. en mtestag per rad
:eparml.

:h3.ETOSS
:p.
:hp2.ETOSS:ehp2.
:p.
Skriver Echotossfilen. Om ingen parameter anges kommer den fil som angivits
i FleetStreet-instllningen att skrivas. En parameter kan anges, och
betecknar d filnamnet hos den fil som ska skrivas.


:h3 hide.LOCK
:p.
:hp2.LOCK:ehp2.
:p.
De angivna mtena sprras, d.v.s. de kommer inte lngra att anvndas av
FleetStreet. Om mtet fr tillfllet r i anvndning, kommer kommandot att
vara i anvndning tills dess mtet inte lngre anvnds.
:p.
Mten kan anges p samma format som vid SCAN

:h3 hide.UNLCK
:p.
:hp2.UNLCK:ehp2.
:p.
De sprrade mtena kommer att "lsas upp". Mten anges p samma format som
vid LOCK.


.* @2@ **********************************************************************
:h2 id=fleetcom.FleetCom
:p.
Ett speciellt verktyg vid namn FleetCom skickas med FleetStreet. FleetCom
r en klient fr FleetStreets pipe-server. Anropskonventionen r&colon.
:xmp.
FLEETCOM kommando [parameter]
:exmp.
:p.
FleetCom upprttar en frbindelse med pipe-servern, snder kommandot och
dess parametrar, och skriver ut mottagna data. FleetCom rcker i de flesta
fall fr att anvnda FleetStreets pipe-server. FleetCom snder endast ett
kommando per session.
:p.
De felniver (errorlevels) som FleetCom kan lmna r&colon.
:parml break=none tsize=4.
:pt.0
:pd.Allt OK, inget fel.
:pt.1
:pd.Pipe&colon.n kunde inte ppnas. Detta fel upptrder ven om FleetStreet inte
r startad vid anropet. Allts kan Du oftast strunta i detta fel.
:pt.2
:pd.Inget kommando har angetts.
:pt.3
:pd.FleetStreet knner inte igen kommandot.
:pt.4
:pd.Fel vid utfrandet av kommandot, eller systemfel.
:eparml.
:p.
FleetCom anvnder som standard pipe&colon.n \PIPE\FleetStreetDoor. Den kan dock
ven anvnda ett annat namn. Programmet kontrollerar miljvariabeln
FLEETPIPE. Exempel&colon.
:xmp.
SET FLEETPIPE=\PIPE\AnotherPipe
:exmp.
:p.
Om FleetCom ter ska anvnda standardnamnet mste variabeln rensas med
:xmp.
SET FLEETPIPE=
:exmp.
:p.
:hp2.Exempel p anvndning av FleetCom&colon.:ehp2.
:p.
Avsk alla mten i vilka tossern har tossat nya meddelanden&colon.
:xmp.
SquishP IN -f echotoss.log
FleetCom scan @echotoss.log
:exmp.
:p.
Skriv Echotoss.Log, s att tossern ven kan exportera meddelanden frn
dessa mten&colon.
:xmp.
FleetCom etoss pack.log
SquishP OUT SQUASH -f pack.log
:exmp.
:p.

.* @1@ **********************************************************************
:h1.Tankar kring meddelandebasformaten
:p.
Var och ett av de tre av FleetStreet stdda meddelandebasformaten har sina
fr- och nackdelar. Det hr kapitlet beskriver hur FleetStreet hanterar de
olika formaten, och fungerar som en guide fr att vlja det format som
passar dig.

.* @2@ **********************************************************************
:h2.*.MSG
:p.
FleetStreet anvnder Squish' MSGAPI32.DLL fr hantering av *.MSG-areor.
Tyvrr r det s att detta API maximalt lser 512 bytes av kludge-raderna i
varje meddelande. Om det finns mer kludgar i ett meddelandet (vilket inte r
ovanligt nr det exempelvis gller meddelanden frn Internet) kommer de helt
enkelt att huggas av efter 512 bytes. Resten av kludgarna fs som vanlig
meddelandetext.
:p.
FleetStreet kommer i dessa fall att flytta de verblivna kludgeraderna frn
meddelandet. En avhuggen kludgrad kommer dock inte lngre att kunna knnas
igen som en dylik. Drfr kan det frekomma att det ibland hamnar en halv
kludgrerad i brjan av meddelandetexten.
:p.
I *.MSG-formatet finns bara att spara Fido-standardattributen. Alla vriga
attribut sparas av FleetStreet som en FLAGS-kludge. Dessa kommer dock inte
att knnas igen av Squish (tossern). Attribut som "Direkt" eller "Arkivera
efter sndning" kommer drfr att vara verkningslsa nr de anvnds tillsammans
med Squish.
:p.
Fr att markera "Lst"-attributet anvnder FleetStreet lsrknaren i
*.MSG-filen. Denna kommer dock att vid packning nollstllas av Squish, s d
kommer meddelandet att n en gng markeras som "olst".

.* @2@ **********************************************************************
:h2.Squish
:p.
MSGAPI32.DLL (vilket anvnds fr hantering av Squishareor) har ett stort
designfel&colon. Nr en area ppnas kommer areaindexet (*.SQI) att lsas
in i minnet. Nr arean ndras kommer dock inte indexet p disken att direkt
sttas att innehlla den aktuella informationen. I stllet kommer ndringen
endast att genomfras i minnet, och kommer inte frrn det att arean stngs
att skrivas tillbaka p disken. Ponera nu att tv program samtidigt arbetar
p arean, och s skriver de oberoende av varnadra ndringar till index.
Detta kommer att leda till ett defekt areaindex, eller i vrsta fall till
att arean frstrs.
:p.
Precis som i *.MSG-areor finns i Squishareor endast standardattributen att
tillg. De andra attributen kommer ven hr att skrivas i en FLAGS-kludge
av FleetStreet. Squish (tossern) beaktar :hp5.inte:ehp5. denna kludgerad.
:p.
Som "Lst"-attribut anvnder FleetStreet den hgsta biten i meddelandets
attributflt.
:p.
"Ls"-attribuet hanteras inte av :hp2.SqPack:ehp2.. Anvnd :hp2.FESQ:ehp2.
fr att packa dina Squish-areor i stllet.


.* @2@ **********************************************************************
:h2.JAM
:p.
I *.JHR-filen fr en JAM-area markeras antalet aktiva meddelanden i arean.
Detta flt skrivs dock inte korrekt av olika programvaror (IMail 175 stter
det hr fltet till 0 vid packning av arean; GoldEd 2.50.Beta6 kan ibland
vid borttagning av meddelanden generera ett underspill i detta flt).
P grund av detta kan inte innehllet i det hr fltet att hllas fr
trovrdigt. FleetStreet frlitar sig istllet p areaindexet.
:p.
Indexet fr JAM-areor har en dlig design. Med hjlp av endast indexposten
r det omjligt att bestmma om ett meddelande r borttaget eller aktivt. Det
finns bara tv mjligheter att g runt problemet&colon.
:ol.
:li.Man lser frutom indexet meddelandehuvudet, fr att upptcka om
meddelandet r raderat eller aktigt. Detta r lngsamt och motarbetar
indexets syfte. FleetStreet anvnder inte lngre denna metod.
:li.Man visar alla meddelanden, ven om ngra av dem r markerade att
vara "borttagna".
:eol.
:p.
Fr att borttagning av meddelanden trots allt ska ha ngot genomslag, skriver
FleetStreet helt ver meddelandets indexpost. Detta stmmer dock inte till
100% med JAM-specifikationen, men det r trots allt det enda frnuftiga
tillvgagngssttet. Meddelanden som en gng har tagits bort med FleetStreet
dyker i alla fall inte upp mer.
:p.
Mnga meddelandebas-"utilities" tar bort genom att bara markera meddelandet
som borttaget i huvudet, och ndrar inte indexposten. I sdana fall br man,
i anslutning till detta, packa arean fr att slutgiltigt ta bort dessa
meddelanden.

.* @1@ **********************************************************************
:h1.Tankar kring tossers
:p.
FleetStreet stder flera olika tossers direkt. I detta kapitel hittar
du ngra tips p hur samarbetet med olika tossers kan effektiviseras.

.* @2@ **********************************************************************
:h2.Squish
:p.
Samarbetet med Squish r relativt problemfritt. Det finns dock ngra
noteringar som br gras&colon.
:ul.
:li.Squish knner varken av eller behandlar FLAGS-kludgen, d.v.s bara
standardmeddelandeattributen har ngon som helst effekt.
:li.Vid packning av meddelanden i *.MSG-areor kommer lsrknaren att
sttas tillbaka till 0, vilket betyder att meddelanden kommer att
markeras som "olst".
:eul.

.* @2@ **********************************************************************
:h2.Fastecho
:p.
:ul.
:li.Fastecho stder inte Squish' Broadcast-("Fjrrbeordran")-funktioner.
:li.En egendomlighet r hanteringen av flera netmailareor. I motsats till
Squish kan inte Fastecho tossa till eller packa frn flera netmailareor.
Netmailen mste fre packningen exporteras till en sekundr netmailarea,
fr att sedan drifrn exporteras och packas. Fr att exportera anvnds
samma kommando som vid export av echomail. FleetStreet behandlar dock
samliga netmailareor p samma stt, d.v.s de kommer inte att skrivas till
ECHOTOSS.LOG-filen. Vid export kommer allts inte netmail i de
sekundra netmailareorna att registreras.
:p.
Lsningen till detta problem r att genomfra exporten i tv steg&colon.
I det frsta steget exporteras echomail med hjlp av ECHOTOSS.LOG-filen. I det
andra steget exporteras netmailen till den sekundra netmailarean med hjlp
av en "dummy"-ECHOTOSS.LOG. Denna dummy-ECHOTOSS.LOG innehller helt enkelt
bara en lista p de sekundra netmailareorna. I det sista steget kommer
den exporterade posten att packas.
:p.
Exempel&colon.
:xmp.
FASTECH2 SCAN -Lechotoss.log
FASTECH2 SCAN -Lnmareas.log
FASTECH2 PACK -P

[NMAREAS.LOG]
GERNET
OS2NET
:exmp.
:eul.

.* @2@ **********************************************************************
:h2.IMail
:p.
Version 1.75 av IMail har tyvrr ett fel&colon. I JAM-areor sparas
:hp2.PATH:ehp2.-kludgen och :hp2.SEEN-BY:ehp2.-raderna till meddelandetexten,
i stllet fr (som anges i specifikationen) i meddelandehuvudet. P grund
av detta kommer dessa rader att i FleetStreet visas under meddelandetexten.


.* @1@ **********************************************************************
:h1.Bilagor
:p.

.***************************************************************************
.* Kludge-Lines - Kludgerader
.* @2@
.*

:h2 id=kludges.Kludgerader
:p.
Fljande kludgerader genereras och igenknns av FleetStreet&colon.
:parml compact tsize=3 break=all.
:pt.:hp2.FMPT:ehp2.
:pt.:hp2.TOPT:ehp2.
:pt.:hp2.INTL:ehp2.
:pd.Dessa kludgar genereras av FleetStreet i enlighet med :hp4.FTS-0001 rev.
15:ehp4. om meddelandet r i NetMail.
:p.Squish skriver om dessa kludges vid exportering av meddelandena. Std fr
dem r allts egentligen inte ndvndigt.
:p.Vid lsning av meddelanden, ignoreras dessa kludges.
:p.

:pt.:hp2.MSGID:ehp2.
:pd.Vid skrivning av meddelanden genereras i enlighet med :hp4.FTS-0009 rev.
1.:ehp4. Adresskomponenten r fyrdimensionell.
:p.Vid lsning av ett echomail-mte anvnds :hp2.MSGID:ehp2. fr att ta reda
p brevets avsndaradress. Om en :hp2.MSGID:ehp2. inte innehller ngon
FTN-adress, eller om den saknas, avsks Origin-linjen fr en giltig adress.
:p.

:pt.:hp2.REPLY:ehp2.
:pd.Vid skrivning av svar skrivs originalets :hp2.MSGID:ehp2. som en
:hp2.REPLY:ehp2.-kludge.
:p.

:pt.:hp2.PID:ehp2.
:pd.Om du har aktiverat :hp2.PID:ehp2. i instllningarna, kommer
:hp2.PID:ehp2.-kludges att skrivas, tillsammans med en kort tear-rad. En
lng tear-rad lggs till om :hp2.PID:ehp2. inte r aktiverat.
:p.FleetStreet fljer rekommendationerna i :hp4.FSC-0046 rev. 2:ehp4..
:p.

:pt.:hp2.REPLYTO:ehp2.
:pd.Vid besvarande av NetMail som innehller en :hp2.REPLYTO:ehp2.-kludge
kommer den dr angivna adressen att sttas in som mottagande anvndarnamn.
:p.I echomailmten ignoreras denna kludge. FleetStreet fljer rekommendationerna
i :hp4.FSC-0035 rev. 1.:ehp4.
:p.

:pt.:hp2.REPLYADDR:ehp2.
:pd.Om Du svarar p ett NetMail med :hp2.REPLYADDR:ehp2. kommer den dr
angivna adressen att lggas till i en "To&colon."-rad i brjan av svaret.
:p.I echomailmten ignoreras denna kludge. FleetStreet fljer rekommendationerna
i :hp4.FSC-0035 rev. 1.:ehp4.
:p.

:pt.:hp2.SPLIT:ehp2.
:pd.D ett meddelande sparas, och det r lngre n 12 KB, kommer det att delas
i mindre delar i enlighet med :hp4.FSC-0047 rev. 1:ehp4.. Fljande avvikelser r
vrda att notera&colon.
:ul.
:li.D meddelandet aldrig funnits i meddelandebasen i sin helhet, s r
meddelandenumret i :hp2.SPLIT:ehp2.-kludgen beroende p implementation (m.a.o
meddelandenumret fr den frst skapade delen).
:li.:hp4.FSC-0047:ehp4. rekommenderar att det inte finns ngon :hp2.MSGID:ehp2.
i del tv och framt, s att en kontroll av duplikat inte ska radera dessa
delar. FleetStreet genererar dremot en ny :hp2.MSGID:ehp2. fr varje del,
vilket ger samma resultat.
:li.D delnumret i :hp2.SPLIT:ehp2.-kludgen r tvsiffrigt, skapas
maximalt 99 delar. Meddelandelngden r drmed begrnsad till 1188 KB.
:li.Vid redigering kan det frndrade meddelandet maximalt vara 15
KB lngt. En ny uppdelning skulle kollidera med numreringen hos de pfljande
delarna, vilket skulle medfra att sammanfogning av meddelandena ej lngre
vore mjlig.
:li.Numreringen av meddelandedelarna grs i slutet av mnesraden,
inte i brjan, vilket fresls. Genom detta frfarande kommer delarna att visas i
rtt ordning i mneslistan.
:eul.
:p.
:pt.:hp2.APPEND:ehp2.
:pt.:hp2.REALADDRESS:ehp2.
:pd.Dessa kludgar behlls vid svar.
:p.
:pt.:hp2.CHARSET/CHRS:ehp2.
:pd.FleetStreet stder dessa kludgar upp till och med niv 2 i enlighet med
:hp4.FSC-0054 Rev. 4:ehp4.. Vid skrivning av meddelanden anvnder FleetStreet
alltid :hp2.IBMPC 2:ehp2..
:p.
:pt.:hp2.ACUPDATE:ehp2.
:pd.Denna kludgerad anvnds i Squish 1.10 fr att ndra eller radera
meddelanden hos andra system. Konsultera dokumentationen fr Squish 1.10 fr
ytterligare information.
:p.
:pt.:hp2.AREA:ehp2.
:pd.Om denna kludgerad hittas i ett meddelande, och mtet knns igen av
FleetStreet kommer svaret automatiskt att hamna i det hr angivna mtet.
:p.
:pt.:hp2.FLAGS:ehp2.
:pd.:hp2.FLAGS:ehp2.-kludgen innehller de meddelandeattribut som inte
stds direkt av meddelandebasen. Formatet p dena kludge r definierat i
:hp4.FSC-0053:ehp4..
:p.
:pt.:hp2.FWDFROM, FWDTO, FWDSUBJ, FWDORIG, FWDDEST, FWDAREA, FWDMSGID:ehp2.
:pd.Dessa kludgar genereras vid vidaresndning av meddelanden. De
innehller headerinformation fr det ursprunliga meddelandet. Nr du svarar
p ett sdant meddelande anvnder FleetStreet dessa poster fr svaret.
:eparml.

.* @2@ **********************************************************************
:h2 id=cmdlin.Kommandoradsparametrar
:p.
FleetStreet godtar fljande kommandoradsparameter&colon.
:parml.
:pt.:hp2.-C<skvg>:ehp2.
:pd.INI-filerna kommer inte att lsas och skrivas frn den aktuella
katalogen, utan i stllet frn den katalog du anger.
:p.:hp2.Exempel&colon.:ehp2.
:p.FLTSTRT.EXE -Cd&colon.\myinis
:eparml.

.* @2@ **********************************************************************
:h2.Svarskoder
:p.
FLTSTRT.EXE ger fljande svarskoder&colon.
:parml break=none.
:pt.:hp2.0:ehp2.
:pd.Inga nya meddelanden har skrivits.
:pt.:hp2.1:ehp2.
:pd.Nya netmails har skrivits.
:pt.:hp2.2:ehp2.
:pd.Nya echomailmeddelanden har skrivits.
:pt.:hp2.4:ehp2.
:pd.Nya lokala meddelanden har skrivits.
:pt.:hp2.255:ehp2.
:pd.Allvarligt fel
:eparml.
:p.
En kombination av 1, 2 och 4 betyder att meddelanden har skrivits in i
flera av mtestyperna. Exempelvis betyder 5 att meddelanden skrivits bde i
netmail och lokala mten.

.* @2@ **********************************************************************
:h2.Buggrapporter
:p.
FleetStreet r med skerhet inte felfritt. Jag kan drfr bar uppmuntra
alla att meddela alla fel till mig. Jag kan d efter min bsta frmga
frska avhjlpa felet.
:p.
Mnga fel kan jag ev. inte (direkt) stta mig in i. Fljande
frgestllningar r frhoppningsvis relevanta fr att kunna avhjlpa
felet&colon.
:ul.
:li.Lter felet sig reproduceras?
:li.Upptrder felet vid frsta frsket, eller frst efter flera gnger?
:li.Vilka funktioner utfrdes nr felet uppstod?
:li.Utfrdes funktionen frn tangentbordet, menyn eller knappraden? Gr det
ngon skillnad om Du anvnder en annan metod?
:li.Framtrder ngot felmeddelande? Vilket?
:li.r FleetStreet riktigt konfigurerat?
:li.Vad exakt hnder nr felet uppstr?
:eul.
:p.
Om FleetStreet stngs av p grund av ett fel, kommer filien
:hp2.FLTSTRT.DMP:ehp2. att skapas i den aktuella katalogen. Med hjlp av
denna fil kan felet oftast lokaliseras tmligen enkelt.


.* @2@ **********************************************************************
:h2.Anvnda program
:p.
FleetStreet skapades och testades med fljande program&colon.
:ul.
:li.Kompilator&colon. IBM VisualAge C++ 3.0 (C-lge)
:li.Debugger&colon. IBM C/C++ Debugger 3.0 (IPMD)
:li.Utvecklingsmilj&colon. IBM Workframe 3.0
:li.Lnkare&colon. ILink
:li.Redigerare&colon. Enhanced Editor, Tiny Editor, LPEX
:li.Verktygsprogram&colon. IBM OS/2 Toolkit 3.0; GNU Grep; PMTree; ExeMap;
Hexdump; PMSpy; PM Camera
:eul.

.* @2@ **********************************************************************
:h2 id=support.Support
:p.Michael Hohner kan ns p fljande e-post-adresser&colon.
:parml compact break=none tsize=16.
:pt.Fidonet&colon.
:pd.Michael Hohner 2&colon.2490/1050.17 (new!)
:pt.OS2Net&colon.
:pd.Michael Hohner 81&colon.499/617.17 (new!)
:pt.Internet&colon.
:pd.miho@n-online.de (new!)
:eparml.
:p.
:hp2.Fido echomail&colon.:ehp2.
:p.
Det finns tv Fidonet-mten hos 2&colon.2490/1050, FLEETBETA och
FLEETSTREET. FLEETBETA r det tysksprkiga mtet, FLEETSTREET r det
internationella mtet (engelsksprkigt). Skriv ett netmail till Robert
Gloeckner 2&colon.2490/1050, om Du vill f tag p mtet. Dr kan Du
f information om andra noder som har mtet. Mtet kan fritt vidaresndas,
men snd oss information om anslutna noder.
:p.
Frgor om FleetStreet kan ven stllas i Fidonetmtet OS2BBS.GER.

:euserdoc.
