
/* Simple client-end example of a MaxSnoop app.
 *
 * Microsoft C 6.0a.
 */

#define INCL_NOPM
#define INCL_DOS
#define INCL_DOSERRORS
#include <os2.h>
#include <stdio.h>
#include <string.h>


static HPIPE OpenPipe(char *name);
static USHORT PRead(HPIPE hp, VOID *pv, USHORT cb, USHORT *pbr);

void main(int argc, char **argv)
{
    HPIPE hp;
    char msg[258];
    USHORT bytes;
    int l;
    for(;;){
        hp = OpenPipe(argv[1]);
        if(!hp)
            break;
        while(!PRead(hp, msg, sizeof(msg)-2, &bytes)){
            msg[bytes] = 0;
            l = strlen(msg);
            if(msg[l-1] != '\n'){
                msg[l] = '\n';
                msg[l+1] = 0;
            }
            fputs(msg, stdout);
        }
        DosClose(hp);
    }
}

/* if the pipe doesn't exist, this function polls for it.  I don't
 * like polling,  but we have no choice,  since the Snooper is
 * usually always running,  but the Snoopee is not.
 */
static HPIPE OpenPipe(char *name)
{
    char *pname;
    USHORT rc, us;
    HPIPE hf;
    char app[256];
    USHORT bytes;
    int shown = FALSE;

    pname = name;
    if(!pname)
        pname = "\\pipe\\maxsnoop";


    printf("pipe name is '%s'\n", pname);
    for(;;){
        rc = DosOpen(pname, &hf, &us, 0L, FILE_NORMAL,
                 FILE_OPEN,
                 OPEN_ACCESS_READONLY  | OPEN_SHARE_DENYREADWRITE | OPEN_FLAGS_NOINHERIT,
                 0L);
        if(!rc)
            break;      // success.
        if(rc == ERROR_PIPE_BUSY){
            printf("pipe is busy. .\n");
            rc = DosWaitNmPipe(pname, 1000L);
            if(rc && rc != ERROR_SEM_TIMEOUT)
                break;
        }
        else{
            if(!shown){ // only print this mesg once.
                printf("Pipe doesn't exist; polling continues.\n");
                shown = TRUE;
            }
            DosSleep(500L);
         }
    }

    if(rc){
        printf("dosopen error %d\n", rc);
        return 0;
    }
    DosSetNmPHandState(hf,  NP_READMODE_MESSAGE | NP_WAIT);
    if(!PRead(hf, app, sizeof(app), &bytes))
        printf("\n\nConnected to application: %s\n", app);
    return hf;
}

static USHORT PRead(HPIPE hp, VOID *pv, USHORT cb, USHORT *pbr)
{
    USHORT rc;
    USHORT br=0;
    USHORT state;
    AVAILDATA ad;

    rc = DosRead(hp, pv, cb, &br);
    if(!br) printf(":read zero bytes\n");
    if(!rc && br == 0){
        DosSleep(1L);   // yield to LanMan on zero byte read,  so it can detect any pipe error.
        rc = DosPeekNmPipe(hp, "", 0, &br, &ad, &state);
        if(!rc && state != NP_CONNECTED)
            rc = ERROR_BROKEN_PIPE;
    }
    *pbr = br;
    return rc;
}
