/*
 * $Id: mkdesc.c 1.1 92/09/19 19:01:39 davidn Exp Locker: davidn $
 * make descriptions file from articles in the current directory
 *
 * $Log:	mkdesc.c $
 * Revision 1.1  92/09/19  19:01:39  davidn
 * Initial revision
 *
 */

# include <stdio.h>
# include <stddef.h>
# include <stdlib.h>
# include <ctype.h>
# include <string.h>
# include <memory.h>
# include <dos.h>
# include <errno.h>

# include "dosdir.h"
# ifndef MAX_PATH
#  define MAX_PATH 128
# endif


# define DESCFILE "files.bbs"
# define ADDDOT   0

char descfile[MAX_PATH] = DESCFILE;

int line = 0;
const char *hdr[] =
{
	"Subject:",
	"Newsgroups:",
	"To:",
	"From:",
	"Path:"
	"Keywords:",
	"Summary:",
	NULL
};

const int hln[] =
{
	8,
	11,
	3,
	5,
	5,
	9,
	8
};

static char
*skip_whi (char *s)
{

	while (isspace (*s))
		++s;
	return s;
}



int
main (int argc, char *argv[])
{
	int 			j, carg;
	FILE			*ip, *fp;
	struct FFIND	ff;

	for (carg = 0; ++carg < argc; )
	{
		if (argv[carg][0] == '-')
		{
			switch (tolower (argv[carg][1]))
			{
				case 's':   line = 0;   break;
				case 'n':   line = 1;   break;
				case 't':   line = 2;   break;
				case 'f':   line = 3;   break;
				case 'p':   line = 4;   break;
				case 'k':   line = 5;   break;
				case 'u':   line = 6;   break;
			}
		}
	}

	fp = NULL;
	j = FINDFIRST (ALLFILES, _A_NORMAL, &ff);
	while (j == 0)
	{
		if (strcmp (f_name(&ff), descfile) != 0)
		{

# if ADDDOT
			if (strchr (f_name(&ff), '.') == NULL)
				strcat (f_name(&ff), ".");
# endif
			ip = fopen (f_name(&ff), "r");
			if (ip != NULL)
			{
				int lines, gotone;
				char buf[512];

				for (lines = gotone = 0; !gotone && fgets (buf, 512, ip) != NULL; )
				{
					gotone = (memcmp (buf, hdr[line], hln[line]) == 0);
					if (*buf == '\n')	/* Empty line */
						break;
				}

				if (gotone)
				{
					if (fp == NULL)
					{
						char * pp, bak[MAX_PATH];

						strcpy (bak, descfile);
						pp = strrchr (bak, '.');
						if (pp == NULL)
							pp = bak + strlen(bak);
						strcpy (pp, ".BAK");
						remove (bak);
						rename (descfile, bak);
						fp = fopen (descfile, "w");
						if (fp == NULL)
						{
							fprintf (stderr, "mkdesc: Can't create '%s' = %s\n", descfile, strerror(errno));
							rename (bak, descfile);
							break;
						}
					}

					fprintf (fp, "%s %s", f_name(&ff), skip_whi (buf + hln[line]));
					printf (".");
				}
				fclose (ip);
			}
		}
		j = FINDNEXT (&ff);
	}
	FINDCLOSE (&ff);
	if (fp != NULL)
	{
		fclose (fp);
		printf ("\n");
	}
	return 0;
}

