
/**
***  This file is part of the source to QQLink, a FTS-9 reply linker for
*** use with the Squish(tm) mail processor.
*** Copyright (c) 1993 Josh Parsons. All rights reserved, however:
***
***         1) You are permitted to freely distribute this source,
***           provided you do not remove this copyright notice, and
***           provided you do not charge a fee, for the service of
***           distributing this material, over and above the value
***           of disks, phone tolls, etc. incurred in such distribution.
***        2) You are permitted to use executables produced from this
***           source in the manner described in QQLink.DOC, which should
***           accompany this file.
***        3) You are permitted to use this source in your own programs,
***           provided that your derivative work carries an
***           acknowledgement that portions of its source are derived
***           from QQLink, by Josh Parsons.
***
***        NB: This source carries no warrantee, implicit or explicit
***            of fitness for any particular task.
**/


#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <io.h>
#include <fcntl.h>
#include <sys\stat.h>

#include "msgapi.h"
#include "qqdat.h"

#define LOCAL static

extern char link_slow;

int cdecl printf(const char *,...);

QQDAT *open_qq(const char *path,MSG *area,int is_squish,int method) {
  char buf[80];
  QQDAT *qq;
  // make a path to the QQLink info file for this area
  strcpy(buf,path);
  if(is_squish) strcat(buf,".QQL");
  else strcat(buf,"\\QQLINK.");
  // set up qq area struct
  if(area==NULL) return NULL;
  qq=calloc(1,sizeof(QQDAT));
  if(qq==NULL) return qq;
  qq->area=area;
  if(!link_slow) {
    qq->file=open(buf,O_CREAT|O_BINARY|O_RDWR,S_IREAD|S_IWRITE);
    if(qq->file<0) return NULL;
    _read(qq->file,&qq->f,sizeof(struct QQF));
    // if combined mode, (try to) load extra table
    if(qq->f.method==LINK_COM1)
      _write(qq->file,&qq->f2,sizeof(struct QQF));
    };

  // old version, or with wrong method, or doesn't exist? start anew!
  if(qq->f.sig!=QQL2_SIG||(method!=qq->f.method&&method!=LINK_LAST)||link_slow) {
    memset(&qq->f,0,sizeof(struct QQF));
    memset(&qq->f2,0,sizeof(struct QQF));
    qq->f.sig=QQL2_SIG;
    qq->f.method=LINK_FTS9;
    qq->f2.sig=QQL2_SIG;
    qq->f2.method=LINK_COM2;
    }
  if(method!=LINK_LAST) qq->f.method=method;
  qq->oldhigh=qq->f.high;
  return qq;
  };

static char cbuf[1024];
int trunc_qq=0;
LOCAL void makeid(MSGID *id,const char *s) {
  char b=0;
  int ctr=trunc_qq;
  while(*s) {
    (*id)+=((long)tolower(*s))<<b;
    b=(b+1)%24;
    s++;
    if((--ctr)==0) break;
    };
  if(*id==0) *id=1; // ID=0 is used for "no ID found" by getid()
  };
LOCAL void getid(MSGH *msg,MSGID *id,MSGID *oid) {
  char *msgid,*reply,*s;
  MsgReadMsg(msg,NULL,0,0,NULL,1000,cbuf);
  msgid=strstr(cbuf,"\01MSGID: ");
  reply=strstr(cbuf,"\01REPLY: ");
  *id=*oid=0;
  if(msgid) {
    msgid+=8;
    s=strchr(msgid,1);
    if(s) *s=0;
    makeid(id,msgid);
    };
  if(reply) {
    reply+=8;
    s=strchr(reply,1);
    if(s) *s=0;
    makeid(oid,reply);
    };
  };

LOCAL void flushxmsg(QQDAT *qq,int i) {
  MSGH *msg;
  if(qq->xmnum[i]<1||qq->xmflg[i]==0) return; // Leave the memorial NOW!
  msg=MsgOpenMsg(qq->area,MOPEN_RW,qq->xmnum[i]);
  if(msg==NULL) printf("\nInternal error flushing message %ld (%d)\n",qq->xmnum[i],i);
  else {
    MsgWriteMsg(msg,0,qq->xmbuf+i,NULL,0,0,0,NULL);
    MsgCloseMsg(msg);
    };
  qq->xmflg[i]=0;
  };

// this buffer is used to suppress redundant writes
static XMSG last_xmsg[1];
static long last_xnum;

static XMSG *readxmsg(QQDAT *qq,MSGH *msg,long msgn) {
  int i,j;
  last_xnum=msgn;
  // see if we've got it in a buffer...
  for(i=0;i<MAX_XMSG;i++) if(qq->xmnum[i]==msgn) {
    memcpy(last_xmsg,qq->xmbuf+i,sizeof(XMSG));
    return qq->xmbuf+i;
    };
  if(msg==NULL) return NULL;
  // see if there's an unused buffer to load it into
  for(i=0;i<MAX_XMSG;i++) if(qq->xmnum[i]==0) {
    MsgReadMsg(msg,qq->xmbuf+i,0,0,NULL,0,NULL);
    qq->xmnum[i]=msgn;
    qq->xmflg[i]=0;
    memcpy(last_xmsg,qq->xmbuf+i,sizeof(XMSG));
    return qq->xmbuf+i;
    };
  // find the least recently used buffer and use that
  i=0;
  for(j=0;j<MAX_XMSG;j++) if(qq->xmnum[j]<qq->xmnum[i]) i=j;
  if(qq->xmflg[i]) flushxmsg(qq,i);
  MsgReadMsg(msg,qq->xmbuf+i,0,0,NULL,0,NULL);
  qq->xmnum[i]=msgn;
  qq->xmflg[i]=0;
  memcpy(last_xmsg,qq->xmbuf+i,sizeof(XMSG));
  return qq->xmbuf+i;
  };
LOCAL void writexmsg(QQDAT *qq,MSGH *msg,long msgn,XMSG *xmsg) {
  int i;
  // check for a redundant write
  if(msgn==last_xnum) {
    if(!memcmp(xmsg,last_xmsg,sizeof(XMSG)))
      return;
    last_xnum=0;
    };
  // write the xmsg to buffer or disk
  for(i=0;i<MAX_XMSG;i++) if(qq->xmnum[i]==msgn) break;
  if(i>=MAX_XMSG||msg) {
    int i_opened=0;
    if(msg==NULL) {
      //printf("Internal error in writexmsg()\n");
      msg=MsgOpenMsg(qq->area,MOPEN_RW,msgn);
      i_opened++;
      };
    if(msg) MsgWriteMsg(msg,0,xmsg,NULL,0,0,0,NULL);
    if(i<MAX_XMSG) qq->xmflg[i]=0;
    if(i_opened&&msg) MsgCloseMsg(msg);
    }
  else qq->xmflg[i]=1;
  };

LOCAL long getsubj(QQDAT *qq,MSGH *msg,long msgn,int *to_all) {
  XMSG *xmsg=readxmsg(qq,msg,msgn);
  char *s=xmsg->subj;
  long id=0;
  extern char *all_name;
  // strip 'RE:'s and leading spaces.
  while(*s) {
    if(!strnicmp(s,"re:",3)) s+=3;
    else if(*s==' ') s++;
    else break;
    };
  // encode the subj.
  makeid(&id,s);
  if(all_name&&*all_name) *to_all=!stricmp(xmsg->to,all_name);
  else *to_all=0;
  return id;
  };

LOCAL void setorig(QQDAT *qq,MSGH *msg,long msgn,long uid) {
  int i;
  XMSG *xmsg;
  xmsg=readxmsg(qq,msg,msgn);
  xmsg->replyto=uid;
//  for(i=0;i<MAX_REPLY;i++) xmsg->replies[i]=0; /* used to clean new msgs */
  writexmsg(qq,msg,msgn,xmsg);
  };
LOCAL void setrepl(QQDAT *qq,MSGH *msg,long msgn,long uid,MSG *area) {
  int i,i_opened_msg=0;
  XMSG *xmsg;
  xmsg=readxmsg(qq,msg,msgn);
  if(xmsg==NULL&&msg==NULL) {
    msg=MsgOpenMsg(area,MOPEN_RW,msgn);
    i_opened_msg++;
    xmsg=readxmsg(qq,msg,msgn);
    };
  if(xmsg==NULL) return; // Still a problem?
  for(i=0;i<MAX_REPLY;i++) if(xmsg->replies[i]==0||xmsg->replies[i]==uid) break;
  i%=MAX_REPLY;
  xmsg->replies[i]=uid;
  writexmsg(qq,msg,msgn,xmsg);
  if(i_opened_msg) MsgCloseMsg(msg);
  };

#define ADJ(x) (((x)+MAX_MSGS)%MAX_MSGS)

LOCAL MSGID upd_table(struct QQF *qq,MSGID id,long uid) {
  qq->id[qq->topid]=id;
  qq->uid[qq->topid]=uid;
  qq->high=uid;
  qq->topid=ADJ(qq->topid+1);
  return id;
  };

int link_qq(QQDAT *_qq,MSGH *msg,long uid,int clean) {
  MSGID orig=0,msgid=0,auxid=0;
  // set up a couple of shortcuts
  MSG *area=_qq->area;
  struct QQF *qq=&(_qq->f);
  long msgn=MsgUidToMsgn(area,uid,UID_EXACT);
  int to_all;

  // if we're cleaning, wipe this message's reply links.
  if(clean) {
    XMSG *xmsg=readxmsg(_qq,msg,msgn);
    memset(xmsg->replies,0,sizeof(long)*MAX_REPLY);
    xmsg->replyto=0;
    writexmsg(_qq,msg,msgn,xmsg);
    };

  // get ID and ORIGID (for subject linking these are identical)
  switch(qq->method) {
    case(LINK_FTS9):
      getid(msg,&msgid,&orig);
      if(upd_table(qq,msgid,uid)==0)
        return 0; // No MSGID
      break;
    case(LINK_SUBJ):
      orig=msgid=getsubj(_qq,msg,msgn,&to_all);
      if(to_all) orig=0;
      upd_table(qq,msgid,uid);
      break;
    case(LINK_COM1):
      getid(msg,&msgid,&orig);
      auxid=getsubj(_qq,msg,msgn,&to_all);
      upd_table(qq,msgid,uid);
      upd_table(&_qq->f2,auxid,uid);
      if(!orig&&!to_all) {
        msgid=orig=auxid;
        qq=&_qq->f2;
        };
      break;
    };

  // if there's an original, try to link it.
  if(orig) {
    int i;
    // Scan backwards from the current msg for a match for orig
    for(i=ADJ(qq->topid-2);i!=qq->topid;i=ADJ(i-1))
      if(qq->id[i]==orig) break;
    // Found one?
    if(i!=qq->topid) {
      long omsgn=MsgUidToMsgn(area,qq->uid[i],UID_EXACT);
//      long msgn=MsgUidToMsgn(area,uid,UID_EXACT);
//      MSGH *omsg=NULL;
      if(msgn<0||omsgn==msgn) return 2;
      setorig(_qq,msg,msgn,qq->uid[i]);
      setrepl(_qq,/*omsg*/NULL,omsgn,uid,area);
      return 3; // Found original
      };
    return 2; // Can't find original
    };
  return 1; // No REPLY
  };

void close_qq(QQDAT *qq) {
  int i;
  if(qq==NULL) return;
  for(i=0;i<MAX_XMSG;i++) flushxmsg(qq,i);
  if(!link_slow) {
    if(qq->f.high!=qq->oldhigh) {
      lseek(qq->file,0,0);
      _write(qq->file,&qq->f,sizeof(struct QQF));
      // if combined mode, save extra table
      if(qq->f.method==LINK_COM1)
        _write(qq->file,&qq->f2,sizeof(struct QQF));
      _write(qq->file,NULL,0); // make sure we truncate file here.
      };
    close(qq->file);
    };
  free(qq);
  };

int percent_qq(QQDAT *qq,long msgnum) {
  int i,nided=0;
  if(msgnum<=0) return 0;
  if(msgnum>MAX_MSGS) msgnum=MAX_MSGS;
  for(i=0;i<msgnum;i++) if(qq->f.id[ADJ(qq->f.topid-i)]) nided++;
  return ((long)nided*100)/msgnum;
  };
