/* ARJDND.CMD */

/*   ARJ Drag & Drop v0.9    */
/*      written by           */
/*    Alexander Hoff         */

call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs

'@echo off'
call RxFuncAdd 'VInit', 'VREXX', 'VINIT'
initcode = VInit()
if initcode = 'ERROR' then signal CLEANUP

signal on failure name CLEANUP
signal on halt name CLEANUP
signal on syntax name CLEANUP

/* call init procedure */
call init 

/* get arguments */
PARSE UPPER ARG all_args
IF (WORD(all_args,1)="") THEN SIGNAL menue
ELSE DO
 IF (WORD(all_args,2)="") THEN DO
   filenames.1=all_args  /* create array containing filelist */
   filenames.0 = 1  /* one parameter parsed */
 END  
 ELSE signal ArgErr /* more than one argumente handed over */
END

/* ein Arj-Archive kann folgende Endungen haben .arj, .a01 , ... , .a99   */
/* Liegt bei dem bergebenen eine .a* Erweiterung vor, gehen wir davon aus*/
/* da ein Arj-Archive vorliegt ( andernfalls gibt Arj halt eine Fehler-  */
/* meldung aus ) */

IF (POS(".A",filenames.1) \=0) THEN SIGNAL entpacken
ELSE SIGNAL packen
 
/* ===================================== */

entpacken:

dummy=VDialogPos(50,50)

prompt.0 = 1
prompt.1 = ' Enter target-path ( e.g. : C:\TMP ) '
prompt.vstring = ''  /* init */

button=VInputBox(' ARJ Drag & Drop (Option : decompress) ',prompt,48,3)

if button='OK' then
   /* start ARJ in a DOS-background session */
     Session Arj OpDecompress filenames.1 prompt.vstring

signal CLEANUP

/* ===================================== */

packen:
   /* separate program's name and path */
 Name=FILESPEC("N",filenames.1)
 position=POS(Name,filenames.1)
 path=DELSTR(filenames.1,position)

 dummy=VDialogPos(50,60)

 msg.0 = 2
 msg.1 = ' Do you want to compress the directory'
 msg.2 = ' ' path
 button=VMsgBox(' ARJ Drag & Drop (Option : compress) ',msg,6)
 if button='YES' then do
   filenames.1=INSERT(path,Joker); /* fge Joker an den Pfad an */
 end
 else do
  filenames.1=INSERT(path,Name); 
 end
 
 dummy=VDialogPos(50,60)
 
 msg.0 = 1
 msg.1 = ' Add another file to archive ? '
 button=VMsgBox(' ARJ Drag & Drop (Option : compress) ',msg,6)
 if button='YES' then do /* show file select box and add selected */
                         /* file to filenames.i */        

   exit='FALSE'  /* init */
   do until (exit=TRUE) 
     count =  filenames.0 /* init */

     dummy=VDialogPos(50,60)

     selectbutton = VFileBox(' Select a file or choose >CANCEL< to continue ', path, 'file')
     if selectbutton='OK' then do
       count = count+1
       filenames.count=file.vstring  /* store selected file in array */
       filenames.0=count   /* increase array index */
         /* updating path is more comfortable (it may have changed) */
       Name=FILESPEC("N",filenames.count)
       position=POS(Name,filenames.count)
       path=DELSTR(filenames.count,position)
     end
     else exit='TRUE'

   end /* do until */ 
 end 

 dummy=VDialogPos(50,60)

 prompt.0 = 1
 prompt.1 = ' Enter target-path ( e.g. : A:\archive.arj)  '
 prompt.vstring = ''  /* init */

 button=VInputBox(' ARJ Drag & Drop (Option : compress) ',prompt,52,3)

 if button='OK' then do
   targetpath=prompt.vstring
 /* soll das komprimierte File auf mehrere Disketten verteilt werden ? */

   dummy=VDialogPos(50,60)

   prompt.0 = 5
   prompt.1 = ' If you want to enable multiple volumes, please   '
   prompt.2 = ' enter volume-size in k-byte (e.g. : 1440 builds  '
   prompt.3 = ' 1.4 MB volumes).  '
   prompt.4 = ' Otherwise click the OK button without entering   '
   prompt.5 = ' anything.  '
   prompt.vstring = ''  /* init */

   button=VInputBox(' ARJ Drag & Drop (Option : compress) ',prompt,60,3)
   if button='OK' then do
     if (prompt.vstring="") then ArjCompress=INSERT(OpCompress,OpSelfExtract)
     else do
         ArjCompress=INSERT(OpCompress,OpMultipleVol)
         ArjCompress=INSERT(ArjCompress,prompt.vstring)
         ArjCompress=INSERT(ArjCompress,"k")
     end
     if (filenames.0>1) then do   /* more than one file to compress ? */
       tmppath=DIRECTORY()
       tmppath=INSERT(tmppath,'\')
       filename=INSERT(tmppath,TmpFilename)
        /* erase old tmp file */
       result=SysFileDelete(filename)

         /* save filelist to tmp.file */
       do i=1 to filenames.0
         result=LINEOUT(filename,filenames.i)
       end

         /* check, if an error occured */
       if result<>0 then signal savelisterr

         /* close file */
       dummy=stream(filename,'C','close')

         /* starte ARJ in einer DOS-Background Session */
       FileList=INSERT(OpFileList,filename)
       Session Arj ArjCompress targetpath FileList
     end
     else /* only one file to compress */ 
       Session Arj ArjCompress targetpath filenames.1
   end   
 end

SIGNAL CLEANUP

/* ===================================== */

savelisterr:
 dummy=VDialogPos(50,60)

 msg.0 = 8
 msg.1 = ' Error during saving file :  '
 msg.2 = ' ' filename
 msg.3 = ''
 msg.4 = ' Error code : ' result
 msg.5 = ''
 msg.6 = ' Instruction:  '
 msg.7 = '   After correcting this error ( you may start   '
 msg.8 = '   another task ), please restart the program.   '

 button=VMsgBox('                      Status ',msg,1)

 dummy=VDialogPos(50,50)

signal CLEANUP   /* not nice, but it works */

/* ===================================== */

loadcfg:   /* load previous saved data and init program const. */
   /* init program const. */
 Joker='*.*'
 ArjName='arj.exe'
 CfgFilename='arjdnd.cfg'
 TmpFilename='arjdnd.tmp'
 OpFileList='!'
 
 path=DIRECTORY()
 path=INSERT(path,'\')

   /* check, if cfg-file exists */
 filename = INSERT(path,CfgFilename)
 status = STREAM(filename,'C','QUERY EXISTS') 
 if status='' then signal loaderr

 /* now i need the size of arjdnd.cfg */
 filelen = STREAM(filename,'C','QUERY SIZE')
 
 /* get data ... */
 do i=1 to filelen
   help.i=CHARIN(filename,,1)
 end
 
 /* eliminate the previous added '@' (procedure savecfg) */
 /* and transfer data to the array cfgdata               */
 index = 1
 cfgdata.index = '' /* init */
 do i=1 to filelen
   if help.i<>'@' then
     cfgdata.index=INSERT(cfgdata.index,help.i)
   else do
     if (i<>filelen) then do  /* the last endmark must not be used */
      index=index+1
      cfgdata.index= '' /* init */
     end
   end
 end

    /* init configuration with previous loaded data */
ArjPath=cfgdata.1
OpCompress=cfgdata.2
OpDecompress=cfgdata.3
OpMultipleVol=cfgdata.4
OpSelfExtract=cfgdata.5
Session=cfgdata.6
Arj=INSERT(ArjPath,ArjName)

    /* close file */
dummy=stream(filename,'C','close')   

RETURN
  
/* =================================== */

loaderr:
 dummy=VDialogPos(50,60)

 msg.0 = 4
 msg.1 = ' Error during loading file :  '
 msg.2 = ' ' filename
 msg.3 = ''
 msg.4 = '          CONTINUE ?  '

 button=VMsgBox('            Status ',msg,6)

 dummy=VDialogPos(50,50)

 if button='YES' then
   return
 else
   signal cleanup     /* not nice but it works */

/* ===================================== */

savecfg:   /* save configuration */
 path=DIRECTORY()
 path=INSERT(path,'\')

 filename=INSERT(path,CfgFilename)  

 /* erase cfg-files (override is difficult) */
 result=SysFileDelete(filename)

 /* now write a new cfg-file and insert endmark */
 do i=1 to index
   help=INSERT(cfgdata.i,'@')  /* i need endmark of each index for loading */
   result=CHAROUT(filename,help) /* therefor insert endmark '@' */
 end

   /* check, if an error occured */
 if result<>0 then signal saverr

   /* close file */
 dummy=stream(filename,'C','close')

RETURN

/* =================================== */

saverr:

dummy=VDialogPos(50,60)

msg.0 = 10
msg.1 = ' Error during saving file : '
msg.2 = ' ' filename
msg.3 = ''
msg.4 = ' Error code : ' result
msg.5 = ''
msg.6 = ' Instruction:  '
msg.7 = '   After correcting this error ( you may start    '
msg.8 = '   another task ), please change a configuration  ' 
msg.9 = '   entry in order to override damaged files with  '
msg.10= '   correct values.  '

button=VMsgBox('                      Status ',msg,1)

dummy=VDialogPos(50,50)

signal menue

/* =================================== */
chcfg:

 dummy=VDialogPos(50,60)

 prompt.0 = 6
 prompt.1 = 'Path to arj  : '
 prompt.2 = 'Session call : '
 prompt.3 = 'Compress parameter   : '
 prompt.4 = 'Decompress parameter : '
 prompt.5 = 'Multiple volume parameter : '
 prompt.6 = 'Self extract parameter    : '

 width.0 = 6   /* width in characters */
 width.1 = 46
 width.2 = 46
 width.3 = 8
 width.4 = 8
 width.5 = 8
 width.6 = 8

 hide.0 = 6
 hide.1 = 0 /* echo all inputs */
 hide.2 = 0
 hide.3 = 0
 hide.4 = 0
 hide.5 = 0
 hide.6 = 0

 change.0 = 5
 change.1 = ArjPath  /* default strings */
 change.2 = Session
 change.3 = OpCompress
 change.4 = OpDecompress
 change.5 = OpMultipleVol
 change.6 = OpSelfExtract

 button=VMultBox(' Change current configuration ',prompt,width,hide,change,3)

 if button='OK' then
   do          
     change.1 = STRIP(change.1,T) /* delete all blanks at string end */
        /* check, if the last char is the required backslash */
     if ( LASTPOS('\',change.1) \= LENGTH(change.1) ) then 
       change.1=INSERT(change.1,'\')

     cfgdata.1    = change.1

     change.3 = STRIP(change.3,T)
     change.3 = INSERT(change.3,' ') /* ! */
     cfgdata.2    = change.3

     change.4 = STRIP(change.4,T)
     cfgdata.3    = change.4

     change.5 = STRIP(change.5,T)
     cfgdata.4    = change.5

     change.6 = STRIP(change.6,T) 
     change.6 = INSERT(change.6,' ')
     cfgdata.5    = change.6

     change.2 = STRIP(change.2,T)
     change.2 = INSERT(change.2,' ')
     cfgdata.6    = change.2 

       /* update current programm variables */
     ArjPath = cfgdata.1
     OpCompress = cfgdata.2
     OpDecompress = cfgdata.3
     OpMultipleVol = cfgdata.4
     OpSelfExtract = cfgdata.5
     Session = cfgdata.6  
   
       /* save new configuration to arjdnd.cfg file */
     call savecfg
   end

 dummy=VDialogPos(50,50)
   
 signal menue

/* =================================== */

ArgErr:
 dummy=VDialogPos(50,60)
 
 msg.0 = 8
 msg.1 = '             Argument Error !!! '
 msg.2 = '' 
 msg.3 = 'Explanation : '
 msg.4 = ' This program DOES NOT accept more than one '
 msg.5 = ' parameter. Please restart the program with '    
 msg.6 = ' parsing only one parameter and you will    '
 msg.7 = ' certainly understand why there is no need  ' 
 msg.8 = ' need to accept more parameters. '

 call VMsgBox' ARJ Drag & Drop v0.9 ',msg,1

 signal CLEANUP     /* not nice but it works */

/* =================================== */

/* menue box : */

menue:

call VDialogPos 50,50

table.rows = 3
table.cols = 1
table.width.1 = 38

table.1.1 = 'Product Information  '
table.2.1 = 'Change Configuration  '
table.3.1 = 'Quit  '

button = VTableBox('      Arj Drag & Drop v0.9',table,4,38,5,1)
selection = table.vstring

if selection = '1' then
  call productinfo
if selection = '2' then
  call chcfg
if selection = '3' then
  signal CLEANUP
else signal menue

signal menue  /* just to be sure */

/* ===================================== */

productinfo:

call VDialogPos 50,60

msg.0 = 9
msg.1 = '         ARJ Drag & Drop v0.9   '
msg.2 = ''
msg.3 = '              written by         '
msg.4 = ''
msg.5 = '            Alexander Hoff       '
msg.6 =''
msg.7 = '     Thanks to Boris Boehlen for  '
msg.8 = '       having made some helpful   '
msg.9 = '            contributions         '
call VMsgBox '           Information',msg,1
RETURN

/* ===================================== */

HowtoUse:
RETURN

/* ===================================== */

init: 

 index = 0
 cfgdata.0 = index /* init configuration array */
 signal loadcfg 

RETURN

/* ===================================== */

/* exit with init : */

CLEANUP:
call VExit
exit

