#include "stdio.h"
#include "math.h"
#include "malloc.h"
#include "memory.h"
#include "string.h"

int	DECOMPRESS_FACTORS = 0;
int	DECOMPRESS_NOFACTORS = 0;
unsigned long START = 0;
unsigned long END = 999999999;

#define bitset(a,i)	{ a[(i) >> 3] |= (1 << ((i) & 7)); }
#define bitclr(a,i)	{ a[(i) >> 3] &= ~(1 << ((i) & 7)); }
#define bittst(a,i)	(a[(i) >> 3] & (1 << ((i) & 7)))

/* Return TRUE if arg is a prime */

int isprime (
	unsigned long p)
{
	unsigned long f, fmax;
	if ((p & 1) == 0) return (p == 2);
	if (p % 3 == 0) return (p == 3);
	fmax = sqrt (p);
	for (f = 5; f <= fmax; f += 6) {
		if (p % f == 0) return (0);
		if (p % (f+2) == 0) return (0);
	}
	return (1);
}

/* Use a simple sieve to find prime numbers */

#define MAX_PRIMES	6600
static	unsigned int num_primes = 0;
static	unsigned int *primes = NULL;
static	struct sieve_info {
	unsigned long first_number;
	unsigned int bit_number;
	unsigned int num_bits;
	unsigned long start;
	unsigned long end;
	char	array[4096];
} si;

/* Start sieve by allocate a sieve info structure */

void start_sieve (
	unsigned long start,
	unsigned long end)
{
	unsigned int i, fmax;

	if (start < 3) start = 3;
	si.start = start;
	si.end = end;
	si.first_number = start | 1;
	si.bit_number = 1;
	si.num_bits = 0;

	if (primes == NULL) {
		unsigned int f;
		primes = (unsigned int *) malloc (MAX_PRIMES * 2 * sizeof (unsigned int));
		for (i = 0, f = 3; i < MAX_PRIMES * 2; f += 2)
			if (isprime (f)) primes[i] = f, i += 2;
	}

/* Determine the first bit to clear */

	fmax = (unsigned int) sqrt ((double) end);
	for (i = 0; i < MAX_PRIMES * 2; i += 2) {
		unsigned long f, r, bit;
		f = primes[i];
		if (f > fmax) break;
		if (si.first_number == 3) {
			bit = (f * f - 3) >> 1;
		} else {
			r = (unsigned long) (si.first_number % f);
			if (r == 0) bit = 0;
			else if (r & 1) bit = (f - r) / 2;
			else bit = (f + f - r) / 2;
			if (f == si.first_number + 2 * bit) bit += f;
		}
		primes[i+1] = bit;
	}
	num_primes = i;
}

/* Return next prime from the sieve */

unsigned long sieve ()
{
	unsigned int i;

/* Return next prime in the sieve */

ret:	while (si.bit_number < si.num_bits) {
		unsigned int bit = si.bit_number++;
		if (bittst (si.array, bit))
			return (si.first_number + 2 * bit);
	}

/* See if we are done */

	si.first_number += 2 * si.num_bits;
	if (si.first_number > si.end) 
		return (0xFFFFFFFF);

/* Fill the sieve with ones, then zero out the composites */

	memset (si.array, 0xFF, sizeof (si.array));
	si.num_bits = (unsigned int) (si.end - si.first_number) / 2 + 1;
	if (si.num_bits > sizeof (si.array) * 8)
		si.num_bits = sizeof (si.array) * 8;
	for (i = 0; i < num_primes; i += 2) {
		unsigned int f, bit;
		f = primes[i];
		for (bit = primes[i+1]; bit < si.num_bits; bit += f)
			bitclr (si.array, bit);
		primes[i+1] = bit - si.num_bits;
	}
	si.bit_number = 0;
	goto ret;
}

void end_sieve ()
{
}

/* Do an addition on an ascii number */

void ascadd (char *n, unsigned long amt)
{
	unsigned long digit;
	char	*p;

	p = n + strlen (n);
	for ( ; ; ) {
		digit = *--p - '0';
		if (digit + amt >= 10) {
			*p = (char) (digit + amt - 10 + '0');
			amt = 1;
		} else {
			*p = (char) (digit + amt + '0');
			break;
		}
		if (p == n) {
			char	buf[200];
			strcpy (buf, n);
			n[0] = '1';
			strcpy (n+1, buf);
			break;
		}
	}
}

/* Do a multiplication on an ascii number */

void ascmul (char *n, unsigned long p, char *res)
{
	char	buf[200];
	char	*q, *r;
	unsigned long val, tmp;

	r = buf + 199; *r = 0;
	q = n + strlen (n);
	val = 0;
	for ( ; ; ) {
		if (q != n) val += (*--q - '0') * p;
		tmp = val / 10;
		*--r = (char) (val - tmp * 10 + '0');
		val = tmp;
		if (val == 0 && q == n) break;
	}
	strcpy (res, r);
}

/* Decompress factoring data */

void decompress_factors (char *fname)
{
static	FILE	*out = NULL;
	FILE	*factors;
	unsigned long p, count, inc;
	char	str[200], fac[200], k[200], *q;

	factors = fopen (fname, "r");
	if (factors == NULL) {
		printf ("Error opening %s\n", fname);
		return;
	}

	if (out == NULL) {
		out = fopen ("factors", "w");
		if (out == NULL) {
			printf ("Error opening factors\n");
			return;
		}
	}

	p = 0;
	for ( ; ; ) {
		str[0] = 0;
		for (q = str; ; q++) {
			*q = getc (factors);
			if (feof (factors)) goto done;
			if (*q == '\n') {
				*q = 0;
				break;
			}
		}

		q = strchr (str, ',');

		if (q == NULL) {
			q = str;
			if (str[0] == 0)
				count = 0;
			else if (isdigit (str[0]))
				count = *q++ - '0';
			else if (str[0] >= 'A' && str[0] <= 'Z')
				count = *q++ - 'A' + 10;
			else if (str[0] >= 'a' && str[0] <= 'z')
				count = *q++ - 'a' + 36;
		} else if (p != 0 && q - str <= 5) {
			*q++ = 0;
			count = atoi (str) + 62;
		} else {
			*q++ = 0;
			p = atoi (str);
			while (sieve () != p);
			goto skip_count;
		}

		p = sieve ();
		while (count--) p = sieve ();

skip_count:	if (q[0] == 0) strcpy (q, "0");

		if ((p & 3) == 1)
			if ((q[strlen(q)-1] - '0') & 1)
				inc = 2;
			else
				inc = 3;
		else
			if ((q[strlen(q)-1] - '0') & 1)
				inc = 2;
			else
				inc = 1;
		ascmul (q, 2, k);
		ascadd (k, inc);

		if (DECOMPRESS_FACTORS == 2)
			strcpy (fac, k);
		else {
			ascmul (k, p + p, fac);
			ascadd (fac, 1);
		}

		if (p > END) break;
		if (p >= START) fprintf (out, "%lu,%s\n", p, fac);
	}


done:	fclose (factors);
}

/* Decompress nofactoring data */

void decompress_nofactors (char *nofname)
{
static	FILE	*out = NULL;
	FILE	*nofactors;
	unsigned long p, count, limit;
	char	str[200], *q;

	nofactors = fopen (nofname, "r");
	if (nofactors == NULL) {
		printf ("Error opening %s\n", nofname);
		return;
	}

	if (out == NULL) {
		out = fopen ("nofactor", "w");
		if (out == NULL) {
			printf ("Error opening nofactor\n");
			return;
		}
	}

	p = 0;
	for ( ; ; ) {
		str[0] = 0;
		for (q = str; ; q++) {
			*q = getc (nofactors);
			if (feof (nofactors)) goto done;
			if (*q == '\n') {
				*q = 0;
				break;
			}
		}

		q = strchr (str, ',');

		if (q == NULL) {
			q = str;
			if (str[0] == 0)
				count = 0;
			else if (isdigit (str[0]))
				count = *q++ - '0';
			else if (str[0] >= 'A' && str[0] <= 'Z')
				count = *q++ - 'A' + 10;
			else if (str[0] >= 'a' && str[0] <= 'z')
				count = *q++ - 'a' + 36;
		} else if (p != 0 && q - str <= 5) {
			*q++ = 0;
			count = atoi (str) + 62;
		} else {
			*q++ = 0;
			p = atoi (str);
			limit = atoi (q);
			while (sieve () != p);
			goto output;
		}

		p = sieve ();
		while (count--) p = sieve ();

		if (q[0] == 0) goto output;
		if (q[1]) 
			limit = atoi (q);
		else if (q[0] < '5')
			limit += q[0] - '0' + 1;
		else
			limit -= q[0] - '5' + 1;

output:		if (p > END) break;
		if (p >= START) {
			if (DECOMPRESS_NOFACTORS == 2)
				fprintf (out, "Test=");
			if (DECOMPRESS_NOFACTORS == 3)
				fprintf (out, "Factor=");
			fprintf (out, "%lu,%lu\n", p, limit);
		}
	}

done:	fclose (nofactors);
}

/* Decompress factoring data */

void decompress ()
{
	if (DECOMPRESS_FACTORS) {
		start_sieve (3, 79300000);
		decompress_factors ("factors.cmp");
		end_sieve ();
	}
	if (DECOMPRESS_NOFACTORS) {
		start_sieve (3, 79300000);
		decompress_nofactors ("nofactor.cmp");
		end_sieve ();
	}
}

/* Decompress factoring data */

void main (int argc, char **argv)
{
	int	i, number = 0;
	char	*p;

/* Process command line switches */

	for (i = 1; i < argc; i++) {
		p = argv[i];

		if (isdigit (*p)) {
			if (number == 0) START = atoi (p);
			else END = atoi (p);
			number = 1;
			continue;
		}

		if (*p++ != '-') break;
		switch (*p++) {

		case 'F':
		case 'f':
			DECOMPRESS_FACTORS = 1;
			break;

		case 'K':
		case 'k':
			DECOMPRESS_FACTORS = 2;
			break;

		case 'N':
		case 'n':
			DECOMPRESS_NOFACTORS = 1;
			break;

		case 'T':
		case 't':
			DECOMPRESS_NOFACTORS = 2;
			break;

		case 'W':
		case 'w':
			DECOMPRESS_NOFACTORS = 3;
			break;

/* Otherwise unknown switch */

		default:
			printf ("Invalid switch\n");
		}
	}

	decompress ();
}
