


SHAR(1)                                                   SHAR(1)


NNAAMMEE
       shar - create shell archives

SSYYNNOOPPSSIISS
       shar [ options ] file ...
       shar -S [ options ]

DDEESSCCRRIIPPTTIIOONN
       Shar creates "shell archives" (or shar files) which are in
       text format and can be mailed. These files may be unpacked
       later  by  executing  them  with  /bin/sh.  The  resulting
       archive is sent to standard out unless the  _-_o  option  is
       given.   A wide range of features provide extensive flexi-
       bility in  manufacturing  shars  and  in  specifying  shar
       "smartness."   Archives may be "vanilla" or comprehensive.
       This manual page reflects shar version 3.49.

   OOPPTTIIOONNSS
       Options can be given in any order. Some options depend  on
       each other:
            The _-_o option is required if the _-_l or _-_L option is used.
            The _-_n option is required if the _-_a option is used.
            See _-_V below.

       _-_V     Produce  "vanilla"  shars  which rely only upon the
              existence of sed and echo in the unsharing environ-
              ment.   In  addition,  "if  test" must also be sup-
              ported if the _-_X option is used.  The  _-_V  silently
              disables options offensive to the "network cop" (or
              "brown shirt"), but does warn you if it  is  speci-
              fied  with  _-_B,  _-_C, _-_p or _-_M (any of which does or
              might require uudecode or compress in the unsharing
              environment).

       _-_v     Verbose  OFF. Disables the inclusion of comments to
              be output when the archive is unpacked.

       _-_w     Do NOT check with 'wc -c' after unpack. The default
              is to check.

       _-_n name
              Name of archive to be included in the header of the
              shar files.  See the _-_a switch.

       _-_a     Allows automatic generation of headers:
                   Submitted-by: who@where
                   Archive-name: <name>/part##
              The <name> must be given with the  _-_n  switch.   If
              name includes a '/' "/part" isn't used. Thus:
                 -n xyzzy                      produces:
                                               xyzzy/part01
                                               xyzzy/part02

                 -n xyzzy/patch                produces:



                         August 12, 1990                        1





SHAR(1)                                                   SHAR(1)


                                               xyzzy/patch01
                                               xyzzy/patch02

                 -n xyzzy/patch01.             produces:
                                               xyzzy/patch01.01
                                               xyzzy/patch01.02

              The  who@where can be explicitly stated with the _-_s
              switch if the default isn't apropriate.   Who@where
              is essentially built as `whoami`@`uname`.

       _-_s who@where
              Override automatically determined submitter name.

       _-_x     Overwrite existing files without checking.  If nei-
              ther _-_x nor _-_X is specified, the unpack will  check
              for and not overwrite existing files when unpacking
              the archive (unless '-c' is passed as  a  parameter
              to the script when unpacking).

       _-_X     Interactively  overwrite existing files (DO NOT USE
              FOR SHARS SUBMITTED TO THE NET).

       _-_B     Treat all files as binary, use  uuencode  prior  to
              packing.  This  increases  the size of the archive.
              The  recipient  must  have  uudecode  in  order  to
              unpack.   (USE  OF  UUENCODE  IS NOT APPRECIATED BY
              MANY ON THE NET).

       _-_T     Treat all files as text (default).

       _-_C     Compress and uuencode all files prior  to  packing.
              The  recipient must have uudecode and uncompress in
              order to unpack (USE OF UUENCODE  AND  COMPRESS  IS
              NOT APPRECIATED BY MANY ON THE NET).

       _-_m     Generate 'touch' commands to restore the file modi-
              fication  dates  when  unpacking  files  from   the
              archive.

       _-_p     Allow  positional  parameter  options.  The options
              "_-_B" and "_-_T" and "_-_C" may be embedded,  and  files
              to the right of the option will be processed in the
              specified mode.

       _-_b X   When doing compression, use '-bX' as a parameter to
              compress.  The _-_B options turns on the _-_C option by
              default.

       _-_M     Mixed mode. Determine if  the  files  are  text  or
              binary  and  archive  correctly.  Files found to be
              binary are uudecoded prior to packing (USE OF UUEN-
              CODE IS NOT APPRECIATED BY MANY ON THE NET).




                         August 12, 1990                        2





SHAR(1)                                                   SHAR(1)


       _-_P     Use  temporary  files  instead of pipes in the shar
              file.

       _-_c     Start the shar with a cut line. A line saying  'Cut
              here' is placed at the start of each output file.

       _-_f     Restore  by  filename  only, rather than path. This
              option causes only file names to be used, which  is
              useful  when  building a shar from several directo-
              ries, or another directory.  Note that if a  direc-
              tory  name  is  passed to shar, the substructure of
              that directory will be restored whether _-_f is spec-
              ified or not.

       _-_d XXX Use XXX to delimit the files in the shar instead of
              SHAR_EOF.  This is for those who want to  personal-
              ize their shar files.

       _-_F     Forces  the  prefix  character (normally 'X' unless
              the parameter to the _-_d option starts with 'X')  to
              be  prepended  to  every line even if not required.
              This option may slightly increase the size  of  the
              archive, especially if _-_B or _-_C is used.

       _-_o XXX Save  the  archive  to  files  XXX.01  thru  XXX.nn
              instead of standard out.  Must be used when the  _-_l
              or the _-_L switches are used

       _-_l XX  Limit  the  output file size to XXk bytes but don't
              split input files.

       _-_L XX  Limit output file size to XXk bytes and split files
              if necessary. The archives created with this option
              must be unpacked in correct order.

       _-_S     Read list of files to be packed from  the  standard
              input  rather  than  from  the command line.  Input
              must be in a form similar to that generated by  the
              find  command,  one filename per line.  This switch
              is especially useful when the command line will not
              hold the list of files to be packed. For example:

              find . -type f -print | sort | shar -S -C -L50 -o /tmp/big

              If  _-_p  is  specified on the command line, then the
              options "_-_B" and "_-_T" and "_-_C" may be  included  in
              the  standard  input (on a line separate from file-
              names).  The maximum number of  lines  of  standard
              input, file names and options, may not exceed 1024.

EEXXAAMMPPLLEESS
       shar *.c > cprog.shar                # all C prog sources
       shar -v *.[ch] > cprog.shar          # non-verbose, .c and .h files
       shar -B -l28 -oarc.sh *.arc          # all binary .arc files, into



                         August 12, 1990                        3





SHAR(1)                                                   SHAR(1)


                                            # files arc.sh.01 thru arc.sh.NN
       shar -f /lcl/src/u*.c > u.sh         # use only the filenames

WWAARRNNIINNGGSS
       No chmod or touch is ever generated for  directories  cre-
       ated  when  unpacking.   Thus,  if a directory is given to
       shar, the protection and modification dates of correspond-
       ing  unpacked  directory may not match those of the origi-
       nal.

       If a directory is passed to shar, it may be  scanned  more
       than  once.   Therefore,  one should be careful not change
       the directory while shar is running.

       Be careful that the output file(s) are not included in the
       inputs  or shar may loop until the disk fills up.  Be par-
       ticularly careful when a directory is passed to shar  that
       the output files are not in that directory (or a subdirec-
       tory of that directory).

       Use of the _-_B, _-_M or _-_C may slow the archive process  con-
       siderably, depending on the number of files.

       Use  of  _-_X  produces shars which _W_I_L_L cause problems with
       many  unshar  procedures.   Use  this  feature  only   for
       archives to be passed among agreeable parties.  Certainly,
       _-_X is NOT for shell archives which are to be submitted  to
       Usenet.   Usage of _-_B or _-_C in net shars will cause you to
       be flamed off the earth.  Using _-_m or  not  using  _-_F  may
       also get you occasional complaints.

SSEEEE AALLSSOO
       unshar(1)

DDIIAAGGNNOOSSTTIICCSS
       Error  messages  for  illegal or incompatible options, for
       non-regular,  missing  or  inaccessible   files   or   for
       (unlikely) memory allocation failure.

AAUUTTHHOORRSS
       shar3 is a derived work based on the efforts of:
       decvax!microsof!uw-beave!jim (James Gosling at CMU)
       Michael A. Thompson, Dalhousie University, Halifax, N.S., Canada
       davidsen@sixhub (Bill Davidsen)
       rhg@CPS.COM (Richard H. Gumpertz)
       colas@avahi.inria.fr (Colas Nahaboo)
       bill@netagw.com (Bill Aten)
       dennis%nanovx@gatech.edu (Dennis Boylan)
       wht%n4hgf@gatech.edu (Warren Tucker)
       (other anonymous persons)

       man pages:
       jhd@irfu.se (Jan Dj{rv)




                         August 12, 1990                        4


