char *revision = "3.49";
char RCS_ID[] = "$Header: /u/rhg/src/shar/shar.c,v 3.49 90/09/12 15:14:41 rhg Exp $";
/*
** shar.c

  Defined functions:
	gen_mkdir(path)
	gen_mkdir_script(path)
	setTOUCH()
	walktree(rtn,rootname)
	header(argc,argv)
	helpuser()
	main(argc,argv)
	mode_map(mode,mode_str)
	shar(file,RstrName)

*/
/*+:EDITS:*/
/*:09-12-1990-14:24-rhg@cps.com-added missing return(0) to walkdown */
/*:09-12-1990-14:13-rhg@cps.com-deleted some redundant, unused, code */
/*:09-12-1990-00:28-rhg@cps.com-added more directions to the shar header */
/*:09-09-1990-20:12-rhg@cps.com-added CLOSEDIR_VOID */
/*:09-09-1990-18:42-rhg@cps.com-added check for "From" under OptPREFIX */
/*:09-09-1990-11:55-rhg@cps.com-modified code under NOT STR(N)CMP_IS_FAST */
/*:09-08-1990-21:20-rhg@cps.com-added NO_DIRENT for SunOS 3 sys/dir.h */
/*:09-08-1990-21:04-rhg@cps.com-fixed bug in PREFIX check: strcmp(line,Delim) */
/*:08-06-1990-00:40-rhg@cps.com-revised Cut message to be more explanatory */
/*:08-05-1990-14:04-rhg@cps.com-merged Rname into walktree */
/*:08-05-1990-12:11-rhg@cps.com-added walktree & support for sharing dirs */
/*:08-05-1990-09:05-rhg@cps.com-change -Bn, -t, and -b to -bn, -T, and -B */
/*:08-04-1990-15:31-rhg@cps.com-added -Bn to set compress -bn (default 12) */
/*:08-04-1990-15:31-rhg@cps.com-changed shar3_???_.tmp to _shar_???_.tmp */
/*:08-04-1990-15:22-rhg@cps.com-added check for "exit 0" under OptPREFIX */
/*:08-04-1990-14:32-rhg@cps.com-added -m to generate TOUCH (default off) */
/*:08-04-1990-14:18-rhg@cps.com-reversed the meaning of -x and deleted -O */
/*:06-14-1990-14:48-rhg@cps.com-made Split and eXists compatible.
/*:06-14-1990-14:18-rhg@cps.com-made -x the default and added -O
/*:06-14-1990-12:44-rhg@cps.com-always terminate the && and report failures
/*:06-14-1990-12:28-rhg@cps.com-clear mkdir_already between -l files
/*:06-14-1990-12:14-rhg@cps.com-change PREFIX from a #define to an int variable.
/*:04-19-1990-22:49-rhg@cps.com-get rid of "set" so "sh sharfil -c" will work */
/*:04-19-1990-21:52-rhg@cps.com-add -F to clear OptPREFIX */
/*:04-18-1990-08:49-rhg@cps.com-add OptPREFIX (for now, always on) */
/*:07-09-1990-19:24-wht@n4hgf-back to fgrep amc -- fits more -m touches */
/*:07-01-1990-18:37-wht@n4hgf-wait() needed after fork() */
/*:05-19-1990-02:47-wht@n4hgf-change fgrep amc to mmdd */
/*:05-16-1990-01:53-wht@n4hgf-Archive-name had extra period sometimes */
/*:05-10-1990-20:39-wht@n4hgf-altos does not not like at-sign in filenames */
/*:05-10-1990-13:38-wht@n4hgf-add -V Vanilla mode */
/*:05-07-1990-00:06-wht@n4hgf-test all mallocs for Purity Of Essence */
/*:05-07-1990-00:06-wht@n4hgf-add -S switch */
/*:05-05-1990-01:37-relay.EU.net!rivm!a3-dont assume vax is running BSD */
/*:04-18-1990-02:01-wht@n4hgf-3.20 rhg@cps.com did all the NICE work */
/*:04-17-1990-14:30-rhg@cps.com-pretty up if-then-else-fi in shar file */
/*:04-17-1990-12:13-rhg@cps.com-add Split and renamed old -l to -L */
/*:04-17-1990-12:13-rhg@cps.com-add -c option to shar file execution */
/*:04-17-1990-11:20-rhg@cps.com-simplify TOUCH logic in shar file */
/*:04-17-1990-10:27-rhg@cps.com-create setTOUCH to avoid duplicate code */
/*:04-17-1990-04:43-rhg@cps.com-add missing && to commands in shar file(s) */
/*:04-17-1990-02:03-rhg@cps.com-add Compress */
/*:04-16-1990-17:08-rhg@cps.com-add AvoidPipes as well as code to use pipes */
/*:04-03-1990-20:09-wht@n4hgf-3.11 */
/*:04-01-1990-13:20-pat@rwing-correct case on M option in getopt() call */
/*:04-01-1990-13:50-pat@rwing-change defaults on -v, -w to be on */
/*:03-29-1990-18:23-wht@n4hgf-add automatic sequent support */
/*:03-28-1990-15:56-wht@n4hgf-add mode and length net.bandwidth chrome */
/*:03-28-1990-14:23-wht@n4hgf-correct some runtime diagnostics */
/*:11-14-1989-02:21-wht-SHAR_EOF was botched if last file char not newline */
/*:11-02-1989-14:11-wht-add touch -am */

/*
 Shar puts readable text files together in a package
 from which they are easy to extract.
 earlier attribution wht@n4hgf has:	decvax!microsof!uw-beave!jim
                                    (James Gosling at CMU)
*/
/*
 *	I have made several mods to this program:
 *
 *	1) the -----Cut Here-----... now preceds the script.
 *	2) the cat has been changed to a sed which removes a prefix
 *	character from the beginning of each line of the extracted
 *	file, this prefix character is added to each line of the archived
 *	files and is not the same as the first character of the
 *	file delimeter.
 *	3) added several options:
 *		-c	- add the -----Cut Here-----... line.
 *		-d'del' - change the file delimeter to del.
 *		-s	- cause the resulting script to print the wc of
 *			  the orignal file and the wc of the extracted
 *			  file.
 *
 *				Michael A. Thompson
 *				Dalhousie University
 *				Halifax, N.S., Canada.
 */

/*
 *	I, too, have been hacking this code. This is the version on sixhub
 *		bill davidsen (davidsen@sixhub.uucp)
 *
 *	- added support for binary files
 *	- automatic creation of limited size multiple file archives,
 *	  each of which may be unpacked separately, and with sequence
 *	  checking.
 *	- support for mixed text and binary files
 *	- preserve file permissions
 *	- restore to filename rather than pathname
 *
 */
/*
 *  One good hack deserves another ... this version generates shell
 *  code which attempts to create missing directories
 *  handle deviants sun, vax, pyr (pyramid), SCO XENIX/UNIX automatically
 *  for sequent, add -DBSD42
 *  force Verbose on
 *  if unsharing system's touch Sys V compatible (allows touch -m),
 *  restore file dates
 *  -n switch puts an alpha "name" in header
 *  -a (if also -n) puts "Submitted-by:" & "Archive-name: <name>/part##
 *  use getopt
 *  as well as some other chrome-plated junque
 *  ...!gatech!emory!tridom!wht (wht%n4hgf@gatech.edu) Warren Tucker
 *
 *  3.11 - Fri Apr  6 14:21:51 EDT 1990
 *  With due deference to davidsen@sixhub, more changes..... copies
 *  of this, like 3.10,  were mailed to him:
 *  From wht  Fri Apr  6 15:14:30 1990 remote from n4hgf
 *  Received: by n4hgf.UUCP (smail2.5-UNIX/386 5.3.2)
 *  	id AA01781; 6 Apr 90 15:14:30 EDT (Fri)
 *  Date: Fri, 6 Apr 90 15:14:30 EDT
 *  X-Mailer: Mail User's Shell (6.5 4/17/89)
 *  From: wht@n4hgf (Warren Tucker)
 *  To: davidsen@sixhub
 *  Subject: shar 3.11
 *  X-Bang-Reply-to: gatech!n4hgf!wht -or- emory!tridom!n4hgf!wht
 *  Reply-to: wht%n4hgf@gatech.edu
 *  Message-Id: <9004061514.AA01781@n4hgf.UUCP>
 *
 *  1. changes suggested by pat@rwing (Pat Myrto) and silvert@cs.dal.ca
 *  (Bill Silvert)
 *  2. fixes to who_am_i code in who@where.c
 *
 *  3.20 - Wed Apr 18 01:58:32 EDT 1990
 *  changes were made per edit notes by
From: gatech!mailrus!uunet!cpsolv.CPS.COM!rhg (Richard H. Gumpertz)
 *  ...!gatech!n4hgf!wht (wht%n4hgf@gatech.edu) Warren Tucker
 *
 */

/* MS-DOS port (c) 1990 by Thorsten Ohl, ohl@gnu.ai.mit.edu
   This port is distributed under the terms of the
   GNU General Public License as published by the
   Free Software Foundation.  */

#include <stdio.h>
#include <sys/types.h>
#include <time.h>
#include <sys/stat.h>
#include <ctype.h>

/* assume system v unless otherwise fixed */
#if (defined(pyr) || defined(vax) || defined(sequent)) && !defined(BSD42) && !defined(SYS5)
#define BSD42
#endif
#if defined(sun)	/* this miscreant doesn't exactly fit BSD or SYSV */
#undef BSD42
#undef SYS5
#endif
#if !defined(BSD42) && !defined(sun) && !defined(SYS5)
#define SYS5
#endif

#if defined(sun) || defined(BSD42)
#define strchr	index
#define strrchr	rindex
#endif

#ifdef MSDOS

#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <stdarg.h>
#include <process.h>
#include <direct.h>
#include <io.h>

/* We will use some GNUish MS-DOS stuff */
#include <getopt.h>
#include <gnulib.h>
char *program_name;

/* Unkown to MS-DOS */
#define S_ISUID 0x00
#define S_ISGID 0x00
#define S_ISVTX 0x00

/* Nobody ever waits for MS-DOS ... */
#define wait(foo) (-1)

#define who_where(buf) \
  {							\
    char *user = getenv ("USER");			\
    strcpy (buf, user ? user : "anonymous@any.net");	\
  }

#define getcwd(buf, len)  msdos_format_filename (getcwd (buf, len))

/* We make this program selfcontained by providing our own pipes.
   This also avoids the neccessity of invoking a subshell (which
   may turn out to be a command.com ....  */

#define pipe_file1 (_pipe_file (0))
#define pipe_file2 (_pipe_file (1))
extern char *_pipe_file (int n);
extern int filter_through_command (char *infile, char *outfile,
				   char *command, ...);

/* From uuchar.c */
extern void encode (FILE *in, FILE *out);

extern void main (int argc, char **argv);
static char *mode_map (unsigned short mode, char *mode_str);
static void setTOUCH (void);
static int walkdown (int (*rtn) (char *, char *), char *file, int filelen,
		     char *rname);
static int walktree (int (*rtn) (char *, char *), char *rootname);
static int onecheck (char *file, char *rname);
static int oneheader (char *file, char *rname);
static int header (int argc, char **argv);
static void gen_mkdir (char *path);
static void gen_mkdir_script (char *path);
static int shar (char *file, char *RstrName);
static int helpuser (void);

#else /* not MSDOS */

char *strchr();
char *strrchr();
#ifdef __STDC__ /* my concession to ANSI-pansiness */
void *malloc();
#else
char *malloc();
#endif
FILE *fdopen();
FILE *popen();

#endif /* not MSDOS */

#define	DELIM		"SHAR_EOF"/* put after each file */
#define PREFIX1		'X'	/* goes in front of each line */
#define PREFIX2		'Y'	/* goes in front of each line if Delim[0] == PREFIX1 */
#define WC	        "wc -c <"

int PREFIX = PREFIX1;	/* Character to get at the beginning of each line */

int Archive_name = 0;	/* option to generate "Archive-name:" headers */
int Verbose = 1;		/* option to provide append/extract feedback */
int Wc_c = 1;			/* option to provide wc checking */
char *Delim = DELIM;	/* pointer to delimiter string */
int OptPREFIX = 1;		/* suppress PREFIX unless 1st char forces it */
int Cut = 0;			/* option to provide cut mark */
char *CutMessage = "---- Cut Here and feed the following to sh ----\n";
int Binary = 0;			/* flag for binary files */
int AvoidPipes = 0;		/* use temp file instead of pipe to feed uudecode, etc.
						   (better error detection at expense of disk space) */
int Vanilla = 0;		/* no Brown-Shirt mode */
int Touch = 0;			/* generate $TOUCH commands */
int Compress = 0;		/* run input files through compress (requires Binary) */
int CompressBits = 12;	/* -b option to compress */
int Mixed = 0;			/* mixed text and binary files */
int eXists = 1;			/* check if file exists */
int InterOW = 0;		/* interactive overwrite */
int PosParam = 0;		/* allow positional parameters */
int FileStrip;			/* strip directories from filenames */
#ifdef	DEBUG
int de_bug = 0;			/* switch for debugging on */
#define DeBug(f,v) if (de_bug) printf(f, v)
#else	/* normal compile */
#define DeBug(f,v)		/* do nothing */
#endif

FILE *fpout = stdout;
int shar();
unsigned limit = 0;
int Split = 0;			/* Split files in the middle */
long ftell();
long TypePos;			/* position for archive type message */
long EndHeadPos;		/* position for first file in the shar file */
char outname[50];		/* base for output filename */
char filename[50];		/* actual output filename */
char *sharname = (char *)0;
char *submitter = (char *)0;
int filenum = 0;		/* output file # */
struct stat fst;		/* check file type, access */

#ifdef MSDOS
void
main (int argc, char **argv)
#else
main(argc,argv)
char **argv;
#endif
{
int status = 0;
int stdin_file_list = 0;
char *oname;
int c;
extern int optind;
extern char *optarg;

#ifdef MSDOS
	program_name = argv[0];
#endif
	while((c = getopt(argc,argv,"VmSvwd:BTCb:xXcfMpPFas:n:l:L:o:h")) != -1)
	{
		switch(c)
		{
		case 'V':
			Vanilla = 1;
			break;
		case 'm':
			Touch = 1;
			break;
		case 'S':
			stdin_file_list = 1;
			break;
		case 'v':
			Verbose = 0;
			break;
		case 'w':
			Wc_c = 0;
			break;
		case 'd':
			Delim = optarg;
			PREFIX = (Delim[0] == PREFIX1 ? PREFIX2 : PREFIX1);
			break;
		case 'B': /* binary files */
			Binary = 1;
			Compress = 0;
			break;
		case 'T': /* text mode */
			Binary = 0;
			Compress = 0;
			break;
		case 'b': /* Compress bits */
			CompressBits = atoi(optarg);
			/* fall through to -C */
		case 'C': /* Compress */
			Binary = 1;
			Compress = 1;
			break;
		case 'x': /* don't worry whether the file exist */
			eXists = 0;
			break;
		case 'X': /* ask the user whether to overwrite existing files */
			InterOW = 1;
			eXists = 1;
			break;
		case 'c':
			Cut = 1;
			break;
		case 'f': /* filenames only */
			FileStrip = 1;
			break;
		case 'M': /* mixed text and binary */
			Mixed = 1;
			break;
		case 'p': /* allow positional parameters */
			PosParam = 1;
			break;
		case 'P': /* use temp files instead of pipes in the shar file */
			AvoidPipes = 1;
			break;
		case 'F': /* force PREFIX to be put out even if not required */
			OptPREFIX = 0;
			break;
		case 'l': /* soft size limit in k */
			if((limit = atoi(optarg)) > 1)
				--limit;
			Split = 0;
			DeBug("Soft limit %dk\n",limit);
			break;
		case 'L': /* hard size limit in k */
			if((limit = atoi(optarg)) > 1)
				--limit;
			Split = (limit != 0);
			AvoidPipes = 1;
			DeBug("Hard limit %dk\n",limit);
			break;
		case 'n': /* name of archive */
			sharname = optarg;
			break;
		case 's': /* submitter */
			submitter = optarg;
			break;
		case 'a': /* generate Archive-name: headers */
			Archive_name = 1;
			break;
		case 'o': /* specify output file */
			oname = optarg;
			strcpy(outname,oname);
			strcat(outname,".");
			filenum = 1;
			strcpy(filename,outname);
			strcat(filename,"01");
			fpout = fopen(filename,"w");
			if(!fpout)
			{ /* creation error */
				perror("can't create output file");
				exit(1);
			}
			break;
#ifdef	DEBUG
		case '$': /* totally undocumented $ option, debug on */
			de_bug = 1;
			break;
#endif
		default: /* invalid option */
		case 'h': /* help */
			helpuser();
			break;
		}
	}

	if(Vanilla)
	{
		fprintf(stderr,"Vanilla mode disabling years of progress :-)\n");
		Wc_c = 0;
		OptPREFIX = 0;
#ifdef V_AVOIDPIPES	/* pipes are benign and only used with uudecode anyway */
		AvoidPipes = 1;
#endif /* V_AVOIDPIPES */
#ifdef V_NOFORCE	/* If the user specifies non-defaults, let him have them */
#else
		Touch = 0;
		InterOW = 0;
		if(Binary || Mixed || Compress || PosParam)
			fprintf(stderr,"WARNING: non-Text storage options overridden.\n");
		Binary = 0;
		Mixed = 0;
		Compress = 0;
		PosParam = 0;
#endif /* V_NOFORCE */
	}

	if(stdin_file_list)
	{
		char stdin_buf[258];
		argc = 0;
		if(!(argv = (char **)malloc(1024 * sizeof(char *))))
			goto MEMORY_ERROR;
		stdin_buf[0] = 0;
		while(fgets(stdin_buf,sizeof(stdin_buf),stdin))
		{
			if(argc == 1024)
			{
				fprintf(stderr,"max files from stdin is 1024!\n");
				exit(1);
			}
			if(stdin_buf[0])
				stdin_buf[strlen(stdin_buf) - 1] = 0;
			if(!(argv[argc] = malloc(strlen(stdin_buf) + 1)))
			{
MEMORY_ERROR: /* NOT likely, but free software must pure as snow! */
				fprintf(stderr,"out of memory handling stdin input at %d\n",
					argc);
				exit(1);
			}
			strcpy(argv[argc],stdin_buf);
			++argc;
			stdin_buf[0] = 0;
		}
		optind = 0;
	}

	if(optind >= argc)
	{
		fprintf(stderr,"shar: No input files\n");
		helpuser();
		exit(1);
	}

	if(Archive_name && !sharname)
	{
		fprintf(stderr,"shar: -n must accompany -a\n");
		helpuser();
		exit(1);
	}

	if(!submitter)
	{
		if(!(submitter = malloc(128)))
		{
			fprintf(stderr,"memory allocation failed\n"); /* NOT likely */
			exit(1);
		}
		who_where(submitter);
	}

	if(header(argc-optind,&argv[optind]))
		exit(2);

	if(InterOW)
	{
		Verbose = 1;
		fputs("wish=\n",fpout);
		if(Archive_name)
		{
			fprintf(stderr,
				"PLEASE do not submit -X shars to the usenet or other\n");
			fprintf(stderr,
				"public networks.  They will cause problems.\n");
		}
	}

	EndHeadPos = ftell(fpout);

	for( ; optind < argc; ++optind)
	{ /* process positional parameters and files */
		if(PosParam)
		{		/* allow -B and -T and -C inline */
			if(strcmp(argv[optind],"-B") == 0)
			{ /* set binary */
				Binary = 1;
				Compress = 0;
				continue;
			}
			if(strcmp(argv[optind],"-T") == 0)
			{ /* set mode text */
				Binary = 0;
				Compress = 0;
				continue;
			}
			if(strcmp(argv[optind],"-C") == 0)
			{ /* set compress */
				Binary = 1;
				Compress = 1;
				continue;
			}
		}
		status += walktree(shar,argv[optind]);
	}

	/* delete the sequence file, if any */
	if(Split && filenum > 1)
	{
		fputs("rm -f _shar_seq_.tmp\n",fpout);
		fputs("echo You have unpacked the last part\n",fpout);
		if(!Verbose)
			fprintf(stderr,"Created %d files\n",filenum);
	}
	fputs("exit 0\n",fpout);
	exit(status);
}

/*+-----------------------------------------------------------------------
	mode_map(mode,mode_str)	build drwxrwxrwx string
------------------------------------------------------------------------*/
char *
mode_map(mode,mode_str)
unsigned short mode;
char *mode_str;
{
#ifdef THIS_IS_NOT_NEEDED_FOR_SHAR
register unsigned ftype = mode & S_IFMT;
#endif
register char *rtn;
static char result[12];

	rtn = (mode_str == (char *)0) ? result : mode_str;

	/*          drwxrwxrwx */
	/*          0123456789 */
	strcpy(rtn,"----------");

#ifdef THIS_IS_NOT_NEEDED_FOR_SHAR
	switch(ftype)
	{
		case S_IFIFO:	*rtn = 'p'; break; /* FIFO (named pipe) */
		case S_IFDIR:	*rtn = 'd'; break; /* directory */
		case S_IFCHR:	*rtn = 'c'; break; /* character special */
		case S_IFBLK:	*rtn = 'b'; break; /* block special */
		case S_IFREG:	*rtn = '-'; break; /* regular */

#if defined(sun) | defined(BSD42)
		case S_IFLNK:	*rtn = 'l'; break; /* symbolic link */
		case S_IFSOCK:	*rtn = 's'; break; /* socket */
#endif

#if defined (SYS5)
		case S_IFNAM:						/* name space entry */
			if(mode & S_INSEM)				/* semaphore */
			{
				*rtn = 's';
				break;
			}
			if(mode & S_INSHD)				/* shared memory */
			{
				*rtn = 'm';
				break;
			}
#endif

		default:		*rtn = '?'; break;	/* ??? */
	}
#endif /* THIS_IS_NOT_NEEDED_FOR_SHAR */

	if(mode & 000400) *(rtn + 1) = 'r';
	if(mode & 000200) *(rtn + 2) = 'w';
	if(mode & 000100) *(rtn + 3) = 'x';
	if(mode & 004000) *(rtn + 3) = 's';
	if(mode & 000040) *(rtn + 4) = 'r';
	if(mode & 000020) *(rtn + 5) = 'w';
	if(mode & 000010) *(rtn + 6) = 'x';
	if(mode & 002000) *(rtn + 6) = 's';
	if(mode & 000004) *(rtn + 7) = 'r';
	if(mode & 000002) *(rtn + 8) = 'w';
	if(mode & 000001) *(rtn + 9) = 'x';
	if(mode & 001000) *(rtn + 9) = 't';

	return(rtn);

}	/* end of mode_map */

void
setTOUCH()
{
	if(Touch)
	{
		fputs("if touch 2>&1 | fgrep 'amc' > /dev/null\n",fpout);
		fputs(" then TOUCH=touch\n",fpout);
		fputs(" else TOUCH=true\n",fpout);
		fputs("fi\n",fpout);
	}
} /* end of setTOUCH */

#ifdef NO_WALKTREE

int
walktree(rtn,file)				/* dummy walktree */
int (*rtn)(/*file,rname*/);	/* may also assume fst is set */
char *file;
{
	register char *rname;

	if(stat(file,&fst))
	{
		fprintf(stderr,"shar: Can't access %s\n",file);
		return(1);
	}

	if(FileStrip)
	{ /* use just the filename */
		rname = file + strlen(file);
		while(rname > file && *rname != '/')
			--rname;
		if(*rname == '/')
			++rname;
	}
	else
		rname = file;
	if(!strncmp(rname,"./",2) && rname[2])
		rname += 2;

	return((*rtn)(file,rname));
}

#else /* NO_WALKTREE*/


#ifdef MSDOS

#include <ndir.h>
#define DIRENTRY struct direct
#define CLOSEDIR_VOID

/* The one from ndir.h is much too short! (and has different semantics) */
#undef MAXNAMLEN
#define MAXNAMLEN _MAX_PATH

#else /* not MSDOS */

#ifdef NO_DIRENT

#include <sys/dir.h>			/* SunOS 3, etc. */
#define DIRENTRY struct direct

#else /* NO_DIRENT */

#include <dirent.h>			/* Doug Gwyn's dirent routines */
#define DIRENTRY struct dirent

#endif /* NO_DIRENT */

DIR *opendir();
DIRENTRY *readdir();

#endif /* not MSDOS */

int
#ifdef MSDOS
walkdown (int (*rtn)(char *, char *), char *file, int filelen, char *rname)
#else
walkdown(rtn,file,filelen,rname)
int (*rtn)(/*file,rname*/);	/* may also assume fst is set */
char *file, *rname;			/* *rname must be *file + n where n < filelen */
int filelen;
#endif
{
	DIR *dirp;
	DIRENTRY *dp;

	if(stat(file,&fst))
	{
		fprintf(stderr,"shar: Can't access %s\n",file);
		return(1);
	}

	if((fst.st_mode & S_IFMT) != S_IFDIR)
		return((*rtn)(file,rname));

	if(!(dirp = opendir(file)))
	{
		fprintf(stderr,"shar: unable to open directory %s",file);
		return(1);
	}

	if(!strcmp(rname,"."))
		rname += 2;				/* avoid "./xxx" when sharing "." */

	while((dp = readdir(dirp)))
		if (strcmp(dp->d_name,".") && strcmp(dp->d_name,".."))
		{
			int newlen;

			if((newlen = filelen + 1 + strlen(dp->d_name)) >= MAXNAMLEN)
			{
				fprintf(stderr,"shar: file name too long: %s/%s\n",
						file,dp->d_name);
				return(1);
			}
			sprintf(file + filelen,"/%s",dp->d_name);

			if(walkdown(rtn,file,newlen,rname))
				return(1);

			file[filelen] = '\0';	/* in case we print any error messages */
		}

#ifdef CLOSEDIR_VOID
	closedir(dirp);
#else /* CLOSEDIR_VOID */
	if(closedir(dirp))
	{
		fprintf(stderr,"shar: unable to close directory %s",file);
		return(1);
	}
#endif /* CLOSEDIR_VOID */
    return(0);
}

int
#ifdef MSDOS
walktree (int (*rtn)(char *, char *), char *rootname)
#else
walktree(rtn,rootname)				/* real walktree */
int (*rtn)(/*file,rname*/);	/* may also assume fst is set */
char *rootname;
#endif
{
	char file[MAXNAMLEN];
	int filelen;
	register char *rname;

	if((filelen = strlen(rootname)) >= MAXNAMLEN)
	{
		fprintf(stderr,"shar: file name too long: %s\n",rootname);
		return(1);
	}
	strcpy(file,rootname);

	if(FileStrip)
	{ /* use just the filename */
		rname = file + filelen;
		while(rname > file && *rname != '/')
			--rname;
		if(*rname == '/')
			++rname;
	}
	else
		rname = file;
	if(!strncmp(rname,"./",2) && rname[2])
		rname += 2;

	return(walkdown(rtn,file,filelen,rname));
}

#endif /* NO_WALKTREE */

int
onecheck(file,rname)
char *file, *rname;
{
	if(access(file,04))
	{
		fprintf(stderr,"shar: Can't access %s\n",file);
		return(1);
	}

	return(0);
}

int
oneheader(file,rname)
char *file, *rname;
{
	fprintf(fpout,"# %6ld %s %s\n",fst.st_size,
		mode_map(fst.st_mode & ~(S_ISUID|S_ISGID|S_ISVTX),(char *)0),rname);
	return(0);
}

#ifdef MSDOS
int
header (int argc, char **argv)
#else
header(argc,argv)
char **argv;
#endif
{
int i;
FILE *fpsource;	/* pipe temp */
char s128[128];
long now;
struct tm *utc;
struct tm *gmtime();

	/* see if any conflicting options */
	if(limit && !filenum)
	{ /* can't rename what you don't have */
		fprintf(stderr,"Can't use -l or -L option without -o\n");
		helpuser();
		return(1);
	}

	for(i = 0; i < argc; i++)
	{ /* skip positional parameters */
		if(PosParam &&
			(strcmp(argv[i],"-B") == 0 ||
		     strcmp(argv[i],"-T") == 0 ||
		     strcmp(argv[i],"-C") == 0))
			continue;

		if(walktree(onecheck,argv[i]))
			return(1);
	}

	if(Archive_name)
	{
		fprintf(fpout,"Submitted-by: %s\n",submitter);
		fprintf(fpout,"Archive-name: %s%s%02d\n\n",
			sharname,(strchr(sharname,'/')) ? "" : "/part",
			(filenum) ? filenum : 1);
	}

	if(Cut)
		fputs(CutMessage,fpout);
	fputs("#!/bin/sh\n",fpout);
	if(sharname)
		fprintf(fpout,"# This is %s, a shell archive (produced by shar %s)\n",
			sharname,revision);
	else
		fprintf(fpout,"# This is a shell archive (produced by shar %s)\n",
			revision);
	fputs("# To extract the files from this archive, save it to a file, remove\n",
		fpout);
	fputs("# everything above the \"!/bin/sh\" line above, and type \"sh file_name\".\n#\n",
		fpout);

	time(&now);
	utc = gmtime(&now);
	fprintf(fpout,"# made %02d/%02d/%04d %02d:%02d UTC by %s\n",
		utc->tm_mon + 1,utc->tm_mday,utc->tm_year + 1900,
		utc->tm_hour,utc->tm_min,
		submitter);


#ifdef MSDOS
	/* Get current directory (w/ cosmetics) */
	getcwd (s128, 127);
#else /* not MSDOS */
#if defined(SYS5)
	if(!(fpsource = popen("/bin/pwd","r")))
		return(-1);
	fgets(s128,sizeof(s128),fpsource);
	s128[strlen(s128) - 1] = 0;
	fclose(fpsource);
#else
#if defined(BSD42) || defined(sun)
	getwd(s128);
#else
#include "Need_conditional_compile_fix"
#endif
#endif
#endif /* not MSDOS */

	fprintf(fpout,"# Source directory %s\n",s128);

	fprintf(fpout,"#\n# existing files %s\n",
		(eXists) ? "will NOT be overwritten unless -c is specified" 
			: ((InterOW) ? "MAY be overwritten"
				: "WILL be overwritten"));

	if(InterOW)
		fputs("# The unsharer will be INTERACTIVELY queried.\n",fpout);

	if(Vanilla)
	{
		fputs("# This format requires very little intelligence at unshar time.\n",fpout);
		fputs("# ",fpout);
		if(eXists || Split)
			fputs("\"if test\", ",fpout);
		if(Split)
			fputs("\"cat\", \"rm\", ",fpout);
		fputs("\"echo\", \"true\", and \"sed\" may be needed.\n",fpout);
	}

	if(Split)
	{ /* may be split, explain */
		fputs("#\n",fpout);
		TypePos = ftell(fpout);
		fprintf(fpout,"%-75s\n%-75s\n","#","#");
	}

	fputs("#\n# This shar contains:\n",fpout);
	fputs("# length  mode       name\n",fpout);
	fputs("# ------ ---------- ------------------------------------------\n",
		fpout);
	for(i = 0; i < argc; i++)
	{ /* output names of files but not parameters */
		if(PosParam &&
			(strcmp(argv[i],"-B") == 0 ||
		     strcmp(argv[i],"-T") == 0 ||
		     strcmp(argv[i],"-C") == 0))
			continue;
		if(walktree(oneheader,argv[i]))
			exit(1);
	}
	fputs("#\n",fpout);

	setTOUCH();

	if(Split)
	{ /* now check the sequence */
		fputs("if test -r _shar_seq_.tmp; then\n",fpout);
		fputs("\techo 'Must unpack archives in sequence!'\n",fpout);
		fputs("\techo Please unpack part `cat _shar_seq_.tmp` next\n",fpout);
		fputs("\texit 1\nfi\n",fpout);
	}
	return(0);
}

#define MAX_MKDIR_ALREADY	128	/* ridiculously enough */
char *mkdir_already[MAX_MKDIR_ALREADY];
int mkdir_already_count = 0;

void
gen_mkdir(path)
char *path;
{
register int ialready;
char *cptr;

/* if already generated code for this dir creation, don't do again */
	for(ialready = 0; ialready < mkdir_already_count; ialready++)
	{
		if(!strcmp(path,mkdir_already[ialready]))
			return;
	}

/* haven't done this one */
	if(mkdir_already_count == MAX_MKDIR_ALREADY)
	{
		fprintf(stderr,"too many directories for mkdir generation\n");
		exit(255);
	}
	if(!(cptr = mkdir_already[mkdir_already_count++] = malloc(strlen(path)+1)))
	{
		fprintf(stderr,"out of memory for mkdir generation\n");
		exit(255);
	}
	strcpy(cptr,path);

/* generate the text */
	fprintf(fpout,"if test ! -d '%s'; then\n",path);
	if(Verbose)
		fprintf(fpout,"    echo 'x - creating directory %s'\n",path);
	fprintf(fpout,"    mkdir '%s'\n",path);
	fputs("fi\n",fpout);

}	/* end of gen_mkdir */

void
gen_mkdir_script(path)
register char *path;
{
register char *cptr;

	for(cptr = strchr(path,'/'); cptr; cptr = strchr(cptr + 1,'/'))
	{
		/* avoid empty string if leading or double '/' */
		if(cptr == path || *(cptr - 1) == '/')
			continue;
		/* omit '.' */
		if((*(cptr - 1) == '.') && ((cptr == path + 1) || (*(cptr - 2) == '/')))
			continue;
		*cptr = 0;				/* temporarily terminate string */
		gen_mkdir(path);
		*cptr = '/';
	}
}	/* end of gen_mkdir_script */

int
shar(file,RstrName)
char *file, *RstrName;
{
char line[BUFSIZ];
FILE *fpsource;
long cursize,remaining,ftell();
int split = 0;		/* file split flag */
char *filetype;		/* text or binary */
struct tm *lt;
char *filename_base;

	/* check to see that this is still a regular file  and readable */
	if((fst.st_mode & S_IFMT) != S_IFREG)
	{ /* this is not a regular file */
		fprintf(stderr,"shar: %s is not a regular file\n",file);
		return(1);
	}
	if(access(file,04))
	{
		fprintf(stderr,"shar: Can't access %s\n",file);
		return(1);
	}

	/* if limit set, get the current output length */
	if(limit)
	{
		cursize = ftell(fpout);
		remaining = (limit * 1024L) - cursize;
		DeBug("In shar: remaining size %ld\n",remaining);
		
		if(!Split && cursize > EndHeadPos &&
			(Binary ? fst.st_size + fst.st_size/3 : fst.st_size) > remaining)
		{ /* change to another file */
			DeBug("Newfile, remaining %ld, ",remaining);
			DeBug("limit still %d\n",limit);

			/* close the "&&" and report an error if any of the above failed */
			fprintf(fpout,"true || echo 'restore of %s failed'\n",RstrName);

			fprintf(fpout, "echo End of part %d, continue with part %d\n",
				filenum,filenum + 1);
			fputs("exit 0\n",fpout);

			fclose(fpout);

			/* Clear mkdir_already in case the user unshars out of order */
			while (mkdir_already_count > 0)
				free(mkdir_already[--mkdir_already_count]);

			/* form the next filename */
			sprintf(filename,"%s%02d",outname,++filenum);
			fpout = fopen(filename,"w");
			if(Verbose)
				fprintf(stderr,"Starting file %s\n",filename);

			if(Archive_name)
			{
				fprintf(fpout,"Submitted-by: %s\n",submitter);
				fprintf(fpout,"Archive-name: %s%s%02d\n\n",
					sharname,(strchr(sharname,'/')) ? "" : "/part",
					(filenum) ? filenum : 1);
			}

			if(Cut)
				fputs(CutMessage,fpout);

			fputs("#!/bin/sh\n",fpout);
			fprintf(fpout,"# This is part %02d of %s\n",
			    filenum,(sharname) ? sharname : "a multipart archive");

			setTOUCH();

			EndHeadPos = ftell(fpout);
		}
	}

	fprintf(fpout,"# ============= %s ==============\n",RstrName);

	gen_mkdir_script(RstrName);

	/* if mixed, determine the file type */
	if(Mixed)
	{
#ifdef MSDOS
		int i;
		int chars_read;
		char buf[128];

		/* Heuristics:  look for nonprintable characters
		   at the head of the file.  */

		FILE *fp = fopen (file, "rb");
		chars_read = fread (buf, 1, 128, fp);
		fclose (fp);

		for (i = 0; i < chars_read; i++)
		  if (!isgraph (buf[i]) && !isspace (buf[i]))
		    break;

		Binary = (i == chars_read) ? 0 : 1;

#else /* not MSDOS */

		int count;
		sprintf(line,"file %s | egrep -c \"text|shell\"",file);
		fpsource = popen(line,"r");
		fscanf(fpsource,"%d",&count);
		pclose(fpsource);
		Binary = (count != 1);

#endif /* not MSDOS */
	}

	if(Binary)
#ifdef MSDOS
	{
		FILE *outptr;

		fflush (fpout);

		if (Compress)
		  {
		    sprintf (line, "-b%d", CompressBits);
		    filter_through_command (file, pipe_file1,
					    "compress", line, NULL);
		    fpsource = fopen (pipe_file1, "rb");
		  }
		else
		  fpsource = fopen(file, "rb");

		outptr = fopen (pipe_file2, "w");
		fprintf (outptr,"begin 600 %s\n",
				(Compress ? "_shar_cmp_.tmp" : RstrName));
		encode (fpsource, outptr);
		fprintf (outptr, "end\n");
		fclose (outptr);

		fpsource = freopen (pipe_file2, "r", fpsource);
		filetype = (Compress ? "Compressed" : "Binary");
	}
#else /* not MSDOS */
	{ /* fork a uuencode process */
		static int pid,pipex[2];

		pipe(pipex);
		fflush(fpout);

		if(pid = fork())
		{ /* parent, create a file to read */
			if(pid < 0)
			{
				fprintf(stderr,"could not fork!\n");
				exit(1);
			}
			close(pipex[1]);
			fpsource = fdopen(pipex[0],"r");
			filetype = (Compress ? "Compressed" : "Binary");
		}
		else
		{ /* start writing the pipe with encodes */
			FILE *outptr;

			if(Compress)
			{
				sprintf(line, "compress -b%d < '%s'", CompressBits, file);
				fpsource = popen(line, "r");
			}
			else
				fpsource = fopen(file, "rb");
			outptr = fdopen(pipex[1],"w");
			fprintf(outptr,"begin 600 %s\n",
				(Compress ? "_shar_cmp_.tmp" : RstrName));
			encode(fpsource,outptr);
			fprintf(outptr,"end\n");
			if(Compress)
				pclose(fpsource);
			else
			{
				fclose(fpsource);
			}
			exit(0);
		}
	}
#endif /* not MSDOS */
	else
	{
		fpsource = fopen(file,"r");
		filetype = "Text";
	}

	if(fpsource)
	{
		/* protect existing files */
		if(eXists)
		{
			fprintf(fpout,"if test -f '%s' -a X\"$1\" != X\"-c\"; then\n",
				RstrName);
			if(InterOW)
			{
				fputs("\tcase $wish in\n",fpout);
				fprintf(fpout,"\tA*|a*) echo 'x - overwriting %s';;\n",
					RstrName);
				fprintf(fpout,
		"\t*) echo '? - overwrite %s -- [No], [Y]es, [A]ll, [Q]uit? '\n",
					RstrName);
				fputs("\t\tread wish;;\n",fpout);
				fputs("\tesac\n",fpout);
				fputs("\tcase $wish in\n",fpout);
				fputs("\tQ*|q*) echo aborted; exit 86;;\n",fpout);
				fputs("\tA*|a*|Y*|y*) x=Y;;\n",fpout);
				fputs("\t*) x=N;;\n",fpout);
				fputs("\tesac\n",fpout);
				fputs("else\n",fpout);
				fputs("\tx=Y\n",fpout);
				fputs("fi\n",fpout);
				fputs("if test $x != Y; then\n",fpout);
				fprintf(fpout,"\techo 'x - skipping %s'\n",RstrName);
			}
			else
				fprintf(fpout,"\techo 'x - skipping %s (File already exists)'\n",
					RstrName);
			if (Split)
				fputs("\trm -f _shar_wnt_.tmp\n",fpout);
			fputs("else\n",fpout);
			if (Split)
				fputs("> _shar_wnt_.tmp\n",fpout);	
		}

		fprintf(stderr,"shar: saving %s (%s)\n",file,filetype);
		if(Verbose)
		{ /* info on archive and unpack */
			fprintf(fpout,"echo 'x - extracting %s (%s)'\n",
			    RstrName,filetype);
		}
		if(Binary)
		{ /* run sed through uudecode (via temp file if might get split) */
			fprintf(fpout, "sed 's/^%c//' << '%s' %s &&\n",
			   	PREFIX,Delim,
				(AvoidPipes ? "> _shar_tmp_.tmp" : "| uudecode"));
		}
		else
		{ /* just run it into the file */
			fprintf(fpout,"sed 's/^%c//' << '%s' > '%s' &&\n",
			    PREFIX,Delim,RstrName);
		}
		while(fgets(line,BUFSIZ,fpsource))
		{ /* output a line and test the length */
			if(OptPREFIX && isgraph(line[0]) && line[0] != PREFIX
#ifdef STRCMP_IS_FAST
			   && strcmp(line,Delim)
#else /* STRCMP_IS_FAST */
			   && (line[0] != Delim[0] || strcmp(line,Delim))
#endif /* STRCMP_IS_FAST */
#ifdef STRNCMP_IS_FAST
			   && strncmp(line,"exit 0",6)	/* See unshar -e: avoid "exit 0" */
			   && strncmp(line,"From",4)	/* Don't let mail prepend a ">" */
#else /* STRNCMP_IS_FAST */
			   && (line[0] != 'e'			/* See unshar -e: avoid "exit 0" */
				   || strncmp(line,"exit 0",6))
			   && (line[0] != 'F'			/* Don't let mail prepend a ">" */
			   	   || strncmp(line,"From",4))
#endif /* STRNCMP_IS_FAST */
			  )
				fputs(line,fpout);
			else
			{
				fprintf(fpout,"%c%s",PREFIX,line);
				--remaining;	/* count PREFIX (in case Split is in effect) */
			}
#ifdef MSDOS	/* This probably doesn't work but accounts for some old code */
			if(Split && (remaining -= strlen(line) + 1) < 0)	/* 1 extra for CR */
#else
			if(Split && (remaining -= strlen(line)) < 0)
#endif
			{ /* change to another file */
				DeBug("Newfile, remaining %ld, ",remaining);
				DeBug("limit still %d\n",limit);

				if(line[strlen(line) - 1] != '\n')
					fputc('\n',fpout);

				fprintf(fpout,"%s\n",Delim);

				/* close the "&&" and report an error if any of the above failed */
				fprintf(fpout,"true || echo 'restore of %s failed'\n",RstrName);

				if (eXists)
					fputs("fi\n",fpout);

				if(Verbose)
				{ /* output some reassurance */
					fprintf(fpout, "echo 'End of %s part %d'\n",
						(sharname) ? sharname : "",filenum);
					fprintf(fpout, "echo 'File %s is continued in part %d'\n",
					    RstrName,filenum + 1);
				}
				else
					fprintf(fpout,
					    "echo 'End of part %d, continue with part %d'\n",
					    filenum,filenum + 1);
				fprintf(fpout,"echo %d > _shar_seq_.tmp\n",filenum + 1);
				fputs("exit 0\n",fpout);

				if(filenum == 1)
				{ /* rewrite the info lines on the firstheader */
					fseek(fpout,TypePos,0);
					fprintf(fpout,"%-75s\n%-75s\n",
					    "# This is part 1 of a multipart archive",
					    "# do not concatenate these parts, unpack them in order with /bin/sh");
				}
				fclose(fpout);

				/* form the next filename */
				sprintf(filename,"%s%02d",outname,++filenum);
				fpout = fopen(filename,"w");

				if(Archive_name)
				{
					fprintf(fpout,"Submitted-by: %s\n",submitter);
					fprintf(fpout,"Archive-name: %s%s%02d\n\n",
						sharname,(strchr(sharname,'/')) ? "" : "/part",
						(filenum) ? filenum : 1);
				}

				if(Cut)
					fputs(CutMessage,fpout);
				fputs("#!/bin/sh\n",fpout);

				fprintf(fpout,"# this is %s (part %d of %s)\n",
					((filename_base = strrchr(filename,'/'))
						? filename_base + 1
						: filename),
				    filenum,
				    (sharname) ? sharname : "a multipart archive");
				fputs(
		"# do not concatenate these parts, unpack them in order with /bin/sh\n",
					fpout);
				fprintf(fpout,"# file %s continued\n#\n",RstrName);

				setTOUCH();

				fputs("if test ! -r _shar_seq_.tmp; then\n",fpout);
				fputs("\techo 'Please unpack part 1 first!'\n",fpout);
				fputs("\texit 1\nfi\n",fpout);
				fputs("(read Scheck\n",fpout);
				fprintf(fpout," if test \"$Scheck\" != %d; then\n",filenum);
				fputs("\techo Please unpack part \"$Scheck\" next!\n",
					fpout);
				fputs("\texit 1\n",fpout);
				fputs(" else\n\texit 0\n fi\n",fpout);
				fputs(") < _shar_seq_.tmp || exit 1\n",fpout);

				if(eXists)
					if(Verbose)
					{ /* keep everybody informed */
						fputs("if test ! -f _shar_wnt_.tmp; then\n",fpout);
						fprintf(fpout,"\techo 'x - still skipping %s'\n",
								RstrName);
						fputs("else\n",fpout);
					}
					else
						fputs("if test -f _shar_wnt_.tmp; then\n",fpout);

				if(Verbose)
				{ /* keep everybody informed */
					fprintf(stderr,"Starting file %s\n",filename);
					fprintf(fpout,"echo 'x - continuing file %s'\n",RstrName);
				}
				fprintf(fpout,"sed 's/^%c//' << '%s' >> '%s' &&\n",
				    PREFIX,Delim,
					(Binary ? "_shar_tmp_.tmp" : RstrName));
				remaining = limit * 1024L;
				split = 1;
			}
		}

		(void) fclose(fpsource);
		while(wait((int *)0) >= 0)
			;

		if(line[strlen(line) - 1] != '\n')
			fputc('\n',fpout);

		fprintf(fpout,"%s\n",Delim);
		if(split && Verbose)
			fprintf(fpout,"echo 'File %s is complete' &&\n",RstrName);

		/* if this file was uuencoded w/Split, decode it and drop the temp */
		if(Binary && AvoidPipes)
		{
			if(Verbose)
				fprintf(fpout,"echo 'uudecoding file %s' &&\n",RstrName);
			fputs("uudecode < _shar_tmp_.tmp && rm -f _shar_tmp_.tmp &&\n",fpout);
		}

		/* if this file was compressed, uncompress it and drop the temp */
		if(Compress)
		{
			if(Verbose)
				fprintf(fpout,"echo 'uncompressing file %s' &&\n",RstrName);
			fprintf(fpout,
			    "compress -d < _shar_cmp_.tmp > '%s' && rm -f _shar_cmp_.tmp &&\n",
				RstrName);
		}

		if(Touch)
		{
			/* set the dates as they were */
			lt = localtime(&fst.st_mtime);
			fprintf(fpout,"$TOUCH -am %02d%02d%02d%02d%02d '%s' &&\n",
				lt->tm_mon + 1,
				lt->tm_mday,
				lt->tm_hour,
				lt->tm_min,
				lt->tm_year,
				RstrName);
		}

		if(Vanilla)
		{
			/* close the "&&" and report an error if any of the above failed */
			fprintf(fpout,"true || echo 'restore of %s failed'\n",RstrName);
		}
		else
		{
			/* set the permissions as they were */
			fprintf(fpout,"chmod %04o %s ||\n",
				fst.st_mode & 00777,RstrName);

			/* report an error if any of the above failed */
			fprintf(fpout,"echo 'restore of %s failed'\n",RstrName);

			if(Wc_c)
			{ /* validate the transferred file */
				FILE *pfp;
				char command[BUFSIZ];

#ifdef MSDOS
				filter_through_command (file, pipe_file1,
							"wc", "-c", NULL);
				if (pfp = fopen (pipe_file1, "r"))
#else
				sprintf(command,"%s '%s'",WC,file);
				if((pfp = popen(command,"r")))
#endif
				{
					char wc[BUFSIZ];

					fscanf(pfp,"%s",wc);
					fprintf(fpout,"Wc_c=\"`%s '%s'`\"\n",WC,RstrName);
					fprintf(fpout,"test %s -eq \"$Wc_c\" ||\n",wc);
					fprintf(fpout,
					    "\techo '%s: original size %s, current size' \"$Wc_c\"\n",
						RstrName, wc);
#ifdef MSDOS
					fclose (pfp);
#else
					pclose(pfp);
#endif
				}
			}
		}

		/* if the exists option is in place close the if */
		if(eXists)
		{
			if (Split)
				fputs("rm -f _shar_wnt_.tmp\n",fpout);

			fputs("fi\n",fpout);
		}

		return(0);
	}
	else
	{
		fprintf(stderr,"shar: Can't open %s (%s): ",file,filetype);
		perror("");
		return(1);
	}
}


char *helpinfo[] =
{
	"-V  produce \"vanilla\" shars demanding little of the unshar environment",
	"-v  verbose messages OFF while executing",
	"-m  restore file modification dates & times with \"touch\" commands",
	"-w  don't check with 'wc -c' after unpack",
	"-a  generate Submitted-by: & Archive-name: headers",
	"-nXXX   use XXX as the name of the archive (documentation)",
	"-s  override automatically determined submitter name",
	"-x  overwrite existing files without checking if they already exist",
	"-X  interactively overwrite existing files (NOT FOR NET SHARS)",
	"-B  treat all files as binary, use uuencode",
	"-T  treat all files as text (default)",
	"-C  compress and uuencode all files",
	"-bXX    pass -bXX (default 12) to compress when compressing (implies -C)",
	"-p  allow positional parameter options. The options \"-B\" and \"-T\"",
	"    and \"-C\" may be embedded, and files to the right of the",
	"    option will be processed in the specified mode",
	"-M  mixed mode. Determine if the files are text or",
	"    binary and archive correctly.",
	"-P  use temp files instead of pipes in the shar file",
	"-F  force the prefix character on every line (even if not required)",
	"-c  start the shar with a cut line",
	"-f  restore by filename only, rather than path",
	"-dXXX   use XXX to delimit the files in the shar",
	"-oXXX   (or -o XXX) output to file XXX.01 thru XXX.nn",
	"-lXX    limit output file size to XXk bytes (but don't split files)",
	"-LXX    limit output file size to XXk bytes (may split files)",
	"-S      read files to wrap from stdin, ignoring argument line",
	"\nThe -S option reads filenames one per line from stdin; input",
	"format must be similar to 'find' output, except that if -p",
	"is specified, -B, -T or -C may be used (on lines by themselves)",
	"e.g., find . -type f -print | sort | shar -C -l50 -o /tmp/big",
	"\nThe 'o' option is required if the 'l' or 'L' option is used",
	"The 'n' option is required if the 'a' option is used",
	"\n-a generates sharname/part## headers. If the -a argument contains",
	"a '/', then /part is not appended",
	"The automatic submitter name is trivial: essentially `whoami`@`uname`",
	(char *)0
};

helpuser()
{				/* output a command format message */
	register char **ptr;
	fprintf(stderr,
	    "shar %s\nusage: shar [ options ] file ...\n       shar -S [ options ]\n",
		revision);
	for(ptr = helpinfo; *ptr; ptr++)
		fprintf(stderr,"%s\n",*ptr);

	exit(1);
}
/* vi: set tabstop=4 shiftwidth=4: */
