/* UnTGZOS2 substitute (Use at your own risk!) */
/* By Salvador Parra Camacho */
/* 02/10/2002 */
/* Edit the following four lines */
untgz = ''
gzip = 'call gzip.cmd'
tar = 'call tar.cmd'
tar_compress = 'C:\SYS\PKRs\GZIP\gzip.exe'

'@echo off'

parse arg option archive

if untgz <> '' then
	do
	'@'||untgz option archive
	exit rc
	end

/* The following lines are used when UnTGZOS2 is not specified */

'SETLOCAL'
'SET TAR_COMPRESS='tar_compress

if option = '-l' then
	list = 1
else
	do
	list = 0
	archive = option archive
	end
if archive = '' then
	do
	say ''
	say '  Correct parameters:'
	say '      untgz -l archive: list the archive contents.'
	say '      untgz archive: extract the archive contents.'
	say ''
	exit 1
	end

archive_basename = filespec('name',archive)

if pos('.',archive_basename) = 0 then
	do
	say ''
	say '  Does not exist an extension!'
	say ''
	exit 1
	end

last_ext = translate(substr(archive_basename,lastpos('.',archive_basename)+1))

arc_wo_ext = delstr(archive_basename,lastpos('.',archive_basename))

if pos('.',arc_wo_ext) <> 0 then
	first_ext = translate(substr(arc_wo_ext,lastpos('.',arc_wo_ext)+1))
else
	first_ext = ''

select
	when first_ext = '' & last_ext = 'GZ' then
		ARC = 'GZ'
	when first_ext = '' & last_ext = 'GZ"' then
		ARC = 'GZ'
	when first_ext = '' & last_ext = 'Z' then
		ARC = 'GZ'
	when first_ext = '' & last_ext = 'Z"' then
		ARC = 'GZ'
	when first_ext = '' & last_ext = 'TAR' then
		ARC = 'TAR'
	when first_ext = '' & last_ext = 'TAR"' then
		ARC = 'TAR'
	when first_ext = '' & last_ext = 'TGZ' then
		ARC = 'TGZ'
	when first_ext = '' & last_ext = 'TGZ"' then
		ARC = 'TGZ'
	when first_ext = 'TAR' & last_ext = 'GZ' then
		ARC = 'TGZ'
	when first_ext = 'TAR' & last_ext = 'GZ"' then
		ARC = 'TGZ'
	when first_ext = 'TAR' & last_ext = 'Z' then
		ARC = 'TGZ'
	when first_ext = 'TAR' & last_ext = 'Z"' then
		ARC = 'TGZ'
	when first_ext = 'TAR' & last_ext = '_Z' then
		ARC = 'TGZ'
	when first_ext = 'TAR' & last_ext = '_Z"' then
		ARC = 'TGZ'
	when first_ext = 'TAR' & last_ext = '-Z' then
		ARC = 'TGZ'
	when first_ext = 'TAR' & last_ext = '-Z"' then
		ARC = 'TGZ'
	when first_ext <> '' & last_ext = 'GZ' then
		ARC = 'GZ'
	when first_ext <> '' & last_ext = 'GZ"' then
		ARC = 'GZ'
	when first_ext <> '' & last_ext = 'Z' then
		ARC = 'GZ'
	when first_ext <> '' & last_ext = 'Z"' then
		ARC = 'GZ'
	otherwise
		do
		say ''
		say '  Extensions not recognized!'
		say ''
		exit 1
		end
end

select
	when list = 0 & ARC = 'GZ' then
		gzip' -d 'archive
	when list = 1 & ARC = 'GZ' then
		gzip' -vlN 'archive
	when list = 0 & ARC = 'TAR' then
		tar' -xvf 'archive
	when list = 1 & ARC = 'TAR' then
		tar' -tvf 'archive
	when list = 0 & ARC = 'TGZ' then
		gzip' -dc 'archive' | 'tar' -xvf -'
	when list = 1 & ARC = 'TGZ' then
		gzip' -dc 'archive' | 'tar' -tvf -'
end
'ENDLOCAL'
exit rc