/* REXX Programm zum Installieren von ZiPMe */

Call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
Call sysloadfuncs

Call SysCls

say "                     Willkommen zur Installation von ZiPMe."
say ""
say "Dieses Programm wird folgendes tun:"
say ""
say "Es wird einen WPS Ordner mit einem Programmobjekt fr ZiPMe, einer Schablone"
say "fr ZIP-Dateien und einem Objekt fr die Datei Liesmich erstellen. Das"
say "ZiPMe-Programmobjekt wird mit allen *.ZIP Dateien assoziiert, so da Sie auf"
say "eine ZIP-Datei doppelklicken knnen, um automatisch ZiPMe mit dieser Datei zu"
say "starten. Mit der Schablone, die Sie in ihren Schablonen-Ordner verschieben"
say "knnen, knnen Sie dokumentenzentriert neue ZIP-Dateien erzeugen."
say ""

say "Soll mit der Installation fortgefahren werden? (J/N)"
PARSE PULL reply
if reply = "N" | reply = "n" then exit

curdir = Directory()

Error = 0

if SysCreateObject("WPFolder", "ZiPMe", "<WP_DESKTOP>", "OBJECTID=<ZIPME_FOLDER>") then
  say "ZiPMe Ordner erstellt ..."
else do
  say "Der ZiPMe Ordner konnte nicht erstellt werden!"
  Error = 1
end

if SysCreateObject("WPProgram", "ZiPMe", "<ZIPME_FOLDER>", "EXENAME="curdir"\ZIPME.EXE;STARTUPDIR="curdir";ASSOCFILTER=*.ZIP") then
  say "ZiPMe Programmobjekt erstellt ..."
else do
  say "Das ZiPMe Programmobjekt konnte nicht erstellt werden!"
  Error = 1
end

if SysCreateObject("WPProgram", "Liesmich", "<ZIPME_FOLDER>", "EXENAME=e.exe;PARAMETERS="curdir"\Liesmich") then
  say "Liesmich Objekt erstellt ..."
else do
  say "Das Liesmich Objekt konnte nicht erstellt werden!"
  Error = 1
end

if SysCopyObject(""curdir"\ZIP file.ZIP", "<ZIPME_FOLDER>") then
  say "ZiPMe Schablone erstellt ..."
else do
  say "Die ZiPMe Schablone konnte nicht erstellt werden!"
  Error = 1
end

say ""

if Error then do
say "Einige oder alle Objekte konnten nicht erstellt werden!"
say "Wenn Sie das EMX-Laufzeitsystem noch nicht installiert haben, dann kopieren"
say "Sie die mit ZiPMe mitgelieferte Datei emx.dll in das Verzeichnis, in das Sie"
say "ZiPMe installiert haben oder in ein Verzeichnis, das in der LIBPATH-Anweisung"
say "in ihrer Config.sys steht. Danach starten Sie ZiPMe und folgen den Anweisungen"
say "zur manuellen Installation in der Online-Hilfe."
end  
else do
say "Alle Objekte wurden erfolgreich installiert."
say "Wenn Sie das EMX-Laufzeitsystem noch nicht installiert haben, dann kopieren"
say "Sie die mit ZiPMe mitgelieferte Datei emx.dll in das Verzeichnis, in das Sie"
say "ZiPMe installiert haben oder in ein Verzeichnis, das in der LIBPATH-Anweisung"
say "in ihrer Config.sys steht."
say "berprfen Sie, ob sich zip.exe und unzip.exe in einem Verzeichnis befinden,"
say "das in der PATH-Anweisung Ihrer Config.sys steht oder kopieren Sie diese in"
say "das Verzeichnis, in das Sie ZiPMe installiert haben."
end

