/* REXX file to install BACK_ME on the desktop     */
/* if you use this script as a starting point for your   */
/* own install script and make improvements, please send */
/* me a copy ---  dwhawk@intcon.net                   */

call rxfuncadd 'sysloadfuncs', 'rexxutil', 'sysloadfuncs'
call sysloadfuncs                /* register system functions */
address cmd '@echo off'          /* echo is turned off */

call SysCLS

say "BACK_ME installation"
say "Enter destination drive and directory"
say "for example C:\OS2\APPS"
say "to install in the curent directory just press enter"

pull dest
call setup_dir(dest) 

say "Enter backup drive and directory"
say "for example C:\BACKUPS"
say "to install in the curent directory just press enter"

pull bdest
call setup_bdir(bdest) 

call copy_files
call MKOBJ
exit

check_ok:
/*  say  'Okay to continue(Y/N) ? '         */
  k = SysGetKey('NOECHO') 
  if k = 'Y' | k = 'y'  then return
  say 'halting'
    exit


mkdir:  /* Procedure for creating dir */
  Parse Arg dir
  rc = SysMkDir(dir)
  If (rc = 0 | rc = 5) Then Return
  Say 'Problem creating destination directory "'dir'"'
  Exit


MKOBJ:
Settings = 'EXENAME='direct||'\PMBack_me.exe;'
Settings = Settings||'PROGTYPE=PM;MINIMIZED=NO;'
Settings = Settings||'CCVIEW=NO;'
Settings = Settings||'STARTUPDIR='||bdirect';'
rc=SysCreateObject('WPProgram','BACK_ME','<WP_DESKTOP>',Settings,'R');

if rc = 1 then Say "BACK_ME installed on desktop"
Settings = 'EXENAME=view.exe;'
Settings = Settings||'PROGTYPE=PM;MINIMIZED=NO;'
Settings = Settings||'CCVIEW=NO;'
Settings = Settings||'PARAMETERS='||direct||'\Backme.inf;'
Settings = Settings||'STARTUPDIR='||direct
rc=SysCreateObject('WPProgram','BACK_ME Information','<WP_DESKTOP>',Settings,'R');
if rc = 1 then Say "BACK_ME Help installed on desktop"

return

setup_dir:      /* accept install path and create it if needed */
                /* the desired install path is in ARG(1) */
                /* if no path is specified current directory is used*/

Parse Arg destin  /* parameter of setup_dir */

save_dest = destin    /*  save original destin to */
                      /*  determine if copy needed */

If destin = "" Then destin = Directory()

Say "Shall I install in "destin"?    (Y/N)"
Call Check_Ok  /* your check routine */

Parse Var destin direct ':\' destin   /* get drive name only */
direct=direct':'

Do Until destin = ""     /* No matter how many sub dirs present */
  Parse Var destin sub '\' destin
  direct=direct'\'sub
  Call mkdir direct
End
return

copy_files:
say "copying files"
if save_dest \= ""  then do
   'COPY backme.inf' direct
   'COPY PMBack_me.exe' direct  
   'COPY back_me.exe' direct  
   end     
return

setup_bdir:      /* accept install path and create it if needed */
                /* the desired install path is in ARG(1) */
                /* if no path is specified current directory is used*/

Parse Arg bdestin  /* parameter of setup_dir */


If bdestin = "" Then bdestin = Directory()

Say "Use " bdestin " as the backup directory?    (Y/N)"
Call Check_Ok  /* your check routine */

Parse Var bdestin bdirect ':\' bdestin   /* get drive name only */
bdirect=bdirect':'

Do Until bdestin = ""     /* No matter how many sub dirs present */
  Parse Var bdestin sub '\' bdestin
  bdirect=bdirect'\'sub
  Call mkdir bdirect
End
return
