/* This is a Rexx Procedure */
/* MAKDSKV4 v1.00a           */
/* MAKEDSKV4.CMD is a REXX implementation of MAKESR.CMD modified to use     */
/* the 4 disk utility set produced by the OS2_V4 "CreateBootDisk" utility   */
/* in place of the 3 disk set that was used by OS2_V3 (Warp). It also       */
/* incorporates the keyboard country code used in REXXKBD.CMD rather than   */
/* calling it externally.                                                   */
/*                                                                          */
/* I make absolutely no claims or warranties regarding the suitability,     */
/* safety, or reliability of this procedure when used on your particular    */
/* set-up and I have had no access to test it on any system other than my   */
/* own.                                                                     */
/*                                                                          */    
/* At a minimum, backup a test volume and restore it using your recovery    */
/* disks BEFORE  you rely on them to recover any valuable data.             */
/*                                                                          */
/* The only rights I wish to claim with regard to this software is that     */
/* if you modify it in any way, please remove my name from it before any    */
/* distribution of such a revised version.                                  */
/*                                                                          */
/* John Getsoian (71005.3316@compuserve.com)                                */


call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs

/*get arguments */ 

PARSE UPPER ARG source target opparm
echo off

/* Check Stuff */

/* Is this a merlin system? */

opver=SysOS2Ver()
IF opver < 2.40 THEN SIGNAL nov4

/* verify a proper target diskette drive */

IF (target <> "A:" & target <> "B:") THEN SIGNAL notarget 

/* verify source drive */
dummy=Stream(source||'\os2\format.com','c','query exists')
IF dummy="" THEN SIGNAL nosource

/* verify the call originates in Dualstor directory */

dummy=Stream('sr.exe','c','query exists')
IF dummy="" THEN SIGNAL invalidlocal

/* begin nuts and bolts - first make disks unless user supplies (skip) */

cls 
say "Ŀ"
say " MAKDSKV4.CMD - Create DualstorV3 Disaster       "
say " Recovery Disks for OS2_V4                       "
say "                                                 "
say " To create your disaster recovery set            "
say " you will need:                                  "
say "   -Your OS2_V4 CD loaded into your CD-ROM drive "
say "   -4 1.4 MB floppy disks                        "
say "                                                 "
say " or                                              "
say "   you can use the 'skip' parameter if you       "
say "   have already made a V4 utility disk set       "
say "   you wish to use                               "
say "                                                 "
say " System files will installed from drive "source"       "
say " Target drive is floppy disk "target"                  "
say "                                                 "
say ""
say "Press CTRL-C to QUIT"
say "         or"
PAUSE

/* Check for SKIP parm  */

IF opparm <>"SKIP" THEN bootdisk

/* get rid of existing config.sys and snooper list */

loopit:  
say "."
say " Ŀ"
say " Insert the 2nd of the four disks in drive "target"    "
say " "
say " Press CTRL-C to QUIT"
say "          or"
PAUSE

/*Is this the right disk? */
info=SysDriveInfo(target)
PARSE UPPER VAR info nul1 nul2 drivesize diskname

IF (drivesize > 2400000 | drivesize < 1000000) then SIGNAL not14flop

IF diskname = "DISK 1" then call ahead1
    else
        say "."
        say "Wrong disk inserted!"
        call loopit 
ahead1:

say " Ŀ"
say " Deleting files from Disk #2                     "
say " "

targstring=target||'\*.flt 1>nul 2>nul'
del targstring

/* more files could be deleted  here but why bother, plenty of room */

/* make sure target files are accessible */
targstring=target||'\config.sys -r 1>nul'
attrib targstring
targstring=target||'\snoop.lst -r 1>nul'
attrib targstring

/* Build new config.sys */
targfile=target||'\config.sys 1>nul 2>nul'
del targfile

say "."
say " Ŀ"
say " Creating CONFIG.SYS on Disk #2                  "
say " "
say "."

/* get country information (incorporate REXXKBD.CMD from Dualstor OEM)  */

say "."
say " Ŀ"
say " Recovering country information from source volume "
say " "
say "."
infile=source||'\config.sys'
do while lines(infile) > 0
    dataline=linein(infile)
    dataline_pos_lower=pos('devinfo=kbd,',dataline)
    dataline_pos_upper=pos('DEVINFO=KBD,',dataline)
    if dataline_pos_lower \= dataline_pos_upper
    then do
       comma2=lastpos(',',dataline)            /*pos of 2nd comma*/
       comma2=comma2-1
       keyparm=substr(dataline,1,comma2)
       keyparm=keyparm||",keyboard.dcp"
     end
end

/* check for HPFS */
say "."
say " Ŀ"
say "  Checking for HPFS                                   "
say " "
say "."

targfile=target||'\config.sys'
targstring=source||'\os2\hpfs.ifs'
hpfsflag=Stream(targstring,'c','query exists')
IF hpfsflag <> "" THEN rc=LINEOUT(targfile,'ifs=hpfs.ifs /c:256')

rc=rc+LINEOUT(targfile,'buffers=64')
rc=rc+LINEOUT(targfile,'iopl=yes')
rc=rc+LINEOUT(targfile,'memman=noswap')
rc=rc+LINEOUT(targfile,'protshell=a:\cmd.exe /k startup.cmd')
rc=rc+LINEOUT(targfile,'set os2_shell=a:\cmd.exe')
rc=rc+LINEOUT(targfile,'diskcache=256,LW')
rc=rc+LINEOUT(targfile,'protectonly=yes')
rc=rc+LINEOUT(targfile,'libpath=.;\;\os2\dll;')
rc=rc+LINEOUT(targfile,'pauseonerror=no')
rc=rc+LINEOUT(targfile,'codepage=850')
rc=rc+LINEOUT(targfile,keyparm)
rc=rc+LINEOUT(targfile,'devinfo=scr,ega,vtbl850.dcp')
rc=rc+LINEOUT(targfile,'set path=\;\os2;\os2\system;\os2\install;')
rc=rc+LINEOUT(targfile,'set dpath=\;\os2;\os2\system;\os2\install;')
rc=rc+LINEOUT(targfile,'set keys=on')
rc=rc+LINEOUT(targfile,'set saveconnect=1')
rc=rc+LINEOUT(targfile,'basedev=ibmkbd.sys')
rc=rc+LINEOUT(targfile,'basedev=ibm1flpy.add')
rc=rc+LINEOUT(targfile,'basedev=ibm1s506.add')
rc=rc+LINEOUT(targfile,'basedev=ibm2flpy.add')
rc=rc+LINEOUT(targfile,'basedev=ibm2adsk.add')
rc=rc+LINEOUT(targfile,'basedev=ibm2scsi.add')
rc=rc+LINEOUT(targfile,'basedev=ibmint13.i13')
rc=rc+LINEOUT(targfile,'basedev=os2dasd.dmd')
rc=rc+LINEOUT(targfile,'basedev=aha152x.add')
rc=rc+LINEOUT(targfile,'basedev=aha154x.add')
rc=rc+LINEOUT(targfile,'basedev=aha164x.add')
rc=rc+LINEOUT(targfile,'basedev=aha174x.add')
rc=rc+LINEOUT(targfile,'basedev=aic7770.add')
rc=rc+LINEOUT(targfile,'basedev=aic7870.add')
rc=rc+LINEOUT(targfile,'basedev=btscsi.add')
rc=rc+LINEOUT(targfile,'basedev=fd16-700.add')
rc=rc+LINEOUT(targfile,'basedev=fd8xx.add')
rc=rc+LINEOUT(targfile,'basedev=fd7000ex.add')
rc=rc+LINEOUT(targfile,'basedev=dpt20xx.add')
rc=rc+LINEOUT(targfile,'basedev=dac960.add')
rc=rc+LINEOUT(targfile,'basedev=flashpt.add')
rc=rc+LINEOUT(targfile,'basedev=ipsraid.add')
rc=rc+LINEOUT(targfile,'basedev=ql10os2.add')
rc=rc+LINEOUT(targfile,'basedev=ql40os2.add')
rc=rc+LINEOUT(targfile,'basedev=ql510.add')
rc=rc+LINEOUT(targfile,'device=\dos.sys')
rc=rc+LINEOUT(targfile,'device=\mouse.sys')
rc=rc+LINEOUT(targfile,'device=ip22drv.sys')

targstring=target||'ibm2m57.add'
dummy=Stream(targstring,'c','query exists')
IF dummy <> "" THEN rc=rc+LINEOUT(targfile,'basedev=ibm2m57.add')
rc=rc+LINEOUT(targfile,'device=\testcfg.sys')
rc=rc+LINEOUT(targfile)
IF rc > 0 then SIGNAL writefail


say "."
say " Ŀ"
say "  New config.sys successfully created!               "
say " "
say "."

/* create an abreviated snoop list */
targfile=target||'\snoop.lst 1>nul 2>nul'
del targfile
targfile=target||'\snoop.lst'

rc=LINEOUT(targfile,'resrv.snp')
rc=rc+LINEOUT(targfile,'netdet1.snp')
rc=rc+LINEOUT(targfile,'ibmkbd.snp')
rc=rc+LINEOUT(targfile,'ibm1flpy.snp')
rc=rc+LINEOUT(targfile,'ibm1s506.snp')
rc=rc+LINEOUT(targfile,'aha6360.snp')
rc=rc+LINEOUT(targfile,'aha154x.snp')
rc=rc+LINEOUT(targfile,'aha174x.snp')
rc=rc+LINEOUT(targfile,'aic7870.snp')
rc=rc+LINEOUT(targfile,'ql10os2.snp')
rc=rc+LINEOUT(targfile,'ql40os2.snp')
rc=rc+LINEOUT(targfile,'ql510.snp')
rc=rc+LINEOUT(targfile,'ipsraid.snp')
rc=rc+LINEOUT(targfile,'btscsi.snp')
rc=rc+LINEOUT(targfile,'fd16-700.snp')
rc=rc+LINEOUT(targfile,'fd8xx.snp')
rc=rc+LINEOUT(targfile,'fd7000ex.snp')
rc=rc+LINEOUT(targfile,'dpt20xx.snp')
rc=rc+LINEOUT(targfile,'flashpt.snp')
rc=rc+LINEOUT(targfile,'dac960.snp')
rc=rc+LINEOUT(targfile,'pcmcia.snp')
rc=rc+LINEOUT(targfile,'ir.snp')
rc=rc+LINEOUT(targfile,'netdet2.snp')
rc=rc+LINEOUT(targfile,'pcibus.snp')
rc=rc+LINEOUT(targfile,'mouse.snp')
rc=rc+LINEOUT(targfile)
IF rc > 0 then SIGNAL writefail

loopit2:
say "."
say " Ŀ"
say " Insert the 3nd of the four disks in drive "target"    "
say " "
say " Press CTRL-C to QUIT"
say "          or"
PAUSE

/*Is this the right disk? */
info=SysDriveInfo(target)
PARSE UPPER VAR info nul1 nul2 nul3 diskname
IF diskname = "DISK 2" then call ahead2
    else
        say "."
        say "Wrong disk inserted!"
        call loopit2 
ahead2:

say "."
say " Ŀ"
say " Deleting files from Disk #3                     "
say " "
say "."

targstring=target||'\fdisk.com 1>nul 2>nul' ; del targstring
targstring=target||'\npxemltr.dll 1>nul 2>nul' ; del targstring
targstring=target||'\os2cdrom.dmd 1>nul 2>nul' ; del targstring
targstring=target||'\cdinst.exe 1>nul 2>nul' ; del targstring
targstring=target||'\sysinst1.exe 1>nul 2>nul' ; del targstring
targstring=target||'\sysinst2.exe 1>nul 2>nul' ; del targstring
targstring=target||'\marketng.msg 1>nul 2>nul' ; del targstring
targstring=target||'\del.lst 1>nul 2>nul' ; del targstring
targstring=target||'\cdfs.ifs 1>nul 2>nul' ; del targstring
targstring=target||'\startup.cmd 1>nul 2>nul' ; del targstring
targstring=target||'\message.txt 1>nul 2>nul' ; del targstring

say "."
say " Ŀ"
say " Copying files to Disk #3                        "
say " "
say "."

targstring='ip22drv.sys '||target||'\ >nul' ; copy targstring
targstring='ip2xdmn.exe '||target||'\ >nul' ; copy targstring
targstring='ipcrgui.dll '||target||'\ >nul' ; copy targstring
targstring='ipbb.dll '||target||'\ >nul' ; copy targstring
targstring='ipbp.dll '||target||'\ >nul' ; copy targstring
targstring='ipmb.dll '||target||'\ >nul' ; copy targstring
targstring='ipnwutil.dll '||target||'\ >nul' ; copy targstring
targstring='ipqual.dll '||target||'\ >nul' ; copy targstring
targstring='iprst.dll '||target||'\ >nul' ; copy targstring
targstring='ipucgen.dll '||target||'\ >nul' ; copy targstring
targstring='sr.exe '||target||'\ >nul' ; copy targstring


If hpfsflag <> ""
    then do
        targstring=source||'\os2\dll\uhpfs.dll '||target||'\ >nul' ; copy targstring
        targstring=source||'\os2\hpfs.ifs '||target||'\ >null >nul' ; copy targstring
    end


say "."
say " Ŀ"
say " Creating STARTUP.CMD                            "
say " "
say "."
  
targfile=target||'\startup.cmd'

rc=LINEOUT(targfile,'cls') 
rc=rc+LINEOUT(targfile,'@echo off')
rc=rc+LINEOUT(targfile,'type message.txt')
rc=rc+LINEOUT(targfile,'detach ip2xdmn.exe')
rc=rc+LINEOUT(targfile)
IF rc > 0  then SIGNAL writefail

say "."
say " Ŀ"
say " Creating Message.txt                            "
say " "
say "."


targfile=target||'\message.txt'
rc=LINEOUT(targfile,'.')
rc=rc+LINEOUT(targfile,' Ŀ')
rc=rc+LINEOUT(targfile,'                                                                ')
rc=rc+LINEOUT(targfile,' Run SR.EXE from this disk to recover Dualstor tape volumes     ')
rc=rc+LINEOUT(targfile,' Use SR /ds for filename scroll during recovery                 ')
rc=rc+LINEOUT(targfile,'                                                                ')
rc=rc+LINEOUT(targfile,' Disk 4 contains disk utilities (FDISK, FORMAT, CHKDSK)         ')
rc=rc+LINEOUT(targfile,' plus some room for a few of your own                           ')
rc=rc+LINEOUT(targfile,'                                                                ')
rc=rc+LINEOUT(targfile,' ')
rc=rc+LINEOUT(targfile,'.')
rc=rc+LINEOUT(targfile)
if rc >0 then SIGNAL writefail

loopit3:
say "."
say " Ŀ"
say " Insert the last of the four disks in drive "target"   "
say " "
say " Press CTRL-C to QUIT"
say "          or"
PAUSE

/*Is this the right disk? */
info=SysDriveInfo(target)
PARSE UPPER VAR info nul1 nul2 nul3 diskname
IF diskname = "DISK 3" then call ahead3
    else
        say "."
        say "Wrong disk inserted!"
        call loopit3 
ahead3:

/* not sure why this needs to be added back, its not on the original util set   */
/* but the CLI wont work from disk 4 without it                                 */

targstring=source||'\os2\dll\kbdcalls.dll '||target||'\ >nul' ; copy targstring

say "."
say " Ŀ"
say "  DONE!                                          "
say " "
say "."

exit


/* error traps  */

nosource:
say "."
say "Invalid system drive. Your OS2 system drive must be specified."
say "."
call parmerr

notarget:
say "."
say target "Invalid target drive specification"
say "."
call parmerr
       
parmerr:
say "."
say "Usage: MAKDSKV4 [OS2 System Drive:] [Target Floppy Drive:] [skip] "
say ""
say " -use skip to use an existing set of OS_2V4 utility disks"
say "."
exit

invalidlocal:
say "."
say "This script must be run from your Dualstor directory. Change your"
say "working directory to the Dualstor directory and run MAKDSKV4 again."
say "."
exit

nov4:
say "."
say "  This script is for OS2_V4 systems only, "
say "  for OS_2V3 (Warp) use MAKESR.CMD"
say "."
exit

writefail:
say "."
say "There was a problem creating the "||targfile||" file on the target diskette "
say "."
exit

not14flop:
say "."
say "Sorry, this script is for 1.4 meg floppies disks only."
say "."
exit

