/*
Ŀ
 OS2Copy2.CMD v.2.1.02 GA part 2 of 2.                                 
                                                                       
 REXX script to copy OS/2 2.1 GA HPFS or FAT BootManager system,       
 from one drive letter to another  eg. from D: to E:,                  
 from FAT to FAT, HPFS to HPFS.                                        
                                                                       
 Documentation is found in the file OS2COPY.DOC                        
                                                                       
 Copyright (C): John Sthle                                            
                289A Buddinge Hovedgade                                
                DK-2880 Bagsvrd                                       
                Denmark, Europe                                        
                Phone +45 44 98 66 18                                  
                                                                       
                Internet:            john.staahle@dkb.dk               
                RIME and ILINK OS/2: John Staahle                      
                                                                       
 Disclaimer, warning and what not:                                     
 !! NO responsibility or any other obligation you can ever think of    
    is assumed, honored or anything else.                              
 
*/

Call RxFuncAdd SysLoadFuncs, RexxUtil, SysLoadFuncs
CALL SysLoadFuncs

PARSE UPPER Arg all_args

HPFSSys = 'HPFS' 
FATSys  = 'FAT'

'@ECHO OFF'
'Set PROMPT=$E[1;33m$P$G'
Call SysCLS
CALL StartMelding

CALL HentParametre
IF (FromDrive==ToDrive) THEN DO
   CALL FromSameAsTo
   CALL HentParametre
   IF (FromDrive==ToDrive) THEN DO
      CALL FromSameAsTo
      EXIT
   END
   CALL SysCls
END
ToSubDir   = SUBSTR(FromDrive,1,1)
ToLetter   = SUBSTR(ToDrive,1,1)
ToLocation = ToDrive'\'ToSubDir
FromDrive

CALL FindFiler
CALL GetYesNo
CALL GetXCopSw
CALL AskCreate 
IF (OK \= YesLetter) THEN DO
   'FDISK'
   CALL AskCreate 
   IF (OK \= YesLetter) THEN DO
      SAY
      SAY 'It is impossible to copy OS/2 without a bootable partition on 'ToDrive
      SAY
      EXIT
   END
END
CALL SysCls

CALL Kopimeddelelse
CALL SetERMSG

/* Here goes */

CALL DiskFormat
CALL CheckFreeBefore
CALL MakeDirs
Call SysCLS
SAY 'Ŀ'
SAY '                                                                '
SAY '  OS2Copy2 v.2.1.02 GA Copyright (c) 1992-1994: John Sthle     '
SAY '                                                                '
SAY '  Working  -  do NOT touch !!!  Do NOT start other sessions !!! '
SAY '                                                                '
SAY ''
'XCOPY 'FromDrive'\*.* 'ToDrive'\ 'XcopSw' /S /E 1>NUL 2>&1'
CALL FixNotCopy
CALL RetEAs
IF ((FromFilSys==FATSys) & (ToFilSys==HPFSSys)) THEN DO
   CALL TilNytFilSystem
END
CALL CopyInitFilesToNewDrive
CALL CopyBinFiles
CALL CopyTextFiles
CALL LineOut(cInitList)
InitEditExe' 'FromDrive' 'ToDrive' 'cInitLis2' 'InitEditExe
CALL CopyInitFilesToInstall
CALL CopyTextFilesToInstall
CALL LineOut(cInitList)
DROP cInitList
CALL OKMelding
CALL CleanUp
CALL SlutMelding
ToDrive
'CD OS2'
'SetBoot /B 1>NUL 2>&1'

/*  EXIT  */
/**/

GetYesNo:
   YesNo = ' '
   DO WHILE (SubStr(YesNo,2,1) \= '/')
      YesNo = LineIn(YesNoFile)
   END
   YesLetter = SubStr(YesNo,1,1)
   NoLetter  = SubStr(YesNo,3,1)
   IF (YesLetter == ' ') THEN YesLetter = 'Y'
   IF (NoLetter  == ' ') THEN NoLetter  = 'N'
   CALL LineOut(YesNoFile)
RETURN

/*.......................................................................*/

GetXCopSw:
   XCopSw = ' '
   DO WHILE (SubStr(XCopSw,2,1) \= '/')
      XCopSw = LineIn(XCopSwFile)
   END
   IF (XCopSw == ' ') THEN XCopSw = ' /E /H /T /R /V'
   CALL LineOut(XCopSwFile)
RETURN

/*.......................................................................*/

FindFiler:

   InitEditFil = 'InitEdit.EXE'
   InitEditExe = SysSearchPath('PATH',InitEditFil)
   IF (InitEditExe=='') then DO
      NoFileName = InitEditFil
      CALL FileNotThere
      CALL GoodBye
      EXIT
   END
   
   InitEditList = 'InitEdit.LST'
   cInitList    = SysSearchPath('PATH',InitEditList)
   IF (cInitList=='') then DO
      NoFileName = InitEditList
      CALL FileNotThere
      CALL GoodBye
      EXIT
   END
   cInitLis2 = SubStr(cInitList,1,LastPos('.',cInitList))||'LS2'

   YesNoFil  = 'YesNo.LNG'
   YesNoFile = SysSearchPath('PATH',YesNoFil)
   IF (YesNoFile=='') then DO
      NoFileName = YesNoFil
      CALL FileNotThere
      CALL GoodBye
      EXIT
   END
   
   IF ((FromFilSys==FATSys) & (ToFilSys==HPFSSys)) THEN DO
      BootStrap = 'BOOT21.'SubStr(HPFSSys,1,3)
      CopyBootStrap = SysSearchPath('PATH',BootStrap)
      IF (CopyBootStrap=='') then DO
         NoFileName = YesNoFil
         CALL FileNotThere
         CALL GoodBye
         EXIT
      END
   END
   
   XCopSwFil  = 'XCopy.Sw'
   XCopSwFile = SysSearchPath('PATH',XCopSwFil)
   IF (XCopSwFile=='') then DO
      NoFileName = XCopSwFile
      CALL FileNotThere
      'PAUSE'
   END

RETURN

/*.......................................................................*/
HentParametre:
   
ArgNo = 1
/* 'OS2Copy <FromDrive>[:]  <ToDrive>[:] [<To file system>]' */

CALL HentFraParametre
CALL HentTilParametre

RETURN

/*.......................................................................*/
HentFraParametre:
   k=SysCurPos()
   FromDrive=word(all_args,ArgNo)
   DO WHILE (FromDrive=='')
      CALL SysCurPos word(k,1), 0
      SAY 'Partition to copy OS/2 system FROM (X:) ?'
      CALL SysCurPos word(k,1), 48
      PULL FromDrive
   END
   IF (SUBSTR(FromDrive,2,1)<>':') THEN FromDrive = FromDrive':'

   'FDISK /Query |'RxQueue
   DO WHILE (QUEUED() > 0)
      PARSE PULL cFilSysInfo
      IF (SubStr(cFilSysInfo,19,2)==FromDrive) THEN DO
         IF (SubStr(cFilSysInfo,30,2)=='07') THEN FromFilSys = HPFSSys
         IF (SubStr(cFilSysInfo,30,2)=='06') THEN FromFilSys = FATSys
      END
   END
RETURN

/*.......................................................................*/
HentTilParametre:
   ArgNo   = ArgNo + 1
   ToDrive = word(all_args,ArgNo)
   k=SysCurPos()
   DO WHILE (ToDrive=='')
      CALL SysCurPos word(k,1), 0
      SAY 'Hard drive to copy your OS/2 system TO  (X:) ?'
      PULL ToDrive 
   END
   IF (SUBSTR(ToDrive,2,1) \= ':') THEN ToDrive = ToDrive':'
   
   ArgNo     = ArgNo + 1
   ToFilSys = word(all_args,ArgNo)
   IF (ToFilSys=='') THEN DO
      ToFilSys = FromFilSys
   END
   ELSE DO
      IF (substr(ToFilSys,1,1) == substr(FATSys,1,1))  THEN ToFilSys = FATSys
      IF (substr(ToFilSys,1,1) == substr(HPFSSys,1,1)) THEN ToFilSys = HPFSSys
   END
RETURN

/*.......................................................................*/
SelectBootStrap:
RETURN

/*.......................................................................*/
DiskFormat:
   'FDISK /Query |'RXQueue
   FilSysInfo.0 = QUEUED()
   DO i = 1 TO FilSysInfo.0
      PARSE PULL FilSysInfo.i
      IF (SubStr(FilSysInfo.i,19,2)==FromDrive) THEN DO
         IF (SubStr(FilSysInfo.i,30,2)=='07') THEN FromFilSys = HPFSSys
         IF (SubStr(FilSysInfo.i,30,2)=='06') THEN FromFilSys = FATSys
      END
   END
         SAY 'Ŀ'
         SAY ' If, for some reason, the format does not work:                        ' 
         SAY ' 1. Press Ctrl C to STOP.                                              ' 
IF (FromFilSys == HPFSSys) THEN DO                                        
         SAY " 2. Perform format "ToDrive" /FS:"FromFilSys" 'by hand', giving NO label              "
         /* SAY " 2. Perform format x: /FS:HPFS by hand, giving NO label              " */
END
ELSE DO
   IF (ToFilSys == FromFilSys) THEN DO
         SAY " 2. Perform format "ToDrive" /FS:"FromFilSys" 'by hand', giving NO label               "
         /* SAY " 2. Perform format x: /FS:FAT by hand, giving NO label               " */
   END
   ELSE DO
      IF (ToFilSys == HPFSSys) THEN DO                                        
         SAY " 2. Perform format "ToDrive" /FS:"ToFilSys" 'by hand', giving NO label              "
         /* SAY " 2. Perform format x: /FS:HPFS by hand, giving NO label              " */
      END
   END
END
         SAY ' 3. Shut down and restart the computer.                                '
         SAY ''
SAY
   
IF (FromFilSys==ToFilSys) THEN DO
   'Echo 'YesLetter'|Format 'ToDrive' /FS:'FromFilSys' /V:'ToLetter'OS2'FromFilSys
END
ELSE DO
   'Echo 'YesLetter'|Format 'ToDrive' /FS:'ToFilSys' /V:'ToLetter'OS2'ToFilSys
END
RETURN

/*.......................................................................*/
CheckFreeBefore:
CALL CheckFree
IF (ToFree < FromUsed) THEN DO
 CALL SysCls
 SAY
 SAY 'Ŀ'
 SAY '                                                             '
 SAY '  Drive 'FromDrive' contains          'FORMAT(FromUsed,8,0)' KB files etc.         '
 SAY '  Drive 'ToDrive' has room for only 'FORMAT(ToFree,8,0)' KB                    '
 SAY '                                                             '
 SAY '  There is NOT room enough for a copy of 'FromDrive' on 'ToDrive'            '
 SAY '                                                             '
 SAY '  Now is the time to remove superfluous files on 'ToDrive'          '
 SAY '  using a different thread                                   '
 SAY '                                                             '
 SAY ''
 SAY
 SAY 'Press CTRL C to stop or'
 'PAUSE'
END
RETURN

/*.......................................................................*/

CheckFreeAfter:

SwapSize = 0
   InitSize = 0
   FromInis = FromDrive'\OS2\*.INI'
   rc = SysFileTree(FromInis,'InitFiles.','F')
   IF (InitFiles.0 > 0) THEN DO i = 1 TO InitFiles.0
      InitSize = InitSize + WORD(InitFiles.i,3)
   END
   ELSE DO
      InitSize = 1000
   END
   InitSize = (InitSize * 1.2 + SwapSize) /1024
   CALL CheckFree
 IF (ToFree < InitSize) THEN DO
  CALL SysCls
  SAY
  SAY 'Drive 'FromDrive' contains          'FORMAT(InitSize,8,0)' KB init files'
  SAY 'Drive 'ToDrive' has room for only 'FORMAT(ToFree,8,0)' KB'
  SAY 'There is NOT room enough for a copy of 'FromDrive' on 'ToDrive
  SAY
  SAY 'Ŀ'
  SAY '    Aborting     '
  SAY ''
  CALL CleanUp
  EXIT
 END     
RETURN

/*.......................................................................*/

CheckFree:
   FromInfo  = SysDriveInfo(FromDrive)
   FromTotal = SUBWORD(FromInfo,3,1)/1024
   FromFree  = SUBWORD(FromInfo,2,1)/1024
   FromUsed  = FromTotal - FromFree
    
   ToInfo    = SysDriveInfo(ToDrive)
   ToFree    = SUBWORD(ToInfo,2,1)/1024
RETURN

/*.......................................................................*/
TilNytFilSystem:
   BootStrap =  ToDrive'\OS2BOOT.'
   'Attrib -H -R -S 'BootStrap
   'COPY 'CopyBootStrap' 'BootStrap
   'Attrib +H +R +S 'BootStrap
RETURN

/*.......................................................................*/
CopyInitFilesToNewDrive:
CALL SysCls
SAY 'Ŀ'
SAY '                                                             '
SAY '  Now is the time to shut down ALL OTHER processes           '
SAY '                                                             '
SAY ''
'PAUSE'
   CALL CheckFreeAfter
   CALL MakeDirs
   CALL InitCopyMelding
   cInitFil = LineIn(cInitList,1,1)
   DO WHILE (cInitFil \= '>INIT_FILES')
      cInitFil = LineIn(cInitList)
   END
   cInitFil = LineIn(cInitList)
   DO WHILE ((cInitFil \= '>BIN_FILES') & (LEFT(cInitFil,1)=='\'))
      IndIni = FromDrive'\OS2'cInitFil
      UdIni  = ToLocation||cInitFil
      SAY 'Working on 'IndIni
      'Attrib -R 'UdIni' 1>NUL 2>&1'
      'Echo N|XCOPY 'IndIni' 'UdIni' 'XCopSw' 1>NUL 2>&1'
      'Attrib -R 'UdIni' 1>NUL 2>&1'
      cInitFil = LineIn(cInitList)
   END
   CALL OKForFileNotFound
   'Attrib -R 'ToDrive'\OS2\OS2*.!!! 1>NUL 2>&1'
   'DEL 'ToDrive'\OS2\OS2*.!!! 1>NUL 2>&1'
   'Attrib -R 'ToDrive'\OS2\OS2*.INI 1>NUL 2>&1'
RETURN

/* .....................................................................*/

CopyInitFilesToInstall:
   cInitFil = LineIn(cInitList,1,1)
   DO WHILE cInitFil  \=  '>INIT_FILES'
      cInitFil = LineIn(cInitList)
   END

   DO WHILE (cInitFil \= '>BIN_FILES')
      cInitFil = LineIn(cInitList)
      DO WHILE (substr(cInitFil,1,1)=='\')
         'XCOPY 'ToDrive'\OS2'cInitFil ToDrive'\OS2\INSTALL 'XCopSw' 1>NUL 2>&1'
         cInitFil = LineIn(cInitList)
      END
   END
RETURN

/*.......................................................................*/

CopyBinFiles:
   DO WHILE (BinFil \= '>TXT_FILES')
      BinFil = LineIn(cInitList)
      DO WHILE (substr(BinFil,1,1)=='\')
         'Attrib -R 'ToDrive||BinFil' 1>NUL 2>&1'
         'DEL 'ToDrive||BinFil' 1>NUL 2>&1'
         'XCOPY 'FromDrive||BinFil ToLocation' 'XCopSw' 1>NUL 2>&1'
         BinFil = LineIn(cInitList)
      END
   END
RETURN

/*.......................................................................*/

CopyTextFiles:
   DO WHILE (TxtFil \= '>>>THE_END')
      TxtFil = LineIn(cInitList)
      DO WHILE (substr(TxtFil,1,1)=='\')
         'XCOPY 'FromDrive||TxtFil' 'ToLocation' 'XCopSw' 1>NUL 2>&1'
         TxtFil = LineIn(cInitList)
      END
   END
RETURN

/*.......................................................................*/

CopyTextFilesToInstall:
   DO WHILE (TxtFil \= '>>>THE_END')
      TxtFil = LineIn(cInitList)
      DO WHILE (substr(TxtFil,1,1)=='\')
         'XCOPY 'ToDrive||TxtFil' 'ToDrive'\OS2\INSTALL 'XCopSw' 1>NUL 2>&1'
         TxtFil = LineIn(cInitList)
      END
   END
RETURN

/*.......................................................................*/

CleanUp:
   'Copy 'Fromdrive'\Startup.@#@ 'Fromdrive'\Startup.Cmd 1>NUL 2>&1'
   'Copy 'ToDrive'\StartUp.@#@   'ToDrive'\Startup.Cmd 1>NUL 2>&1'
   'DEL  'Fromdrive'\Startup.@#@'
   'DEL  'Todrive'\Startup.@#@'
RETURN

/*.......................................................................*/
DeleteError:
   PROCEDURE EXPOSE rc cDummy cERMSG rcError
   SAY 'Delete 'cDummy
   IF (rc <= rcError.0) THEN DO
      SAY rcError.rc' 'cERMSG
   END    
   ELSE DO
      SAY rcError.1
   END    
RETURN

/*.......................................................................*/

StartMelding:
SAY 'Ŀ'
SAY '                                                                           '
SAY ' OS2Copy2 v.2.1.02 GA Copyright (c) 1992-1994: John Sthle                 '
SAY ' This OS2Copy script is placed in the Public Domain                        '
SAY '                                                                           '
SAY ''
SAY 'Ŀ'
SAY ' Wait for the system to stabilize (no disk activity) before you continue!  '
SAY ''
RETURN

/*.......................................................................*/

InitCopyMelding:
SAY 'Ŀ'
SAY '                                                                           '
SAY '  Copying .INI files in progress.                                          '
SAY '                                                                           '
SAY ''
RETURN

/*.......................................................................*/

FileNotThere:
   SAY '   Ŀ'
   SAY '   ' NoFileName' was >> NOT <<  found in your path'
   SAY '   ' NoFileName' is crucial for the success of this procedure'
   SAY '    !!! Path to 'NoFileName' must be included in your Config.Sys   !!!'
   SAY '    !!! Path to 'NoFileName' must be included in your Autoexec.Bat !!!'
   SAY '   '
RETURN

/*.......................................................................*/

FromSameAsTo:
SAY 'Ŀ'
SAY '                                                                         '
SAY '    FromDrive ('FromDrive') is the same as ToDrive ('ToDrive') NO GO!                    '
SAY '                                                                         '
SAY ''
   'PAUSE'
   CALL SysCls
RETURN

/*.......................................................................*/

Kopimeddelelse:
SAY 'Ŀ'
SAY '                                                                       '
SAY ' Copying OS/2 'FromDrive' -----> 'ToDrive'                                             '
SAY '                                                                       '
SAY ''
IF ((ToFilSys\='') & (FromFilSys\=ToFilSys)) THEN DO
   SAY 'Ŀ'
   SAY ' Copying OS/2 'FromFilSys'  ----->  'ToFilSys'                                        '
   SAY ''
END
RETURN

/*.......................................................................*/
SetERMSG:
   rcError.1  = 'Other file error'
   rcError.2  = 'File not found'
   rcError.3  = 'Path not found'
   rcError.4  = 'Unknown error'
   rcError.5  = 'Access denied'
   rcError.0  = 5
RETURN

/*.......................................................................*/

AskCreate:
SAY 'Ŀ'
SAY '                                                                           '
SAY ' Do you already have a bootable partition on 'ToDrive' or                         '
k = SysCurPos()                                                              
SAY ' did you create one and insert it in BootManager                           '
SAY '                                                                           '
SAY ''
   p = SysCurPos()                                                              
   OK = ''
   DO WHILE ((OK \= YesLetter) & (OK \= NoLetter))
      CALL SysCurPos word(k,1),60
      SAY '('YesNo')?'
      CALL SysCurPos word(k,1),67
      JaNej = SysGetKey()
      PARSE UPPER VAR JaNej OK
   END
   CALL SysCurPos word(p,1),0
RETURN

/*.......................................................................*/
OKForFileNotFound:
SAY
SAY 'SYSxxxx: The system cannot find the file specified.'
SAY '              is >>> OK <<<'
SAY 
RETURN

/*.......................................................................*/

MakeDirs:
SAY
SAY 'SYSxxxx: A subdirectory or file 'ToLocation' already exists.'
SAY 'SYSxxxx: A subdirectory or file 'ToDrive'\OS2 already exists.'
SAY
SAY '             are >>>  OK  <<<'
SAY
  
'MD 'ToLocation
'MD 'ToDrive'\OS2'
RETURN

/*.......................................................................*/
RetEAs:
RETURN

/*.......................................................................*/
GoodBye:
   SAY 'Mission impossible. Good-bye, cruel world'
   CALL CleanUp
RETURN

/* .....................................................................*/

OKMelding:
SAY
SAY 'A backup of original files is left in subdirectory 'ToLocation
CALL OKForFileNotFound
SAY 'This just tells that originally you did not have no STARTUP.CMD'
SAY
RETURN

/*.......................................................................*/
Slutmelding:
SAY 'Ŀ'
SAY '                                              '
SAY ' Now you are about to warm-boot your computer '
SAY '         from your new copy of OS/2           '
SAY '                                              '
SAY ''
RETURN

/*.......................................................................*/
FixNotCopy:
   NotCopyFil  = 'Not_Copy.Lst'
   NotCopyFile = SysSearchPath('PATH',NotCopyFil)
   IF (NotCopyFile\='') then DO
      cNotCopy = LineIn(NotCopyFile,1,1)
      DO WHILE (SubStr(cNotCopy,1,1) == '/')
         cNotCopy = LineIn(NotCopyFile)
      END
      DO WHILE (SubStr(cNotCopy.i,1,1) == '\')
         'Attrib -H -R -S "'ToDrive||cNotCopy'" 1>NUL 2>&1'
         'DEL "'ToDrive||cNotCopy'" 1>NUL 2>&1'
         cNotCopy = LineIn(NotCopyFile)
      END
   END
RETURN

/**/
