/* This creates a Main Window with a Group of 1 DROP BOX with the
   END flag set.  Whenever the user types 'del' into the entry, RXDLG
   returns, and we delete all of the items in the DROP BOX's list.  If
   the user types 'add' item, we add several items to the list.
*/

/* Trap ERROR and FAILURE */
SIGNAL ON ERROR
SIGNAL ON FAILURE

/* =============== Create "Main Window" ================= */
/* First Group is DROP */
RXTYPE.1 = 'DROP'

/* Use of a control in this group causes RXDLG to return */
RXFLAGS.1 = 'END'

/* Label for control. No Groupbox */
RXLABEL.1 = ' '

/* TotalControls, ControlsPerLine, WidthOfControls */
RXINFO.1 = '1 1 90 6'

/* REXX variable where initial text stored */
RXVAL.1 = 'STRS'

/* Position */
RXX.1 = 10
RXY.1 = 150

/* Text */
STRS.1 = 'all'
STRS.2 = 'none'
STRS.3 = 'something'
STRS.4 = 'more'
STRS.5 = 'del'
STRS.6 = ' '

/* Default size and position (also gives us sizing and max button) */
RXWIN1 = ''

/* NOCLOSE since we want to close the window ourselves.
    No RESULT Flag, so the ESC and ENTER keys do nothing, and we don't
    have to bother checking for those */
RXDLG 1 '"Main Window"' 'RXWIN1'  'NOCLOSE'

more:

/* Do user interaction */
RXDLG

/* Did user click upon the CLOSE ICON? If so, then exit */
IF RXID < 0 THEN EXIT

/* Since there is only 1 group and 1 control, we know that the DROP BOX caused
   RXDLG to return. Check the selection. If the user typed 'del', then delete
   all items.  We could pass each item to delete in a separate call to RXSET
   with the DEL command, but by omitting the Value arg, DEL will automatically
   delete all items in the list. If the user typed 'add', then we ADD a few
   items to the list
*/

/* If 'del' was typed, delete all items in the list */
IF STRS.0 = 'del' THEN DO
   RXSAY 'Deleting list...'
   RXSET '""' 1 1 'DEL' '|'
END

/* If 'del' was typed, add some items to the list */
IF STRS.0 = 'add' THEN DO
   RXSAY 'Creating list...'

   /* First let's hide the list. If we were adding a lot of items,
       this could speed things up */
   RXSET '""' 1 1 'HIDE'

   /* Delete whatever is currently in the list */
   RXSET '""' 1 1 'DEL' '|'

   /* Add items 'Item 1', 'Item 2', 'Item 3', and 'Item 4'. Add them at the end of the list (-1) */
   DO i = 1 TO 4
      RXSET '""' 1 1 'ADD' 'Item' i'|-1'
   END

   /* OK, show the list now */
   RXSET '""' 1 1 'SHOW'
END


SIGNAL more

/* ==================================================== */
FAILURE:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
ERROR:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
