/* RxBMWlog.cmd a logger program to write to RxBMW.hst */
/*                                         */
CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
CALL SysLoadFuncs
PARSE ARG logComment
curDir = Directory()
histfile = curDir'\RxBMW.hst'
dateTime = timestamp()
logdata =  dateTime ||' '|| logComment
errors = lineout(histfile, logdata)
exit

/******************************************************************/
/* Routine : TimeStamp                                            */
/* Function: Get date and time stamp NOW                          */
/* Calls   : nothing                                              */
/* Args    : nothing                                              */
/* Returns : yyyymmdd hh:mm:ss                                    */
/******************************************************************/
TimeStamp: procedure
     today = date()
     time_now = time()
     parse var time_now hh ":" mm ":" ss
     time_now = right( hh, 2, "0" ) || ":" || right( mm, 2, "0" ) || ":" || ,
         right( ss, 2, "0" )

RETURN today || " " || time_now
