/* REXX file to install DH_ClipSave/2 on the deskop     */
/* if you use this script as a starting point for your   */
/* own install script and make improvements, please send */
/* me a copy ---  dwhawk@southwind.net                   */

call rxfuncadd 'sysloadfuncs', 'rexxutil', 'sysloadfuncs'
call sysloadfuncs                /* register system functions */
address cmd '@echo off'          /* echo is turned off */

call SysCLS

version = 'S'
savefile='clipsave'
me='DH_ClipSave/2'
object_name=me;
say "DH_ClipSave/2 installation"
say "Enter destination drive and directory"
say "for example C:\OS2\APPS"
say "to install in the curent directory just press enter"

parse pull dest
call setup_dir(dest) 
say " "

call SysFileTree 'clipsave.exe', 'file', 'F'

if file.0 = '0' then do
   say "Enter CPU version to install"
   say "Enter 3 for 386 version"
   say "Enter 4 for 486 version"
   say "Enter 5 for 586/686/Pentium version"
   parse pull version
   say "You have entered a "version
   Call Check_Ok  /* your check routine */
   say "Enter file name for saved text"
   parse pull savefile
   say "You have entered "savefile" for the file name"
   Call Check_Ok  /* your check routine */

   say "Enter the program object name"
   say "To use DH_ClipSave/2 , just press enter"

   parse pull oname
   object_name=oname
   If object_name= "" Then object_name = me

   say "You have entered "object_name" for the program object name"
   Call Check_Ok  /* your check routine */
   end
else 
  say "Installing shareware version of DH_ClipSave/2"

call copy_files
call MKOBJ
exit

check_ok:
  say  'Okay to continue(Y/N) ? '        
  k = SysGetKey('NOECHO') 
  if k = 'Y' | k = 'y'  then return
  say 'halting'
    exit


mkdir:  /* Procedure for creating dir */
  Parse Arg dir
  rc = SysMkDir(dir)
  If (rc = 0 | rc = 5) Then Return
  Say 'Problem creating destination directory "'dir'"'
  Exit


MKOBJ:
   if version = "5" then do
      Settings = 'EXENAME='direct||'\clipsav5.exe;'
   end     
   if version = "4" then do
      Settings = 'EXENAME='direct||'\clipsav4.exe;'
   end     
   if version = "3" then do
      Settings = 'EXENAME='direct||'\clipsav3.exe;'
   end     
   if version = "S" then do
      Settings = 'EXENAME='direct||'\clipsave.exe;'
   end     

Settings = Settings||'PROGTYPE=PM;MINIMIZED=YES'
Settings = Settings||'ICONFILE=clipsave.ico;'
Settings = Settings||'CCVIEW=NO;'
Settings = Settings||'STARTUPDIR='||direct';'
Settings = Settings||'PARAMETERS='savefile';'
rc=SysCreateObject('WPProgram',object_name,'<WP_DESKTOP>',Settings,'R');

if rc = 1 then Say "DH_ClipSave/2 installed on desktop"
return

setup_dir:      /* accept install path and create it if needed */
                /* the desired install path is in ARG(1) */
                /* if no path is specified current directory is used*/

Parse Arg destin  /* parameter of setup_dir */

save_dest = destin    /*  save original destin to */
                      /*  determine if copy needed */

If destin = "" Then destin = Directory()

Say "Shall I install in "destin" ?"
Call Check_Ok  /* your check routine */

Parse Var destin direct ':\' destin   /* get drive name only */
direct=direct':'

Do Until destin = ""     /* No matter how many sub dirs present */
  Parse Var destin sub '\' destin
  direct=direct'\'sub
  Call mkdir direct
End
return

copy_files:
if save_dest \= ""  then do
   'COPY clipsave.doc' direct
   if version = "5" then do
      'COPY clipsav5.exe' direct  
   end     
   if version = "4" then do
      'COPY clipsav4.exe' direct  
   end     
   if version = "3" then do
      'COPY clipsav3.exe' direct  
   end     
   if version = "S" then do
      'COPY clipsave.exe' direct  
   end     
end
return

