/* EOF2CRLF.CMD		 Jerry Levy	18 Mar 95
   Replaces E-O-F's (26 decimal or 1A hex or Control-Z)
   by a carriage return+linefeed
   Syntax:
      eof2crlf inputfile outputfile */

eof = D2c(26)
cr = D2c(13)
lf = D2c(10)
found = 0

Parse Arg inputfile outputfile
Call File_cmd inputfile, 'R'
Call File_cmd outputfile, 'W'

Do While Chars(inputfile) > 0
   datachar = Charin(inputfile)
   If datachar = eof Then
      Do
         found = found + 1
         datachar = cr
         Call Charout outputfile, datachar
         datachar = lf
      End
   Call Charout outputfile, datachar
End
Call File_cmd inputfile, 'C'
Call File_cmd outputfile, 'C'
Say 'EOF characters found =' found
Exit

/* performs common Stream commands and returns 1 if successful */
File_cmd:
Procedure
trace_value = Trace()
Trace 'N'
Parse Arg file_name, command
Select
   When command = 'X' Then
      action = 'QUERY EXISTS'
   When command = 'C' Then
      action = 'CLOSE'
   When command = 'W' Then
      action = 'OPEN WRITE'
   When command = 'R' Then
      action = 'OPEN READ'
   Otherwise Return 0
End
Call Stream file_name, 'C', action
If command = 'X' Then
   answer = Value(result <> '')
Else
   answer = Abbrev(result,'READY')
Trace (trace_value)
Return answer



