/*****************************************************************************/
/*                                                                           */
/*  Programmname  : PROFILE.C                                                */
/*  Verwendung    : Lesen und Schreiben der Profil-Datei                     */
/*  Bibliotheken  :                                                          */
/*  Autor         : Dipl.Ing. Jrgen Dittmer                                 */
/*  Speichermodell: OS/2 PM                                                  */
/*  Compiler      : WATCOM C/C++ v. 10.0                                     */
/*  System        :                                                          */
/*  Erstellung    : 14 Feb 2001                                              */
/*  nderung      : 28 Mai 2001 Dropped Fonts saved in INI                   */
/*****************************************************************************/

#define INCL_WINSHELLDATA
#include <os2.h>
#include "PMRouMon.h"


int ReadPrf (HAB hab, PPROFIL pprofil)
{
HINI  hini; /* ini file handle */
ULONG ulSWP     = sizeof (SWP);
ULONG ulFontLen = sizeof (pprofil->pszFont);
ULONG ulIPLen   = sizeof (pprofil->pszIP);
ULONG ulPassLen = sizeof (pprofil->pszPass);
ULONG ulMaxLen  = sizeof (pprofil->irxmax);

    hini = PrfOpenProfile (hab, "PMRouMon.INI");
    if (PrfQueryProfileData (hini, "SETTING", "CLIENTSWP", &pprofil->swpclient,  &ulSWP)     &
        PrfQueryProfileData (hini, "SETTING", "FONT",      &pprofil->pszFont,    &ulFontLen) &
        PrfQueryProfileData (hini, "SETTING", "ROUTERIP",  &pprofil->pszIP,      &ulIPLen)   &
        PrfQueryProfileData (hini, "SETTING", "PASS",      &pprofil->pszPass,    &ulPassLen) &
        PrfQueryProfileData (hini, "SETTING", "TXMAX",     &pprofil->itxmax,     &ulMaxLen)  &
        PrfQueryProfileData (hini, "SETTING", "RXMAX",     &pprofil->irxmax,     &ulMaxLen)  &
        PrfQueryProfileData (hini, "SETTING", "LOG",       &pprofil->iLog,       &ulMaxLen)  &
        PrfCloseProfile (hini))
        return (0);
    else
        return (1);
}

int WritePrf (HAB hab, PPROFIL pprofil)
{
HINI  hini; /* ini file handle */
ULONG ulSWP     = sizeof (SWP);
ULONG ulFontLen = sizeof (pprofil->pszFont);
ULONG ulIPLen   = sizeof (pprofil->pszIP);
ULONG ulPassLen = sizeof (pprofil->pszPass);
ULONG ulMaxLen  = sizeof (pprofil->irxmax);

    hini = PrfOpenProfile (hab, "PMRouMon.INI");
    PrfWriteProfileData (hini, "SETTING", "CLIENTSWP", &pprofil->swpclient, ulSWP);
    PrfWriteProfileData (hini, "SETTING", "FONT",      &pprofil->pszFont,   ulFontLen);
    PrfWriteProfileData (hini, "SETTING", "ROUTERIP",  &pprofil->pszIP,     ulIPLen);
    PrfWriteProfileData (hini, "SETTING", "PASS",      &pprofil->pszPass,   ulPassLen);
    PrfWriteProfileData (hini, "SETTING", "TXMAX",     &pprofil->itxmax,    ulMaxLen);
    PrfWriteProfileData (hini, "SETTING", "RXMAX",     &pprofil->irxmax,    ulMaxLen);
    PrfWriteProfileData (hini, "SETTING", "LOG",       &pprofil->iLog,      ulMaxLen);
    PrfCloseProfile (hini);
    return (0);
}
