/* */

call RxFuncAdd "SysLoadFuncs", "REXXUTIL", "SysLoadFuncs"
call SysLoadFuncs

call SysCls

say 'Dumb little Rexx Installer for ConfigMaint/2'
say '--------------------------------------------'
say
say '   Installation...'
say
say '   ... will copy files to destination directory'
say '   ... will create folder and objects on desktop'
say '   ... will NOT modify your config.sys and *.ini files'
say '       so stay cool :-)'
say

/* Ask Directory */

say 'Enter target directory (e.g.: C:\CM2):'
say '(<return> = current directory, object creation only, no copy operation)'
PARSE PULL InstDir
InstDir = STRIP(InstDir, 'T', '\')

IF InstDir="" THEN
 DO
   InstDir=directory()
   SIGNAL MakeIcons
 END

/* Create Directory */
say
say '--------------------------------------------'
say 'creating directories...'
say '--------------------------------------------'

if InstDir <> "." then
   do
     call SysFileTree InstDir, "SearchDir", "D"
     if SearchDir.0 = 0 then do
         rc = SysMkDir(InstDir)
            if rc <> 0 then do
                 say "Error: Cannot create directory!" InstDir
                 exit
            end
     end
end

/* Copy files */
say
say '--------------------------------------------'
say 'copying files...'
say '--------------------------------------------'

'@Copy cm2.exe 'InstDir'\cm2.exe'
'@Copy cm2.dll 'InstDir'\cm2.dll'
'@Copy cm2.inf 'InstDir'\cm2.inf'
'@Copy cm2cfg.dat 'InstDir'\cm2cfg.dat'
'@Copy howto.dat 'InstDir'\howto.dat'
'@Copy cm2fold1.ico 'InstDir'\cm2fold1.ico'
'@Copy cm2fold2.ico 'InstDir'\cm2fold2.ico'
'@Copy cm2.ico 'InstDir'\cm2.ico'
'@Copy file_id.diz 'InstDir'\file_id.diz'

MakeIcons:
/* Make icons */
say
say '--------------------------------------------'
say 'creating icons...'
say '--------------------------------------------'

mydir=Directory()

classname='WPFolder'
title='ConfigMaint/2'
location='<WP_DESKTOP>'
icon1=mydir||'\cm2fold1.ico'
icon2=mydir||'\cm2fold2.ico'
icon='ICONFILE='icon1||';ICONNFILE=1,'||icon2
folderid='<CM2_FOLDER>'
setup='OBJECTID='||folderid||';'||icon||';ICONVIEW=FLOWED'
rc=SysCreateObject(classname, title, location, setup, 'U')

classname='WPProgram'
title='CM/2 Information'
location='<CM2_FOLDER>'
infname=InstDir||'\cm2.inf'
WorkDir=InstDir
setup='OBJECTID=<CM2_INFO>;EXENAME=VIEW.EXE;PARAMETERS='||infname||';STARTUPDIR='||WorkDir
rc=SysCreateObject(classname, title, location, setup, 'U')

classname='WPProgram'
title='ConfigMaint/2'
location='<CM2_FOLDER>'
icon='ICONFILE='mydir||'\cm2.ico'
exename='EXENAME='||InstDir||'\cm2.exe'
WorkDir=InstDir
setup='OBJECTID=<CM2_PROGRAM>;STARTUPDIR='||Workdir||';'||icon||';'||exename
rc=SysCreateObject(classname, title, location, setup, 'U')

say
say 'Done.'
say

PARSE VERSION . Level .
IF Level > 4.00 THEN
  DO
    say
    say 'NOTE: You are using ObjectRexx. This will probably slow down processing'
    say '      ConfigMaint/2.'
    say '      To compare with ClassicRexx, performance is ways slower so we suggest'
    say "      to use ClassicRexx if you don't have any good reason to do not."
    say
  END

"@pause"

EXIT